/*
 * Decompiled with CFR 0.152.
 */
package mathEngine;

import game.ViewPort;
import javax.microedition.lcdui.Image;
import mathEngine.CurveEnemy;

public class TopCurveEnemy
extends CurveEnemy {
    public TopCurveEnemy(Image image, int width, int height, int x, int y, byte[] dirFrames) {
        super(image, width, height, x, y, dirFrames);
    }

    public void cycle() {
        if (this.x < this.curveStart) {
            this.setLastXY();
            this.x += this.sp;
            this.setPosition(this.x, this.y);
            return;
        }
        if (this.collidedPlayer()) {
            return;
        }
        if (this.lastX + this.getWidth() < 0 && this.x + this.getWidth() >= 0) {
            this.minus = this.y;
        }
        this.setPosition(this.x, this.y - this.minus - this.getHeight());
        this.setDirFrame();
        this.setLastXY();
        this.x += this.sp;
        this.curveAngle += this.sp / this.step;
        this.calculate();
    }

    protected void setDirFrame() {
        if (this.curveAngle < 60) {
            this.setFrame(this.dirFrames[14]);
        } else if (this.curveAngle >= 60 && this.curveAngle < 120) {
            this.setFrame(this.dirFrames[0]);
        } else {
            this.setFrame(this.dirFrames[2]);
        }
    }

    protected void initialize() {
        this.y = 0;
        this.step = ViewPort.getCurveStep(ViewPort.WIDTH);
        this.curveStart = ViewPort.getCurveStart(ViewPort.WIDTH, this.step);
        this.curveAngle = 0;
    }

    private void setLastXY() {
        this.lastX = this.x;
        this.lastY = this.y;
    }

    protected void calculate() {
        double sinx = Math.sin(Math.toRadians(this.curveAngle));
        this.y = (int)(sinx * (double)ViewPort.HEIGHT / 2.0);
    }

    public boolean outOfView() {
        return this.x >= ViewPort.WIDTH;
    }
}

