/*
 * Decompiled with CFR 0.152.
 */
package menu;

import game.Main;
import game.Setting;
import game.SoundsPlayer;
import game.Tasks;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import menu.Menu;
import menu.SplashMenu;

public class MenuElement {
    public static short WIDTH = (short)125;
    public static short HEIGHT = (short)25;
    boolean selected;
    int lastImageDisplayed = 0;
    public Image image1;
    public Image image2;
    public Image currentImage;
    public int width;
    int x;
    int y;
    int type;
    Menu myMenu;
    int displayTime;

    public MenuElement(Menu menu, byte type, Image image1, Image image2) {
        this.myMenu = menu;
        this.type = type;
        this.image1 = image1;
        this.image2 = image2;
        this.currentImage = image1;
    }

    public void draw(Graphics g) {
        if (this.selected) {
            ++this.displayTime;
            if (this.displayTime > 3) {
                this.changeImage();
            }
            g.drawImage(this.currentImage, this.x, this.y, 0);
        } else {
            g.drawImage(this.image1, this.x, this.y, 0);
        }
    }

    private void changeImage() {
        this.currentImage = this.currentImage == this.image1 ? this.image2 : this.image1;
        this.displayTime = 0;
    }

    public void processAction() {
        switch (this.type) {
            case 0: {
                this.myMenu.endTask = Tasks.viewLevel1();
                this.myMenu.stop();
                break;
            }
            case 1: {
                this.myMenu.endTask = Tasks.loadGame();
                this.myMenu.stop();
                break;
            }
            case 2: {
                this.myMenu.pause();
                Menu menu = Menu.getMenu(1);
                Main.setCurrent((Displayable)menu);
                break;
            }
            case 3: {
                this.myMenu.endTask = Tasks.exitGame();
                this.myMenu.stop();
                break;
            }
            case 5: {
                this.myMenu.endTask = Tasks.continueCurrentLevel();
                this.myMenu.stop();
                break;
            }
            case 4: {
                Main.stopLoadMenu();
                break;
            }
            case 7: {
                Main.setCurrent((Displayable)new SplashMenu(Menu.imgHelpScreen, this.myMenu));
                this.myMenu.pause();
                break;
            }
            case 8: {
                break;
            }
            case 6: {
                Main.setCurrent((Displayable)new SplashMenu(Menu.imgAboutScreen, this.myMenu));
                this.myMenu.pause();
                break;
            }
            case 9: {
                this.myMenu.pause();
                Main.setCurrent((Displayable)Menu.getMenu(3));
                break;
            }
            case 10: {
                Setting.Mode = (byte)2;
                Setting.Save();
                this.type = 11;
                this.image1 = Menu.imgMeduim1;
                this.image2 = Menu.imgMeduim2;
                break;
            }
            case 11: {
                Setting.Mode = (byte)3;
                Setting.Save();
                this.type = 12;
                this.image1 = Menu.imgHard1;
                this.image2 = Menu.imgHard2;
                break;
            }
            case 12: {
                Setting.Mode = 1;
                Setting.Save();
                this.type = 10;
                this.image1 = Menu.imgEasy1;
                this.image2 = Menu.imgEasy2;
                break;
            }
            case 13: {
                this.myMenu.stop();
                Menu menu = Menu.getMenu(0);
                menu.restart();
                Main.setCurrent((Displayable)menu);
                break;
            }
            case 14: {
                SoundsPlayer.getInstance().setSoundLevelHigh();
                SoundsPlayer.getInstance().restart();
                Setting.Sound = (byte)2;
                Setting.Save();
                this.image1 = Menu.imgSoundHigh1;
                this.image2 = Menu.imgSoundHigh2;
                this.type = 18;
                break;
            }
            case 15: {
                SoundsPlayer.getInstance().setSoundLevelLow();
                SoundsPlayer.getInstance().restart();
                Setting.Sound = 1;
                Setting.Save();
                this.image1 = Menu.imgSoundLow1;
                this.image2 = Menu.imgSoundLow2;
                this.type = 14;
                break;
            }
            case 18: {
                SoundsPlayer.getInstance().pause();
                Setting.Sound = 0;
                Setting.Save();
                this.image1 = Menu.imgSoundOff1;
                this.image2 = Menu.imgSoundOff2;
                this.type = 15;
                break;
            }
            case 16: {
                Setting.Vibrate = false;
                Setting.Save();
                this.image1 = Menu.imgVibrateOff1;
                this.image2 = Menu.imgVibrateOff2;
                this.type = 17;
                break;
            }
            case 17: {
                Main.display.vibrate(500);
                Setting.Vibrate = true;
                Setting.Save();
                this.image1 = Menu.imgVibrateOn1;
                this.image2 = Menu.imgVibrateOn2;
                this.type = 16;
                break;
            }
            case 19: {
                this.myMenu.stop();
                Main.downloadFullVersion();
                break;
            }
            case 20: {
                this.myMenu.stop();
                Tasks.LoadMenu().execute();
            }
        }
    }

    static {
        WIDTH = (short)230;
        HEIGHT = (short)38;
    }
}

