/*
 * Decompiled with CFR 0.152.
 */
package game;

import game.Main;
import game.Setting;
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;

public class SoundsPlayer
implements Runnable {
    private static SoundsPlayer spacePlayer;
    private Player pMain;
    private Player pBonus;
    private Player pPlayer;
    private Player pBumb;
    private Player pSuccess;
    private boolean main = false;
    private boolean boss = false;
    private boolean bonus = false;
    private boolean player = false;
    private boolean bumb = false;
    private boolean success = false;
    static InputStream in;
    private int soundLevelMain;
    boolean running = true;
    boolean paused = false;

    private SoundsPlayer() {
    }

    public static SoundsPlayer getInstance() {
        if (spacePlayer == null) {
            spacePlayer = new SoundsPlayer();
            spacePlayer.create();
        }
        return spacePlayer;
    }

    public void setSoundLevelLow() {
        VolumeControl vc = (VolumeControl)this.pMain.getControl("VolumeControl");
        vc.setLevel(this.soundLevelMain / 2);
    }

    public void setSoundLevelHigh() {
        VolumeControl vc = (VolumeControl)this.pMain.getControl("VolumeControl");
        vc.setLevel(this.soundLevelMain);
    }

    public void mainSound() {
        this.main = true;
    }

    public void bossSound() {
        this.boss = true;
    }

    public void bonusSound() {
        this.bonus = true;
    }

    public void playerSound() {
        this.player = true;
    }

    public void successSound() {
        this.success = true;
    }

    public void bumbSound() {
        this.bumb = true;
    }

    private void create() {
        try {
            in = this.getClass().getResourceAsStream("/audio/main.mid");
            this.pMain = Manager.createPlayer((InputStream)in, (String)"audio/midi");
            this.pMain.prefetch();
            VolumeControl vc = (VolumeControl)this.pMain.getControl("VolumeControl");
            this.soundLevelMain = vc.getLevel();
            switch (Setting.Sound) {
                case 2: {
                    this.setSoundLevelHigh();
                    break;
                }
                case 1: {
                    this.setSoundLevelLow();
                    break;
                }
                case 0: {
                    this.main = false;
                }
            }
            in = this.getClass().getResourceAsStream("/audio/bonus.mp3");
            this.pBonus = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
            in = this.getClass().getResourceAsStream("/audio/player.mp3");
            this.pPlayer = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
            in = this.getClass().getResourceAsStream("/audio/bumb.mp3");
            this.pBumb = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
            in = this.getClass().getResourceAsStream("/audio/sucess.mp3");
            this.pSuccess = Manager.createPlayer((InputStream)in, (String)"audio/mpeg");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void pause() {
        this.paused = true;
        if (this.pMain != null) {
            try {
                this.pMain.stop();
                this.main = true;
            }
            catch (MediaException ex) {
                ex.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void restart() {
        if (!this.paused) {
            return;
        }
        this.paused = false;
        SoundsPlayer soundsPlayer = this;
        synchronized (soundsPlayer) {
            this.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (this.running) {
            if (this.paused) {
                try {
                    SoundsPlayer soundsPlayer = this;
                    synchronized (soundsPlayer) {
                        this.wait();
                    }
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            boolean isForgeground = Main.isForeground();
            if (Setting.Sound != 0 && isForgeground) {
                try {
                    if (this.main && this.pMain != null) {
                        this.pMain.start();
                    }
                    if (this.bonus && this.pBonus != null) {
                        this.pBonus.start();
                        this.bonus = false;
                    }
                    if (this.player && this.pPlayer != null) {
                        this.pPlayer.start();
                        this.player = false;
                    }
                    if (this.bumb && this.pBumb != null) {
                        this.pBumb.start();
                        this.bumb = false;
                    }
                    if (this.success && this.pSuccess != null) {
                        this.pSuccess.start();
                        this.success = false;
                    }
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
            if (!isForgeground) {
                this.stopAll();
            }
            try {
                Thread.sleep(50L);
            }
            catch (Exception exception) {}
        }
    }

    public void start() {
        new Thread(this).start();
        if (Setting.Sound == 0) {
            this.pause();
        }
    }

    public void stop() {
        this.running = false;
    }

    public void stopAll() {
        try {
            this.pMain.stop();
        }
        catch (Exception me) {
            me.printStackTrace();
        }
    }
}

