/*
 * Decompiled with CFR 0.152.
 */
package level2;

import game.Main;
import game.ViewPort;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import layers.FanEnemy;
import level2.Level2;
import level3.Alarm;

public class WireLayer {
    private int sp;
    private int y;
    int height;
    int width;
    private Vector vecSprites;
    private Vector vecAlarms;
    int xPlus;
    private int yObjecIndex;

    public WireLayer(int startY, int sp) {
        this.sp = sp;
        this.vecSprites = new Vector();
        int type = Main.random(6);
        switch (type) {
            case 0: {
                this.generateType0();
                break;
            }
            case 1: {
                this.generateType1();
                break;
            }
            case 2: {
                this.generateType2();
                break;
            }
            case 3: {
                this.generateType3();
                break;
            }
            case 4: {
                this.generateType4();
                break;
            }
            case 5: {
                this.generateType5();
                break;
            }
            case 6: {
                this.generateType6();
            }
        }
    }

    private void generateType0() {
        Sprite s1 = new Sprite(Level2.imgStrip2);
        s1.setPosition(20, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 0;
        Sprite s2 = new Sprite(Level2.imgStrip1);
        s2.setPosition(0, -s2.getHeight());
        this.vecSprites.addElement(s2);
        Alarm alarm = new Alarm(Level2.imgAlert, 3, 1, this.sp);
        alarm.setPosition(s1.getX(), s1.getY() + s1.getHeight() - alarm.getHeight());
        this.vecAlarms = new Vector();
        this.vecAlarms.addElement(alarm);
        this.height = s1.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() - 5, s1.getY() + 45, this.sp, (byte)2);
            FanEnemy.generate(s2.getX() + 53, s2.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s2.getX() + 194, s2.getY() - 5, this.sp, (byte)2);
        }
    }

    private void generateType1() {
        Sprite s1 = new Sprite(Level2.imgStrip1);
        s1.setPosition(0, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 1;
        Sprite s2 = new Sprite(Level2.imgStrip3);
        s2.setPosition(ViewPort.WIDTH / 2 - s2.getWidth() / 2, -s2.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s2);
        this.height = s1.getHeight() + s2.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() + 53, s1.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s1.getX() + 194, s1.getY() - 5, this.sp, (byte)2);
        }
    }

    private void generateType2() {
        Sprite s1 = new Sprite(Level2.imgStrip1);
        s1.setPosition(0, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 1;
        Sprite s2 = new Sprite(Level2.imgStrip3);
        s2.setPosition(50, -s2.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s2);
        this.height = s1.getHeight() + s2.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() + 53, s1.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s1.getX() + 194, s1.getY() - 5, this.sp, (byte)2);
        }
    }

    private void generateType3() {
        Sprite s1 = new Sprite(Level2.imgStrip1);
        s1.setPosition(0, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 1;
        Sprite s2 = new Sprite(Level2.imgStrip3);
        s2.setPosition(ViewPort.WIDTH - 50, -s2.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s2);
        this.height = s1.getHeight() + s2.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() + 53, s1.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s1.getX() + 194, s1.getY() - 5, this.sp, (byte)2);
        }
    }

    private void generateType4() {
        Sprite s5 = new Sprite(Level2.imgStrip5);
        s5.setPosition(0, -s5.getHeight());
        this.vecSprites.addElement(s5);
        Sprite s1 = new Sprite(Level2.imgStrip2);
        s1.setPosition(50, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 1;
        Sprite s2 = new Sprite(Level2.imgStrip4);
        s2.setPosition(0, s1.getY() + 100);
        this.vecSprites.addElement(s2);
        this.vecAlarms = new Vector();
        Alarm alarm = new Alarm(Level2.imgAlert, 3, 1, this.sp);
        alarm.setPosition(s1.getX(), s1.getY());
        this.vecAlarms.addElement(alarm);
        alarm = new Alarm(Level2.imgAlert, 3, 1, this.sp);
        alarm.setPosition(s2.getX() + s2.getWidth() - alarm.getWidth(), s2.getY() - (alarm.getHeight() - s2.getHeight()) / 2);
        this.vecAlarms.addElement(alarm);
        this.height = s1.getHeight();
    }

    private void generateType5() {
        Sprite s1 = new Sprite(Level2.imgStrip1);
        s1.setPosition(0, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 2;
        Sprite s2 = new Sprite(Level2.imgStrip3);
        s2.setPosition(ViewPort.WIDTH / 2 - s2.getWidth() / 2, -s2.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s2);
        Sprite s3 = new Sprite(Level2.imgStrip2);
        s3.setPosition(50, -s3.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s3);
        Alarm alarm = new Alarm(Level2.imgAlert, 3, 1, this.sp);
        alarm.setPosition(s2.getX(), s2.getY());
        this.vecAlarms = new Vector();
        this.vecAlarms.addElement(alarm);
        this.height = s1.getHeight() + s2.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() + 53, s1.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s1.getX() + 194, s1.getY() - 5, this.sp, (byte)2);
        }
    }

    private void generateType6() {
        Sprite s1 = new Sprite(Level2.imgStrip1);
        s1.setPosition(0, -s1.getHeight());
        this.vecSprites.addElement(s1);
        this.yObjecIndex = 1;
        Sprite s2 = new Sprite(Level2.imgKa3da);
        s2.setPosition(ViewPort.WIDTH / 2 - s2.getWidth() / 2, -s2.getHeight() - s1.getHeight());
        this.vecSprites.addElement(s2);
        this.height = s1.getHeight() + s2.getHeight();
        if (Level2.WireLayerEnemiesLevel == 0) {
            return;
        }
        if (Level2.WireLayerEnemiesLevel == 2 || Main.random(2) == 0) {
            FanEnemy.generate(s1.getX() + 53, s1.getY() - 5, this.sp, (byte)2);
            FanEnemy.generate(s1.getX() + 194, s1.getY() - 5, this.sp, (byte)2);
        }
    }

    public void draw(Graphics g) {
        int j;
        Sprite temp = null;
        for (j = this.vecSprites.size() - 1; j >= 0; --j) {
            temp = (Sprite)this.vecSprites.elementAt(j);
            temp.paint(g);
        }
        if (this.vecAlarms != null) {
            for (j = this.vecAlarms.size() - 1; j >= 0; --j) {
                temp = (Sprite)this.vecAlarms.elementAt(j);
                temp.paint(g);
            }
        }
    }

    public void cycle() {
        Sprite temp = null;
        for (int j = 0; j < this.vecSprites.size(); ++j) {
            temp = (Sprite)this.vecSprites.elementAt(j);
            temp.setPosition(temp.getX(), temp.getY() + this.sp);
        }
        temp = (Sprite)this.vecSprites.elementAt(this.yObjecIndex);
        this.y = temp.getY();
        if (this.vecAlarms != null) {
            Alarm alarm = null;
            for (int j = this.vecAlarms.size() - 1; j >= 0; --j) {
                alarm = (Alarm)((Object)this.vecAlarms.elementAt(j));
                alarm.cycle();
            }
        }
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public int getY() {
        return this.y;
    }

    public void setSP(int sp) {
        this.sp = sp;
    }
}

