/*
 * Decompiled with CFR 0.152.
 */
package level3;

import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import mathEngine.BottomCurveEnemy;
import mathEngine.CurveEnemy;
import mathEngine.LeftCurveEnemy;
import mathEngine.RightCurveEnemy;
import mathEngine.TopCurveEnemy;

public class CurveGroup {
    private Vector vecEnemies;
    private boolean canGenerate;
    private int width;
    private int height;
    private Image image;
    private byte[] dirFrames;
    private Random random;
    private boolean testedLastEnemy;
    private int timeNoGenerate;

    public CurveGroup(Image img, int width, int height, byte[] dirFrames) {
        this.image = img;
        this.width = width;
        this.height = height;
        this.dirFrames = dirFrames;
        this.vecEnemies = new Vector();
        this.canGenerate = true;
        this.random = new Random();
    }

    private void addElement(CurveEnemy enemy) {
        this.vecEnemies.addElement(enemy);
        Game.addElement(enemy);
    }

    public void removeEnemy(CurveEnemy enemy) {
        this.vecEnemies.removeElement(enemy);
        Game.removeElement(enemy);
    }

    public void cycle() {
        CurveEnemy enemy = null;
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            enemy = (CurveEnemy)this.vecEnemies.elementAt(j);
            enemy.cycle();
            if (!enemy.outOfView()) continue;
            this.removeEnemy(enemy);
        }
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            CurveEnemy curveEnemy = (CurveEnemy)this.vecEnemies.lastElement();
            if (curveEnemy.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        CurveEnemy enemy = null;
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            enemy = (CurveEnemy)this.vecEnemies.elementAt(j);
            enemy.draw(g);
        }
    }

    public void generate() {
        if (!this.canGenerate) {
            return;
        }
        this.canGenerate = false;
        this.testedLastEnemy = false;
        int r = this.random.nextInt(6);
        switch (r) {
            case 0: {
                this.geneateRight();
                break;
            }
            case 1: {
                this.geneateTop();
                break;
            }
            case 2: {
                this.generateBottom();
                break;
            }
            case 3: {
                this.generateLeft();
                break;
            }
            case 4: {
                this.geneateRight();
                this.generateLeft();
                break;
            }
            case 5: {
                this.generateBottom();
                this.geneateTop();
            }
        }
    }

    public void generate2() {
        System.out.println("canGenerate:" + this.canGenerate);
        System.out.println("generate2:" + this.timeNoGenerate);
        if (!this.canGenerate) {
            return;
        }
        if (this.timeNoGenerate > 0) {
            --this.timeNoGenerate;
            return;
        }
        this.canGenerate = false;
        int r = this.random.nextInt(4);
        switch (r) {
            case 0: {
                this.geneateRight();
                break;
            }
            case 1: {
                this.geneateTop();
                break;
            }
            case 2: {
                this.generateBottom();
                break;
            }
            case 3: {
                this.generateLeft();
            }
        }
        this.timeNoGenerate = this.random.nextInt(4) * 20;
    }

    private void geneateTop() {
        TopCurveEnemy enemy = null;
        int curveStart = ViewPort.getCurveStart(ViewPort.WIDTH, ViewPort.getCurveStep(ViewPort.WIDTH));
        for (int j = 0; j < 3; ++j) {
            enemy = new TopCurveEnemy(this.image, this.width, this.height, curveStart - j * this.width - 10, 0, this.dirFrames);
            enemy.setCurveGroup(this);
            this.addElement(enemy);
        }
    }

    private void generateBottom() {
        BottomCurveEnemy enemy = null;
        int curveStart = ViewPort.getCurveStart(ViewPort.WIDTH, ViewPort.getCurveStep(ViewPort.WIDTH));
        for (int j = 0; j < 3; ++j) {
            enemy = new BottomCurveEnemy(this.image, this.width, this.height, curveStart - j * this.width - 10, ViewPort.HEIGHT, this.dirFrames);
            enemy.setCurveGroup(this);
            this.addElement(enemy);
        }
    }

    private void geneateRight() {
        RightCurveEnemy enemy = null;
        int curveStart = ViewPort.getCurveStart(ViewPort.HEIGHT, ViewPort.getCurveStep(ViewPort.HEIGHT));
        for (int j = 0; j < 3; ++j) {
            enemy = new RightCurveEnemy(this.image, this.width, this.height, ViewPort.WIDTH, curveStart - j * this.height - 10, this.dirFrames);
            enemy.setCurveGroup(this);
            this.addElement(enemy);
        }
    }

    private void generateLeft() {
        LeftCurveEnemy enemy = null;
        int curveStart = ViewPort.getCurveStart(ViewPort.HEIGHT, ViewPort.getCurveStep(ViewPort.HEIGHT));
        for (int j = 0; j < 3; ++j) {
            enemy = new LeftCurveEnemy(this.image, this.width, this.height, 0, curveStart - j * this.height - 10, this.dirFrames);
            enemy.setCurveGroup(this);
            this.addElement(enemy);
        }
    }
}

