/*
 * Decompiled with CFR 0.152.
 */
package level3.laser;

import game.Game;
import game.ViewPort;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import level3.laser.LaserEnemy;
import level3.laser.LaserEnemyDown;

public class LaserGroup {
    private Vector vecEnemies = new Vector();
    private Random random = new Random();
    private Image image;
    private int width;
    private int height;
    private int frameIndex;
    private Image imgLaser;
    private int laserWidth;
    private int laserHeight;
    private boolean canGenerate = true;
    private boolean testedLastEnemy;

    public LaserGroup(Image image, int width, int height, Image imgLaser, int laserWidth, int laserHeight, int frameIndex) {
        this.frameIndex = frameIndex;
        this.image = image;
        this.width = width;
        this.height = height;
        this.imgLaser = imgLaser;
        this.laserWidth = laserWidth;
        this.laserHeight = laserHeight;
    }

    public void cycle() {
        if (this.vecEnemies.size() == 0 && !this.testedLastEnemy) {
            this.canGenerate = true;
            return;
        }
        LaserEnemy temp = null;
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            temp = (LaserEnemy)this.vecEnemies.elementAt(j);
            temp.cycle();
        }
        this.testLastEnemyPlace();
    }

    private void testLastEnemyPlace() {
        if (this.testedLastEnemy) {
            return;
        }
        if (this.vecEnemies.size() == 0) {
            return;
        }
        try {
            LaserEnemy laserEnemy = (LaserEnemy)this.vecEnemies.lastElement();
            if (laserEnemy.getY() > 320) {
                this.canGenerate = true;
                this.testedLastEnemy = true;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        LaserEnemy temp = null;
        for (int j = this.vecEnemies.size() - 1; j >= 0; --j) {
            temp = (LaserEnemy)this.vecEnemies.elementAt(j);
            temp.draw(g);
        }
    }

    public void remove(LaserEnemy enemy) {
        this.vecEnemies.removeElement(enemy);
    }

    public void generateDown() {
        if (!this.canGenerate) {
            return;
        }
        this.testedLastEnemy = false;
        this.canGenerate = false;
        int rnd = this.random.nextInt(4);
        switch (rnd) {
            case 0: {
                this.generate0Down();
                break;
            }
            case 1: {
                this.generate1Down();
                break;
            }
            case 2: {
                this.generate2Down();
                break;
            }
            case 3: {
                this.generate3Down();
            }
        }
    }

    private void generate0Down() {
        LaserEnemyDown laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH / 2 - this.width / 2, -this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
    }

    private void generate1Down() {
        LaserEnemyDown laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH / 2 - this.width / 2, -this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
        laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(20, -2 * this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
        laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH - 20 - laserEnemy.getWidth(), -2 * this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
    }

    private void generate2Down() {
        LaserEnemyDown laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH / 2 - this.width / 2, -this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
        laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(20, -2 * this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
    }

    private void generate3Down() {
        LaserEnemyDown laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH / 2 - this.width / 2, -this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
        laserEnemy = new LaserEnemyDown(this.image, this.width, this.height, this.frameIndex, this.imgLaser, this.laserWidth, this.laserHeight);
        laserEnemy.setPosition(ViewPort.WIDTH - 20 - laserEnemy.getWidth(), -2 * this.height);
        laserEnemy.setMyGroup(this);
        Game.addElement(laserEnemy);
        this.vecEnemies.addElement(laserEnemy);
    }

    public void generateLeft() {
    }

    public void genrateRight() {
    }
}

