/*
 * Decompiled with CFR 0.152.
 */
public final class Enemy
extends GameInterface {
    static GameEngine engine;
    byte curIndex;
    byte img;
    byte[] motion;
    public static final byte RoadLine = 18;
    public static final int tileW = 32;
    int deadTime;
    static byte[][][] imgData;
    static byte[][][] frameData;
    static byte[][][] size;
    int vx;
    int vy;
    int lineIndex;
    byte trans;
    int temp;

    public Enemy(GameEngine GE) {
        if (engine == null) {
            engine = GE;
        }
    }

    public void initEnemy(int x, int y, int type) {
        this.x = x;
        this.y = y / 32 * 32 - 1;
        this.type = (byte)type;
        this.nextStatus = this.curStatus = (byte)12;
        this.isLeft = type != 7;
        this.speed = (byte)4;
        this.attack = 1;
        if (imgData[type] == null) {
            Enemy.imgData[type] = engine.readClipData("r" + type + ".dat");
        }
        if (frameData[type] == null) {
            Enemy.frameData[type] = engine.readFrameData("f" + type + ".dat");
        }
        if (size[type] == null) {
            switch (type) {
                case 3: {
                    Enemy.size[type] = new byte[][]{{7, 0, 7, 0}, {8, -1, 4, 0}, {8, -1, 6, 0}, {9, -7, 5, 0}, {13, -11, 11, 0}, {6, 15, 5, 0}, {7, 7, 7, 0}, {7, 0, 15, -1}, {14, -7, 3, -1}, {7, 0, 7, 0}};
                    break;
                }
                case 4: {
                    Enemy.size[type] = new byte[][]{{0, 0, 0, 0}, {-4, 0, 0, 0}, {-3, -1, 1, 0}, {1, -2, 1, 0}, {1, -2, 1, 0}, {-4, 9, 13, 3}, {4, 1, 6, 4}, {3, -8, 3, 1}, {-7, 13, 6, 1}, {-9, 33, 19, 1}, {-6, 1, -7, 1}, {-9, -4, -14, 1}};
                    break;
                }
                case 5: {
                    Enemy.size[type] = new byte[][]{{3, 8, 2, 0}, {2, 9, 0, 0}, {7, 10, 0, -1}, {2, 9, 1, 0}, {4, 10, 0, -1}, {2, 9, 1, 0}, {3, 14, -4, 0}, {8, 9, -4, 0}, {8, 9, -9, 0}, {11, 6, -9, 0}, {12, 19, -17, 0}, {12, 16, -17, 0}, {17, 0, -2, -1}, {3, 8, 2, 0}};
                    break;
                }
                case 6: {
                    Enemy.size[type] = new byte[][]{{1, 0, 3, 0}, {1, 1, 2, 0}, {1, 0, 2, 0}, {1, 0, 3, 0}, {1, 0, 1, 0}, {4, 3, 1, 0}, {1, 0, 3, 0}, {1, 0, 3, 0}};
                    break;
                }
                default: {
                    Enemy.size[type] = engine.readClipData("s" + type + ".dat");
                }
            }
        }
        switch (type) {
            case 0: {
                this.img = (byte)12;
                this.w = 18;
                this.h = 40;
                this.HP_MAX = 1;
                break;
            }
            case 1: {
                this.img = (byte)13;
                this.w = 18;
                this.h = 40;
                this.HP_MAX = 1;
                break;
            }
            case 2: {
                this.img = (byte)14;
                this.w = 18;
                this.h = 40;
                this.HP_MAX = 1;
                break;
            }
            case 3: {
                this.img = (byte)19;
                this.w = 32;
                this.h = 32;
                this.HP_MAX = 1;
                break;
            }
            case 4: {
                this.img = (byte)18;
                this.w = 37;
                this.h = 24;
                this.HP_MAX = 1;
                break;
            }
            case 5: {
                this.img = (byte)15;
                this.w = 24;
                this.h = 41;
                this.HP_MAX = 1;
                break;
            }
            case 6: {
                this.img = (byte)44;
                this.w = 71;
                this.h = 57;
                this.HP_MAX = (short)10;
                break;
            }
            case 7: {
                this.img = (byte)16;
                this.w = 30;
                this.h = 44;
                this.HP_MAX = 1;
            }
        }
        this.HP = this.HP_MAX;
    }

    public void setStatus(byte status) {
        this.index = 0;
        this.nextStatus = status;
    }

    public void roleMove(int mx, int my) {
        GameMap map = Enemy.engine.map;
        this.getSize(this.curIndex);
        int dx = mx + (mx < 0 ? 0 : (mx == 0 ? (this.isLeft ? 0 : this.w - 1) : this.w - 1));
        this.x = !map.canRun(this.x + dx, this.y) || !map.canRun(this.x + dx, this.y - this.h) ? (mx < 0 || mx == 0 && this.isLeft ? (int)((short)((this.x + dx) / 32 * 32 + 32)) : (int)((short)((this.x + dx) / 32 * 32 - this.w))) : (this.x += mx);
        if (my >= 0) {
            if (!map.canFall(this.x, this.y + my) || !map.canFall(this.x + this.w - 1, this.y + my)) {
                if (this.curStatus == 9) {
                    this.setStatus((byte)11);
                }
                this.y = (short)((this.y + my) / 32 * 32 - 1);
            } else {
                this.y += my;
                if (this.curStatus != 9) {
                    this.setStatus((byte)9);
                }
            }
        } else if (my < 0) {
            if (!map.canUp(this.x, this.y + my - this.h) || !map.canUp(this.x + this.w - 1, this.y + my - this.h)) {
                this.y = (short)((this.y + my - this.h) / 32 * 32 + 32 + this.h);
                this.speedY = 0;
            } else {
                this.y += my;
            }
        }
        if (MyGameCanvas.gameStatus == 7) {
            this.x = (short)Math.max(0, this.x);
            this.x = (short)Math.min(this.x, map.mapSize[0] * 32 - this.w);
            this.y = (short)Math.max(10, this.y);
        }
    }

    public void getSize(int index) {
        this.lx = size[this.type][index][0];
        this.rx = size[this.type][index][1];
        this.dy = size[this.type][index][3];
    }

    public void AI_0(GameInterface role) {
        int ex = this.x + this.w / 2;
        int rx = role.x + role.w / 2;
        switch (this.curStatus) {
            case 12: {
                if (Math.abs(ex - rx) >= 150 || role.y - this.y >= 40 || role.y - this.y <= -30 || (ex <= rx || !this.isLeft) && (ex >= rx || this.isLeft)) break;
                this.setStatus((byte)11);
                break;
            }
            case 11: {
                int dx;
                if (Math.abs(ex - rx) < 150 && Math.abs(this.y - role.y) < 30 && (ex > rx && this.isLeft || ex < rx && !this.isLeft)) {
                    this.setStatus(GameMIDlet.gameIndex % 2 == 0 ? (byte)13 : 14);
                    break;
                }
                int n = dx = this.isLeft ? -this.speed : this.speed + this.w - 1;
                if (this.x + dx >= 0 && (!Enemy.engine.map.canFall(this.x + dx, this.y + 5) || !Enemy.engine.map.canFall(this.x + dx, this.y + 5 + 32)) && Enemy.engine.map.canRun(this.x + dx, this.y) && Enemy.engine.map.canRun(this.x + dx, this.y - this.h)) break;
                this.isLeft = !this.isLeft;
                break;
            }
            case 10: {
                if (this.index != 1) break;
                this.isLeft = ex >= rx;
            }
        }
    }

    public void AI_1(GameInterface role) {
        int ex = this.x + this.w / 2;
        int rx = role.x + role.w / 2;
        switch (this.curStatus) {
            case 12: {
                if (Math.abs(ex - rx) >= 150 || role.y - this.y >= 40 || role.y - this.y <= -30 || (ex <= rx || !this.isLeft) && (ex >= rx || this.isLeft)) break;
                this.setStatus((byte)11);
                break;
            }
            case 11: {
                int dx;
                if (Math.abs(ex - rx) < 25 && Math.abs(this.y - role.y) < 30 && (ex > rx && this.isLeft || ex < rx && !this.isLeft)) {
                    this.setStatus((byte)13);
                    break;
                }
                int n = dx = this.isLeft ? -this.speed : this.speed + this.w - 1;
                if (this.x + dx >= 0 && (!Enemy.engine.map.canFall(this.x + dx, this.y + 5) || !Enemy.engine.map.canFall(this.x + dx, this.y + 5 + 32)) && Enemy.engine.map.canRun(this.x + dx, this.y) && Enemy.engine.map.canRun(this.x + dx, this.y - this.h)) break;
                this.isLeft = !this.isLeft;
                break;
            }
            case 10: {
                if (this.index != 1) break;
                this.isLeft = ex >= rx;
            }
        }
    }

    public void AI_2(GameInterface role) {
        int ex = this.x + this.w / 2;
        int rx = role.x + role.w / 2;
        switch (this.curStatus) {
            case 5: 
            case 12: {
                if (Math.abs(ex - rx) >= 150 || Math.abs(this.y - role.y) >= 100) break;
                this.throwBomb(ex, this.y, rx, role.y);
                break;
            }
            case 10: {
                if (this.index != 1) break;
                this.isLeft = ex >= rx;
            }
        }
    }

    public void AI_3(GameInterface role) {
        int ex = this.x + this.w / 2;
        int rx = role.x + role.w / 2;
        switch (this.curStatus) {
            case 12: {
                if (Math.abs(ex - rx) >= 150 || role.y - this.y >= 40 || role.y - this.y <= -30 || (ex <= rx || !this.isLeft) && (ex >= rx || this.isLeft)) break;
                this.setStatus((byte)11);
                break;
            }
            case 11: {
                int dx;
                if (Math.abs(ex - rx) < 105 && Math.abs(this.y - role.y) < 30 && (ex > rx && this.isLeft || ex < rx && !this.isLeft)) {
                    this.setStatus((byte)13);
                    break;
                }
                int n = dx = this.isLeft ? -this.speed : this.speed + this.w - 1;
                if (this.x + dx >= 0 && (!Enemy.engine.map.canFall(this.x + dx, this.y + 5) || !Enemy.engine.map.canFall(this.x + dx, this.y + 5 + 32)) && Enemy.engine.map.canRun(this.x + dx, this.y) && Enemy.engine.map.canRun(this.x + dx, this.y - this.h)) break;
                this.isLeft = !this.isLeft;
                break;
            }
            case 10: {
                if (this.index != 1) break;
                this.isLeft = ex >= rx;
            }
        }
    }

    public void throwBomb(int rx, int ry, int ex, int ey) {
        this.isLeft = rx > ex;
        this.vx = rx > ex ? -6 : 6;
        int t = Math.abs(rx - ex) / Math.abs(this.vx);
        t = Math.max(1, t);
        this.vy = (ey - ry + 30 - t * t) / t;
        this.vy = Math.max(-15, this.vy);
        this.vy = Math.min(-2, this.vy);
        this.setStatus((byte)13);
    }

    public void speedChange() {
        this.speedX = (byte)(this.speedX + this.ax);
        this.speedY = (byte)(this.speedY + this.ay);
        this.speedY = (byte)Math.min(15, this.speedY);
    }

    public void getdistance() {
        this.disX = this.speedX - this.ax / 2;
        this.disY = this.speedY - this.ay / 2;
    }

    public void move() {
        if (this.nextStatus != this.curStatus) {
            this.index = 0;
            this.curStatus = this.nextStatus;
        }
        this.speedChange();
        this.getdistance();
        this.sx = 0;
        this.sy = 0;
        if (this.injureTime > 0) {
            this.injureTime = (byte)(this.injureTime - 1);
        }
        if (this.curStatus != 3 && (this.HP <= 0 || this.y > Enemy.engine.map.mapSize[1] * 32 - 10)) {
            this.HP = 0;
            this.setStatus((byte)3);
            if (Enemy.engine.gameRank == 5) {
                int i = 0;
                while (i < 11) {
                    if (Enemy.engine.enemy[i].HP == 0) {
                        Enemy.engine.passNum = (byte)(Enemy.engine.passNum + 1);
                    }
                    ++i;
                }
            }
        }
        switch (this.type) {
            case 0: {
                this.AI_0(Enemy.engine.role);
                this.move0();
                break;
            }
            case 1: {
                this.AI_1(Enemy.engine.role);
                this.move1();
                break;
            }
            case 2: {
                this.AI_2(Enemy.engine.role);
                this.move2();
                break;
            }
            case 3: {
                this.AI_0(Enemy.engine.role);
                this.move3();
                break;
            }
            case 4: {
                this.AI_3(Enemy.engine.role);
                this.move4();
                break;
            }
            case 5: {
                this.AI_0(Enemy.engine.role);
                this.move5();
                break;
            }
            case 6: {
                this.AI_0(Enemy.engine.role);
                this.move6();
                break;
            }
            case 7: {
                this.move7();
            }
        }
        this.sx = this.x + (this.isLeft ? -this.rx : -this.lx);
        this.sy = this.y + this.dy + 18;
    }

    public void move0() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)13;
                this.roleMove(0, 5);
                if (++this.index < 4) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{13, 14, 15, 15, 15, 15, 15};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.setStatus((byte)11);
                break;
            }
            case 12: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
                break;
            }
            case 13: {
                byte[] motion = new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 7, 8, 6, 6};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (this.index == 8) {
                    engine.addToVector(0, this.x + this.w / 2 + (this.isLeft ? -50 : 32), this.y - 25 + 4, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 14: {
                byte[] motion = new byte[]{9, 9, 9, 9, 9, 9, 9, 9, 10, 11, 9, 9};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (this.index == 8) {
                    engine.addToVector(0, this.x + this.w / 2 + (this.isLeft ? -50 : 32), this.y - 19 + 4, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 11: {
                byte[] motion = new byte[]{2, 3, 4, 5};
                this.curIndex = motion[this.index];
                this.roleMove(this.isLeft ? -this.speed : this.speed, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
            }
        }
    }

    public void move1() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)7;
                this.roleMove(0, 5);
                if (++this.index < 4) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 1;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{7, 8, 9, 9, 9, 9, 9};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                this.curIndex = 1;
                this.roleMove(0, 5);
                if (++this.index < 3) break;
                this.setStatus((byte)11);
                break;
            }
            case 12: {
                this.curIndex = 1;
                this.roleMove(0, 5);
                break;
            }
            case 13: {
                this.motion = new byte[]{10, 10, 11, 12, 12, 12, 10, 10};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 11: {
                this.motion = new byte[]{2, 3, 4, 5};
                this.curIndex = this.motion[this.index];
                this.roleMove(this.isLeft ? -this.speed : this.speed, 5);
                if (++this.index < this.motion.length) break;
                this.index = 0;
            }
        }
    }

    public void move2() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)6;
                this.roleMove(0, 5);
                if (++this.index < 4) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{6, 7, 8, 8, 8, 8, 8};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 12: {
                this.motion = new byte[]{0, 0, 1, 1};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 13: {
                this.motion = new byte[]{2, 3, 4, 4, 4, 4, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.curIndex = this.motion[this.index];
                if (this.index == 2) {
                    engine.setBomb1(this.vx, this.vy);
                    engine.addToVector(9, this.x + this.w / 2 + (this.isLeft ? -41 : 13), this.y - 30, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                this.roleMove(0, 5);
                if (++this.index < this.motion.length) break;
                this.setStatus((byte)5);
            }
        }
    }

    public void move3() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)7;
                this.roleMove(0, 5);
                if (++this.index < 4) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{6, 7, 8, 9};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.setStatus((byte)11);
                break;
            }
            case 12: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
                break;
            }
            case 13: 
            case 14: {
                byte[] motion = new byte[]{2, 3, 4, 5, 5, 5, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
                this.curIndex = motion[this.index];
                if (this.index == 3) {
                    engine.addToVector(11, this.x + this.w / 2 + (this.isLeft ? -41 : 13), this.y - 20, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 11: {
                byte[] motion = new byte[]{0, 1, 2};
                this.curIndex = motion[this.index];
                this.roleMove(this.isLeft ? -this.speed : this.speed, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
            }
        }
    }

    public void move4() {
        switch (this.curStatus) {
            case 11: 
            case 12: {
                this.motion = new byte[]{10, 10, 11, 11, 10, 10, 11, 11, 10, 10, 11};
                this.curIndex = this.motion[this.index];
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 3: 
            case 10: {
                this.motion = new byte[]{5, 6, 7};
                this.curIndex = this.motion[this.index];
                this.y += 8;
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 13: {
                this.motion = new byte[]{0, 1, 2, 3, 4, 3, 4, 3, 4, 3};
                this.curIndex = this.motion[this.index];
                this.x = this.isLeft ? (this.x += -16) : (this.x += 16);
                this.y = this.index > 4 ? (this.y += 4) : (this.y += -4);
                if (++this.index < this.motion.length) break;
                this.isLeft = !this.isLeft;
                this.setStatus((byte)12);
            }
        }
    }

    public void move5() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)12;
                this.roleMove(0, 5);
                if (++this.index < 4) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{12, 12, 13, 13, 13, 13, 13};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.setStatus((byte)11);
                break;
            }
            case 12: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
                break;
            }
            case 13: {
                byte[] motion = new byte[]{6, 6, 6, 6, 6, 6, 6, 6, 7, 7, 7, 7};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (this.index == 8) {
                    engine.addToVector(12, this.x + this.w / 2 + (this.isLeft ? -50 : 32), this.y - 25 + 4, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 14: {
                byte[] motion = new byte[]{8, 8, 8, 8, 8, 8, 8, 8, 9, 9, 9, 9};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (this.index == 8) {
                    engine.addToVector(12, this.x + this.w / 2 + (this.isLeft ? -50 : 32), this.y - 19 + 4, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 11: {
                byte[] motion = new byte[]{2, 3, 4, 5};
                this.curIndex = motion[this.index];
                this.roleMove(this.isLeft ? -this.speed : this.speed, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
            }
        }
    }

    public void move6() {
        switch (this.curStatus) {
            case 10: {
                this.curIndex = (byte)6;
                this.roleMove(0, 5);
                if (++this.index < 2) break;
                this.setStatus((byte)5);
                break;
            }
            case 9: {
                this.curIndex = 0;
                this.roleMove(0, 10);
                break;
            }
            case 3: {
                this.motion = new byte[]{7, 7, 7, 7, 7, 7, 7};
                this.curIndex = this.motion[this.index];
                if (this.index == 0) {
                    GameEngine.AddBlastEffectList(this.x + 20, this.y, 12, 0, 0);
                    GameMap cfr_ignored_0 = Enemy.engine.map;
                    GameMap.shakeTime = (byte)10;
                }
                this.roleMove(0, 5);
                if (this.index >= this.motion.length - 1) break;
                ++this.index;
                break;
            }
            case 5: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.setStatus((byte)11);
                break;
            }
            case 12: {
                byte[] motion = new byte[]{0, 0, 1, 1};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
                break;
            }
            case 13: 
            case 14: {
                byte[] motion = new byte[]{4, 4, 4, 4, 4, 4, 4, 4, 5, 5};
                this.curIndex = motion[this.index];
                this.roleMove(0, 5);
                if (this.index == 8) {
                    engine.addToVector(13, this.x + this.w / 2 + (this.isLeft ? -50 : 32), this.y - 40, this.isLeft ? 1 : 0, GameEngine.enemyShot);
                }
                if (++this.index < motion.length) break;
                this.setStatus((byte)5);
                break;
            }
            case 11: {
                byte[] motion = new byte[]{0, 1, 2, 3};
                this.curIndex = motion[this.index];
                this.roleMove(this.isLeft ? -this.speed : this.speed, 5);
                if (++this.index < motion.length) break;
                this.index = 0;
            }
        }
    }

    public void move7() {
        switch (this.curStatus) {
            case 12: {
                this.motion = new byte[]{4, 4, 5, 5, 6, 6, 7, 7};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                if (Enemy.engine.passNum >= 65 && Enemy.engine.passNum2 == 2) {
                    this.setStatus((byte)11);
                    break;
                }
                if (++this.index < this.motion.length) break;
                this.index = 0;
                break;
            }
            case 11: {
                this.motion = new byte[]{4, 5, 8, 9, 10, 11, 12, 13, 12, 13, 12, 13, 12, 13};
                this.curIndex = this.motion[this.index];
                if (this.index >= 6) {
                    this.roleMove(this.isLeft ? -this.speed * 2 : this.speed * 2, 5);
                } else {
                    this.roleMove(0, 5);
                }
                if (++this.index < this.motion.length) break;
                this.index = 0;
                this.setStatus((byte)3);
                break;
            }
            case 3: {
                this.motion = new byte[]{13, 13, 13, 13};
                this.curIndex = this.motion[this.index];
                this.roleMove(0, 5);
                ++this.deadTime;
                if (this.index < this.motion.length - 1) {
                    ++this.index;
                    break;
                }
                MyGameCanvas.setST((byte)15);
            }
        }
    }

    public void paint() {
        if (this.deadTime > 10 || this.deadTime % 2 == 1) {
            return;
        }
        switch (this.type) {
            case 4: {
                this.drawFrame(this.sx, this.sy + 18, this.curIndex, this.isLeft, 100);
                break;
            }
            case 6: {
                this.drawFrame(this.sx, this.sy, this.curIndex, !this.isLeft, 100);
                break;
            }
            default: {
                this.drawFrame(this.sx, this.sy, this.curIndex, this.isLeft, 100);
            }
        }
    }

    public void drawFrame(int x, int y, int index, boolean isLeft, int drawLevel) {
        int i = 0;
        while (i < frameData[this.type][index].length) {
            this.temp = frameData[this.type][index][i];
            this.trans = (byte)(isLeft ? frameData[this.type][index][i + 4] ^ 1 : frameData[this.type][index][i + 4]);
            Tools.addObject(this.img, x + frameData[this.type][index][i + (isLeft ? 3 : 1)], y + frameData[this.type][index][i + 2], Tools.bToi(imgData[this.type][this.temp][0]), Tools.bToi(imgData[this.type][this.temp][1]), Tools.bToi(imgData[this.type][this.temp][2]), Tools.bToi(imgData[this.type][this.temp][3]), 36, this.trans, drawLevel);
            i += 5;
        }
    }

    public void Injure(int ack) {
        if (this.type == 7) {
            return;
        }
        if (this.injureTime == 0) {
            this.HP = (short)(this.HP - ack);
            this.injureTime = (byte)2;
            this.setStatus((byte)10);
            if (this.type == 6) {
                return;
            }
            GameEngine.AddBlastEffectList(this.x + this.w / 2 - 5, this.y - this.h / 2, 5, this.isLeft ? 1 : 0, 0);
        }
    }

    public void push(int mx) {
        this.roleMove(mx, 5);
        this.sx = this.x + (this.isLeft ? -this.rx : -this.lx);
        this.sy = this.y + this.dy + 18;
    }

    static {
        imgData = new byte[8][][];
        frameData = new byte[8][][];
        size = new byte[8][][];
    }
}

