/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;

public class Menu
extends Canvas
implements Runnable {
    private GameMidlet midlet = null;
    private volatile Thread thread = null;
    private Image imageMenu = null;
    private Image imageAbout = null;
    private Image imageCursorGame = null;
    private Image imageCreditAbout = null;
    private Image imageCursorExit = null;
    private boolean loop = false;
    private boolean about = false;
    int x45 = 0;
    int x70 = 0;
    int yCursorGame = 0;
    int yCursorAbout = 0;
    int yCursorExit = 0;
    int state = 1;
    private Player scroll = null;

    public Menu(GameMidlet midlet) {
        this.midlet = midlet;
        this.setFullScreenMode(true);
        try {
            this.imageMenu = Image.createImage((String)"/Menu.png");
            this.imageAbout = Image.createImage((String)"/Splash.png");
            this.imageCursorGame = Image.createImage((String)"/Game.png");
            this.imageCreditAbout = Image.createImage((String)"/About.png");
            this.imageCursorExit = Image.createImage((String)"/Exit.png");
        }
        catch (Exception ex) {
            System.err.println("In the block =menu=  images are not loaded");
        }
        this.x45 = 45;
        this.x70 = 70;
        this.yCursorGame = 180;
        this.yCursorAbout = 220;
        this.yCursorExit = 260;
        this.state = 1;
        this.scroll = this.createSound("/Scroll.wav", "audio/X-wav");
    }

    public void start() {
        this.loop = true;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (this.loop) {
            this.repaint();
            try {
                Thread.sleep(20L);
            }
            catch (Exception ex) {
                System.err.println("Class Menu  metod run()");
            }
        }
    }

    public void stop() {
        this.loop = false;
        this.thread = null;
        System.gc();
    }

    public void paint(Graphics graphics) {
        graphics.setColor(250, 250, 250);
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        if (this.about) {
            graphics.drawImage(this.imageAbout, 0, 0, 0);
        } else {
            graphics.drawImage(this.imageMenu, 0, 0, 0);
            if (this.state == 1) {
                graphics.drawImage(this.imageCursorGame, this.x45, this.yCursorGame, 0);
                graphics.drawImage(this.imageCreditAbout, this.x70, this.yCursorAbout, 0);
                graphics.drawImage(this.imageCursorExit, this.x70, this.yCursorExit, 0);
            }
            if (this.state == 2) {
                graphics.drawImage(this.imageCursorGame, this.x70, this.yCursorGame, 0);
                graphics.drawImage(this.imageCreditAbout, this.x45, this.yCursorAbout, 0);
                graphics.drawImage(this.imageCursorExit, this.x70, this.yCursorExit, 0);
            }
            if (this.state == 3) {
                graphics.drawImage(this.imageCursorGame, this.x70, this.yCursorGame, 0);
                graphics.drawImage(this.imageCreditAbout, this.x70, this.yCursorAbout, 0);
                graphics.drawImage(this.imageCursorExit, this.x45, this.yCursorExit, 0);
            }
        }
    }

    protected void keyPressed(int keyCode) {
        int action = this.getGameAction(keyCode);
        if (this.about && (keyCode == -6 || keyCode == -7)) {
            this.about = false;
            this.startScrollSound();
        }
        switch (action) {
            case 6: {
                ++this.state;
                if (this.state > 3) {
                    this.state = 1;
                }
                this.startScrollSound();
                break;
            }
            case 1: {
                --this.state;
                if (this.state < 1) {
                    this.state = 3;
                }
                this.startScrollSound();
                break;
            }
            case 8: {
                this.startScrollSound();
                if (this.state == 1) {
                    this.stop();
                    this.midlet.loadingGame();
                }
                if (this.state == 2) {
                    this.about = true;
                }
                if (this.state != 3) break;
                this.stop();
                this.midlet.exitGame();
            }
        }
    }

    private Player createSound(String file, String format) {
        Player player = null;
        try {
            InputStream input = this.getClass().getResourceAsStream(file);
            player = Manager.createPlayer((InputStream)input, (String)format);
            player.prefetch();
        }
        catch (IOException ex) {
        }
        catch (MediaException ex) {
            // empty catch block
        }
        return player;
    }

    private void startScrollSound() {
        if (this.scroll != null) {
            try {
                this.scroll.stop();
                this.scroll.setMediaTime(0L);
                this.scroll.start();
            }
            catch (MediaException mediaException) {
                // empty catch block
            }
        }
    }
}

