/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.util.Enumeration;
import javax.microedition.rms.RecordFilter;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import net.sourceforge.floggy.persistence.Comparator;
import net.sourceforge.floggy.persistence.Filter;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.IndexFilter;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.PolymorphicObjectSet;
import net.sourceforge.floggy.persistence.SingleObjectSet;
import net.sourceforge.floggy.persistence.impl.IndexManager;
import net.sourceforge.floggy.persistence.impl.ObjectComparator;
import net.sourceforge.floggy.persistence.impl.ObjectSetImpl;
import net.sourceforge.floggy.persistence.impl.PersistableMetadata;
import net.sourceforge.floggy.persistence.impl.PersistableMetadataManager;
import net.sourceforge.floggy.persistence.impl.PolymorphicObjectSetImpl;
import net.sourceforge.floggy.persistence.impl.RecordStoreManager;
import net.sourceforge.floggy.persistence.impl.SerializationManager;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;
import net.sourceforge.floggy.persistence.impl.strategy.JoinedStrategyObjectFilter;
import net.sourceforge.floggy.persistence.impl.strategy.PerClassStrategyObjectFilter;
import net.sourceforge.floggy.persistence.impl.strategy.SingleStrategyObjectFilter;

public class PersistableManagerImpl
extends PersistableManager {
    private Class a = Class.forName("net.sourceforge.floggy.persistence.Deletable");
    private Class b = Class.forName("net.sourceforge.floggy.persistence.strategy.PerClassStrategy");
    private Class c = Class.forName("net.sourceforge.floggy.persistence.strategy.SingleStrategy");

    public PersistableManagerImpl() {
        SerializationManager.setPersistableManager(this);
        PersistableMetadataManager.init();
        IndexManager.init();
    }

    public int batchSave(Persistable persistable) {
        __Persistable __Persistable2 = Utils.checkArgumentAndCast(persistable);
        int n2 = __Persistable2.__getId();
        if (n2 > 0) {
            throw new FloggyException("You should not use this method to update the persistable object.");
        }
        n2 = this.save(persistable);
        __Persistable2.__setId(0);
        return n2;
    }

    public void delete(Persistable object) {
        int n2 = (object = Utils.checkArgumentAndCast((Persistable)object)).__getId();
        if (n2 > 0) {
            RecordStore recordStore = RecordStoreManager.getRecordStore((__Persistable)object);
            try {
                object.__delete();
                recordStore.deleteRecord(n2);
                IndexManager.afterDelete((__Persistable)object);
                object.__setId(0);
                return;
            }
            catch (Exception exception) {
                object = exception;
                throw Utils.handleException(exception);
            }
            finally {
                RecordStoreManager.closeRecordStore(recordStore);
            }
        }
    }

    public void deleteAll() {
        try {
            Enumeration enumeration = PersistableMetadataManager.getClassBasedMetadatas();
            while (enumeration.hasMoreElements()) {
                PersistableMetadata persistableMetadata = (PersistableMetadata)enumeration.nextElement();
                IndexManager.deleteIndex(persistableMetadata.getClassName());
                RecordStoreManager.deleteRecordStore(persistableMetadata.getRecordStoreName());
            }
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
    }

    public void deleteAll(Class object) {
        __Persistable __Persistable2 = Utils.createInstance((Class)object);
        PersistableMetadata persistableMetadata = PersistableMetadataManager.getClassBasedMetadata(((Class)object).getName());
        if (this.a.isAssignableFrom((Class<?>)object) || persistableMetadata.getSuperClassName() != null) {
            object = this.find((Class)object, null, null);
            for (int i2 = 0; i2 < object.size(); ++i2) {
                __Persistable2 = (__Persistable)object.get(i2);
                this.delete(__Persistable2);
            }
            return;
        }
        try {
            RecordStoreManager.deleteRecordStore(__Persistable2.getRecordStoreName());
            IndexManager.deleteIndex(((Class)object).getName());
            return;
        }
        catch (Exception exception) {
            object = exception;
            throw Utils.handleException(exception);
        }
    }

    public SingleObjectSet find(Class clazz, Filter filter, Comparator comparator) {
        return this.find(clazz, filter, comparator, false);
    }

    public SingleObjectSet find(Class clazz, Filter object, Comparator object2, boolean bl) {
        ObjectComparator objectComparator = null;
        __Persistable __Persistable2 = Utils.createInstance(clazz);
        object = this.a(__Persistable2, (Filter)object, bl);
        if (object2 != null) {
            objectComparator = new ObjectComparator((Comparator)object2, Utils.createInstance(clazz), Utils.createInstance(clazz), bl);
        }
        object2 = null;
        __Persistable2 = RecordStoreManager.getRecordStore(__Persistable2);
        try {
            object = __Persistable2.enumerateRecords((RecordFilter)object, objectComparator, false);
            int n2 = object.numRecords();
            if (n2 > 0) {
                object2 = new int[n2];
                for (int i2 = 0; i2 < n2; ++i2) {
                    object2[i2] = object.nextRecordId();
                }
            }
            object.destroy();
        }
        catch (RecordStoreException recordStoreException) {
            object = recordStoreException;
            throw Utils.handleException((Exception)((Object)recordStoreException));
        }
        finally {
            RecordStoreManager.closeRecordStore((RecordStore)__Persistable2);
        }
        return new ObjectSetImpl((int[])object2, clazz, this, bl);
    }

    public SingleObjectSet find(Class clazz, IndexFilter object, boolean bl) {
        if (object == null) {
            throw new IllegalArgumentException("The indexFilter cannot be null");
        }
        Utils.validatePersistableClassArgument(clazz);
        try {
            object = IndexManager.getId(clazz, ((IndexFilter)object).getIndexName(), ((IndexFilter)object).getIndexValue());
            return new ObjectSetImpl((int[])object, clazz, this, bl);
        }
        catch (Exception exception) {
            object = exception;
            throw Utils.handleException(exception);
        }
    }

    public int getId(Persistable persistable) {
        persistable = Utils.checkArgumentAndCast(persistable);
        return persistable.__getId();
    }

    public Object getProperty(String string) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The property name cannot be null or empty");
        }
        if (string.equals("BATCH_MODE")) {
            if (RecordStoreManager.getBatchMode()) {
                return Utils.TRUE;
            }
            return Utils.FALSE;
        }
        if (string.equals("STORE_INDEX_AFTER_SAVE_OPERATION")) {
            if (IndexManager.getStoreIndexAfterSave()) {
                return Utils.TRUE;
            }
            return Utils.FALSE;
        }
        throw new IllegalArgumentException("Unreconized property: " + string);
    }

    public boolean isPersisted(Persistable persistable) {
        return (persistable = Utils.checkArgumentAndCast(persistable)).__getId() > 0;
    }

    public void load(Persistable persistable, int n2) {
        this.load(persistable, n2, false);
    }

    public void load(Persistable persistable, int n2, boolean bl) {
        persistable = Utils.checkArgumentAndCast(persistable);
        RecordStore recordStore = RecordStoreManager.getRecordStore((__Persistable)persistable);
        try {
            byte[] byArray = recordStore.getRecord(n2);
            if (byArray != null) {
                persistable.__deserialize(byArray, bl);
            }
            persistable.__setId(n2);
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        finally {
            RecordStoreManager.closeRecordStore(recordStore);
        }
    }

    public PolymorphicObjectSet polymorphicFind(Class clazz, Filter filter, boolean bl) {
        Object object = null;
        Object object2 = null;
        object = null;
        object = PersistableMetadataManager.getClassBasedMetadata(clazz.getName());
        PolymorphicObjectSetImpl polymorphicObjectSetImpl = new PolymorphicObjectSetImpl(this, bl);
        String[] stringArray = ((PersistableMetadata)object).getDescendents();
        if (stringArray == null || stringArray.length == 0) {
            stringArray = new String[]{clazz.getName()};
        }
        for (int i2 = 0; i2 < stringArray.length; ++i2) {
            RecordStoreException recordStoreException;
            try {
                clazz = Class.forName(stringArray[i2]);
                object2 = Utils.createInstance(clazz);
                object = this.a((__Persistable)object2, filter, bl);
            }
            catch (ClassNotFoundException classNotFoundException) {
                object2 = classNotFoundException;
                throw Utils.handleException(classNotFoundException);
            }
            object2 = RecordStoreManager.getRecordStore((__Persistable)object2);
            try {
                recordStoreException = object2.enumerateRecords((RecordFilter)object, null, false);
                int n2 = recordStoreException.numRecords();
                if (n2 > 0) {
                    object = new int[n2];
                    for (int i3 = 0; i3 < n2; ++i3) {
                        object[i3] = recordStoreException.nextRecordId();
                    }
                    polymorphicObjectSetImpl.addList((int[])object, clazz);
                }
                recordStoreException.destroy();
                continue;
            }
            catch (RecordStoreException recordStoreException2) {
                recordStoreException = recordStoreException2;
                throw Utils.handleException((Exception)((Object)recordStoreException2));
            }
            finally {
                RecordStoreManager.closeRecordStore((RecordStore)object2);
            }
        }
        return polymorphicObjectSetImpl;
    }

    public int save(Persistable persistable) {
        persistable = Utils.checkArgumentAndCast(persistable);
        RecordStore recordStore = RecordStoreManager.getRecordStore((__Persistable)persistable);
        try {
            byte[] byArray = persistable.__serialize(true);
            int n2 = persistable.__getId();
            if (n2 <= 0) {
                n2 = recordStore.addRecord(byArray, 0, byArray.length);
                persistable.__setId(n2);
            } else {
                recordStore.setRecord(n2, byArray, 0, byArray.length);
            }
            IndexManager.afterSave((__Persistable)persistable);
            int n3 = n2;
            return n3;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
        finally {
            RecordStoreManager.closeRecordStore(recordStore);
        }
    }

    public void setProperty(String string, Object object) {
        if (string == null || string.trim().length() == 0) {
            throw new IllegalArgumentException("The property name cannot be null or empty");
        }
        if (object == null) {
            throw new IllegalArgumentException("The property value cannot be null");
        }
        if (string.equals("BATCH_MODE")) {
            if (object instanceof Boolean) {
                RecordStoreManager.setBatchMode((Boolean)object);
                return;
            }
            throw new IllegalArgumentException("The property PersistableManager.BATCH_MODE must be an instance of Boolean");
        }
        if (string.equals("STORE_INDEX_AFTER_SAVE_OPERATION")) {
            if (object instanceof Boolean) {
                IndexManager.setStoreIndexAfterSave((Boolean)object);
                return;
            }
            throw new IllegalArgumentException("The property PersistableManager.STORE_INDEX_AFTER_SAVE_OPERATION must be an instance of Boolean");
        }
        throw new IllegalArgumentException("Unreconized property: " + string);
    }

    public void shutdown() {
        try {
            IndexManager.shutdown();
            RecordStoreManager.shutdown();
            return;
        }
        catch (Exception exception) {
            Exception exception2 = exception;
            throw Utils.handleException(exception);
        }
    }

    private RecordFilter a(__Persistable __Persistable2, Filter filter, boolean bl) {
        Class<?> clazz = __Persistable2.getClass();
        Object object = null;
        if (this.b.isAssignableFrom(clazz)) {
            if (filter != null) {
                object = new PerClassStrategyObjectFilter(__Persistable2, filter, bl);
            }
        } else {
            object = this.c.isAssignableFrom(clazz) ? (filter != null ? new SingleStrategyObjectFilter(__Persistable2, filter, bl) : new SingleStrategyObjectFilter(__Persistable2, bl)) : (filter != null ? new JoinedStrategyObjectFilter(__Persistable2, filter, bl) : new JoinedStrategyObjectFilter(bl));
        }
        return object;
    }
}

