/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.floggy.persistence.impl;

import java.io.DataInput;
import java.io.DataOutput;
import java.util.Calendar;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Stack;
import java.util.TimeZone;
import java.util.Vector;
import net.sourceforge.floggy.persistence.FloggyException;
import net.sourceforge.floggy.persistence.Persistable;
import net.sourceforge.floggy.persistence.PersistableManager;
import net.sourceforge.floggy.persistence.impl.IndexMetadata;
import net.sourceforge.floggy.persistence.impl.Utils;
import net.sourceforge.floggy.persistence.impl.__Persistable;

public class SerializationManager {
    public static final int NOT_NULL = 0;
    public static final int NULL = 1;
    private static PersistableManager a = null;

    protected SerializationManager() {
    }

    public static final Boolean readBoolean(DataInput dataInput) {
        Boolean bl = null;
        if (dataInput.readByte() == 0) {
            bl = dataInput.readBoolean() ? Utils.TRUE : Utils.FALSE;
        }
        return bl;
    }

    public static final Byte readByte(DataInput dataInput) {
        Byte by = null;
        if (dataInput.readByte() == 0) {
            by = new Byte(dataInput.readByte());
        }
        return by;
    }

    public static final Calendar readCalendar(DataInput dataInput) {
        Object object = null;
        if (dataInput.readByte() == 0) {
            object = dataInput.readUTF();
            object = Calendar.getInstance(TimeZone.getTimeZone((String)object));
            ((Calendar)object).setTime(new Date(dataInput.readLong()));
        }
        return object;
    }

    public static final Character readChar(DataInput dataInput) {
        Character c2 = null;
        if (dataInput.readByte() == 0) {
            c2 = new Character(dataInput.readChar());
        }
        return c2;
    }

    public static final Date readDate(DataInput dataInput) {
        Date date = null;
        if (dataInput.readByte() == 0) {
            date = new Date(dataInput.readLong());
        }
        return date;
    }

    public static final Double readDouble(DataInput dataInput) {
        Double d2 = null;
        if (dataInput.readByte() == 0) {
            d2 = new Double(dataInput.readDouble());
        }
        return d2;
    }

    public static final Float readFloat(DataInput dataInput) {
        Float f2 = null;
        if (dataInput.readByte() == 0) {
            f2 = new Float(dataInput.readFloat());
        }
        return f2;
    }

    public static final Hashtable readHashtable(DataInput dataInput) {
        Hashtable<Object, Object> hashtable = null;
        if (dataInput.readByte() == 0) {
            int n2 = dataInput.readInt();
            hashtable = new Hashtable<Object, Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = SerializationManager.readObject(dataInput, false);
                Object object2 = SerializationManager.readObject(dataInput, false);
                hashtable.put(object, object2);
            }
        }
        return hashtable;
    }

    public static final Vector readIndexMetadata(DataInput dataInput) {
        Vector<Object> vector = null;
        if (dataInput.readByte() == 0) {
            int n2 = dataInput.readInt();
            vector = new Vector<Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                Object object = dataInput.readUTF();
                String string = dataInput.readUTF();
                Vector vector2 = SerializationManager.readStringVector(dataInput);
                object = new IndexMetadata((String)object, string, vector2);
                vector.addElement(object);
            }
        }
        return vector;
    }

    public static final Integer readInt(DataInput dataInput) {
        Integer n2 = null;
        if (dataInput.readByte() == 0) {
            n2 = new Integer(dataInput.readInt());
        }
        return n2;
    }

    public static final Vector readIntVector(DataInput dataInput) {
        Vector<Integer> vector = null;
        if (dataInput.readByte() == 0) {
            int n2 = dataInput.readInt();
            vector = new Vector<Integer>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                vector.addElement(new Integer(dataInput.readInt()));
            }
        }
        return vector;
    }

    public static final Long readLong(DataInput dataInput) {
        Long l2 = null;
        if (dataInput.readByte() == 0) {
            l2 = new Long(dataInput.readLong());
        }
        return l2;
    }

    public static final Object readObject(DataInput dataInput, boolean bl) {
        Object object = null;
        String string = dataInput.readUTF();
        if ("java.lang.Boolean".equals(string)) {
            object = dataInput.readBoolean() ? Utils.TRUE : Utils.FALSE;
        } else if ("java.lang.Byte".equals(string)) {
            object = new Byte(dataInput.readByte());
        } else if ("java.lang.Character".equals(string)) {
            object = new Character(dataInput.readChar());
        } else if ("java.lang.Double".equals(string)) {
            object = new Double(dataInput.readDouble());
        } else if ("java.lang.Float".equals(string)) {
            object = new Float(dataInput.readFloat());
        } else if ("java.util.Hashtable".equals(string)) {
            object = SerializationManager.readHashtable(dataInput);
        } else if ("java.lang.Integer".equals(string)) {
            object = new Integer(dataInput.readInt());
        } else if ("java.lang.Long".equals(string)) {
            object = new Long(dataInput.readLong());
        } else if ("java.lang.Short".equals(string)) {
            object = new Short(dataInput.readShort());
        } else if ("java.lang.String".equals(string)) {
            object = dataInput.readUTF();
        } else if ("java.lang.StringBuffer".equals(string)) {
            object = new StringBuffer(dataInput.readUTF());
        } else if ("java.util.Calendar".equals(string)) {
            Object object2 = dataInput.readUTF();
            object2 = Calendar.getInstance(TimeZone.getTimeZone((String)object2));
            ((Calendar)object2).setTime(new Date(dataInput.readLong()));
            object = object2;
        } else if ("java.util.Date".equals(string)) {
            object = new Date(dataInput.readLong());
        } else if ("java.util.TimeZone".equals(string)) {
            object = TimeZone.getTimeZone(dataInput.readUTF());
        } else if ("java.util.Vector".equals(string)) {
            object = SerializationManager.readVector(dataInput, bl);
        } else if (bl) {
            dataInput.readInt();
        } else {
            object = Utils.createInstance(Class.forName(string));
            a.load((Persistable)object, dataInput.readInt(), bl);
        }
        return object;
    }

    public static final Persistable readPersistable(DataInput dataInput, Persistable object, boolean bl) {
        if (bl) {
            switch (dataInput.readByte()) {
                case -1: {
                    dataInput.readUTF();
                }
                case 0: {
                    dataInput.readInt();
                }
                case 1: {
                    object = null;
                }
            }
        } else {
            switch (dataInput.readByte()) {
                case -1: {
                    object = dataInput.readUTF();
                    object = (Persistable)Class.forName((String)object).newInstance();
                }
                case 0: {
                    a.load((Persistable)object, dataInput.readInt());
                    break;
                }
                case 1: {
                    object = null;
                }
            }
        }
        return object;
    }

    public static final Short readShort(DataInput dataInput) {
        Short s2 = null;
        if (dataInput.readByte() == 0) {
            s2 = new Short(dataInput.readShort());
        }
        return s2;
    }

    public static final Stack readStack(DataInput object, boolean n2) {
        Stack stack = null;
        if ((object = SerializationManager.readVector((DataInput)object, n2 != 0)) != null) {
            stack = new Stack();
            for (n2 = 0; n2 < ((Vector)object).size(); ++n2) {
                stack.push(((Vector)object).elementAt(n2));
            }
        }
        return stack;
    }

    public static final String readString(DataInput dataInput) {
        String string = null;
        if (dataInput.readByte() == 0) {
            string = dataInput.readUTF();
        }
        return string;
    }

    public static final StringBuffer readStringBuffer(DataInput dataInput) {
        StringBuffer stringBuffer = null;
        if (dataInput.readByte() == 0) {
            stringBuffer = new StringBuffer(dataInput.readUTF());
        }
        return stringBuffer;
    }

    public static final Vector readStringVector(DataInput dataInput) {
        Vector<String> vector = null;
        if (dataInput.readByte() == 0) {
            int n2 = dataInput.readInt();
            vector = new Vector<String>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                vector.addElement(dataInput.readUTF());
            }
        }
        return vector;
    }

    public static final TimeZone readTimeZone(DataInput dataInput) {
        TimeZone timeZone = null;
        if (dataInput.readByte() == 0) {
            timeZone = TimeZone.getTimeZone(dataInput.readUTF());
        }
        return timeZone;
    }

    public static final Vector readVector(DataInput dataInput, boolean bl) {
        Vector<Object> vector = null;
        if (dataInput.readByte() == 0) {
            int n2 = dataInput.readInt();
            vector = new Vector<Object>(n2);
            for (int i2 = 0; i2 < n2; ++i2) {
                if (dataInput.readByte() == 1) {
                    vector.addElement(null);
                    continue;
                }
                vector.addElement(SerializationManager.readObject(dataInput, bl));
            }
        }
        return vector;
    }

    public static void setPersistableManager(PersistableManager persistableManager) {
        a = persistableManager;
    }

    public static final void writeBoolean(DataOutput dataOutput, Boolean bl) {
        if (bl == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeBoolean(bl);
    }

    public static final void writeByte(DataOutput dataOutput, Byte by) {
        if (by == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeByte(by.byteValue());
    }

    public static final void writeCalendar(DataOutput dataOutput, Calendar calendar) {
        if (calendar == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeUTF(calendar.getTimeZone().getID());
        dataOutput.writeLong(calendar.getTime().getTime());
    }

    public static final void writeChar(DataOutput dataOutput, Character c2) {
        if (c2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeChar(c2.charValue());
    }

    public static final void writeDate(DataOutput dataOutput, Date date) {
        if (date == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeLong(date.getTime());
    }

    public static final void writeDouble(DataOutput dataOutput, Double d2) {
        if (d2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeDouble(d2);
    }

    public static final void writeFloat(DataOutput dataOutput, Float f2) {
        if (f2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeFloat(f2.floatValue());
    }

    public static final void writeHashtable(DataOutput dataOutput, Hashtable hashtable) {
        if (hashtable == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeInt(hashtable.size());
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k2 = enumeration.nextElement();
            SerializationManager.writeObject(dataOutput, k2);
            SerializationManager.writeObject(dataOutput, hashtable.get(k2));
        }
    }

    public static final void writeIndexMetadata(DataOutput dataOutput, Vector vector) {
        if (vector == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        int n2 = vector.size();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            IndexMetadata indexMetadata = (IndexMetadata)vector.elementAt(i2);
            dataOutput.writeUTF(indexMetadata.getRecordStoreName());
            dataOutput.writeUTF(indexMetadata.getName());
            SerializationManager.writeStringVector(dataOutput, indexMetadata.getFields());
        }
    }

    public static final void writeInt(DataOutput dataOutput, Integer n2) {
        if (n2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeInt(n2);
    }

    public static final void writeIntVector(DataOutput dataOutput, Vector vector) {
        if (vector == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        int n2 = vector.size();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeInt((Integer)vector.elementAt(i2));
        }
    }

    public static final void writeLong(DataOutput dataOutput, Long l2) {
        if (l2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeLong(l2);
    }

    public static final void writeObject(DataOutput dataOutput, Object object) {
        String string = object.getClass().getName();
        if (object instanceof Calendar) {
            string = "java.util.Calendar";
        } else if (object instanceof TimeZone) {
            string = "java.util.TimeZone";
        }
        dataOutput.writeUTF(string);
        if (object instanceof Boolean) {
            dataOutput.writeBoolean((Boolean)object);
            return;
        }
        if (object instanceof Byte) {
            dataOutput.writeByte(((Byte)object).byteValue());
            return;
        }
        if (object instanceof Character) {
            dataOutput.writeChar(((Character)object).charValue());
            return;
        }
        if (object instanceof Double) {
            dataOutput.writeDouble((Double)object);
            return;
        }
        if (object instanceof Float) {
            dataOutput.writeFloat(((Float)object).floatValue());
            return;
        }
        if (object instanceof Hashtable) {
            object = (Hashtable)object;
            SerializationManager.writeHashtable(dataOutput, (Hashtable)object);
            return;
        }
        if (object instanceof Integer) {
            dataOutput.writeInt((Integer)object);
            return;
        }
        if (object instanceof Long) {
            dataOutput.writeLong((Long)object);
            return;
        }
        if (object instanceof Short) {
            dataOutput.writeShort(((Short)object).shortValue());
            return;
        }
        if (object instanceof String) {
            dataOutput.writeUTF(object.toString());
            return;
        }
        if (object instanceof StringBuffer) {
            dataOutput.writeUTF(object.toString());
            return;
        }
        if (object instanceof Calendar) {
            object = (Calendar)object;
            dataOutput.writeUTF(((Calendar)object).getTimeZone().getID());
            dataOutput.writeLong(((Calendar)object).getTime().getTime());
            return;
        }
        if (object instanceof Date) {
            dataOutput.writeLong(((Date)object).getTime());
            return;
        }
        if (object instanceof TimeZone) {
            object = (TimeZone)object;
            dataOutput.writeUTF(((TimeZone)object).getID());
            return;
        }
        if (object instanceof Vector) {
            object = (Vector)object;
            SerializationManager.writeVector(dataOutput, (Vector)object);
            return;
        }
        if (object instanceof __Persistable) {
            int n2 = a.save((Persistable)object);
            dataOutput.writeInt(n2);
            return;
        }
        throw new FloggyException("The class " + string + " doesn't is a persistable class!");
    }

    public static final void writePersistable(DataOutput dataOutput, String string, Persistable persistable) {
        if (persistable == null) {
            dataOutput.writeByte(1);
            return;
        }
        String string2 = persistable.getClass().getName();
        if (!string.equals(string2)) {
            dataOutput.writeByte(-1);
            dataOutput.writeUTF(string2);
        } else {
            dataOutput.writeByte(0);
        }
        dataOutput.writeInt(a.save(persistable));
    }

    public static final void writeShort(DataOutput dataOutput, Short s2) {
        if (s2 == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeChar(s2.shortValue());
    }

    public static final void writeStack(DataOutput dataOutput, Stack stack) {
        SerializationManager.writeVector(dataOutput, stack);
    }

    public static final void writeString(DataOutput dataOutput, String string) {
        if (string == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeUTF(string);
    }

    public static final void writeStringBuffer(DataOutput dataOutput, StringBuffer stringBuffer) {
        if (stringBuffer == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeUTF(stringBuffer.toString());
    }

    public static final void writeStringVector(DataOutput dataOutput, Vector vector) {
        if (vector == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        int n2 = vector.size();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            dataOutput.writeUTF((String)vector.elementAt(i2));
        }
    }

    public static final void writeTimeZone(DataOutput dataOutput, TimeZone timeZone) {
        if (timeZone == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        dataOutput.writeUTF(timeZone.getID());
    }

    public static final void writeVector(DataOutput dataOutput, Vector vector) {
        if (vector == null) {
            dataOutput.writeByte(1);
            return;
        }
        dataOutput.writeByte(0);
        int n2 = vector.size();
        dataOutput.writeInt(n2);
        for (int i2 = 0; i2 < n2; ++i2) {
            Object e2 = vector.elementAt(i2);
            if (e2 == null) {
                dataOutput.writeByte(1);
                continue;
            }
            dataOutput.writeByte(0);
            SerializationManager.writeObject(dataOutput, e2);
        }
    }
}

