/*
 * Decompiled with CFR 0.152.
 */
package thaptuchinh.mapworld;

import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import thaptuchinh.ThapTuChinhCanvas;
import thaptuchinh.data.KindOfScreen;
import thaptuchinh.data.PiPoDesigner;
import thaptuchinh.data.TtcGameDesign;
import thaptuchinh.history.History;

public class MapWorld {
    public boolean startNewScreen = true;
    private TtcGameDesign mGameDesign;
    private History mHistory;
    private Sprite battleNext;
    private Sprite tableLeft;
    private Sprite tableRight;
    private Image mapWorld;
    private Image column;
    private Sprite[] battleFinished;
    private byte[] talks;
    private final short[] x = new short[]{260, 230, 240, 220, 190, 210, 170, 245, 135, 155, 275, 395, 380, 400, 170, 10, 430, 450, 410, 380, 385};
    private final short[] y = new short[]{120, 120, 130, 125, 95, 115, 145, 120, 250, 225, 155, 135, 155, 120, 190, 160, 210, 130, 170, 170, 200};
    private final short[] moveX = new short[]{0, 2, 2, 4, 3, 2, 4, 15, 11, 4, 12, 12, 3, 4, 23, 16, 42, 2, 4, 3, 1};
    private final short[] moveY = new short[]{0, 0, 2, 1, 3, 2, -3, -5, -13, -5, -7, -2, -4, -7, -7, 3, 5, -8, -4, 0, 6};
    private final byte[] ttc = PiPoDesigner.toByteIndex("TH\u1eacP T\u1ef0 CHINH");
    private short ttcX;
    private short storeX;
    private short columnX_1;
    private short columnX_2;
    private short moveStr;
    private short x_1;
    private short x_2;
    private short yMap;
    private short columnY_1;
    private short columnY_2;
    private short y_1;
    private short y_2;
    private short nMove;
    private short width;
    private short height;
    private short movePointX;
    private short movePointY;
    private short wait;
    private short wait2;
    private short kindOfScreenX;
    public short xMap;
    public boolean isOuting;
    public boolean isOuting_2;
    private int[] rgb;

    public void init(TtcGameDesign gameDesign, short level) {
        if (ThapTuChinhCanvas.width == 320) {
            if (ThapTuChinhCanvas.height > 300 && ThapTuChinhCanvas.height <= 320) {
                this.kindOfScreenX = (short)40;
            } else if (ThapTuChinhCanvas.height == 240) {
                this.kindOfScreenX = (short)40;
            }
        } else {
            this.kindOfScreenX = ThapTuChinhCanvas.height == 480 ? (short)200 : (short)0;
        }
        this.mGameDesign = gameDesign;
        this.battleFinished = new Sprite[level + 1];
        try {
            this.mapWorld = this.mGameDesign.getMap();
            this.tableLeft = this.mGameDesign.getKhungCnv();
            this.tableRight = new Sprite(this.tableLeft);
            this.battleNext = this.mGameDesign.getPointBattle();
            this.battleFinished[0] = this.mGameDesign.getPositionBar();
            for (int k = 1; k <= level; ++k) {
                this.battleFinished[k] = new Sprite(this.battleFinished[0]);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.width = ThapTuChinhCanvas.widthScreen;
        this.height = ThapTuChinhCanvas.heightScreen;
        this.isOuting = true;
        this.isOuting_2 = true;
        if (level >= 1) {
            this.xMap = this.x[level - 1] > 223 ? (short)-223 : (short)0;
        } else {
            this.xMap = (short)-223;
            this.isOuting = false;
        }
        this.storeX = this.xMap;
        this.ttcX = (short)(this.width / 2 - PiPoDesigner.getLengString(this.ttc, 0, -16777216, 0, this.ttc.length) / 2 + this.kindOfScreenX);
        this.yMap = (short)((this.height - this.mapWorld.getHeight()) * 3 / 4);
        this.nMove = 0;
        this.movePointX = 0;
        this.movePointY = (short)KindOfScreen.y;
        this.setText((short)level);
    }

    public void setText(short level) {
        if (level == 0) {
            this.talks = PiPoDesigner.toByteIndex("Eo bi\u1ec3n Salamis");
        } else if (level == 1) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Ionia");
        } else if (level == 2) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Sena Gallica");
        } else if (level == 3) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Sluys");
        } else if (level == 4) {
            this.talks = PiPoDesigner.toByteIndex("Eo bi\u1ec3n Manche");
        } else if (level == 5) {
            this.talks = PiPoDesigner.toByteIndex("V\u1ecbnh Pantras");
        } else if (level == 6) {
            this.talks = PiPoDesigner.toByteIndex("M\u0169i Trafalgar");
        } else if (level == 7) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Adriatic");
        } else if (level == 8) {
            this.talks = PiPoDesigner.toByteIndex("\u0110\u1ea3o Falkland");
        } else if (level == 9) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Coronel");
        } else if (level == 10) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Imbros");
        } else if (level == 11) {
            this.talks = PiPoDesigner.toByteIndex("C\u1ea3ng L\u1eef Thu\u1eadn");
        } else if (level == 12) {
            this.talks = PiPoDesigner.toByteIndex("B\u00e1n \u0111\u1ea3o S\u01a1n \u0110\u00f4ng");
        } else if (level == 13) {
            this.talks = PiPoDesigner.toByteIndex("Eo bi\u1ec3n Tsushima");
        } else if (level == 14) {
            this.talks = PiPoDesigner.toByteIndex("S\u00f4ng La Plata");
        } else if (level == 15) {
            this.talks = PiPoDesigner.toByteIndex("Tr\u00e2n Tr\u00e2u C\u1ea3ng");
        } else if (level == 16) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Coral");
        } else if (level == 17) {
            this.talks = PiPoDesigner.toByteIndex("\u0110\u1ea3o san h\u00f4 Midway");
        } else if (level == 18) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Philippines");
        } else if (level == 19) {
            this.talks = PiPoDesigner.toByteIndex("V\u1ecbnh Leyte");
        } else if (level == 20) {
            this.talks = PiPoDesigner.toByteIndex("Bi\u1ec3n Java ");
        }
    }

    public void draw(Graphics g, short level) {
        g.drawImage(this.mapWorld, this.xMap + this.kindOfScreenX, this.yMap + KindOfScreen.y, 0);
        g.setColor(0);
        g.fillRect((int)this.kindOfScreenX, KindOfScreen.y, (int)this.width, (int)this.yMap);
        g.fillRect((int)this.kindOfScreenX, this.yMap + this.mapWorld.getHeight() + KindOfScreen.y, (int)this.width, this.height - this.yMap - this.mapWorld.getHeight());
        this.tableLeft.setPosition((int)this.kindOfScreenX, KindOfScreen.y);
        this.tableLeft.paint(g);
        this.tableRight.setTransform(2);
        this.tableRight.setPosition(this.kindOfScreenX + this.tableLeft.getWidth(), KindOfScreen.y);
        this.tableRight.paint(g);
        this.battleNext(g, (short)0, level);
        this.battleNext(g, (short)1, level);
        this.battleNext(g, (short)2, level);
        this.battleNext(g, (short)3, level);
        this.battleNext(g, (short)4, level);
        this.battleNext(g, (short)5, level);
        this.battleNext(g, (short)6, level);
        this.battleNext(g, (short)7, level);
        this.battleNext(g, (short)8, level);
        this.battleNext(g, (short)9, level);
        this.battleNext(g, (short)10, level);
        this.battleNext(g, (short)11, level);
        this.battleNext(g, (short)12, level);
        this.battleNext(g, (short)13, level);
        this.battleNext(g, (short)14, level);
        this.battleNext(g, (short)15, level);
        this.battleNext(g, (short)16, level);
        this.battleNext(g, (short)17, level);
        this.battleNext(g, (short)18, level);
        this.battleNext(g, (short)19, level);
        this.battleNext(g, (short)20, level);
        this.battleNext(g, (short)21, level);
        PiPoDesigner.drawString(g, this.ttcX, KindOfScreen.y + 5, this.ttc, 0, -16777216, 0, this.ttc.length);
        this.movePosition(level);
        if (this.kindOfScreenX != 0) {
            g.setColor(0);
            g.fillRect(0, 0, (int)this.kindOfScreenX, (int)ThapTuChinhCanvas.height);
            g.fillRect(ThapTuChinhCanvas.width - this.kindOfScreenX, 0, (int)this.kindOfScreenX, (int)ThapTuChinhCanvas.height);
            if (KindOfScreen.x == 200) {
                g.fillRect(KindOfScreen.x, 0, 240, 80);
                g.fillRect((int)this.kindOfScreenX, ThapTuChinhCanvas.height - 80, (int)this.width, 80);
            }
        }
    }

    public void movePosition(short level) {
        if (this.nMove == 10) {
            if (this.isOuting) {
                if (this.x_1 < this.x_2 - 4) {
                    this.movePointX = (short)(this.movePointX + this.moveX[level]);
                    this.movePointY = (short)(this.movePointY + this.moveY[level]);
                    if (this.storeX == 0 && this.x_1 + this.moveX[level] >= this.width - 17) {
                        this.xMap = (short)(this.xMap - this.moveX[level]);
                    }
                    if (this.x_1 + this.moveX[level] == this.x_2 - 4) {
                        this.isOuting = false;
                    }
                } else if (this.x_1 > this.x_2 - 4) {
                    this.movePointX = (short)(this.movePointX - this.moveX[level]);
                    this.movePointY = (short)(this.movePointY - this.moveY[level]);
                    if (this.storeX == 0) {
                        if (this.x_1 - 4 - this.moveX[level] <= 0) {
                            this.xMap = (short)(this.xMap + this.moveX[level]);
                        }
                    } else if (this.x_1 - 4 - this.moveX[level] <= 223) {
                        this.xMap = (short)(this.xMap + this.moveX[level]);
                    }
                    if (this.x_1 - this.moveX[level] == this.x_2 - 4) {
                        this.isOuting = false;
                    }
                }
            }
        } else {
            this.nMove = (short)(this.nMove + 1);
        }
    }

    public void battleNext(Graphics g, short j, short level) {
        if (level == j - 1) {
            if (level >= 1) {
                this.battleNext.setPosition(this.x[level - 1] - 4 + this.xMap + this.movePointX + this.kindOfScreenX, this.y[level - 1] - 4 + this.movePointY + KindOfScreen.y);
                this.x_1 = (short)(this.x[level - 1] + this.movePointX);
                this.y_1 = (short)(this.y[level - 1] + this.movePointY);
            } else {
                this.battleNext.setPosition(this.x[0] - 4 + this.xMap + this.kindOfScreenX, this.y[0] - 4 + KindOfScreen.y);
            }
            this.battleNext.paint(g);
            this.battleNext.nextFrame();
        } else if (level > j) {
            this.battleFinished[j].setPosition(this.x[j] + this.xMap + this.kindOfScreenX, this.y[j] + KindOfScreen.y);
            this.battleFinished[j].paint(g);
            this.battleFinished[j].setFrame(1);
        } else if (level == j) {
            this.battleFinished[j].setPosition(this.x[j] + this.xMap + this.kindOfScreenX, this.y[j] + KindOfScreen.y);
            this.x_2 = (short)(this.x[j] + 4);
            this.y_2 = (short)(this.y[j] + 4);
            this.battleFinished[j].paint(g);
            this.battleFinished[j].setFrame(0);
            PiPoDesigner.drawString(g, this.x[j] + 7 + this.xMap + this.kindOfScreenX, this.y[j] - 10 + KindOfScreen.y, this.talks, -1728013927, -256, 0, this.talks.length);
        }
    }

    public void setNullInstance() {
        this.mGameDesign = null;
        this.mHistory.setNullInstance();
        this.mHistory = null;
        this.rgb = null;
    }
}

