/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.utils;

import com.bgate.core.GameObject;
import com.bgate.core.Screen;
import com.bgate.utils.PiPoDesigner;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;

public class Menu {
    public static final int DEFAULT_HEIGHT = 213;
    public static String[] menuPaymenu = new String[]{"scratch Cards", "SMS", "Exit"};
    public static int[] framePaymenu = new int[]{10, 10, 8};
    public static String[] menuLogin = new String[]{"Sign up", "Forgot Password", "About Us", "Exit"};
    public static int[] frameMenuLogin = new int[]{6, 9, 7, 8};
    public static String[] menuSelecRoom = new String[]{"Recharge", "Shop", "Top Players", "Inbox", "D.S Friends", "Change Password", "Exit"};
    public static int[] frameMenuSelectRoom = new int[]{10, 4, 5, 3, 2, 9, 8};
    public static String[] menuRoom = new String[]{"Recharge", "Shop", "Top Players", "Inbox", "D.S Friends", "Change Password", "Exit"};
    public static int[] frameMenuRoom = new int[]{10, 4, 5, 3, 2, 9, 8};
    public static String[] menuTableMaster = new String[]{"Recharge", "Bet", "Invite a player", "Set password", "Players", "Info", "Inbox", "Exit"};
    public static int[] frameTableMaster = new int[]{10, 11, 12, 13, 14, 15, 3, 8};
    public static String[] menuTableMasterHasPass = new String[]{"Recharge", "Bet", "Invite a player", "Set password", "Skip password", "Players", "Info", "Inbox", "Exit"};
    public static int[] frameTableMasterHasPass = new int[]{10, 11, 12, 13, 17, 14, 15, 3, 8};
    public static String[] menuTableMasterPlaying = new String[]{"Recharge", "Players", "Info", "Inbox", "Exit"};
    public static int[] frameTableMasterPlaying = new int[]{10, 12, 15, 3, 8};
    public static String[] menuTablePlayer = new String[]{"Recharge", "Players", "Info", "Inbox", "Exit"};
    public static int[] frameTablePlayer = new int[]{10, 12, 15, 3, 8};
    public static String[] menuPopupMaster = new String[]{"Kick player", "View Profile", "Add to Friends", "Skip"};
    public static int[] framePopupMaster = new int[]{18, 1, 16, 8};
    public static String[] menuPopupPlayer = new String[]{"View Profile", "Add to Friends", "Skip"};
    public static int[] framePopupPlayer = new int[]{1, 16, 8};
    public Screen screen;
    public boolean isTouchScreen;
    public String[] texts;
    public int[] frames;
    public MenuItem[] items;
    public int index;
    public int minIndexMenu;
    public int maxItemOn;
    public TiledLayer background;
    public int width;
    public int height;
    public int maxHeight;
    public int x;
    public int y;
    public boolean itemMoveUp;
    public boolean itemMoveDown;
    public int noMove;

    public Menu(Screen screen, String[] texts, int[] frames, int maxHeight) {
        this.screen = screen;
        this.texts = texts;
        this.frames = frames;
        this.maxHeight = maxHeight;
        this.init();
    }

    public Menu(Screen screen, String[] texts, int[] frames) {
        this.screen = screen;
        this.texts = texts;
        this.frames = frames;
        this.maxHeight = 213;
        this.init();
    }

    public void updateNew(String[] texts, int[] frames, int maxHeight) {
        this.texts = null;
        this.background = null;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].dispose();
            this.items[i] = null;
        }
        this.items = null;
        this.texts = texts;
        this.frames = frames;
        this.maxHeight = maxHeight;
        Runtime.getRuntime().gc();
        this.init();
    }

    public void init() {
        this.items = new MenuItem[this.texts.length];
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i] = new MenuItem(this.texts[i], this.frames[i], i);
            this.items[i].setBoxSize(148, 33);
        }
        if (this.items.length * this.items[0].boxHeight < this.maxHeight) {
            this.height = this.items.length * this.items[0].boxHeight;
            this.maxItemOn = this.items.length;
        } else {
            this.height = this.maxHeight;
            this.maxItemOn = this.maxHeight / this.items[0].getBoxHeight();
        }
        this.width = this.background.getWidth();
    }

    public void setPosition(int x, int y) {
        this.x = x;
        this.y = y;
        this.background.setPosition(x, y);
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].setPosition(x, y + (this.height - this.maxItemOn * this.items[0].boxHeight) / 2 + i * this.items[i].getBoxHeight());
        }
    }

    public int down() {
        if (this.index < this.items.length - 1) {
            if (this.index == this.minIndexMenu + this.maxItemOn - 1) {
                ++this.minIndexMenu;
                this.itemMoveUp = true;
            }
            ++this.index;
        }
        return this.index;
    }

    public int up() {
        if (this.index > 0) {
            if (this.index == this.minIndexMenu) {
                --this.minIndexMenu;
                this.itemMoveDown = true;
            }
            --this.index;
        }
        return this.index;
    }

    public void resetIndex() {
        this.index = 0;
        this.minIndexMenu = 0;
    }

    public void paint(Graphics g) {
        int dy;
        int i;
        if (this.itemMoveDown) {
            for (i = 0; i < this.items.length; ++i) {
                this.items[i].move(0, this.items[i].getBoxHeight() / 3);
            }
            ++this.noMove;
            if (this.noMove == 3) {
                this.itemMoveDown = false;
                this.noMove = 0;
                for (i = 0; i < this.items.length; ++i) {
                    dy = this.items[i].getBoxHeight() - 3 * (this.items[i].getBoxHeight() / 3);
                    this.items[i].move(0, dy);
                }
            }
        } else if (this.itemMoveUp) {
            for (i = 0; i < this.items.length; ++i) {
                this.items[i].move(0, -this.items[i].getBoxHeight() / 3);
            }
            ++this.noMove;
            if (this.noMove == 3) {
                this.itemMoveUp = false;
                this.noMove = 0;
                for (i = 0; i < this.items.length; ++i) {
                    dy = this.items[i].getBoxHeight() - 3 * (this.items[i].getBoxHeight() / 3);
                    this.items[i].move(0, -dy);
                }
            }
        }
        g.setClip(this.x, this.y, this.width, this.height);
        this.background.paint(g);
        for (i = 0; i < this.items.length; ++i) {
            this.items[i].paint(g);
        }
        g.setClip(0, 0, this.screen.getWidth(), this.screen.getHeight());
    }

    public void dispose() {
        this.texts = null;
        this.screen = null;
        this.background = null;
        for (int i = 0; i < this.items.length; ++i) {
            this.items[i].dispose();
            this.items[i] = null;
        }
        this.items = null;
    }

    public boolean inBounds(int x, int y) {
        for (int i = 0; i < this.items.length; ++i) {
            if (!this.screen.inBounds(x, y, this.items[i].getX(), this.items[i].getY(), this.items[i].getBoxWidth(), this.items[i].getBoxHeight())) continue;
            this.index = i;
            return true;
        }
        return false;
    }

    public boolean checkDragged(int xRealeased, int yRealeased, int xPressed, int yPressed) {
        boolean bl = true;
        int deltaY = Math.abs(yPressed - yRealeased);
        if (deltaY > 10) {
            bl = true;
            if (yRealeased > yPressed) {
                this.up();
            }
            if (yRealeased < yPressed) {
                this.down();
            }
        } else {
            bl = false;
        }
        return bl;
    }

    public class MenuItem
    extends GameObject {
        public Sprite icon;
        public String title;
        public int indexItem;

        public MenuItem(String title, int frame, int index) {
            this.icon.setFrame(frame);
            this.title = title;
            this.indexItem = index;
        }

        public void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
            this.icon.setPosition(x + 5, y);
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }

        public int getBoxWidth() {
            return this.boxWidth;
        }

        public int getBoxHeight() {
            return this.boxHeight;
        }

        public void setBoxSize(int boxWidth, int boxHeight) {
            this.boxWidth = boxWidth;
            this.boxHeight = boxHeight;
        }

        public void move(int dx, int dy) {
            this.x += dx;
            this.y += dy;
            this.icon.move(dx, dy);
        }

        public void paint(Graphics g) {
            if (Menu.this.index == this.indexItem) {
                g.setColor(117, 117, 117);
                g.fillRect(this.x, this.y - 2, this.boxWidth, this.boxHeight);
            }
            this.icon.paint(g);
            PiPoDesigner.drawString(g, this.title, -1, 0, this.icon.getX() + this.icon.getWidth() + 6, this.icon.getY() + this.icon.getHeight() / 2 - 8);
        }

        public void dispose() {
            this.icon = null;
            this.title = null;
        }

        public void nextFrame() {
        }

        public void setFrame(int index) {
            this.icon.setFrame(index);
        }

        public int getFrame() {
            return 0;
        }
    }
}

