/*
 * Decompiled with CFR 0.152.
 */
package com.bgate.utils;

import com.bgate.core.Screen;
import com.bgate.utils.PiPoDesigner;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public class Dialog {
    public static final int DIALOG_WARNING = 0;
    public static final int DIALOG_LOADING = 1;
    public static final int DIALOG_OKCANCEL = 2;
    public static final int DIALOG_OK = 3;
    public static final int DIALOG_NOTICE = 4;
    public Screen screen;
    public int type;
    public int kind = -1;
    public int width;
    public int height;
    public String text = "Please wait ...";
    public Sprite loading;

    public Dialog(Screen screen, int type) {
        this.screen = screen;
        this.type = type;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setKind(int kind) {
        this.kind = kind;
    }

    public void paintWarning(Graphics g) {
        g.setColor(0, 51, 77);
        g.fillRoundRect(20, this.screen.getHeight() - 5 - 20 - 35, this.screen.getWidth() - 40, 57, 10, 10);
        g.setColor(-16472648);
        g.fillRect(20, this.screen.getHeight() - 5 - 25, this.screen.getWidth() - 40, 20);
        g.drawRoundRect(20, this.screen.getHeight() - 5 - 20 - 35, this.width - 40, 57, 10, 10);
        PiPoDesigner.drawCenterString(g, "OK", -65536, -1, this.screen.getWidth() / 2, this.screen.getHeight() - 5 - 22);
        PiPoDesigner.drawCenterString(g, this.text, -1, -1, this.screen.getWidth() / 2, this.screen.getHeight() - 5 - 20 - 20 - 5);
    }

    public void paintLoading(Graphics g) {
        if (this.loading == null) {
            // empty if block
        }
        g.setColor(0, 51, 77);
        g.fillRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() - 20 - 30, 2 * this.screen.getWidth() / 3, 50, 10, 10);
        g.setColor(18, 87, 104);
        g.drawRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() - 20 - 30, 2 * this.screen.getWidth() / 3, 49, 10, 10);
        PiPoDesigner.drawCenterString(g, this.text, -1, -1, this.screen.getWidth() / 2, this.screen.getHeight() - 20);
    }

    public void paintOkCancel(Graphics g) {
        g.setColor(0, 51, 77);
        g.fillRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() / 4, 2 * this.screen.getWidth() / 3, this.screen.getHeight() / 2, 7, 7);
        g.setColor(18, 87, 104);
        g.drawRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() / 4, 2 * this.screen.getWidth() / 3, this.screen.getHeight() / 2, 7, 7);
        g.drawLine(this.screen.getWidth() / 6, 3 * this.screen.getHeight() / 4 - 22, 5 * this.screen.getWidth() / 6, 3 * this.screen.getHeight() / 4 - 22);
        PiPoDesigner.drawString(g, this.text, -1, -1, this.screen.getWidth() / 6 + 5, this.screen.getHeight() / 4 + 5, 2 * this.screen.getWidth() / 3 - 10, this.screen.getHeight() / 2 - 10);
        PiPoDesigner.drawString(g, "Agree", -1, -1, this.screen.getWidth() / 6 + 5, 3 * this.screen.getHeight() / 4 - 20);
        PiPoDesigner.drawString(g, "Skip", -1, -1, 5 * this.screen.getWidth() / 6 - 5 - PiPoDesigner.stringWidth("Decline"), 3 * this.screen.getHeight() / 4 - 20);
    }

    public void paintOk(Graphics g) {
        g.setColor(0, 51, 77);
        g.fillRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() / 4, 2 * this.screen.getWidth() / 3, this.screen.getHeight() / 2, 7, 7);
        g.setColor(18, 87, 104);
        g.drawRoundRect(this.screen.getWidth() / 6, this.screen.getHeight() / 4, 2 * this.screen.getWidth() / 3, this.screen.getHeight() / 2, 7, 7);
        g.drawLine(this.screen.getWidth() / 6, 3 * this.screen.getHeight() / 4 - 22, 5 * this.screen.getWidth() / 6, 3 * this.screen.getHeight() / 4 - 22);
        PiPoDesigner.drawString(g, this.text, -1, -1, this.screen.getWidth() / 6 + 5, this.screen.getHeight() / 4 + 5, 2 * this.screen.getWidth() / 3 - 10, this.screen.getHeight() / 2 - 10);
        PiPoDesigner.drawCenterString(g, "OK", -1, -1, this.screen.getWidth() / 2, 3 * this.screen.getHeight() / 4 - 20);
    }

    public void paintNotice(Graphics g) {
        g.setColor(0, 51, 77);
        g.fillRoundRect(20, this.screen.getHeight() - 5 - 20 - 35, this.screen.getWidth() - 40, 57, 10, 10);
        g.setColor(18, 87, 104);
        g.drawRoundRect(20, this.screen.getHeight() - 5 - 20 - 35, this.screen.getWidth() - 40, 57, 10, 10);
        PiPoDesigner.drawCenterString(g, this.text, -1, -1, this.screen.getWidth() / 2, this.screen.getHeight() - 5 - 20 - 20 - 5);
    }

    public void paint(Graphics g) {
        switch (this.type) {
            case 1: {
                this.paintLoading(g);
                break;
            }
            case 2: {
                this.paintOkCancel(g);
                break;
            }
            case 0: {
                this.paintWarning(g);
                break;
            }
            case 3: {
                this.paintOk(g);
                break;
            }
            case 4: {
                this.paintNotice(g);
            }
        }
    }

    public boolean touchOkWarning(int x, int y) {
        return this.screen.inBounds(x, y, this.screen.getWidth() / 2 - 100, this.screen.getHeight() - 60, 200, 60);
    }

    public boolean touchOkDialogOkCancel(int x, int y) {
        int xAnchorOk = this.screen.getWidth() / 6;
        int yAnchorOk = 3 * this.screen.getHeight() / 4 - 40;
        int xAnchorCancel = 5 * this.screen.getWidth() / 6 - 15 - PiPoDesigner.stringWidth("Skip");
        int yAnchorCancel = 3 * this.screen.getHeight() / 4 - 40;
        return this.screen.inBounds(x, y, xAnchorOk, yAnchorOk, 40, 40);
    }

    public boolean touchCancelDialogOkCancel(int x, int y) {
        int xAnchorCancel = 5 * this.screen.getWidth() / 6 - 15 - PiPoDesigner.stringWidth("Skip");
        int yAnchorCancel = 3 * this.screen.getHeight() / 4 - 40;
        return this.screen.inBounds(x, y, xAnchorCancel, yAnchorCancel, 40, 40);
    }

    public boolean touchOkDialog(int x, int y) {
        return true;
    }
}

