/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.FilterInputStream;
import java.io.IOException;
import java.util.Hashtable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ActionGroup {
    public static Hashtable imageTable = new Hashtable();
    ActionGroup instance;
    Action[] actions;
    long[] moduleSize;
    public String fileName;
    int cx;
    int cy;

    public ActionGroup(String fn) {
        this.fileName = fn;
        if (this.fileName.indexOf(".bin") == -1) {
            this.fileName = String.valueOf(this.fileName) + ".bin";
        }
        FilterInputStream dis = null;
        try {
            try {
                dis = new DataInputStream(this.getClass().getResourceAsStream(this.fileName));
                int headSize = ((DataInputStream)dis).readUnsignedByte();
                this.moduleSize = new long[headSize];
                String[] name = new String[headSize];
                int i = 0;
                while (i < headSize) {
                    this.moduleSize[i] = ((DataInputStream)dis).readLong();
                    int length = ((DataInputStream)dis).readInt();
                    byte[] data = new byte[length];
                    ((DataInputStream)dis).read(data);
                    name[i] = new String(data, "UTF-8");
                    data = null;
                    ++i;
                }
                int actionNum = ((DataInputStream)dis).readUnsignedByte();
                this.actions = new Action[actionNum];
                int i2 = 0;
                while (i2 < actionNum) {
                    this.actions[i2] = new Action();
                    int frameNum = ((DataInputStream)dis).readUnsignedByte();
                    this.actions[i2].frames = new Frame[frameNum];
                    int j = 0;
                    while (j < frameNum) {
                        this.actions[i2].frames[j] = new Frame();
                        this.actions[i2].frames[j].delay = ((DataInputStream)dis).readShort();
                        this.actions[i2].frames[j].collide = ((DataInputStream)dis).readLong();
                        int moduleNum = ((DataInputStream)dis).readUnsignedByte();
                        this.actions[i2].frames[j].modules = new Module[moduleNum];
                        int k = 0;
                        while (k < moduleNum) {
                            int ID = ((DataInputStream)dis).readUnsignedByte();
                            this.actions[i2].frames[j].modules[k] = new Module();
                            this.actions[i2].frames[j].modules[k].id = ID;
                            this.actions[i2].frames[j].modules[k].srcx = ((DataInputStream)dis).readShort();
                            this.actions[i2].frames[j].modules[k].srcy = ((DataInputStream)dis).readShort();
                            this.actions[i2].frames[j].modules[k].rotate = ((DataInputStream)dis).readByte();
                            this.actions[i2].frames[j].modules[k].actionList = this;
                            this.actions[i2].frames[j].modules[k].srcImage = this.getImage(name[ID]);
                            ++k;
                        }
                        ++j;
                    }
                    ++i2;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        finally {
            try {
                if (dis != null) {
                    dis.close();
                }
            }
            catch (Exception exception) {}
        }
    }

    private Image getImage(String name) {
        Image srcImage = null;
        if (imageTable.containsKey(name)) {
            srcImage = (Image)imageTable.get(name);
        } else {
            try {
                srcImage = Image.createImage((String)("/imgAct/" + name + ".png"));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            imageTable.put(name, srcImage);
        }
        return srcImage;
    }

    public void playAction(int id, int count) {
        if (id < 0 || id > this.actions.length - 1) {
            return;
        }
        this.actions[id].playAction(count);
    }

    public void paintAction(int id, Graphics g, int cx, int cy) {
        if (id < 0 || id > this.actions.length - 1) {
            return;
        }
        this.actions[id].paintAction(g, cx, cy);
    }

    public Action getAction(int id) {
        if (id < 0 || id > this.actions.length - 1) {
            return null;
        }
        return this.actions[id];
    }

    public boolean isEnd(int id) {
        if (id < 0 || id > this.actions.length - 1) {
            return true;
        }
        return this.actions[id].isEnd();
    }

    public void setFrame(int id, int index) {
        if (id < 0 || id > this.actions.length - 1) {
            return;
        }
        this.actions[id].setFrame(index);
    }

    public void removeMe() {
        imageTable.remove(this.fileName);
    }
}

