/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.io.IOException;

public final class CGameStats
implements GameStats {
    public static final byte CAMERA_NONE = 0;
    public static final byte CAMERA_NORMAL = 1;
    public static final byte CAMERA_OVERRIDE = 2;
    public static final byte SYS_WORLD = 0;
    public static final byte SYS_SCREEN = 1;
    public static final byte SYS_CAMERA = 2;
    public static int[] STATE_Type;
    public static int[] STATE_Flags;
    public byte m_type = (byte)-1;
    public int m_flags;
    public int m_flags_ex;
    protected short m_life;
    public int m_Components;
    public static final int ANIMATOR_State = 0;
    public static final int ANIMATOR_ClipID = 1;
    public static final int ANIMATOR_Time = 2;
    public static final int ANIMATOR_Max = 3;
    public int[][] m_Animators;
    public byte m_Layer;
    public byte m_geometry_type;
    public int m_size;
    public int m_size_y;
    public int m_PassableCellsMask;
    public int m_ExcludeObjectsMask;
    public boolean m_bSlidingEnabled;
    public int m_MaxSpeed;
    public boolean m_bMoverBehavior;
    public int m_CollisionObjectsMask = 0;
    public static final int WEAPON_Type = 0;
    public static final int WEAPON_ClassID = 1;
    public static final int WEAPON_BulletID = 2;
    public static final int WEAPON_FireEffect = 3;
    public static final int WEAPON_FireX = 4;
    public static final int WEAPON_FireY = 5;
    public static final int WEAPON_FireZ = 6;
    public static final int WEAPON_SoundID = 7;
    public static final int WEAPON_ReloadTime = 8;
    public static final int WEAPON_ClipReloadTime = 9;
    public static final int WEAPON_NonbulletDmg = 10;
    public static final int WEAPON_StateID = 11;
    public static final int WEAPON_Accuracy = 12;
    public static final int WEAPON_AmmoInClip = 13;
    public static final int WEAPON_Ammo = 14;
    public static final int WEAPON_Max = 15;
    public int[][] m_Weapons;
    public static final int INTERACTIVE_NumStates = 0;
    public static final int INTERACTIVE_Effect = 1;
    public static final int INTERACTIVE_Max = 2;
    public int[] m_Interactive;
    public static final int WARRIOR_WeaponDeviation = 0;
    public static final int WARRIOR_AttackDuration = 1;
    public static final int WARRIOR_AttackCooldown = 2;
    public static final int WARRIOR_SpawnCooldown = 3;
    public static final int WARRIOR_BulletsPerShoot = 4;
    public static final int WARRIOR_Max = 5;
    public int[] m_Warrior;
    public static final int PHYSICS_Mass = 0;
    public static final int PHYSICS_Friction = 1;
    public static final int PHYSICS_Max = 2;
    public int[] m_Physics;
    public static final int EXPLOSIVE_Radius = 0;
    public static final int EXPLOSIVE_Impulse = 1;
    public static final int EXPLOSIVE_Damage = 2;
    public static final int EXPLOSIVE_EffectID = 3;
    public static final int EXPLOSIVE_SoundID = 4;
    public static final int EXPLOSIVE_Max = 5;
    public int[] m_Explosive;
    public static final int TARGET_ClassID = 0;
    public static final int TARGET_CanDisengage = 1;
    public static final int TARGET_Max = 2;
    public int[][] m_Targets;
    public int m_TargetMaxDistance;
    public int m_TargetMaxAngle;
    public static final int ARMOURED_Bullet = 0;
    public static final int ARMOURED_Percentage = 1;
    public static final int ARMOURED_Max = 2;
    public int[][] m_Vulnerabilities;

    CGameStats() {
    }

    public String toString() {
        return "m_type " + this.m_type;
    }

    public void AssignComponents(CGameStats cGameStats) {
        Debug.Println("AssignComponents: " + this.m_type + " from " + cGameStats.m_type);
        this.m_Components = cGameStats.m_Components;
        this.m_Animators = cGameStats.m_Animators;
        this.m_Layer = cGameStats.m_Layer;
        this.m_geometry_type = cGameStats.m_geometry_type;
        this.m_size = cGameStats.m_size;
        this.m_size_y = cGameStats.m_size_y;
        this.m_PassableCellsMask = cGameStats.m_PassableCellsMask;
        this.m_ExcludeObjectsMask = cGameStats.m_ExcludeObjectsMask;
        this.m_bSlidingEnabled = cGameStats.m_bSlidingEnabled;
        this.m_MaxSpeed = cGameStats.m_MaxSpeed;
        this.m_bMoverBehavior = cGameStats.m_bMoverBehavior;
        this.m_CollisionObjectsMask = cGameStats.m_CollisionObjectsMask;
        this.m_Weapons = cGameStats.m_Weapons;
        this.m_Interactive = cGameStats.m_Interactive;
        this.m_Warrior = cGameStats.m_Warrior;
        this.m_Physics = cGameStats.m_Physics;
        this.m_Explosive = cGameStats.m_Explosive;
        this.m_Targets = cGameStats.m_Targets;
        this.m_TargetMaxDistance = cGameStats.m_TargetMaxDistance;
        this.m_TargetMaxAngle = cGameStats.m_TargetMaxAngle;
        this.m_Vulnerabilities = cGameStats.m_Vulnerabilities;
    }

    public static void LoadStates(DataInputStream dataInputStream) throws IOException {
        STATE_Type = new int[15];
        STATE_Flags = new int[15];
        int n = dataInputStream.readShort();
        for (int i = 0; i < n; ++i) {
            int n2 = dataInputStream.readInt();
            int n3 = dataInputStream.readInt();
            int n4 = dataInputStream.readInt();
            if (15 == n2) continue;
            CGameStats.STATE_Type[n2] = n3;
            CGameStats.STATE_Flags[n2] = n4;
        }
    }

    public void loadFromStream(DataInputStream dataInputStream) throws IOException {
        this.m_type = (byte)dataInputStream.readInt();
        int n = dataInputStream.readInt();
        if (-1 != n) {
            this.AssignComponents(CGameScene.g_scene.GameStats_FindStatsByType(n));
        }
        this.m_life = dataInputStream.readShort();
        this.m_flags = dataInputStream.readInt();
        this.m_flags_ex = dataInputStream.readInt();
        int n2 = dataInputStream.readShort();
        for (int i = 0; i < n2; ++i) {
            this.loadComponent(dataInputStream, dataInputStream.readInt());
        }
    }

    protected void loadComponent(DataInputStream dataInputStream, int n) throws IOException {
        switch (n) {
            case 0: {
                this.m_Layer = (byte)dataInputStream.readInt();
                this.m_Animators = new int[dataInputStream.readShort()][];
                for (int i = 0; i < this.m_Animators.length; ++i) {
                    this.m_Animators[i] = new int[3];
                    this.m_Animators[i][0] = dataInputStream.readInt();
                    this.m_Animators[i][1] = dataInputStream.readInt();
                    this.m_Animators[i][2] = dataInputStream.readInt();
                    if (0 != this.m_Animators[i][2]) continue;
                    this.m_Animators[i][2] = Integer.MAX_VALUE;
                }
                break;
            }
            case 1: {
                this.m_geometry_type = (byte)dataInputStream.readInt();
                this.m_size = dataInputStream.readInt();
                this.m_size_y = dataInputStream.readInt();
                switch (this.m_geometry_type) {
                    case 0: 
                    case 1: {
                        this.m_size_y = this.m_size;
                    }
                }
                break;
            }
            case 2: {
                this.m_PassableCellsMask = dataInputStream.readInt();
                this.m_ExcludeObjectsMask = dataInputStream.readInt();
                this.m_bSlidingEnabled = dataInputStream.readBoolean();
                break;
            }
            case 5: {
                this.m_MaxSpeed = dataInputStream.readInt();
                this.m_bMoverBehavior = dataInputStream.readBoolean();
                this.m_CollisionObjectsMask = dataInputStream.readInt();
                break;
            }
            case 4: {
                this.m_Weapons = new int[dataInputStream.readShort()][15];
                for (int i = 0; i < this.m_Weapons.length; ++i) {
                    for (int j = 0; j < 15; ++j) {
                        this.m_Weapons[i][j] = dataInputStream.readInt();
                    }
                }
                break;
            }
            case 6: {
                this.m_Warrior = new int[5];
                for (int i = 0; i < 5; ++i) {
                    this.m_Warrior[i] = dataInputStream.readInt();
                }
                break;
            }
            case 7: {
                this.m_Interactive = new int[2];
                for (int i = 0; i < 2; ++i) {
                    this.m_Interactive[i] = dataInputStream.readInt();
                }
                break;
            }
            case 9: {
                this.m_Physics = new int[2];
                for (int i = 0; i < 2; ++i) {
                    this.m_Physics[i] = dataInputStream.readInt();
                }
                break;
            }
            case 10: {
                this.m_Explosive = new int[5];
                for (int i = 0; i < 5; ++i) {
                    this.m_Explosive[i] = dataInputStream.readInt();
                }
                break;
            }
            case 11: {
                this.m_TargetMaxDistance = dataInputStream.readInt();
                this.m_TargetMaxAngle = dataInputStream.readInt();
                this.m_Targets = new int[dataInputStream.readShort()][2];
                for (int i = 0; i < this.m_Targets.length; ++i) {
                    this.m_Targets[i][0] = dataInputStream.readInt();
                    this.m_Targets[i][1] = dataInputStream.readBoolean() ? 1 : 0;
                }
                break;
            }
            case 13: {
                this.m_Vulnerabilities = new int[dataInputStream.readShort()][2];
                for (int i = 0; i < this.m_Vulnerabilities.length; ++i) {
                    for (int j = 0; j < 2; ++j) {
                        this.m_Vulnerabilities[i][j] = dataInputStream.readInt();
                    }
                }
                break;
            }
        }
        this.m_Components |= 1 << n;
    }

    void reset() {
    }

    short getLife() {
        int n = -1;
        if (this.isPlayer()) {
            n = 0;
        } else if (15 == this.m_type) {
            n = 1;
        } else if (this.isEnemy()) {
            n = 3;
        } else if (21 == this.m_type) {
            n = 4;
        }
        if (-1 != n) {
            return (short)g5.Math_MulFlt(this.m_life, CGameScene.g_scene.GamePlot_GetConst(n));
        }
        return this.m_life;
    }

    boolean isPlayer() {
        return this.checkFlags(2048);
    }

    boolean isEnemy() {
        return 0 != (this.m_Components & 0x40);
    }

    int getTargetPriority(CGameStats cGameStats) {
        if (null != this.m_Targets) {
            for (int i = 0; i < this.m_Targets.length; ++i) {
                if (this.m_Targets[i][0] != cGameStats.m_type) continue;
                return i;
            }
        }
        return Integer.MAX_VALUE;
    }

    int getHitEffect() {
        if ((this.m_Components & 0x40) != 0 || (this.m_flags & 0x800) != 0) {
            return 24;
        }
        return -1;
    }

    int getHeadlessType() {
        switch (this.m_type) {
            case 2: {
                return 26;
            }
            case 39: {
                return 65;
            }
            case 60: {
                return 66;
            }
            case 23: {
                return 40;
            }
            case 24: {
                return 41;
            }
        }
        return -1;
    }

    int GetVulnerability(int n) {
        for (int i = 0; i < this.m_Vulnerabilities.length; ++i) {
            if (n != this.m_Vulnerabilities[i][0]) continue;
            return this.m_Vulnerabilities[i][1];
        }
        return 0;
    }

    boolean checkFlags(int n) {
        if (-1 == n) {
            return true;
        }
        return 0 != (this.m_flags & n);
    }

    boolean checkFlagsEx(int n) {
        if (-1 == n) {
            return true;
        }
        return 0 != (this.m_flags_ex & n);
    }
}

