/*
 * Decompiled with CFR 0.152.
 */
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class CTerrainObject {
    protected static final int PASSLAYERINFO_TYPE = 0;
    protected static final int PASSLAYERINFO_ACTIVITY = 1;
    protected static final int PASSLAYERINFO_MAX = 2;
    protected static final int GRAPHLAYERINFO_ACTIVITY = 0;
    protected static final int GRAPHLAYERINFO_MAX = 1;
    protected static final byte EPLT_NONE = 0;
    protected static final byte EPLT_FULL = 1;
    protected static final byte EPLT_RECT = 2;
    public static final byte EPLA_ON = 0;
    public static final byte EPLA_OFF = 1;
    public static final byte EGLA_ON = 0;
    public static final byte EGLA_OFF = 1;
    public static final byte EGTA_ON = 0;
    public static final byte EGTA_OFF = 1;
    public static final byte BASEGAMEPASSVALUE_OPEN = 0;
    public static final byte BASEGAMEPASSVALUE_CLOSED = 1;
    public static final byte BASEGAMEPASSVALUE_SHOOT = 2;
    public static final byte BASEGAMEPASSVALUE_SMOOTH = 3;
    protected static int[] m_frect1 = new int[5];
    protected static int[] m_frect2 = new int[5];
    protected static int[] m_frect3 = new int[5];
    protected static int[] m_coords1 = new int[3];
    private static final int LEVELLAYER_BOTTOM = 0;
    private static final int LEVELLAYER_DYNAMIC = 1;
    private static final int LEVELLAYER_TOP = 2;
    private static final int LEVELLAYER_MAX = 3;
    protected short m_GridX;
    protected short m_GridY;
    protected short m_GridCellWidth;
    protected short m_GridCellHeight;
    protected short m_GridColumns;
    protected short m_GridRows;
    protected byte[] m_GridData;
    protected Image[] m_GridTiles;
    protected short m_PassGridW;
    protected short m_PassGridH;
    protected int m_PassCellW;
    protected int m_PassCellH;
    protected byte[] m_PassLayers;
    protected Vector m_PassData;
    protected CGameScene m_Scene;
    public static byte CheckedPassValue;
    static final int PBH_Fast = 0;
    static final int PBH_Nice = 1;
    protected static int m_CollisionHint;

    public void Init(int n) {
        this.m_Scene = CGameScene.g_scene;
        try {
            int n2;
            int n3;
            int n4;
            DataInputStream dataInputStream = g5.getResourcePart("/Levels.bin", n);
            dataInputStream.readShort();
            this.m_GridX = dataInputStream.readShort();
            this.m_GridY = dataInputStream.readShort();
            this.m_GridCellWidth = dataInputStream.readShort();
            this.m_GridCellHeight = dataInputStream.readShort();
            this.m_GridColumns = dataInputStream.readShort();
            this.m_GridRows = dataInputStream.readShort();
            this.m_GridX = (short)(this.m_GridX - (this.m_GridCellWidth >> 1));
            this.m_GridY = (short)(this.m_GridY - (this.m_GridCellHeight >> 1));
            dataInputStream.skip(dataInputStream.readUnsignedByte());
            this.m_GridData = new byte[this.m_GridColumns * this.m_GridRows];
            dataInputStream.readFully(this.m_GridData);
            this.m_GridTiles = new Image[256];
            for (n4 = 0; n4 < this.m_GridData.length; ++n4) {
                n3 = this.m_GridData[n4];
                if (n3 == -1 || null != this.m_GridTiles[n2 = n3 & 0xFF]) continue;
                this.m_GridTiles[n2] = Image.createImage((int)this.m_GridCellWidth, (int)this.m_GridCellHeight);
                g5.Tile_Render(this.m_GridTiles[n2].getGraphics(), n2, this.m_GridCellWidth >> 1, this.m_GridCellHeight >> 1);
            }
            this.m_PassGridW = dataInputStream.readShort();
            this.m_PassGridH = dataInputStream.readShort();
            this.m_PassCellW = dataInputStream.readInt();
            this.m_PassCellH = dataInputStream.readInt();
            n4 = dataInputStream.readByte();
            if (n4 > 0 && this.m_PassGridW > 0 && this.m_PassGridH > 0) {
                this.m_PassLayers = new byte[2 * n4];
                this.m_PassData = new Vector(n4);
                for (n3 = 0; n3 < n4; ++n3) {
                    int n5 = n3 * 2;
                    byte by = dataInputStream.readByte();
                    n2 = by;
                    this.m_PassLayers[n5 + 0] = by;
                    this.m_PassLayers[n5 + 1] = 0;
                    if (n2 != 1 || this.m_PassGridW <= 0 || this.m_PassGridH <= 0) continue;
                    byte[] byArray = new byte[this.m_PassGridW * this.m_PassGridH >> 2];
                    dataInputStream.readFully(byArray);
                    this.m_PassData.addElement(byArray);
                }
            }
            dataInputStream.close();
        }
        catch (Exception exception) {
            Debug.PrintException(exception);
        }
        this.m_Scene.m_gridWidth = this.m_PassGridW;
        this.m_Scene.m_gridHeight = this.m_PassGridH;
        this.m_Scene.m_cellWidth = this.m_PassCellW;
        this.m_Scene.m_cellHeight = this.m_PassCellH;
    }

    public void Shutdown() {
        this.m_GridTiles = null;
    }

    public void Render(Graphics graphics, byte by) {
        if (by != 0) {
            return;
        }
        int n = Math.max(0, (graphics.getClipX() - this.m_GridX) / this.m_GridCellWidth);
        int n2 = Math.max(0, (graphics.getClipY() - this.m_GridY) / this.m_GridCellHeight);
        int n3 = Math.min(this.m_GridColumns, n + (graphics.getClipWidth() + (this.m_GridCellWidth - 1)) / this.m_GridCellWidth + 1);
        int n4 = Math.min(this.m_GridRows, n2 + (graphics.getClipHeight() + (this.m_GridCellHeight - 1)) / this.m_GridCellHeight + 1);
        for (int i = n2; i < n4; ++i) {
            int n5 = i * this.m_GridColumns + n;
            int n6 = this.m_GridX + this.m_GridCellWidth * n;
            int n7 = this.m_GridY + this.m_GridCellHeight * i;
            int n8 = n;
            while (n8 < n3) {
                if ((this.m_GridData[n5] & 0xFF) >= 0 && (this.m_GridData[n5] & 0xFF) < this.m_GridTiles.length && this.m_GridTiles[this.m_GridData[n5] & 0xFF] != null) {
                    graphics.drawImage(this.m_GridTiles[this.m_GridData[n5] & 0xFF], n6, n7, 20);
                }
                ++n8;
                ++n5;
                n6 += this.m_GridCellWidth;
            }
        }
    }

    public static void setCollisionHint(int n) {
        m_CollisionHint = n;
    }

    protected boolean PB_Fast(int n, int n2) {
        if (CheckedPassValue != 3) {
            return true;
        }
        return this.isPositionBlocked(n - 1, n2) && this.isPositionBlocked(n, n2 - 1) ? m_frect3[1] < m_frect2[3] - m_frect3[0] + m_frect2[0] : (this.isPositionBlocked(n + 1, n2) && this.isPositionBlocked(n, n2 - 1) ? m_frect3[1] - m_frect2[1] < m_frect3[2] - m_frect2[0] : (this.isPositionBlocked(n + 1, n2) && this.isPositionBlocked(n, n2 + 1) ? m_frect3[3] > m_frect2[3] - m_frect3[2] + m_frect2[0] : this.isPositionBlocked(n - 1, n2) && this.isPositionBlocked(n, n2 + 1) && m_frect3[3] - m_frect2[1] > m_frect3[0] - m_frect2[0]));
    }

    protected boolean PB_Nice(int n, int n2) {
        int n3 = (m_frect1[0] + m_frect1[2]) / 2;
        int n4 = (m_frect1[1] + m_frect1[3]) / 2;
        if (CheckedPassValue == 3) {
            if (this.isPositionBlocked(n - 1, n2) && this.isPositionBlocked(n, n2 - 1)) {
                if (n3 >= m_frect2[0] && n4 >= m_frect2[1]) {
                    return m_frect1[0] + n4 < m_frect2[0] + m_frect2[3];
                }
            } else if (this.isPositionBlocked(n + 1, n2) && this.isPositionBlocked(n, n2 - 1)) {
                if (n3 < m_frect2[2] && n4 >= m_frect2[1]) {
                    return -n3 + m_frect1[1] < -m_frect2[0] + m_frect2[1];
                }
            } else if (this.isPositionBlocked(n + 1, n2) && this.isPositionBlocked(n, n2 + 1)) {
                if (n3 < m_frect2[2] && n4 < m_frect2[3]) {
                    return n3 + m_frect1[3] > m_frect2[0] + m_frect2[3];
                }
            } else if (this.isPositionBlocked(n - 1, n2) && this.isPositionBlocked(n, n2 + 1) && n3 >= m_frect2[0] && n4 < m_frect2[3]) {
                return -m_frect1[0] + n4 > -m_frect2[0] + m_frect2[1];
            }
        }
        if (m_frect3[3] - m_frect3[1] >= (m_frect1[2] - m_frect1[0]) / 2 - (m_frect3[2] - m_frect3[0])) {
            return true;
        }
        if (n3 >= m_frect3[0] && n3 < m_frect3[2]) {
            return true;
        }
        return n4 >= m_frect3[1] && n4 < m_frect3[3];
    }

    public boolean isPositionBlocked(int n, int n2, int n3) {
        CheckedPassValue = 0;
        if (this.m_PassData == null) {
            return false;
        }
        CTerrainObject.m_frect1[0] = n - n3;
        CTerrainObject.m_frect1[2] = n + n3;
        CTerrainObject.m_frect1[1] = n2 - n3;
        CTerrainObject.m_frect1[3] = n2 + n3;
        int n4 = Math.max(g5.Math_DivInt(m_frect1[0], this.m_PassCellW), 0);
        int n5 = Math.min(g5.Math_DivInt(m_frect1[2], this.m_PassCellW), this.m_PassGridW - 1);
        int n6 = Math.max(g5.Math_DivInt(m_frect1[1], this.m_PassCellH), 0);
        int n7 = Math.min(g5.Math_DivInt(m_frect1[3], this.m_PassCellH), this.m_PassGridH - 1);
        for (int i = n4; i <= n5; ++i) {
            for (int j = n6; j <= n7; ++j) {
                if (!this.isPositionBlocked(i, j)) continue;
                CTerrainObject.m_frect2[0] = i * this.m_PassCellW;
                CTerrainObject.m_frect2[2] = m_frect2[0] + this.m_PassCellW;
                CTerrainObject.m_frect2[1] = j * this.m_PassCellH;
                CTerrainObject.m_frect2[3] = m_frect2[1] + this.m_PassCellH;
                if (!g5.Math_IsIntersectsRect(m_frect1, m_frect2, m_frect3)) continue;
                if (0 == m_CollisionHint && this.PB_Fast(i, j)) {
                    return true;
                }
                if (1 != m_CollisionHint || !this.PB_Nice(i, j)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isPositionBlocked(int n, int n2) {
        try {
            for (int i = 0; i < this.m_PassData.size(); ++i) {
                int n3;
                byte[] byArray;
                if (this.getPassLayerActivity(i) != 0 || this.m_PassLayers[2 * i + 0] != 1 || 0 == (CheckedPassValue = (byte)(((byArray = (byte[])this.m_PassData.elementAt(i))[(n3 = n + n2 * this.m_PassGridW) >> 2] << ((n3 & 3) << 1) & 0xFF) >> 6))) continue;
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public boolean isIsectsWithSegment(int[] nArray, int[] nArray2, int[] nArray3, int[] nArray4) {
        int n = g5.Math_GetMagnitudeFast2DFlt(nArray[0] - nArray2[0], nArray[1] - nArray2[1]);
        int n2 = Math.min(this.m_PassCellW, this.m_PassCellH);
        int n3 = (n + n2 - 1) / n2;
        for (int i = 1; i <= n3; ++i) {
            g5.Math_InterpolateVector3D(m_coords1, nArray, nArray2, 0, n3, i);
            if (!this.isPositionBlocked(Math.max(g5.Math_DivInt(m_coords1[0], this.m_PassCellW), 0), Math.max(g5.Math_DivInt(m_coords1[1], this.m_PassCellH), 0)) || 2 == CheckedPassValue) continue;
            if (null != nArray3) {
                g5.Math_CopyVector3D(nArray3, m_coords1);
            }
            return true;
        }
        return false;
    }

    public void setPassLayerActivity(int n, byte by) {
        this.m_PassLayers[2 * n + 1] = by;
    }

    public byte getPassLayerActivity(int n) {
        return 0;
    }

    public void setGraphLayerActivity(int n, byte by) {
    }

    public byte getGraphLayerActivity(int n) {
        return 0;
    }

    public void setGraphTileActivity(int n, byte by) {
    }

    public byte getGraphTileActivity(int n) {
        return 0;
    }

    public void setGraphTilesActivity(byte by, byte by2, byte by3) {
    }
}

