/*
 * Decompiled with CFR 0.152.
 */
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Stack;
import java.util.Vector;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;

public class Debug {
    protected static OutputStream m_PrintStream;
    protected static InputStream m_InputStream;
    protected static StringBuffer m_PrintBuffer;
    protected static Vector m_CommandsQueue;
    protected static Stack m_ContextStack;
    protected static final int PRINT_BUFFER_MAX_LENGTH = 2000;
    static long m_memFree_last;

    protected static boolean Console_Init(String string) {
        m_PrintStream = System.out;
        if (null != m_InputStream) {
            new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() {
                    StringBuffer stringBuffer = new StringBuffer();
                    try {
                        while (true) {
                            char c;
                            if ((c = (char)m_InputStream.read()) == '\n') {
                                Vector vector = m_CommandsQueue;
                                synchronized (vector) {
                                    m_CommandsQueue.addElement(stringBuffer.toString());
                                }
                                stringBuffer.setLength(0);
                                continue;
                            }
                            if (c == '\r') continue;
                            stringBuffer.append(c);
                        }
                    }
                    catch (Exception exception) {
                        Debug.PrintException(exception);
                        return;
                    }
                }
            }).start();
        }
        return true;
    }

    protected static void Console_Shutdown() {
        try {
            if (null != m_PrintStream) {
                m_PrintStream.close();
            }
            if (null != m_InputStream) {
                m_InputStream.close();
            }
        }
        catch (IOException iOException) {
            Debug.PrintException(iOException);
        }
    }

    protected static boolean Console_Exec(String string) {
        if (string.equals("quit")) {
            g5.terminate();
        } else if (string.equals("gc")) {
            System.gc();
            Debug.Println("Mem total: " + Runtime.getRuntime().totalMemory() + " free: " + Runtime.getRuntime().freeMemory());
        } else if (string.equals("mem")) {
            Debug.Println("Mem block: " + Debug.memGetLargestFreeBlock());
        } else {
            CGameScene.g_scene.Messages_ShowMessage(string);
            Debug.Println("error: Unknown command");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void Console_ProcessCommands() {
        Vector vector = m_CommandsQueue;
        synchronized (vector) {
            while (!m_CommandsQueue.isEmpty()) {
                Debug.Console_Exec((String)m_CommandsQueue.elementAt(0));
                m_CommandsQueue.removeElementAt(0);
            }
        }
    }

    public static void Print(String string) {
        if (null != m_PrintStream) {
            try {
                m_PrintStream.write(string.getBytes());
                m_PrintStream.flush();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            if (m_PrintBuffer.length() > 2000) {
                m_PrintBuffer.delete(0, m_PrintBuffer.length() - 2000);
            }
            m_PrintBuffer.append(string);
        }
    }

    public static void Println(String string) {
        Debug.Print(string + "\r\n");
    }

    public static void PrintException(Throwable throwable) {
        Debug.Println(throwable.toString());
        throwable.printStackTrace();
        if (null == m_PrintStream) {
            String string = "";
            string = string + "--- CONTEXT:\r\n";
            string = string + Debug.ContextToString();
            string = string + "\r\n";
            string = string + "--- LOG:\r\n";
            string = string + m_PrintBuffer.toString();
            g5.g_display.setCurrent((Displayable)new TextBox("Error", string, Math.max(1, string.length()), 0));
        }
    }

    public static void PrintStackTrace() {
        try {
            throw new Exception();
        }
        catch (Exception exception) {
            Debug.PrintException(exception);
            return;
        }
    }

    public static void PrintMemory() {
        System.gc();
        Debug.Println("Mem total: " + Runtime.getRuntime().totalMemory() + " free: " + Runtime.getRuntime().freeMemory());
    }

    public static void ContextEnter(Object object) {
        m_ContextStack.push(object);
    }

    public static void ContextLeave() {
        m_ContextStack.pop();
    }

    public static String ContextToString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < m_ContextStack.size(); ++i) {
            stringBuffer.append(m_ContextStack.elementAt(i)).append(".");
        }
        return stringBuffer.toString();
    }

    public static boolean Init(MIDlet mIDlet) {
        return Debug.Console_Init("");
    }

    public static void Shutdown() {
        Debug.Console_Shutdown();
    }

    protected static void memReportBegin(String string) {
        System.gc();
        Debug.Println("----------Mem report---------");
        m_memFree_last = Runtime.getRuntime().freeMemory();
        Debug.Println(string);
    }

    protected static void memReport(String string) {
        System.gc();
        long l = Runtime.getRuntime().freeMemory();
        Debug.Println(string + ": " + l + " (" + (l - m_memFree_last) + ")");
        m_memFree_last = l;
    }

    protected static void memReportEnd() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static long memGetLargestFreeBlock() {
        byte[] byArray = null;
        long l = 0L;
        try {
            try {
                while (true) {
                    byArray = null;
                    System.gc();
                    byArray = new byte[(int)(l += 65536L)];
                }
            }
            catch (OutOfMemoryError outOfMemoryError) {
                byArray = null;
                System.gc();
            }
        }
        catch (Throwable throwable) {
            byArray = null;
            System.gc();
            throw throwable;
        }
        return l;
    }

    protected static void RenderStats(g5 g52, Graphics graphics, long l) {
    }

    static {
        m_PrintBuffer = new StringBuffer();
        m_CommandsQueue = new Vector();
        m_ContextStack = new Stack();
    }
}

