/*
 * Decompiled with CFR 0.152.
 */
public final class VectorInt {
    private static final int CAPACITY_INITIAL = 20;
    private static final int CAPACITY_INCREMENT = 20;
    public int m_capacityInitial = 20;
    public int m_capacityIncrement = 20;
    public int[] m_data = null;
    public int m_capacity;
    public int m_elements;

    VectorInt() {
    }

    VectorInt(VectorInt vectorInt) {
        this.m_capacity = vectorInt.m_capacity;
        this.m_elements = vectorInt.m_elements;
        this.m_capacityInitial = vectorInt.m_capacityInitial;
        this.m_capacityIncrement = vectorInt.m_capacityIncrement;
        if (this.m_capacity != 0) {
            this.m_data = new int[this.m_capacity];
            System.arraycopy(vectorInt.m_data, 0, this.m_data, 0, this.m_elements);
        }
    }

    void ensureCapacity(int n) {
        if (this.m_capacity < n) {
            while (this.m_capacity < n) {
                this.m_capacity += 20;
            }
            int[] nArray = new int[this.m_capacity];
            if (this.m_data != null) {
                System.arraycopy(this.m_data, 0, nArray, 0, this.m_elements);
            }
            this.m_data = nArray;
        }
    }

    void addValuePlaceholders(int n) {
        this.addValuePlaceholdersAt(n, this.m_elements);
    }

    void addValuePlaceholdersAt(int n, int n2) {
        int n3 = this.m_elements;
        if (n2 >= 0 && n2 <= n3) {
            int n4 = this.m_elements;
            this.ensureCapacity(n3 + n);
            int n5 = this.m_elements;
            try {
                System.arraycopy(this.m_data, n2, this.m_data, n2 + n, n3 - n2);
            }
            catch (Exception exception) {
                Debug.Println("ERROR: " + this.m_data + " " + n + " " + n2 + " " + n3 + " " + this.m_capacity + " " + n4 + " " + n5);
                Debug.Println("" + this.m_data.length);
                Debug.PrintException(exception);
            }
            this.m_elements = n3 + n;
        }
    }

    void addValue(int n) {
        this.addValueAt(n, this.m_elements);
    }

    void addValueAt(int n, int n2) {
        if (n2 >= 0 && n2 <= this.m_elements) {
            this.addValuePlaceholdersAt(1, n2);
            this.m_data[n2] = n;
        }
    }

    void remValuesAt(int n, int n2) {
        int n3 = this.m_elements;
        if (n > 0 && n2 >= 0 && n2 <= n3 - n) {
            System.arraycopy(this.m_data, n2 + n, this.m_data, n2, n3 - n2 - n);
            this.m_elements = n3 - n;
        }
    }

    void remValueAt(int n) {
        this.remValuesAt(1, n);
    }

    void remAllValues() {
        this.m_elements = 0;
    }

    boolean addSorted(int n) {
        int n2;
        for (n2 = 0; n2 < this.m_elements; ++n2) {
            if (this.m_data[n2] < n) continue;
            if (this.m_data[n2] != n) break;
            return false;
        }
        this.addValueAt(n, n2);
        return true;
    }

    int findSorted(int n) {
        for (int i = 0; i < this.m_elements; ++i) {
            if (n != this.m_data[i]) continue;
            return i;
        }
        return -1;
    }

    boolean deleteSorted(int n) {
        int n2 = this.findSorted(n);
        if (-1 == n2) {
            return false;
        }
        this.remValueAt(n2);
        return true;
    }
}

