/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Walker;
import javax.microedition.lcdui.Image;

public class Knight
extends Walker {
    public static final int[] KNIGHT_TURN_DELAY = new int[]{2, 3, 2, 2};
    public static final int[] KNIGHT_BATTLE_DELAY = new int[]{12, 12, 12, 12};
    public static final byte KNIGHT_START_HIT = 8;
    public static final int[] WIDTH = new int[]{90, 65, 100, 130};
    public static final int[] HEIGHT = new int[]{70, 80, 80, 63};

    public Knight(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByBlue, gameObjects, tracker);
        this.setAttackOver(false);
        this.actualTurnDelay = KNIGHT_TURN_DELAY[this.race];
        this.actualBattleDelay = KNIGHT_BATTLE_DELAY[this.race];
        this.start_hit_anim_idx = (byte)8;
        this.setTurnDelay(this.actualTurnDelay);
        this.type = 1;
        if (ownedByBlue) {
            this.sequence = GameObjects.KNIGHT_ANIM_SEQ[gameObjects.blueWarlord.race];
            this.pixelDiff = GameObjects.KNIGHT_PX_DIFF[gameObjects.blueWarlord.race];
            this.frames = CLImageTracker.pkr_blue[1];
            this.width = WIDTH[gameObjects.blueWarlord.race];
            this.height = HEIGHT[gameObjects.blueWarlord.race];
            CLGameCanvas.playerGameEvent = 17;
            System.out.println("Built knight!");
        } else {
            this.sequence = GameObjects.KNIGHT_ANIM_SEQ[gameObjects.redWarlord.race];
            this.pixelDiff = GameObjects.KNIGHT_PX_DIFF[gameObjects.redWarlord.race];
            this.frames = CLImageTracker.pkr_red[1];
            this.width = WIDTH[gameObjects.redWarlord.race];
            this.height = HEIGHT[gameObjects.redWarlord.race];
        }
        this.setFrameSequence(this.sequence[Person.NORMAL]);
        this.actualSequence = Person.NORMAL;
        this.setRelatedAbilities();
        this.setRelatedBonuses();
        this.defineReferencePixel(this.getWidth() / 2, 0);
        this.level = ownedByBlue ? gameObjects.blueWarlord.unitsLevel[1] : gameObjects.redWarlord.unitsLevel[1];
    }

    public Image getImage() {
        return null;
    }

    public void setRelatedAbilities() {
        switch (this.race) {
            case 0: {
                this.addAbility(256);
                break;
            }
            case 3: {
                this.addAbility(1024);
                break;
            }
            case 1: {
                this.addAbility(0x200000);
                break;
            }
            case 2: {
                this.addAbility(2048);
                this.addAbility(8192);
            }
        }
    }

    public void setRelatedBonuses() {
        switch (this.race) {
            case 0: {
                break;
            }
            case 3: {
                this.addStackBonus(4);
                break;
            }
            case 1: {
                this.addStackBonus(2);
                break;
            }
            case 2: {
                this.addStackBonus(8);
            }
        }
    }
}

