/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLCampaignMap;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.IMenu;
import com.eternity.castlelords.MenuItem;
import com.eternity.castlelords.Warlord;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.BCFont;
import com.impossible.util.ImLoader;
import com.impossible.util.XCanvas;
import com.impossible.util.XClass;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FilterInputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public class LogoCanvas
extends XClass
implements IMenu {
    private CLImageTracker tracker;
    private WarlordsCastles main;
    private Display display;
    private Player audioplayer;
    private boolean loading = false;
    private static final byte MOD_MENU = 0;
    private static final byte MOD_SELECT_RACES = 1;
    private static final byte MOD_SELECT_PERSONALITIES = 2;
    private static final byte MOD_DISTRIBUTE_POINTS = 3;
    private byte mode = 0;
    private boolean isPlayingMusic = false;
    boolean campaignSaved = false;
    static final int S_SOUND = 0;
    static final int S_SKIRMISH = 1;
    static final int S_DROPS = 2;
    static final int S_RACE_BLUE = 3;
    static final int S_RACE_RED = 4;
    static final int S_PORTR_BLUE = 5;
    static final int S_PORTR_RED = 6;
    static final int S_CLASS_BLUE = 7;
    static final int S_CLASS_RED = 8;
    static final int AC_START_CAMPAIGN = 0;
    static final int AC_START_SKIRMISH = 1;
    static final int AC_EXIT = 2;
    static final int AC_CONTINUE_CAMPAIGN = 3;
    static final int AC_INSTALL_PATCH = 4;
    static final int AC_START_NEW_CAMPAIGN = 5;
    static final int AC_CREATE_GAME = 6;
    static final int AC_JOIN_GAME = 7;
    static final int AC_START_TUTORIAL1 = 8;
    static final int AC_START_TUTORIAL2 = 9;
    static final int AC_START_TUTORIAL3 = 10;
    static final byte[][][] settingTexts = new byte[][][]{new byte[][]{CLLocales.getByteString("Off"), CLLocales.getByteString("On")}, new byte[][]{CLLocales.getByteString("Easy"), CLLocales.getByteString("Medium"), CLLocales.getByteString("Hard")}, new byte[][]{CLLocales.getByteString("Off"), CLLocales.getByteString("On")}, new byte[][]{CLLocales.getByteString("Barbarians"), CLLocales.getByteString("Orcs"), CLLocales.getByteString("Undead"), CLLocales.getByteString("Daemons"), CLLocales.getByteString("Random")}, new byte[][]{CLLocales.getByteString("Barbarians"), CLLocales.getByteString("Orcs"), CLLocales.getByteString("Undead"), CLLocales.getByteString("Daemons"), CLLocales.getByteString("Random")}, new byte[0][], new byte[0][], new byte[][]{CLLocales.getByteString("Archmage"), CLLocales.getByteString("Archmage"), CLLocales.getByteString("Archmage"), CLLocales.getByteString("Archmage"), CLLocales.getByteString("Shaman"), CLLocales.getByteString("Shaman"), CLLocales.getByteString("Shaman"), CLLocales.getByteString("Shaman"), CLLocales.getByteString("Random")}, new byte[][]{CLLocales.getByteString("None"), CLLocales.getByteString("Elementalist"), CLLocales.getByteString("Spellsword"), CLLocales.getByteString("Powermage"), CLLocales.getByteString("None"), CLLocales.getByteString("Protector"), CLLocales.getByteString("Berserk"), CLLocales.getByteString("Vanquisher"), CLLocales.getByteString("")}};
    static final int MENU_MAIN = 0;
    static final int MENU_SETTINGS = 1;
    static final int MENU_ARE_YOU_SURE = 2;
    static final int MENU_BT = 3;
    static final int MENU_TUTORIALS = 4;
    static final int MENU_SKIRMISH = 5;
    static final int MENU_SKIRMISH_SETTINGS = 6;
    static byte[] settings = new byte[3];
    int srLine;
    public static final int COL_RECT_INNER = 8614987;
    public static final int COL_RECT_OUTER = 16765564;
    public static final int COL_BLUE = -16554060;
    public static final int COL_RED = -5372926;
    int spBlueOrRed;
    int spLine;
    static final byte MAX_PORTRAIT = 11;
    static final byte MAX_CLASS = 8;
    boolean dpMultiplayer;
    int skIntelligence;
    int skCharisma;
    int skMorality;

    public LogoCanvas(XCanvas canvas, WarlordsCastles main, Display display, CLImageTracker tracker) {
        super(canvas);
        this.tracker = tracker;
        this.main = main;
        this.display = display;
        this.initMenu();
    }

    public void playMusic() {
        try {
            InputStream is = this.getClass().getResourceAsStream("/music/menu.mid");
            this.audioplayer = Manager.createPlayer((InputStream)is, (String)"audio/midi");
            this.audioplayer.prefetch();
            this.audioplayer.setLoopCount(-1);
            this.audioplayer.start();
            this.isPlayingMusic = true;
        }
        catch (Exception ex) {
            this.main.exitGame();
        }
    }

    public void stopMusic() {
        if (this.isPlayingMusic) {
            this.audioplayer.close();
        }
        this.isPlayingMusic = false;
    }

    protected void drawButton(byte[] text, int posX, int posY, Graphics g, boolean flag) {
        if (flag) {
            CLImageTracker.menuButtonOn.draw(g, posX, posY, 20);
        } else {
            CLImageTracker.menuButtonOff.draw(g, posX, posY, 20);
        }
        CLImageTracker.font_small.palette[1] = -11847936;
        CLImageTracker.font_small.palette[2] = 0;
        CLImageTracker.font_small.textOutCenter(g, posX + CLImageTracker.menuButtonOff.getWidth() / 2, posY + CLImageTracker.BUTTON_OFFSET, text);
    }

    public void paint() {
        switch (this.mode) {
            case 0: {
                this.tracker.getIntroImage().draw(XClass.g, 0, 0, 20);
                this.tracker.getMenuBgImage().draw(XClass.g, XCanvas.WIDTH >> 1, 58, 17);
                int y = 80;
                int i = 0;
                while (i < MenuItem.count) {
                    MenuItem item = MenuItem.items[i];
                    switch (item.type) {
                        case 3: {
                            CLImageTracker.font_small.palette[1] = -84952;
                            CLImageTracker.font_small.palette[2] = -16777216;
                            CLImageTracker.font_small.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y += CLImageTracker.font_small.char_height >> 3, item.getText());
                            y += CLImageTracker.font_small.char_height * 9 >> 3;
                            break;
                        }
                        default: {
                            this.drawButton(item.getText(), 57, y, XClass.g, MenuItem.index == i);
                            y += 20;
                        }
                    }
                    ++i;
                }
                if (!this.loading) break;
                CLGameCanvas.drawLoading(XClass.g, false);
                break;
            }
            case 1: {
                this.drawSelectRaces();
                break;
            }
            case 2: {
                this.drawSelectPersonalities();
                break;
            }
            case 3: {
                this.main.cmap.drawLevelUpScreen();
            }
        }
    }

    protected void keyPressed(int key, int gameAction) {
        switch (this.mode) {
            case 0: {
                if (this.loading) break;
                MenuItem.keyPressed(key, gameAction);
                break;
            }
            case 1: {
                this.keyPressedSelectRace(key, gameAction);
                break;
            }
            case 2: {
                this.keyPressedSelectPersonalities(key, gameAction);
                break;
            }
            default: {
                break;
            }
            case 3: {
                this.main.cmap.levelUpKeyPressed(gameAction);
                ((Object)((Object)this.main)).getClass();
                if (CLCampaignMap.DIALOG_TYPE == 4) break;
                this.endDistributePoints();
            }
        }
    }

    public void initMenu() {
        this.mode = 0;
        MenuItem.settingTexts = settingTexts;
        MenuItem.settings = settings;
        MenuItem.menuListener = this;
        this.campaignSaved = CLCampaignMap.hasSaveGame();
        MenuItem.reset();
        MenuItem.openMenu(0);
    }

    public static void initSettings() {
        settings = new byte[9];
        LogoCanvas.settings[0] = 0;
        LogoCanvas.settings[1] = 1;
        LogoCanvas.settings[2] = 1;
        LogoCanvas.settings[3] = 0;
        LogoCanvas.settings[4] = 4;
        LogoCanvas.settings[5] = 0;
        LogoCanvas.settings[6] = 11;
        LogoCanvas.settings[7] = 8;
        LogoCanvas.settings[8] = 8;
        RecordStore rs = null;
        FilterInputStream din = null;
        try {
            try {
                rs = RecordStore.openRecordStore((String)"settings", (boolean)false);
                ByteArrayInputStream bin = new ByteArrayInputStream(rs.getRecord(1));
                din = new DataInputStream(bin);
                int n = ((DataInputStream)din).readByte();
                int i = 0;
                while (i < n) {
                    LogoCanvas.settings[i] = ((DataInputStream)din).readByte();
                    ++i;
                }
                din.close();
                rs.closeRecordStore();
            }
            catch (IOException ioe) {
                System.out.println("I/O excepion while loading settings");
                try {
                    din.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rs.closeRecordStore();
                }
                catch (Exception exception) {}
            }
            catch (RecordStoreException recordStoreException) {
                try {
                    din.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    rs.closeRecordStore();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                return;
            }
        }
        finally {
            try {
                din.close();
            }
            catch (Exception exception) {}
            try {
                rs.closeRecordStore();
            }
            catch (Exception exception) {}
        }
    }

    public static void saveSettings() {
        block19: {
            RecordStore rs = null;
            FilterOutputStream dout = null;
            try {
                try {
                    rs = RecordStore.openRecordStore((String)"settings", (boolean)true);
                    ByteArrayOutputStream bout = new ByteArrayOutputStream();
                    dout = new DataOutputStream(bout);
                    ((DataOutputStream)dout).writeByte(settings.length);
                    int i = 0;
                    while (i < settings.length) {
                        ((DataOutputStream)dout).writeByte(settings[i]);
                        ++i;
                    }
                    ((DataOutputStream)dout).flush();
                    byte[] data = bout.toByteArray();
                    if (rs.getNumRecords() == 0) {
                        rs.addRecord(data, 0, data.length);
                        break block19;
                    }
                    rs.setRecord(1, data, 0, data.length);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    try {
                        dout.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    try {
                        rs.closeRecordStore();
                    }
                    catch (Exception exception) {}
                }
            }
            finally {
                try {
                    dout.close();
                }
                catch (Exception exception) {}
                try {
                    rs.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static int getSoundSetting() {
        return settings[0];
    }

    public static int getSkirmishDifficulty() {
        return settings[1];
    }

    public static int getDropsSetting() {
        return settings[2];
    }

    public void settingChanged(int settingIdx, byte newValue) {
        switch (settingIdx) {
            case 0: {
                if (newValue == 0) {
                    this.stopMusic();
                    break;
                }
                this.playMusic();
            }
        }
    }

    public void doAction(int acCode) {
        switch (acCode) {
            case 5: {
                this.main.setGameType(1);
                break;
            }
            case 0: {
                if (this.campaignSaved) {
                    MenuItem.openMenu(2);
                    MenuItem.next();
                    break;
                }
                this.doAction(5);
                break;
            }
            case 1: {
                this.initSelectRaces();
                break;
            }
            case 3: {
                this.main.startMapCampaignOverview(1);
                break;
            }
            case 8: {
                this.main.startMapCampaignOverview(1);
                this.main.cmap.activeMission = 17;
                CLCampaignMap cLCampaignMap = this.main.cmap;
                ((Object)((Object)this.main)).getClass();
                cLCampaignMap.loadDialogFile((byte)1);
                ((Object)((Object)this.main)).getClass();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.DIALOG_TYPE = (byte)2;
                this.main.cmap.txtIndex = 0;
                this.main.cmap.nextCh = -1;
                this.main.cmap.updateText();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.selMission = (String[])this.main.cmap.missions.elementAt(this.main.cmap.activeMission);
                System.out.println("Loaded tutorial 1");
                this.main.startCampaign(18, new Warlord(CLGameCanvas.gameObjects, true), "5555511111111111", "n", "5555511111111111");
                break;
            }
            case 9: {
                this.main.startMapCampaignOverview(1);
                this.main.cmap.activeMission = 18;
                CLCampaignMap cLCampaignMap = this.main.cmap;
                ((Object)((Object)this.main)).getClass();
                cLCampaignMap.loadDialogFile((byte)1);
                ((Object)((Object)this.main)).getClass();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.DIALOG_TYPE = (byte)2;
                this.main.cmap.txtIndex = 0;
                this.main.cmap.nextCh = -1;
                this.main.cmap.updateText();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.selMission = (String[])this.main.cmap.missions.elementAt(this.main.cmap.activeMission);
                System.out.println("Loaded tutorial 2");
                this.main.startCampaign(19, new Warlord(CLGameCanvas.gameObjects, true), "5555511111111111", "n", "5555511111111111");
                break;
            }
            case 10: {
                this.main.startMapCampaignOverview(1);
                this.main.cmap.activeMission = 19;
                CLCampaignMap cLCampaignMap = this.main.cmap;
                ((Object)((Object)this.main)).getClass();
                cLCampaignMap.loadDialogFile((byte)1);
                ((Object)((Object)this.main)).getClass();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.DIALOG_TYPE = (byte)2;
                this.main.cmap.txtIndex = 0;
                this.main.cmap.nextCh = -1;
                this.main.cmap.updateText();
                ((Object)((Object)this.main)).getClass();
                CLCampaignMap.selMission = (String[])this.main.cmap.missions.elementAt(this.main.cmap.activeMission);
                System.out.println("Loaded tutorial 3");
                this.main.startCampaign(20, new Warlord(CLGameCanvas.gameObjects, true), "5555511111111111", "n", "5555511111111111");
                break;
            }
            case 2: {
                this.main.exitGame();
                break;
            }
            case 4: {
                WarlordsCastles.PATCH.startGetPatch(this);
                CLGameCanvas.load_max = 1;
                CLGameCanvas.load_pos = 0;
                this.loading = true;
                CLGameCanvas.initLoading(false);
            }
        }
    }

    public void loadProgress(int max, int pos) {
        CLGameCanvas.load_max = max;
        CLGameCanvas.load_pos = pos;
        if (pos == max) {
            this.loading = false;
        }
        XClass.canvas.repaint();
        XClass.canvas.serviceRepaints();
    }

    public void openMenu(int menuCode) {
        switch (menuCode) {
            case 0: {
                MenuItem.startAddingItems();
                if (this.campaignSaved) {
                    MenuItem.addItem(new MenuItem(CLLocales.getByteString("Continue Campaign"), 1, 3));
                }
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("NEW_CAMPAIGN"), 1, 0));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("RANDOM_GAME"), 1, 1));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("SETTINGS"), 0, 1));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("END"), 1, 2));
                break;
            }
            case 1: {
                MenuItem.startAddingItems();
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Sound: "), 2, 0));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Install patch"), 1, 4));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Skirmish settings"), 0, 6));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("BACK"), 4, 0));
                break;
            }
            case 6: {
                MenuItem.startAddingItems();
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Difficulty: "), 2, 1));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Drops: "), 2, 2));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("BACK"), 4, 0));
                break;
            }
            case 4: {
                MenuItem.startAddingItems();
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("TUTORIAL1"), 1, 8));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("TUTORIAL2"), 1, 9));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("TUTORIAL3"), 1, 10));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("BACK"), 4, 0));
                break;
            }
            case 2: {
                MenuItem.startAddingItems();
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Are you sure ?"), 3, 0));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("Yes"), 1, 5));
                MenuItem.addItem(new MenuItem(CLLocales.getByteString("No"), 4, 0));
            }
        }
    }

    public void initSelectRaces() {
        this.mode = 1;
        this.srLine = 0;
    }

    private int drawBg(byte[] title) {
        XClass.g.setColor(0);
        XClass.g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        CLImageTracker.resultBG.draw(XClass.g, 0, 0, 20);
        BCFont fBig = CLImageTracker.font_anouncements;
        BCFont fSmall = CLImageTracker.font_small;
        fBig.palette = CLGameCanvas.PAL_VICTORY;
        int y = 14;
        fBig.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, title);
        y += fBig.char_height;
        return y += fSmall.char_height >> 1;
    }

    private void drawSelectRaces() {
        int y = this.drawBg(CLLocales.getByteString("Select Races"));
        this.drawSelectLine(y, -16554060, settings[3], this.srLine == 0);
        this.drawSelectLine(y += CLImageTracker.racePortraits.getHeight() * 2 + (CLImageTracker.font_small.char_height >> 1), -5372926, settings[4], this.srLine == 1);
        y = Math.max(180, y + 1);
        LogoCanvas.drawSmallButton(XClass.g, 15, y, 4, CLLocales.getByteString("Next"));
        LogoCanvas.drawSmallButton(XClass.g, XCanvas.WIDTH - 15, y, 8, CLLocales.getByteString("Back"));
    }

    public static void drawSmallButton(Graphics g, int x, int y, int align, byte[] text) {
        if ((align & 8) == 8) {
            x -= CLImageTracker.menuButtonSmallOn.getWidth();
        }
        if ((align & 1) == 1) {
            x -= CLImageTracker.menuButtonSmallOn.getWidth() >> 1;
        }
        y = Math.max(180, y + 1);
        g.setColor(75, 55, 0);
        BCFont fSmall = CLImageTracker.font_small;
        fSmall.palette[1] = -11847936;
        fSmall.palette[2] = 0;
        CLImageTracker.menuButtonSmallOn.draw(g, x, y, 0x10 | 4);
        fSmall.textOutCenter(g, x + (CLImageTracker.menuButtonSmallOn.getWidth() >> 1), y + CLImageTracker.BUTTON_OFFSET, text);
    }

    private void drawSelectLine(int y, int colStroke, int selected, boolean active) {
        ImLoader portraits = CLImageTracker.racePortraits;
        ImLoader arrows = CLImageTracker.arrows_left_right;
        int w = portraits.getWidth() * 3 + 2 * (portraits.getWidth() >> 3) + 2 * (portraits.getWidth() >> 2);
        int x = XCanvas.WIDTH - w >> 1;
        int h = portraits.getHeight() + (portraits.getHeight() >> 2) + 4 + arrows.getHeight() + (arrows.getHeight() >> 2);
        XClass.g.setColor(colStroke);
        XClass.g.drawRect(x - 1, y, w, h);
        y += portraits.getHeight() >> 2;
        int idx = selected - 1;
        int i = 0;
        int xx = x += portraits.getWidth() >> 2;
        while (i < 3) {
            if (idx < 0) {
                idx = 4;
            }
            if (idx == 5) {
                idx = 0;
            }
            portraits.drawSubImage(XClass.g, xx, y, 0, idx);
            if (i != 1) {
                portraits.drawSubImage(XClass.g, xx, y, 0, 5);
            }
            if (i == 1 && active) {
                XClass.g.setColor(8614987);
                XClass.g.drawRect(xx - 1, y - 1, portraits.getWidth(), portraits.getHeight());
                XClass.g.setColor(16765564);
                XClass.g.drawRect(xx - 2, y - 2, portraits.getWidth() + 2, portraits.getHeight() + 2);
            }
            ++i;
            ++idx;
            xx += portraits.getWidth() + (portraits.getWidth() >> 3);
        }
        arrows.drawSubImage(XClass.g, x, y += 4 + portraits.getHeight(), 0, 0);
        arrows.drawSubImage(XClass.g, xx -= (portraits.getWidth() >> 3) + arrows.getWidth(), y, 0, 1);
        BCFont fSmall = CLImageTracker.font_small;
        y = y + arrows.getHeight() - fSmall.char_height;
        fSmall.palette[1] = -860781;
        fSmall.palette[2] = 0;
        fSmall.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, settingTexts[3][selected]);
    }

    private void keyPressedSelectRace(int key, int ga) {
        switch (ga) {
            case 1: 
            case 6: {
                ++this.srLine;
                if (this.srLine <= 1) break;
                this.srLine = 0;
                break;
            }
            case 2: {
                int idx;
                int n = idx = 3 + this.srLine;
                settings[n] = (byte)(settings[n] - 1);
                if (settings[idx] >= 0) break;
                LogoCanvas.settings[idx] = 4;
                break;
            }
            case 8: {
                key = -6;
                break;
            }
            case 5: {
                int idx;
                int n = idx = 3 + this.srLine;
                settings[n] = (byte)(settings[n] + 1);
                if (settings[idx] <= 4) break;
                LogoCanvas.settings[idx] = 0;
            }
        }
        switch (key) {
            case -6: {
                this.initSelectPersonalities(0);
                break;
            }
            case -7: {
                this.mode = 0;
            }
        }
    }

    private void initSelectPersonalities(int blueOrRed) {
        this.spBlueOrRed = blueOrRed;
        this.mode = (byte)2;
        this.spLine = 0;
    }

    private void drawSelectPersonalities() {
        XClass.g.setColor(0);
        XClass.g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
        CLImageTracker.resultBG.draw(XClass.g, 0, 0, 20);
        BCFont fBig = CLImageTracker.font_anouncements;
        BCFont fSmall = CLImageTracker.font_small;
        ImLoader arrows = CLImageTracker.arrows_left_right;
        fBig.palette = CLGameCanvas.PAL_VICTORY;
        int y = 14;
        fBig.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y, CLLocales.getByteString("Select Personality"));
        fSmall.palette[1] = this.spBlueOrRed == 0 ? -16554060 : -5372926;
        fSmall.palette[2] = 0;
        byte[] text = this.spBlueOrRed == 0 ? CLLocales.getByteString("Player") : CLLocales.getByteString("CPU");
        fSmall.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y += fBig.char_height, text);
        y += fSmall.char_height + (fSmall.char_height >> 1);
        int x = (XCanvas.WIDTH - CLImageTracker.Im_portraits.getWidth() >> 1) - arrows.getWidth() - (arrows.getWidth() >> 1) - (arrows.getWidth() >> 2);
        int w = (XCanvas.WIDTH >> 1) - x << 1;
        int PADDING = 4;
        int h = CLImageTracker.Im_portraits.getHeight() + 2 * PADDING;
        if (this.spLine == 0) {
            XClass.g.setColor(8614987);
            XClass.g.drawRect(x - 1, y - 1, w, h);
            XClass.g.setColor(16765564);
            XClass.g.drawRect(x - 2, y - 2, w + 2, h + 2);
        }
        arrows.drawSubImage(XClass.g, x += arrows.getWidth() >> 2, (y += PADDING) + (CLImageTracker.Im_portraits.getHeight() - arrows.getHeight() >> 1), 0, 0);
        x += arrows.getWidth() + (arrows.getWidth() >> 1);
        int idx = 5 + this.spBlueOrRed;
        int NUM_Im_portraits = 12;
        if (settings[idx] < 12) {
            CLImageTracker.Im_portraits.drawSubImage(XClass.g, x, y, 0, settings[idx]);
        } else {
            CLImageTracker.racePortraits.drawSubImage(XClass.g, XCanvas.WIDTH - CLImageTracker.racePortraits.getWidth() >> 1, y + (CLImageTracker.Im_portraits.getHeight() - CLImageTracker.racePortraits.getHeight() >> 1), 0, 4);
        }
        arrows.drawSubImage(XClass.g, x += CLImageTracker.Im_portraits.getWidth() + (arrows.getWidth() >> 1), y + (CLImageTracker.Im_portraits.getHeight() - arrows.getHeight() >> 1), 0, 1);
        y += CLImageTracker.Im_portraits.getHeight() + PADDING + fSmall.char_height;
        PADDING = 6;
        x = (XCanvas.WIDTH - CLImageTracker.Im_portraits.getWidth() >> 1) - arrows.getWidth() - (arrows.getWidth() >> 1) - (arrows.getWidth() >> 2);
        w = (XCanvas.WIDTH >> 1) - x << 1;
        h = arrows.getHeight() + 2 * PADDING;
        if (this.spLine == 1) {
            XClass.g.setColor(8614987);
            XClass.g.drawRect(x - 1, y - 1, w, h);
            XClass.g.setColor(16765564);
            XClass.g.drawRect(x - 2, y - 2, w + 2, h + 2);
        }
        arrows.drawSubImage(XClass.g, x += arrows.getWidth() >> 2, y += PADDING, 0, 0);
        x += arrows.getWidth() + (arrows.getWidth() >> 1);
        fSmall.palette[1] = -860781;
        idx = 7 + this.spBlueOrRed;
        if (settings[idx] == 8) {
            fSmall.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y + arrows.getHeight() - fSmall.char_height, settingTexts[7][settings[idx]]);
        } else {
            fSmall.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y + (arrows.getHeight() >> 1) - fSmall.char_height, settingTexts[7][settings[idx]]);
            fSmall.textOutCenter(XClass.g, XCanvas.WIDTH >> 1, y + (arrows.getHeight() >> 1), settingTexts[8][settings[idx]]);
        }
        arrows.drawSubImage(XClass.g, x += CLImageTracker.Im_portraits.getWidth() + (arrows.getWidth() >> 1), y, 0, 1);
        y = Math.max(180, y + 1);
        text = this.spBlueOrRed == 0 ? CLLocales.getByteString("Next") : CLLocales.getByteString("Start");
        LogoCanvas.drawSmallButton(XClass.g, 15, y, 4, text);
        LogoCanvas.drawSmallButton(XClass.g, XCanvas.WIDTH - 15, y, 8, CLLocales.getByteString("Back"));
    }

    private void keyPressedSelectPersonalities(int key, int ga) {
        switch (ga) {
            case 1: 
            case 6: {
                ++this.spLine;
                if (this.spLine <= 1) break;
                this.spLine = 0;
                break;
            }
            case 2: {
                int idx;
                int n = idx = 5 + this.spBlueOrRed + this.spLine * 2;
                settings[n] = (byte)(settings[n] - 1);
                if (settings[idx] >= 0) break;
                LogoCanvas.settings[idx] = this.spLine == 0 ? 11 : 8;
                break;
            }
            case 8: {
                key = -6;
                break;
            }
            case 5: {
                int idx;
                int n = idx = 5 + this.spBlueOrRed + this.spLine * 2;
                settings[n] = (byte)(settings[n] + 1);
                if (this.spLine == 0 && settings[idx] > 11) {
                    LogoCanvas.settings[idx] = 0;
                }
                if (this.spLine != 1 || settings[idx] <= 8) break;
                LogoCanvas.settings[idx] = 0;
            }
        }
        switch (key) {
            case -6: {
                if (this.spBlueOrRed == 0) {
                    this.initDistributePoints(0, false);
                    break;
                }
                this.startSkirmish();
                break;
            }
            case -7: {
                if (this.spBlueOrRed == 0) {
                    this.initSelectRaces();
                    break;
                }
                this.initSelectPersonalities(0);
            }
        }
    }

    public void initDistributePoints(int redOrBlue, boolean multiplayer) {
        this.dpMultiplayer = multiplayer;
        this.mode = (byte)3;
        this.stopMusic();
        this.main.initCampaignMapCanvas();
        CLCampaignMap.warlord.setWarlord(1, 1, 2, settings[7 + redOrBlue]);
        CLCampaignMap.warlord.remainingSkillPoints = 0;
        CLCampaignMap.warlord.charIdx = settings[5 + redOrBlue];
        this.main.cmap.initLevelUp(10);
    }

    public void endDistributePoints() {
        this.skIntelligence = CLCampaignMap.warlord.intelligence;
        this.skCharisma = CLCampaignMap.warlord.charisma;
        this.skMorality = CLCampaignMap.warlord.morality;
        if (!this.dpMultiplayer) {
            this.initSelectPersonalities(1);
        }
    }

    private void startSkirmish() {
        int wizardTypeRight;
        int wizardTypeLeft;
        int race_right;
        int race_left = settings[3];
        if (race_left == 4) {
            race_left = XCanvas.next_random(4);
        }
        if ((race_right = settings[4]) == 4) {
            race_right = XCanvas.next_random(4);
        }
        if ((wizardTypeLeft = settings[7]) == 8) {
            wizardTypeLeft = XCanvas.next_random(8);
        }
        if ((wizardTypeRight = settings[8]) == 8) {
            wizardTypeRight = XCanvas.next_random(8);
        }
        this.main.gameType = 3;
        WarlordsCastles.canvas.status = 1;
        WarlordsCastles.xcanvas.setActualClass(WarlordsCastles.canvas);
        this.stopMusic();
        WarlordsCastles.canvas.initRandomGame(race_left, race_right, this.skCharisma, this.skIntelligence, this.skMorality, wizardTypeLeft, 2, 2, 2, wizardTypeRight, true, true);
    }
}

