/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.ArcherShot;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Walker;
import com.eternity.castlelords.Wall;
import com.eternity.castlelords.Warlord;
import com.impossible.util.ImLoader;
import com.impossible.util.XCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Image;

public class Archer
extends Person {
    private static final int[] OFFS_X = new int[]{52, 45, 89, 75};
    private static final int[] OFFS_Y = new int[]{44, 38, 36, 43};
    private int ARCHER_TURN_DELAY = 60;
    private int ARCHER_DOUBLESHOT_DELAY = this.ARCHER_TURN_DELAY / 2;
    private int ARCHER_LIFE_TIME = 425;
    private int WIDTH = 35;
    private int HEIGHT = 36;
    private boolean doubleshot = false;
    private int multiShot = 0;
    public int number;
    public int lifeTime;
    int v;
    int min_lof;
    int max_lof;
    static final byte MOD_WAITING = 0;
    static final byte MOD_SHOOTING = 1;
    byte mode = 0;
    static final int[] frame_seq;
    static final int precalc_frames = 4;
    public int healthY;
    public int healthX;
    int hpFixedPoint;
    ArcherShot shot;

    static {
        int[] nArray = new int[6];
        nArray[2] = 1;
        nArray[3] = 1;
        nArray[4] = 2;
        nArray[5] = 2;
        frame_seq = nArray;
    }

    public Archer(int x, int y, int hp, int pp, boolean ownedByBlue, GameObjects gameObjects, CLImageTracker tracker) {
        super(x, y, hp, pp, ownedByBlue, gameObjects, tracker);
        this.setTurnDelay(this.actualTurnDelay);
        ImLoader imLoader = this.frames = ownedByBlue ? CLImageTracker.archerBlue : CLImageTracker.archerRed;
        this.positionX = ownedByBlue ? (this.positionX += this.frames.getWidth() >> 1) : (this.positionX -= this.frames.getWidth() >> 1);
        this.width = this.frames.getWidth();
        this.height = this.frames.getHeight();
        this.positionY -= this.height;
        this.setRelatedAbilities();
        this.number = 1;
        this.lifeTime = this.ARCHER_LIFE_TIME;
        this.actualTurnDelay = this.ARCHER_TURN_DELAY / this.number;
        this.type = 2;
        if (ownedByBlue) {
            this.level = gameObjects.blueWarlord.unitsLevel[2];
            this.race = gameObjects.blueWarlord.race;
            CLGameCanvas.playerGameEvent = 18;
            this.healthX = this.positionX;
            this.healthY = this.positionY + this.height + 1;
        } else {
            this.level = gameObjects.redWarlord.unitsLevel[2];
            this.race = gameObjects.redWarlord.race;
            this.healthX = this.positionX;
            this.healthY = this.positionY + this.height + 1;
        }
        this.hpFixedPoint = hp << 10;
        this.initArcher();
        this.setFrameSequence(frame_seq);
        this.sequence[0] = frame_seq;
        this.actualTurnDelay = 1;
    }

    void initArcher() {
        switch (this.race) {
            case 0: {
                this.v = (this.tracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 700;
                this.min_lof = 132;
                this.max_lof = 330;
                this.ARCHER_TURN_DELAY = 1800 / XCanvas.DT;
                break;
            }
            case 2: {
                this.v = (this.tracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 600;
                System.out.println("StrongHood height: " + this.tracker.getImageForStronghold(2).getHeight() + " v=" + this.v);
                this.min_lof = 132;
                this.max_lof = 396;
                this.ARCHER_TURN_DELAY = 3000 / XCanvas.DT;
                break;
            }
            case 1: {
                this.v = (this.tracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 1000;
                this.min_lof = 0;
                this.max_lof = 132;
                this.ARCHER_TURN_DELAY = 2500 / XCanvas.DT;
                break;
            }
            case 3: {
                this.v = (this.tracker.getImageForStronghold(2).getHeight() * XCanvas.DT << 8) / 400;
                this.min_lof = 198;
                this.max_lof = 528;
                this.ARCHER_TURN_DELAY = 3500 / XCanvas.DT;
            }
        }
        this.ARCHER_DOUBLESHOT_DELAY = this.ARCHER_TURN_DELAY / 2;
        if (!this.ownedByBlue) {
            int t = this.min_lof;
            this.min_lof = 528 - this.max_lof;
            this.max_lof = 528 - t;
        }
    }

    public Image getImage() {
        return null;
    }

    public void increaseNumber() {
        ++this.number;
    }

    void startWaiting() {
        Warlord w = this.isOwnedByBlue() ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
        this.actualTurnDelay = w.shotTurnDelay[0];
        this.mode = 0;
    }

    public void doStep() {
        super.doStep();
        switch (this.mode) {
            case 0: {
                if (this.getFrameIdx() != 0) {
                    this.nextFrame();
                }
                this.actualTurnDelay -= XCanvas.DT;
                if (this.actualTurnDelay > 0 || this.getFrameIdx() != 0) break;
                Person[] aimed_ps = this.choosePersonsToShootAt();
                this.shot = null;
                if (aimed_ps != null) {
                    System.out.println("Persons in range: " + aimed_ps.length);
                    int i = 0;
                    while (i < 3 && this.shot == null) {
                        int idx = XCanvas.next_random(aimed_ps.length);
                        this.shot = this.race != 1 ? this.shotAtPerson(aimed_ps[idx]) : this.shotAtPersonTroll(aimed_ps[idx]);
                        ++i;
                    }
                    i = 0;
                    while (i < aimed_ps.length && this.shot == null) {
                        this.shot = this.race != 1 ? this.shotAtPerson(aimed_ps[i]) : this.shotAtPersonTroll(aimed_ps[i]);
                        ++i;
                    }
                }
                if (this.shot != null) {
                    this.mode = 1;
                    break;
                }
                this.startWaiting();
                break;
            }
            case 1: {
                int attackerAbilityBonus;
                this.nextFrame();
                if (this.getFrameIdx() != 4) break;
                this.gameObjects.addLiveObject(this.shot);
                boolean willStartWaiting = true;
                Warlord w = this.ownedByBlue ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
                int n = attackerAbilityBonus = w.hasEnchantmentType(18) ? 10 : 0;
                if (!this.doubleshot && this.hasAbility(524288) && GameObject.getChance(GameObjects.DOUBLESHOT_CHANCES[this.level - 1] + attackerAbilityBonus)) {
                    this.mode = 1;
                    this.shot = new ArcherShot(this.shot.x, this.shot.y, this.shot.powerPoints, this.shot.level, this.shot.ownedByBlue, this.gameObjects, this.tracker, this.shot.vx, this.shot.vy, this.abilities);
                    this.doubleshot = true;
                    willStartWaiting = false;
                    this.lastAbility = "DoubleShot";
                    this.gameObjects.addFlyingText(this.lastAbility, 10, this.getPositionX(), this.healthY, 2);
                }
                if (this.multiShot == 0 && this.hasAbility(0x1000000) && GameObject.getChance(GameObjects.MULTITARGET_CHANCES[this.level - 1] + attackerAbilityBonus)) {
                    this.multiShot = XCanvas.next_random(2) + 2;
                    this.lastAbility = "MultiTarget";
                    this.gameObjects.addFlyingText(this.lastAbility, 10, this.getPositionX(), this.healthY, 2);
                }
                if (this.multiShot > 1) {
                    this.mode = 0;
                    willStartWaiting = false;
                }
                if (this.multiShot > 0) {
                    --this.multiShot;
                }
                if (!willStartWaiting) break;
                this.startWaiting();
                this.doubleshot = false;
                this.multiShot = 0;
            }
        }
    }

    public void refreshLifeTime() {
        this.lifeTime = this.ARCHER_LIFE_TIME;
    }

    public void setRelatedAbilities() {
        switch (this.race) {
            case 0: {
                this.addAbility(524288);
                break;
            }
            case 3: {
                this.addAbility(0x1000000);
                this.addAbility(1024);
                break;
            }
            case 1: {
                this.addAbility(262144);
                break;
            }
            case 2: {
                this.addAbility(0x800000);
            }
        }
    }

    Person[] choosePersonsToShootAt() {
        Person[] p = null;
        Vector<GameObject> persons = new Vector<GameObject>();
        int i = 0;
        while (i < this.gameObjects.getLiveObjects().size()) {
            GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
            if (this.isOwnedByBlue() == !temp.isOwnedByBlue() && temp instanceof Person && !(temp instanceof Archer) && !(temp instanceof Wall) && temp.getPositionX() >= this.min_lof && temp.getStartPositionX() <= this.max_lof) {
                persons.addElement(temp);
            }
            ++i;
        }
        if (persons.size() > 0) {
            p = new Person[persons.size()];
            persons.copyInto((Object[])p);
        }
        return p;
    }

    ArcherShot shotAtPersonTroll(Person p) {
        long d;
        int x;
        if (this.ownedByBlue) {
            System.out.println("Troll Trying to shot at person at: (" + p.getPositionX() + ", " + p.getPositionY() + ")");
        }
        int y = this.getPositionY() + OFFS_Y[this.race];
        long h = p.getPositionY() + (p.height() >> 1) - y;
        if (this.isOwnedByBlue()) {
            x = this.getPositionX() + OFFS_X[this.race] - this.frames.getWidth() / 2;
            d = p.getPositionX() - x;
        } else {
            x = this.getPositionX() - OFFS_X[this.race] + this.frames.getWidth() / 2;
            d = x - p.getPositionX();
        }
        if (this.ownedByBlue) {
            System.out.println("H&d&v: " + h + ", " + d + ", " + this.v);
        }
        long g = ArcherShot.getG();
        long t = XCanvas.sqrt((2L * h << 24) / g);
        if (this.ownedByBlue) {
            System.out.println("t&g: " + t + ", " + g);
        }
        long vx = (d << 16) / t;
        if (!this.isOwnedByBlue()) {
            vx = -vx;
        }
        ArcherShot shot = null;
        shot = new ArcherShot(x << 8, y << 8, this.powerPoints, this.level, this.ownedByBlue, this.gameObjects, this.tracker, (int)vx, 0, this.abilities);
        if (this.ownedByBlue) {
            System.out.println("Added new shot: (" + x + ", " + y + "); (" + (vx >> 8) + ", 0); " + this.ownedByBlue + "; v=" + this.v);
        }
        return shot;
    }

    ArcherShot shotAtPerson(Person p) {
        long start_t;
        long te;
        long min_d;
        long d;
        int x;
        int i;
        if (this.ownedByBlue) {
            System.out.println("Trying to shot at person at: (" + p.getPositionX() + ", " + p.getPositionY() + ")");
        }
        long vx = 0L;
        long vy = 0L;
        long ve = 0L;
        if (p instanceof Walker) {
            i = 0;
            while (i < ((Walker)p).pixelDiff.length) {
                ve += (long)((Walker)p).pixelDiff[i];
                ++i;
            }
            ve = (ve << 8) / (long)(((Walker)p).pixelDiff.length * p.actualTurnDelay);
        }
        int y = this.getPositionY() + OFFS_Y[this.race];
        long h = p.getPositionY() + (p.height() >> 1) - y;
        if (this.isOwnedByBlue()) {
            x = this.getPositionX() + OFFS_X[this.race] - (this.frames.getWidth() >> 1);
            d = p.getPositionX() - x;
            min_d = this.min_lof - x;
        } else {
            x = this.getPositionX() - OFFS_X[this.race] + (this.frames.getWidth() >> 1);
            d = x - p.getPositionX();
            min_d = x - this.max_lof;
        }
        if (ve > 0L && !p.isAttackOver()) {
            Walker w = (Walker)p;
            int delay = p.getTurnDelay();
            i = 0;
            while (i < 4) {
                if (delay == 0) {
                    int idx = w.getFrameIdx() + i;
                    if (idx >= w.pixelDiff.length) {
                        idx -= w.pixelDiff.length;
                    }
                    d -= (long)w.pixelDiff[idx];
                } else {
                    delay = p.actualTurnDelay;
                }
                ++i;
                --delay;
            }
        } else {
            ve = 0L;
        }
        if (this.ownedByBlue) {
            System.out.println("Ve: " + ve);
        }
        if (this.ownedByBlue) {
            System.out.println("H&d&v: " + h + ", " + d + ", " + this.v);
        }
        boolean canShoot = false;
        boolean possible = true;
        if (ve > 0L) {
            te = (d << 8) / ve;
            start_t = 1L;
        } else {
            start_t = (d << 8) / (long)this.v;
            te = start_t * 8L;
        }
        canShoot = false;
        if (this.ownedByBlue) {
            System.out.println("---- te=" + te);
        }
        long t = start_t;
        while (t < te && !canShoot && possible) {
            vx = (d << 8) / t - ve;
            if (this.ownedByBlue) {
                System.out.println("------- vx=" + vx);
            }
            if (vx < (long)this.v) {
                vy = XCanvas.sqrt((long)(this.v * this.v) - vx * vx);
                long hh = t * vy >> 8;
                long yy = (long)y + hh;
                if (this.ownedByBlue) {
                    System.out.println("t=" + t + " ------- vy=" + vy + "; yy=" + yy);
                }
                if (hh >= h && yy < 213L) {
                    canShoot = true;
                    if (!this.isOwnedByBlue()) {
                        vx = -vx;
                    }
                }
                if (ve == 0L && yy > 213L) {
                    possible = false;
                }
                if (ve != 0L) {
                    possible = vx * t >> 8 >= min_d;
                }
            }
            ++t;
        }
        ArcherShot shot = null;
        if (canShoot &= possible) {
            shot = new ArcherShot(x << 8, y << 8, this.powerPoints, this.level, this.ownedByBlue, this.gameObjects, this.tracker, (int)vx, (int)vy, this.abilities);
            if (this.ownedByBlue) {
                System.out.println("Added new shot: (" + x + ", " + y + "); (" + (vx >> 8) + ", " + (vy >> 8) + "); " + this.ownedByBlue + "; v=" + this.v);
            }
        } else if (this.ownedByBlue) {
            System.out.println("Can't shot... :(");
        }
        return shot;
    }

    public int sgn(long num) {
        if (num >= 0L) {
            return 1;
        }
        return -1;
    }

    public void upgrade(Warlord w) {
        super.upgrade(w);
        this.hpFixedPoint = this.hitPoints << 10;
    }

    public void addProportionalCastleHit(int damage) {
        this.hpFixedPoint -= (damage * GameObjects.archerFractions[this.race][this.level - 1] << 10) / 100;
        int integralDamage = this.hitPoints - (this.hpFixedPoint >> 10);
        if ((this.hpFixedPoint & 0x3FF) >= 512) {
            --integralDamage;
        }
        if (integralDamage > 0) {
            this.subHitPoints(integralDamage);
            this.gameObjects.addFlyingText("-" + integralDamage, 10, this.healthX, this.healthY - this.height() / 2, 1);
        }
    }
}

