/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.LogoCanvas;
import com.eternity.castlelords.Spell;
import com.eternity.castlelords.WarlordsCastles;
import com.impossible.util.Im;
import com.impossible.util.XCanvas;
import com.impossible.util.XClass;
import javax.microedition.lcdui.Display;

public class LoadCanvas
extends XClass {
    private WarlordsCastles main;
    private Display display;
    private CLImageTracker tracker;
    static final byte MOD_STATIC_DRAW = 0;
    static final byte MOD_ANIM_DRAW = 1;
    static final byte MOD_BLINKING = 2;
    byte mode = 1;
    byte part = 1;
    Im[] images;
    static final int anims = 30;
    public static final int TIMEOUT = 50;
    long start;
    int anim_width;
    int cur_anim_width;
    int blinkTime;
    static final int BLINK_TIME = 400;
    boolean blink = true;

    public LoadCanvas(XCanvas canvas, WarlordsCastles main, Display display, CLImageTracker tracker) {
        super(canvas);
        this.main = main;
        this.display = display;
        this.tracker = tracker;
        this.mode = 1;
        this.anim_width = XCanvas.WIDTH / 30;
        this.cur_anim_width = 0;
        this.part = 1;
    }

    public void tick() {
        switch (this.mode) {
            case 0: {
                if (this.part > 3) break;
                XClass.canvas.repaint();
                XClass.canvas.serviceRepaints();
                this.loadPart(this.part);
                if (this.part < 3) {
                    this.mode = 1;
                    this.anim_width = XCanvas.WIDTH / 30;
                    this.cur_anim_width = 0;
                    this.part = (byte)(this.part + 1);
                    break;
                }
                this.mode = (byte)2;
                this.blinkTime = 400;
                this.blink = true;
                break;
            }
            case 1: {
                ++this.cur_anim_width;
                if (this.cur_anim_width != this.anim_width) break;
                this.mode = 0;
                break;
            }
            case 2: {
                this.blinkTime -= XCanvas.DT;
                if (this.blinkTime > 0) break;
                this.blinkTime = 400;
                this.blink = !this.blink;
            }
        }
    }

    void loadPart(int idx) {
        switch (idx) {
            case 1: {
                this.startWaiting();
                WarlordsCastles.imageTracker.loadScreens();
                this.waiting(1500L);
                break;
            }
            case 2: {
                this.startWaiting();
                WarlordsCastles.imageTracker.loadThings();
                this.waiting(1000L);
                break;
            }
            case 3: {
                this.startWaiting();
                CLLocales.getInstance("english");
                Spell.DESCRIPTIONS = CLLocales.SPELL_DESCRIPTIONS;
                LogoCanvas.initSettings();
                this.main.logo = new LogoCanvas(WarlordsCastles.xcanvas, this.main, this.display, WarlordsCastles.imageTracker);
                if (LogoCanvas.getSoundSetting() == 1) {
                    this.main.logo.playMusic();
                }
                this.waiting(50L);
            }
        }
    }

    void startMenu() {
        this.main.logo.initMenu();
        XClass.canvas.setActualClass(this.main.logo);
        this.images = null;
        WarlordsCastles.imageTracker.resetSplashImages();
        this.main.initGameCanvas();
    }

    public void startWaiting() {
        this.start = System.currentTimeMillis();
    }

    public void waiting(long millis) {
        long waittime = millis - (System.currentTimeMillis() - this.start);
        if (waittime > 0L) {
            try {
                Thread.sleep(waittime);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void paint() {
        Im[] imArray = new Im[4];
        imArray[1] = this.tracker.getLogoImage(1);
        imArray[2] = this.tracker.getLogoImage(2);
        imArray[3] = this.tracker.getIntroImage();
        Im[] im = imArray;
        this.images = im;
        switch (this.mode) {
            case 0: {
                this.images[this.part].draw(XClass.g, 0, 0, 20);
                break;
            }
            case 1: {
                if (this.images[this.part - 1] != null) {
                    this.images[this.part - 1].draw(XClass.g, 0, 0, 20);
                } else {
                    XClass.g.setColor(0);
                    XClass.g.fillRect(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                }
                int x = 0;
                x = 0;
                while (x < XCanvas.WIDTH) {
                    XClass.g.setClip(x, 0, this.cur_anim_width, (int)XCanvas.HEIGHT);
                    this.images[this.part].draw(XClass.g, 0, 0, 20);
                    x += this.anim_width;
                }
                XClass.g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                break;
            }
            case 2: {
                this.images[this.part].draw(XClass.g, 0, 0, 20);
                if (!this.blink) break;
                this.tracker.getPress5().draw(XClass.g, 0, 186, 20);
            }
        }
    }

    protected void keyPressed(int keyCode, int gameAction) {
        switch (this.mode) {
            case 2: {
                if (gameAction != 8) break;
                this.startMenu();
            }
        }
    }
}

