/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.GameObject;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Person;
import com.eternity.castlelords.Resource;
import com.eternity.castlelords.Rider;
import com.eternity.castlelords.Spell;
import com.eternity.castlelords.Warlord;
import com.impossible.util.PalettedSprite;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class Boss
extends Person {
    public int[] pixelDiff = new int[1];
    public int race;
    public int bossType;
    public static final int[] WIDTH = new int[]{90, 115, 200, 90};
    public static final int[] HEIGHT = new int[]{95, 95, 160, 95};
    public static final int[] HP = new int[]{580, 590, 5150, 5300};
    public static final int[] PP = new int[]{5, 10, 10, 15};
    public static final boolean[] owner;
    public static final int BOSS_WARLORD = 0;
    public static final int BOSS_LORDBANE = 1;
    public static final int BOSS_ETHERLORD = 2;
    public static final int BOSS_PLAYERHERO = 3;
    public static int lastHP;
    int redTime;
    int redAlpha;
    int alphaStep;
    static final int LIGHTNING_TIME = 11;
    static int lightning_time;
    static short[] lx;
    static short[] ly;
    static int ln;
    static final short L_NEW_BRANCH = -50;
    static final short L_END_BRANCH = -100;
    static short BRANCH_DISTANCE;
    static final short L_NODES_STEP = 200;
    static short[][] L_BLENGTHS;
    static final short L_MAX_LEVEL = 2;
    static final int L_OFFSX = 162;
    static final int L_OFFSY = 103;
    static int[] stack_x;
    static int[] stack_y;
    static final int COL_L_SIMPLE = 3533048;
    static final int COL_L_MIDDLE = 0xFFFFFF;

    static {
        boolean[] blArray = new boolean[4];
        blArray[3] = true;
        owner = blArray;
        lastHP = 0;
        lightning_time = 0;
        L_BLENGTHS = new short[][]{{528, 17, 3, 50, 70}, {82, 14, 3, 30, 30}, {30, 7, 3, 15, 18}};
        stack_x = new int[3];
        stack_y = new int[3];
    }

    public Boss(int bossType, boolean ownedByPlayer, GameObjects gameObjects, CLImageTracker tracker) {
        super(516 - WIDTH[bossType] / 2, 213 - HEIGHT[bossType], HP[bossType], PP[bossType], ownedByPlayer, gameObjects, tracker);
        this.positionX = !ownedByPlayer ? 516 - WIDTH[bossType] / 2 : 12 + WIDTH[bossType] / 2;
        this.bossType = bossType;
        this.type = 6;
        this.addAbility(32);
        switch (bossType) {
            case 3: {
                this.race = 0;
                this.sequence = GameObjects.RIDER_ANIM_SEQ[this.race];
                this.pixelDiff = GameObjects.RIDER_PX_DIFF[this.race];
                this.frames = CLImageTracker.pkr_red[1];
                this.width = WIDTH[bossType];
                this.height = HEIGHT[bossType];
                break;
            }
            case 0: {
                this.type = 3;
                this.race = 0;
                this.sequence = GameObjects.BOSS_ANIM_SEQ[this.race];
                this.pixelDiff = GameObjects.RIDER_PX_DIFF[this.race];
                this.frames = CLImageTracker.pkr_red[2];
                this.width = WIDTH[bossType];
                this.height = HEIGHT[bossType];
                this.actualBattleDelay = Rider.RIDER_BATTLE_DELAY[this.race];
                break;
            }
            case 1: {
                this.race = 2;
                this.sequence = GameObjects.BOSS_ANIM_SEQ[this.race];
                this.pixelDiff = GameObjects.RIDER_PX_DIFF[this.race];
                this.frames = ownedByPlayer ? CLImageTracker.pkr_blue[3] : CLImageTracker.pkr_red[3];
                this.width = WIDTH[bossType];
                this.height = HEIGHT[bossType];
                this.actualBattleDelay = this.sequence[Person.BATTLE].length;
                break;
            }
            case 2: {
                this.race = 3;
                this.sequence = GameObjects.BOSS_ANIM_SEQ[this.race];
                this.pixelDiff = GameObjects.RIDER_PX_DIFF[this.race];
                this.frames = CLImageTracker.pkr_red[3];
                this.width = WIDTH[bossType];
                this.height = HEIGHT[bossType];
                this.actualBattleDelay = this.sequence[Person.BATTLE].length;
                Boss.initLightning();
            }
        }
    }

    public Image getImage() {
        return null;
    }

    public void doStep() {
        switch (this.bossType) {
            case 3: {
                this.doStep2(true);
                break;
            }
            default: {
                this.doStep2(false);
            }
        }
        this.runRedEffect();
    }

    public void doStep2(boolean isMoving) {
        if (this.bossType == 2) {
            if (this.actualSequence == Person.BATTLE) {
                if (this.turnDelay == 10) {
                    lightning_time = 11;
                } else if (this.turnDelay == 5) {
                    this.gameObjects.addSpell(new Spell(2, false, 5, this.gameObjects, this.tracker));
                }
            }
            if (this.isLightningEnabled()) {
                this.runLightning();
            }
        }
        if (this.getTurnDelay() < 1) {
            this.saveOldPositionXY();
            this.setAttackOver(false);
            this.moved = true;
            int i = 0;
            while (i < this.gameObjects.getLiveObjects().size()) {
                GameObject temp = (GameObject)((Object)this.gameObjects.getLiveObjects().elementAt(i));
                if (temp instanceof Resource) {
                    int textType;
                    Resource res = (Resource)temp;
                    Warlord w = this.isOwnedByBlue() ? this.gameObjects.blueWarlord : this.gameObjects.redWarlord;
                    int n = textType = this.isOwnedByBlue() ? 3 : 4;
                    if (res.hitPoints > 0 && this.collideWith(temp)) {
                        res.setHitPoints(0);
                        switch (res.type) {
                            case 0: {
                                w.addGold(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, textType);
                                break;
                            }
                            case 1: {
                                w.addStone(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("STONES")) + "+" + res.powerPoints, 10, textType);
                                break;
                            }
                            case 2: {
                                w.addMana(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("MANA")) + "+" + res.powerPoints, 10, textType);
                                break;
                            }
                            default: {
                                w.addGold(res.powerPoints);
                                this.gameObjects.addCenterText(String.valueOf(CLLocales.getString("GOLD")) + "+" + res.powerPoints, 10, textType);
                            }
                        }
                    }
                }
                if (temp instanceof Person && temp.isOwnedByBlue() != this.isOwnedByBlue() && this.collideWith(temp)) {
                    if (!isMoving) {
                        this.restorePositionXY();
                    }
                    if (this.actualSequence == Person.BATTLE) {
                        if (this.turnDelay < 1) {
                            if (this.bossType == 0 || this.bossType == 1) {
                                int damage = this.gameObjects.combatTurn(this, (Person)temp);
                                System.out.println("Damage: " + damage);
                                ((Person)temp).subHitPoints(damage);
                                ((Person)temp).addLastDamage(damage);
                                this.gameObjects.addFlyingText("-" + ((Person)temp).lastDamage, 10, ((Person)temp).getPositionX(), ((Person)temp).getPositionY() - 5, 1);
                                ((Person)temp).setLastDamage(0);
                                this.turnDelay = this.actualBattleDelay;
                            } else {
                                this.turnDelay = this.actualBattleDelay;
                            }
                        } else {
                            --this.turnDelay;
                        }
                    } else {
                        this.setFrameSequence(this.sequence[Person.BATTLE]);
                        this.actualSequence = Person.BATTLE;
                        this.turnDelay = this.actualBattleDelay;
                    }
                    this.setAttackOver(true);
                }
                ++i;
            }
            if (!this.isAttackOver()) {
                this.setLastDamage(0);
                this.lastAbility = "";
                if (this.actualSequence != Person.NORMAL) {
                    this.setFrameSequence(this.sequence[Person.NORMAL]);
                    this.actualSequence = Person.NORMAL;
                    this.lastAbility = "";
                }
                this.setTurnDelay(this.actualTurnDelay);
            }
        } else {
            this.setTurnDelay(this.getTurnDelay() - 1);
        }
        this.setRefPixelPosition(this.positionX, this.positionY);
    }

    public void setRedEffect() {
        this.redTime = 250;
        int new_col = 0xFF0000;
        this.alphaStep = 36;
        this.redAlpha = 0;
    }

    public void runRedEffect() {
        if (this.redTime > 0) {
            this.redAlpha += this.alphaStep;
            if (this.alphaStep > 0 && this.redAlpha == 4 * this.alphaStep) {
                this.redAlpha -= 2 * this.alphaStep;
                this.alphaStep = -this.alphaStep;
            }
            this.setRed(this.redAlpha);
            if (this.redAlpha <= 0) {
                this.redTime = 0;
            }
        }
    }

    void setRed(int alpha) {
        PalettedSprite sprite = (PalettedSprite)this.frames;
        int[] palette = sprite.getWorkingPalette();
        int i = 0;
        while (i < palette.length) {
            int r = sprite.getOriginalPaletteColor(i) >> 16 & 0xFF;
            int g = sprite.getOriginalPaletteColor(i) >> 8 & 0xFF;
            int b = sprite.getOriginalPaletteColor(i) & 0xFF;
            palette[i] = (sprite.getOriginalPaletteColor(i) & 0xFF000000) + (255 * alpha + r * (256 - alpha) >> 8 << 16) + (0 + g * (256 - alpha) >> 8 << 8) + (0 + b * (256 - alpha) >> 8);
            ++i;
        }
    }

    void runLightning() {
        if ((--lightning_time & 1) == 0) {
            Boss.generateNewLightning(this.positionX + (this.width >> 1) - 162, 110);
        }
    }

    public boolean isLightningEnabled() {
        return lightning_time > 0;
    }

    public static void initLightning() {
        lx = new short[200];
        ly = new short[200];
        ln = 0;
    }

    static void addLightningNode(int x, int y) {
        if (ln >= lx.length) {
            short[] new_lx = new short[lx.length + 200];
            short[] new_ly = new short[ly.length + 200];
            System.arraycopy(lx, 0, new_lx, 0, ln);
            System.arraycopy(ly, 0, new_ly, 0, ln);
            lx = new_lx;
            ly = new_ly;
        }
        Boss.lx[Boss.ln] = (short)x;
        Boss.ly[Boss.ln] = (short)y;
        ++ln;
    }

    public static void generateLightningBranch(int level, boolean horizontal, int dir) {
        short oy;
        short ox;
        if (level > 2) {
            return;
        }
        short max_len = L_BLENGTHS[level][0];
        short max_step_len = L_BLENGTHS[level][1];
        short min_step_len = L_BLENGTHS[level][2];
        short max_exceed = L_BLENGTHS[level][3];
        short sx = ox = lx[ln - 1];
        short sy = oy = ly[ln - 1];
        if (level > 0) {
            max_len = (short)(XCanvas.next_random(max_len >> 1) + (max_len >> 1));
            Boss.addLightningNode(-50, -50);
        }
        int distance = XCanvas.next_random(L_BLENGTHS[level][4] >> 1) + (L_BLENGTHS[level][4] >> 1);
        while (max_len > 0) {
            short step_y;
            short step_x;
            short len = (short)(XCanvas.next_random(max_step_len - min_step_len) + min_step_len);
            if (len > max_len) {
                len = max_len;
            }
            int dy = 50;
            int dx = 50;
            if (horizontal) {
                step_x = (short)(dir * len);
                dy = (short)(XCanvas.next_random(100) - 50);
                step_y = (short)(step_x * dy / dx);
                if (Math.abs(oy + step_y - sy) >= max_exceed) {
                    step_y = -step_y;
                }
            } else {
                step_y = (short)(dir * len);
                dx = (short)(XCanvas.next_random(100) - 50);
                step_x = (short)(step_y * dx / dy);
                if (Math.abs(ox + step_x - sx) >= max_exceed) {
                    step_x = -step_x;
                }
            }
            ox = (short)(ox + step_x);
            oy = (short)(oy + step_y);
            Boss.addLightningNode(ox, oy);
            max_len = (short)(max_len - len);
            if ((distance -= len) > 0) continue;
            distance += XCanvas.next_random(L_BLENGTHS[level][4] >> 1) + L_BLENGTHS[level][4] >> 1;
            Boss.generateLightningBranch(level + 1, !horizontal, XCanvas.next_random(2) == 0 ? -1 : 1);
        }
        if (level > 0) {
            Boss.addLightningNode(-100, -100);
        }
    }

    static void generateNewLightning(int x, int y) {
        ln = 0;
        Boss.addLightningNode(x, y);
        Boss.L_BLENGTHS[0][0] = (short)(x - 10);
        Boss.generateLightningBranch(0, true, -1);
        int new_branch_count = 0;
        int end_branch_count = 0;
        System.out.println();
        int level = 1;
        int i = 0;
        while (i < ln) {
            if (lx[i] == -50) {
                ++new_branch_count;
                ++level;
            } else if (lx[i] == -100) {
                ++end_branch_count;
                --level;
            }
            ++i;
        }
    }

    static void paintLightning(Graphics g) {
        int ox = lx[0];
        int oy = ly[0];
        int level = 0;
        int i = 1;
        while (i < ln) {
            int x = lx[i];
            int y = ly[i];
            switch (x) {
                case -50: {
                    Boss.stack_x[level] = ox;
                    Boss.stack_y[level] = oy;
                    ++level;
                    break;
                }
                case -100: {
                    ox = stack_x[--level];
                    oy = stack_y[level];
                    break;
                }
                default: {
                    if (level == 0) {
                        g.setColor(3533048);
                        g.drawLine(ox - CLGameCanvas.viewport, oy - 1, x - CLGameCanvas.viewport, y + 1);
                        g.drawLine(ox - CLGameCanvas.viewport, oy + 1, x - CLGameCanvas.viewport, y + 1);
                        g.setColor(0xFFFFFF);
                        g.drawLine(ox - CLGameCanvas.viewport, oy, x - CLGameCanvas.viewport, y);
                    } else {
                        g.setColor(3533048);
                        g.drawLine(ox - CLGameCanvas.viewport, oy, x - CLGameCanvas.viewport, y);
                    }
                    ox = x;
                    oy = y;
                }
            }
            ++i;
        }
    }

    public static void disposeLightning() {
    }
}

