/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.CLLocales;
import com.eternity.castlelords.GameObjects;
import com.eternity.castlelords.Messages;
import com.eternity.castlelords.Spell;
import com.impossible.util.BCFont;
import com.impossible.util.ByteStringBuffer;
import com.impossible.util.Im;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Graphics;

public class IngameMenu {
    public static final byte MENU_LEFT_MAIN = 0;
    public static final byte MENU_SPELLS = 1;
    public static final byte MENU_RECRUIT = 2;
    public static final byte MENU_BUILD = 3;
    public static final byte MENU_UPGRADE_UNITS = 4;
    public static final byte MENU_GAME = 5;
    public static final byte RECRUIT_PIKER = 0;
    public static final byte RECRUIT_KNIGHT = 1;
    public static final byte RECRUIT_ARCHER = 2;
    public static final byte RECRUIT_RIDER = 3;
    public static final byte RECRUIT_CANNON = 4;
    public static final byte TRAIN_PIKER = 0;
    public static final byte TRAIN_KNIGHT = 1;
    public static final byte TRAIN_ARCHER = 2;
    public static final byte TRAIN_RIDER = 3;
    public static final byte TRAIN_CANNON = 4;
    public static final byte BUILD_VILLAGE = 0;
    public static final byte BUILD_MINE = 1;
    public static final byte BUILD_SHRINE = 2;
    public static final byte BUILD_REPAIR = 3;
    public static final byte BUILD_DEFENCE = 4;
    public static final byte BUILD_WALL = 5;
    public static final byte OM_LEFT = 0;
    public static final byte OM_RIGHT = 1;
    public static final byte OM_RECRUIT = 0;
    public static final byte OM_BUILD = 1;
    public static final byte OM_TRAIN = 2;
    public static final byte OM_RAZE_WALLS = 4;
    public static final byte OM_GAME = 5;
    byte type;
    byte parent_menu;
    int parent_idx;
    GameObjects game_objects;
    int idx_selected;
    byte[] title;
    public MenuItem[] items;
    public boolean active = false;
    public int menu_y;
    CLGameCanvas game;
    int exit_key_code;
    byte[] commandTrace = new byte[5];
    int commandIdx;
    static byte[] fixedCommand = null;
    boolean followsFixedCommand = false;
    static final int COL_TEXT = 13418646;
    static final int COL_HILITE = 15855330;
    static final int COL_DIABLED = 7694137;
    static final int COL_BG = 2824460;
    static final int COL_COOLDOWN_STROKE = 9767430;
    static final int COL_COOLDOWN_FILL = 16122368;
    static final int COL_COMMAND_RECT = 0xFF3300;
    static final byte SPACE = -1;
    static final byte LEFT_BR = 69;
    static final byte RIGHT_BR = 70;
    final int MAX_NUMBER_OF_SPELLS;
    static final byte SLASH = 71;

    public IngameMenu(GameObjects go, CLGameCanvas game, int exit_key_code) {
        this.MAX_NUMBER_OF_SPELLS = 5;
        this.game_objects = go;
        this.game = game;
        this.exit_key_code = exit_key_code;
    }

    void checkFollowsFixedCommandSequence() {
        this.followsFixedCommand = false;
        if (fixedCommand != null && this.commandIdx <= fixedCommand.length) {
            boolean ok = true;
            int i = 0;
            while (ok && i < this.commandIdx) {
                ok = fixedCommand[i] == this.commandTrace[i];
                ++i;
            }
            this.followsFixedCommand = ok;
        }
    }

    public static boolean isFixedCommand() {
        return fixedCommand != null;
    }

    public static void fixedCommands(byte[] commandSequence) {
        fixedCommand = commandSequence;
    }

    public static void killFixedCommands() {
        fixedCommand = null;
    }

    public void activate(byte menuType) {
        if (menuType != 1 || this.items == null) {
            this.fillMenu(menuType);
            this.updateMenu();
        }
        this.commandIdx = 0;
        this.commandTrace[this.commandIdx++] = menuType == 0 ? (byte)0 : 1;
        this.checkFollowsFixedCommandSequence();
        this.idx_selected = 0;
        this.active = true;
    }

    public void updateMenu() {
        switch (this.type) {
            case 0: {
                if (this.items == null) break;
                int i = 0;
                while (i < this.game_objects.playerW.tt_actions.length && i < this.items.length) {
                    this.items[i].enabled = this.game_objects.playerW.tt_actions[i];
                    ++i;
                }
                this.items[3].enabled = false;
                int may_train = 0;
                i = 0;
                while (i < 4) {
                    may_train += this.game_objects.playerW.upgradeLevel[i] < this.game_objects.playerW.tt_unit_max_levels[i] ? 1 : 0;
                    ++i;
                }
                if (may_train == 0) {
                    this.items[2].enabled = false;
                }
                this.items[4].enabled = this.game_objects.playerW.wall_state == 2;
                break;
            }
            case 2: {
                int i = 0;
                while (i < this.items.length) {
                    this.items[i].enabled = this.game_objects.playerW.unitsLevel[i] > 0;
                    ++i;
                }
                this.items[2].enabled = this.items[2].enabled && !this.game_objects.playerW.has_archer && this.game_objects.playerW.castleLevel == 2;
                this.items[4].enabled = this.items[4].enabled && !this.game_objects.playerW.has_cannon;
                break;
            }
            case 4: {
                int i = 0;
                while (i < this.items.length) {
                    this.items[i].enabled = this.game_objects.playerW.upgradeLevel[i] < this.game_objects.playerW.tt_unit_max_levels[i];
                    ++i;
                }
                this.items[2].enabled = this.items[2].enabled && this.game_objects.playerW.castleLevel == 2;
                break;
            }
            case 3: {
                int i = 0;
                while (i < this.items.length) {
                    this.items[i].enabled = this.game_objects.playerW.tt_buildings[i];
                    ++i;
                }
                if (this.items.length > 2) {
                    this.items[2].enabled = false;
                }
                this.items[3].enabled = false;
                this.items[5].enabled = this.items[5].enabled & (this.game_objects.playerW.wall_state == 0 && this.game_objects.playerW.canBuildWall);
                break;
            }
            case 1: {
                if (CLGameCanvas.ticks_till_step != 0) break;
                int i = 0;
                while (i < this.items.length) {
                    if (this.items[i].cool_down > 0) {
                        this.items[i].cool_down -= XCanvas.DT;
                        if (this.items[i].cool_down < 0) {
                            this.items[i].cool_down = 0;
                        }
                    }
                    ++i;
                }
                break;
            }
        }
    }

    public byte[] getItemText(int idx) {
        if (this.type == 2 && idx != 2 && idx != 4) {
            ByteStringBuffer bb = new ByteStringBuffer(this.items[idx].text);
            bb.append((byte)-1).append((byte)69).appendNum(this.items[idx].data).append((byte)70).append((byte)-1);
            return bb.toByteString();
        }
        return this.items[idx].text;
    }

    int getItemWidth(int idx) {
        int w = CLImageTracker.font_small.textWidth(this.getItemText(idx));
        return w;
    }

    public void drawMenu(Graphics g, int x_pos, boolean left_anchor) {
        int h;
        int w = this.title != null ? CLImageTracker.font_small.textWidth(this.title) : 0;
        int disabled = 0;
        boolean cool_down = false;
        int i = 0;
        while (i < this.items.length) {
            if (this.items[i].enabled) {
                int l = CLImageTracker.font_small.textWidth(this.getItemText(i));
                if (l > w) {
                    w = l;
                }
            } else {
                ++disabled;
            }
            if (this.items[i].cool_down > 0) {
                cool_down = true;
            }
            ++i;
        }
        int start_idx = 0;
        int end_idx = this.items.length;
        if (this.type == 1) {
            w += 5;
            if (this.idx_selected > 2) {
                start_idx = this.idx_selected - 2;
            }
            if (start_idx + 5 > this.items.length) {
                start_idx = Math.max(0, this.items.length - 5);
            }
            end_idx = Math.min(start_idx + 5, this.items.length);
        }
        if (this.type != 1) {
            h = CLImageTracker.font_small.char_height * (this.items.length - disabled);
        } else {
            h = CLImageTracker.font_small.char_height * Math.min(5, this.items.length);
            if (5 < this.items.length) {
                h += 10;
            }
        }
        if (this.title != null) {
            h += CLImageTracker.font_small.char_height + (CLImageTracker.font_small.char_height >> 1);
        }
        int x = left_anchor ? x_pos : x_pos - w - 2 * CLImageTracker.box[0].getWidth();
        int y = this.menu_y;
        IngameMenu.drawBox(g, x, y, w, h);
        x += CLImageTracker.box[0].getWidth();
        y += CLImageTracker.box[0].getHeight() - 4;
        g.setColor(13418646);
        CLImageTracker.font_small.palette[1] = -3358570;
        CLImageTracker.font_small.palette[2] = 0;
        if (this.title != null) {
            CLImageTracker.font_small.textOutCenter(g, x + (w >> 1), y, this.title);
            g.drawLine(x, y += (CLImageTracker.font_small.char_height >> 2) + CLImageTracker.font_small.char_height, x + w, y);
            y += CLImageTracker.font_small.char_height >> 2;
        }
        g.setColor(13418646);
        if (start_idx > 0) {
            g.fillTriangle(x + (w >> 1), y, x + (w >> 1) - 3, y + 4, x + (w >> 1) + 3, y + 4);
        }
        if (this.type == 1 && 5 < this.items.length) {
            y += 5;
        }
        i = start_idx;
        while (i < end_idx) {
            if (this.items[i].enabled) {
                CLImageTracker.font_small.palette[1] = i == this.idx_selected ? -921886 : -3358570;
                CLImageTracker.font_small.textOut(g, x, y, this.getItemText(i));
                if (this.items[i].cool_down > 0) {
                    g.setColor(16122368);
                    h = (CLImageTracker.font_small.char_height - 1) * this.items[i].cool_down / Spell.getCoolDownByType(this.items[i].data, this.game_objects.playerW.intelligence - 1);
                    g.fillRect(x + w - 4, y + CLImageTracker.font_small.char_height - 1 - h, 4, h);
                    g.setColor(9767430);
                    g.drawRect(x + w - 4, y, 4, CLImageTracker.font_small.char_height - 1);
                }
                if (fixedCommand != null && this.followsFixedCommand && fixedCommand[this.commandIdx] == i) {
                    g.setColor(0xFF3300);
                    g.drawRect(x - 3, y - 1, w + 4, (int)CLImageTracker.font_small.char_height);
                }
                y += CLImageTracker.font_small.char_height;
            }
            ++i;
        }
        g.setColor(13418646);
        if (end_idx < this.items.length) {
            g.fillTriangle(x + (w >> 1), y + 4, x + (w >> 1) - 3, y, x + (w >> 1) + 3, y);
        }
        if (this.items.length - disabled > 0) {
            this.drawStatusBox(g);
        }
    }

    public void fillMenu(byte menuType) {
        this.type = menuType;
        switch (this.type) {
            case 0: {
                this.title = null;
                this.items = new MenuItem[6];
                this.parent_menu = (byte)-1;
                this.items[0] = new MenuItem(CLLocales.getByteString("RECRUIT"), true, 1, 2);
                this.items[1] = new MenuItem(CLLocales.getByteString("BUILD"), true, 1, 3);
                this.items[2] = new MenuItem(CLLocales.getByteString("UPGRADE_UNITS"), true, 1, 4);
                this.items[3] = new MenuItem(CLLocales.getByteString("UPGRADE_CASTLE"), true, 0, 5);
                this.items[4] = new MenuItem(CLLocales.getByteString("Raze walls"), true, 0, 37);
                this.items[5] = new MenuItem(CLLocales.getByteString("Game menu"), true, 1, 5);
                break;
            }
            case 5: {
                this.title = CLLocales.getByteString("Game menu");
                this.parent_menu = 0;
                this.items = new MenuItem[3];
                this.items[0] = new MenuItem(CLLocales.getByteString("OBJECTIVES"), true, 0, 105);
                this.items[1] = new MenuItem(CLLocales.getByteString("Restart"), true, 0, 104);
                this.items[2] = new MenuItem(CLLocales.getByteString("MAIN_MENU"), true, 2, 0);
                break;
            }
            case 1: {
                this.title = CLLocales.getByteString("SPELLS");
                int[] spells = this.game_objects.playerW.getAvailableSpellTypes();
                this.items = new MenuItem[spells.length];
                this.parent_menu = (byte)-1;
                int i = 0;
                while (i < spells.length) {
                    this.items[i] = new MenuItem(Spell.getByteNameOfType(spells[i]), true, 3, 120);
                    this.items[i].data = spells[i];
                    ++i;
                }
                break;
            }
            case 2: 
            case 4: {
                if (this.type == 2) {
                    CLGameCanvas.playerGameEvent = 162;
                    this.title = CLLocales.getByteString("RECRUIT");
                } else {
                    this.title = CLLocales.getByteString("UPGRADE_UNITS");
                }
                this.items = new MenuItem[5];
                this.parent_menu = 0;
                this.items[0] = new MenuItem(CLLocales.getByteString(Messages.PIKER[this.game_objects.playerW.race]), true);
                this.items[1] = new MenuItem(CLLocales.getByteString(Messages.KNIGHT[this.game_objects.playerW.race]), true);
                this.items[2] = new MenuItem(CLLocales.getByteString(Messages.ARCHER[this.game_objects.playerW.race]), true);
                this.items[3] = new MenuItem(CLLocales.getByteString(Messages.RIDER[this.game_objects.playerW.race]), true);
                this.items[4] = new MenuItem(CLLocales.getByteString(Messages.CANNON[this.game_objects.playerW.race]), true);
                if (this.type == 2) {
                    this.items[0].setAction((byte)0, 11);
                    this.items[1].setAction((byte)0, 12);
                    this.items[2].setAction((byte)0, 13);
                    this.items[3].setAction((byte)0, 15);
                    this.items[4].setAction((byte)0, 14);
                    break;
                }
                this.items[0].setAction((byte)0, 41);
                this.items[1].setAction((byte)0, 42);
                this.items[2].setAction((byte)0, 43);
                this.items[3].setAction((byte)0, 45);
                this.items[4].setAction((byte)0, 44);
                CLGameCanvas.playerGameEvent = 163;
                System.out.println("Upgrade menu");
                break;
            }
            case 3: {
                this.title = CLLocales.getByteString("BUILD");
                this.parent_menu = 0;
                this.items = new MenuItem[6];
                this.items[0] = new MenuItem(CLLocales.getByteString("VILLAGE"), true, 0, 31);
                this.items[1] = new MenuItem(CLLocales.getByteString("MINE"), true, 0, 32);
                this.items[2] = new MenuItem(CLLocales.getByteString("SHRINE"), true, 0, 33);
                this.items[3] = new MenuItem(CLLocales.getByteString("REPAIR"), true, 0, 35);
                this.items[4] = new MenuItem(CLLocales.getByteString("DEFENCE"), true, 0, 36);
                this.items[5] = new MenuItem(CLLocales.getByteString("WALL"), true, 0, 34);
            }
        }
    }

    public void handleKeyPress(int keyCode, int ga) {
        if (ga == 8) {
            this.items[this.idx_selected].doAction();
        } else if (keyCode == this.exit_key_code) {
            this.active = false;
        } else {
            switch (ga) {
                case 1: {
                    do {
                        --this.idx_selected;
                        if (this.idx_selected >= 0) continue;
                        this.idx_selected = this.items.length - 1;
                    } while (!this.items[this.idx_selected].enabled);
                    break;
                }
                case 6: {
                    do {
                        ++this.idx_selected;
                        if (this.idx_selected < this.items.length) continue;
                        this.idx_selected = 0;
                    } while (!this.items[this.idx_selected].enabled);
                    break;
                }
                case 2: {
                    if (this.type != 2 || this.idx_selected == 2 || this.idx_selected == 4 || this.items[this.idx_selected].data <= 1) break;
                    --this.items[this.idx_selected].data;
                    break;
                }
                case 5: {
                    if (this.type != 2 || this.idx_selected == 2 || this.idx_selected == 4 || this.items[this.idx_selected].data >= 3) break;
                    ++this.items[this.idx_selected].data;
                }
            }
        }
    }

    public static void drawBox(Graphics g, int x, int y, int w, int h) {
        Im[] boxImages = CLImageTracker.box;
        int xx = x;
        int ww = w;
        boxImages[0].draw(g, x, y, 20);
        int yy = y + (h -= 8) + boxImages[6].getHeight();
        boxImages[6].draw(g, x, yy, 20);
        g.setColor(2824460);
        g.fillRect(xx += boxImages[0].getWidth(), y + boxImages[0].getHeight(), w, h);
        while (ww > 0) {
            if (ww < boxImages[1].getWidth()) {
                g.setClip(xx, y, ww, h + 2 * boxImages[0].getHeight());
            }
            boxImages[1].draw(g, xx, y, 20);
            boxImages[5].draw(g, xx, yy, 20);
            if (ww < boxImages[1].getWidth()) {
                g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                xx += ww;
                ww -= ww;
                continue;
            }
            ww -= boxImages[1].getWidth();
            xx += boxImages[1].getWidth();
        }
        boxImages[2].draw(g, xx, y, 20);
        boxImages[4].draw(g, xx, yy, 20);
        int hh = h;
        yy = y + boxImages[2].getHeight();
        while (hh > 0) {
            if (hh < boxImages[3].getHeight()) {
                g.setClip(x, yy, w + 2 * boxImages[0].getWidth(), hh);
            }
            boxImages[7].draw(g, x, yy, 20);
            boxImages[3].draw(g, xx, yy, 20);
            if (hh < boxImages[3].getHeight()) {
                g.setClip(0, 0, (int)XCanvas.WIDTH, (int)XCanvas.HEIGHT);
                hh -= hh;
                yy += hh;
                continue;
            }
            hh -= boxImages[3].getHeight();
            yy += boxImages[3].getHeight();
        }
    }

    public static int getRealBoxHeight(int h) {
        return h + 2 * (CLImageTracker.box[0].getHeight() - 4);
    }

    void drawStatusBox(Graphics g) {
        int h = 0;
        int w = 0;
        byte[][] lines = null;
        BCFont f = CLImageTracker.font_small;
        switch (this.type) {
            case 2: 
            case 4: {
                h = CLImageTracker.portraits.getHeight();
                break;
            }
            case 3: {
                h = Math.max(CLImageTracker.buildings.getHeight(), CLImageTracker.font_small.char_height << 1);
                break;
            }
            case 1: {
                h = CLImageTracker.spell_icons.getHeight() + CLImageTracker.font_small.char_height;
                w = XCanvas.WIDTH - Math.max(CLImageTracker.spell_icons.getWidth(), CLImageTracker.small_icons.getWidth() + CLImageTracker.font_small.textWidth(new ByteStringBuffer().appendNum(this.game_objects.playerW.getSpellPriceByType(this.items[this.idx_selected].data)))) - 2 * CLImageTracker.box[0].getWidth() + 8 - 3;
                lines = f.splitText(CLLocales.SPELL_DESCRIPTIONS_BYTE[this.items[this.idx_selected].data], w);
                h = Math.max(h, lines.length * f.char_height);
                break;
            }
            default: {
                return;
            }
        }
        short bottom_y = XCanvas.HEIGHT;
        int y = bottom_y - IngameMenu.getRealBoxHeight(h);
        IngameMenu.drawBox(g, 0, y, XCanvas.WIDTH - 2 * CLImageTracker.box[0].getWidth(), h);
        y += 4;
        int x = 4;
        switch (this.type) {
            case 2: 
            case 4: {
                CLImageTracker.portraits.drawSubImage(g, x, y, 0, this.idx_selected);
                f.palette[1] = -3358570;
                f.palette[2] = 0;
                f.textOut(g, x += CLImageTracker.portraits.getWidth() + 2, y, this.items[this.idx_selected].text);
                if (this.type == 4) {
                    int xx = x + f.textWidth(this.items[this.idx_selected].text) + 2;
                    if (this.game_objects.playerW.upgradeLevel[this.idx_selected] > 0) {
                        CLImageTracker.small_icons.drawSubImage(g, xx, y, 0, 5);
                        f.textOut(g, xx += CLImageTracker.small_icons.getWidth() + 2, y, new ByteStringBuffer().appendNum(this.game_objects.playerW.upgradeLevel[this.idx_selected] + 1));
                    } else {
                        f.textOut(g, xx, y, CLLocales.getByteString(" - Unlock"));
                    }
                }
                y += f.char_height;
                if (this.type == 2) {
                    int i = 0;
                    while (i < 4) {
                        if (i == 0) {
                            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, 0);
                        } else {
                            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, i + 2);
                        }
                        x += CLImageTracker.small_icons.getWidth() + 2;
                        ByteStringBuffer s = new ByteStringBuffer();
                        switch (i) {
                            case 0: {
                                if (this.idx_selected == 2 || this.idx_selected == 4) {
                                    s.appendNum(this.game_objects.playerW.getUnitPrice((byte)0, (byte)this.idx_selected));
                                    break;
                                }
                                s.appendNum(this.game_objects.playerW.getUnitPrice((byte)0, (byte)this.idx_selected) * this.items[this.idx_selected].data);
                                break;
                            }
                            case 1: {
                                s.appendNum(this.game_objects.playerW.getUnitPP(this.idx_selected));
                                break;
                            }
                            case 2: {
                                s.appendNum(this.game_objects.playerW.getUnitHP(this.idx_selected));
                                break;
                            }
                            case 3: {
                                s.appendNum(this.game_objects.playerW.unitsLevel[this.idx_selected]);
                            }
                        }
                        f.textOut(g, x, y, s);
                        x += f.textWidth(s) + 2;
                        ++i;
                    }
                } else {
                    int end = this.game_objects.playerW.upgradeLevel[this.idx_selected] > 0 ? 3 : 1;
                    int i = 0;
                    while (i < end) {
                        if (i == 0) {
                            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, 0);
                        } else {
                            CLImageTracker.small_icons.drawSubImage(g, x, y, 0, i + 2);
                        }
                        x += CLImageTracker.small_icons.getWidth() + 2;
                        ByteStringBuffer s = new ByteStringBuffer();
                        switch (i) {
                            case 0: {
                                s.appendNum(this.game_objects.playerW.getUpgradePrice(0, this.idx_selected));
                                break;
                            }
                            case 1: {
                                s.appendNum(this.game_objects.playerW.getUpgradeUnitPP(this.idx_selected));
                                break;
                            }
                            case 2: {
                                s.appendNum(this.game_objects.playerW.getUpgradeUnitHP(this.idx_selected));
                            }
                        }
                        f.textOut(g, x, y, s);
                        x += f.textWidth(s) + 2;
                        ++i;
                    }
                }
                break;
            }
            case 3: {
                CLImageTracker.buildings.drawSubImage(g, x, y + (h - CLImageTracker.buildings.getHeight() >> 1), 0, this.idx_selected);
                x += CLImageTracker.buildings.getWidth() + 2;
                f.palette[1] = -3358570;
                f.palette[2] = 0;
                g.setColor(13418646);
                ByteStringBuffer s = new ByteStringBuffer(this.items[this.idx_selected].text);
                switch (this.idx_selected) {
                    case 0: {
                        s.append((byte)-1).appendNum(this.game_objects.playerW.villages).append((byte)71).appendNum(this.game_objects.playerW.max_villages);
                        break;
                    }
                    case 1: {
                        s.append((byte)-1).appendNum(this.game_objects.playerW.mines).append((byte)71).appendNum(this.game_objects.playerW.max_mines);
                    }
                }
                f.textOut(g, x, y, s);
                CLImageTracker.small_icons.drawSubImage(g, x, y += f.char_height, 0, this.idx_selected < 3 ? 0 : 1);
                x += CLImageTracker.small_icons.getWidth();
                s.delete(0, s.length());
                switch (this.idx_selected) {
                    case 0: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[0][0]);
                        break;
                    }
                    case 1: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[0][1]);
                        break;
                    }
                    case 2: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[0][2]);
                        break;
                    }
                    case 5: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[1][5]);
                        break;
                    }
                    case 3: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[1][3]);
                        break;
                    }
                    case 4: {
                        s.appendNum(GameObjects.BUILDINGS_PRICES[1][4]);
                    }
                }
                f.textOut(g, x, y, s);
                break;
            }
            case 1: {
                ByteStringBuffer price = new ByteStringBuffer();
                price.appendNum(this.game_objects.playerW.getSpellPriceByType(this.items[this.idx_selected].data));
                int idx = Spell.getIconIdx(this.items[this.idx_selected].data);
                CLImageTracker.spell_icons.drawSubImage(g, x + (f.textWidth(price) + CLImageTracker.small_icons.getWidth() - CLImageTracker.spell_icons.getWidth() >> 1), y, idx / 11, idx % 11);
                CLImageTracker.small_icons.drawSubImage(g, x, y += CLImageTracker.spell_icons.getHeight() + 1, 0, 2);
                f.palette[1] = -3358570;
                f.palette[2] = 0;
                g.setColor(13418646);
                f.textOut(g, x + CLImageTracker.small_icons.getWidth(), y + 2, price);
                x = XCanvas.WIDTH - w - CLImageTracker.box[0].getWidth() + 4;
                y -= CLImageTracker.spell_icons.getHeight() + 1;
                int i = 0;
                while (i < lines.length) {
                    f.textOut(g, x, y, lines[i]);
                    ++i;
                    y += f.char_height;
                }
                break;
            }
        }
    }

    class MenuItem {
        static final byte TYP_COMMAND = 0;
        static final byte TYP_OPEN_MENU = 1;
        static final byte TYP_EXIT_TO_MENU = 2;
        static final byte TYP_CAST_SPELL = 3;
        byte[] text;
        boolean enabled;
        int cool_down = 0;
        int data = 2;
        byte acType;
        int acCode;

        public MenuItem(byte[] text, boolean enabled) {
            this.text = text;
            this.enabled = enabled;
        }

        public MenuItem(byte[] text, boolean enabled, byte type, int acCode) {
            this.acType = type;
            this.acCode = acCode;
            this.text = text;
            this.enabled = enabled;
        }

        public void setAction(byte type, int acCode) {
            this.acType = type;
            this.acCode = acCode;
        }

        public void doAction() {
            switch (this.acType) {
                case 1: {
                    IngameMenu.this.commandTrace[IngameMenu.this.commandIdx++] = (byte)IngameMenu.this.idx_selected;
                    IngameMenu.this.checkFollowsFixedCommandSequence();
                    IngameMenu.this.fillMenu((byte)this.acCode);
                    IngameMenu.this.updateMenu();
                    IngameMenu.this.parent_idx = IngameMenu.this.idx_selected;
                    IngameMenu.this.idx_selected = 0;
                    while (IngameMenu.this.idx_selected < IngameMenu.this.items.length && !IngameMenu.this.items[IngameMenu.this.idx_selected].enabled) {
                        ++IngameMenu.this.idx_selected;
                    }
                    break;
                }
                case 0: {
                    if (fixedCommand != null && this.acCode != 104) {
                        IngameMenu.this.commandTrace[IngameMenu.this.commandIdx++] = (byte)IngameMenu.this.idx_selected;
                        boolean ok = true;
                        int ln = Math.min(IngameMenu.this.commandIdx, fixedCommand.length);
                        int i = 0;
                        while (i < ln && ok) {
                            ok = fixedCommand[i] == IngameMenu.this.commandTrace[i];
                            ++i;
                        }
                        if (ok && IngameMenu.this.commandIdx < fixedCommand.length) {
                            boolean bl = ok = this.data == fixedCommand[fixedCommand.length - 1] && fixedCommand.length - IngameMenu.this.commandIdx == 1;
                        }
                        if (!ok) {
                            CLGameCanvas.playerGameEvent = -1;
                            IngameMenu.this.active = false;
                            return;
                        }
                        fixedCommand = null;
                    }
                    IngameMenu.this.game.makeCommand(this.acCode, this.data);
                    IngameMenu.this.active = false;
                    break;
                }
                case 3: {
                    if (this.cool_down != 0) break;
                    if (IngameMenu.this.game.makeCommand(this.acCode, this.data)) {
                        this.cool_down = Spell.getCoolDownByType(this.data, IngameMenu.this.game_objects.playerW.intelligence - 1);
                        CLGameCanvas.playerGameEvent = 120;
                    }
                    IngameMenu.this.active = false;
                    break;
                }
                case 2: {
                    CLGameCanvas.exitToMenu();
                }
            }
        }
    }
}

