/*
 * Decompiled with CFR 0.152.
 */
package com.eternity.castlelords;

import com.eternity.castlelords.CLCampaignMap;
import com.eternity.castlelords.CLGameCanvas;
import com.eternity.castlelords.CLImageTracker;
import com.eternity.castlelords.LoadCanvas;
import com.eternity.castlelords.LogoCanvas;
import com.eternity.castlelords.Patch;
import com.eternity.castlelords.Warlord;
import com.impossible.util.ImLoader;
import com.impossible.util.XCanvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Image;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;

public class WarlordsCastles
extends MIDlet
implements CommandListener {
    public static final int LEFT_SOFT = -6;
    public static final int RIGHT_SOFT = -7;
    public static final int BOX_HEIGHT = 4;
    private Display display = Display.getDisplay((MIDlet)this);
    public static CLGameCanvas canvas;
    LogoCanvas logo;
    public static CLImageTracker imageTracker;
    public CLCampaignMap cmap = null;
    int gameType = 0;
    public int loadingStep = 1;
    public static Patch PATCH;
    public static XCanvas xcanvas;
    public static final Image DUMMY_IMAGE;
    boolean started = false;

    static {
        PATCH = new Patch();
        DUMMY_IMAGE = Image.createImage((int)1, (int)1);
    }

    public WarlordsCastles() {
        imageTracker = new CLImageTracker();
        xcanvas = new XCanvas();
        XCanvas.DT = 66;
        PATCH.loadPatchFromRS();
    }

    protected void destroyApp(boolean unconditional) {
        LogoCanvas.saveSettings();
    }

    protected void pauseApp() {
    }

    protected void startApp() throws MIDletStateChangeException {
        Display.getDisplay((MIDlet)this).setCurrent((Displayable)xcanvas);
        if (!this.started) {
            try {
                imageTracker.loadSplashImages();
            }
            catch (Exception ex) {
                this.exitGame();
            }
            LoadCanvas loadCanvas = new LoadCanvas(xcanvas, this, this.display, imageTracker);
            this.loadingStep = 1;
            xcanvas.setActualClass(loadCanvas);
            xcanvas.init();
            this.started = true;
        }
    }

    public CLGameCanvas getGameCanvas() {
        return canvas;
    }

    public void initGameCanvas() {
        canvas = new CLGameCanvas(xcanvas, this, this.display, imageTracker);
    }

    public void initCampaignMapCanvas() {
        if (this.cmap == null) {
            this.cmap = new CLCampaignMap(xcanvas, this, this.display, imageTracker);
        }
        this.cmap.newGame();
    }

    public void loadCampaignMapCanvas(int slot) {
        if (this.cmap == null) {
            this.cmap = new CLCampaignMap(xcanvas, this, this.display, imageTracker);
        }
        this.cmap.loadGame(slot);
    }

    public void setGameType(int type) {
        switch (type) {
            case 1: {
                this.gameType = 1;
                CLGameCanvas.removeAllLiveObjects();
                this.startMapCampaignOverview(-1);
                break;
            }
            case 2: {
                this.gameType = 1;
                break;
            }
            case 3: {
                this.gameType = 3;
                break;
            }
            case 4: {
                this.gameType = 4;
            }
        }
    }

    protected void startCampaign(int level, Warlord blueWarlord, String techtree, String objectives, String techtreeRed, int redSupremacy) {
        xcanvas.setActualClass(null);
        WarlordsCastles.canvas.status = 1;
        xcanvas.setActualClass(canvas);
        canvas.initCampaign(level, blueWarlord, techtree, objectives, techtreeRed, true, redSupremacy);
    }

    protected void startMapCampaignOverview(int newgame) {
        xcanvas.setActualClass(null);
        this.gameType = 1;
        if (newgame == -1) {
            this.initCampaignMapCanvas();
            xcanvas.setActualClass(this.cmap);
        } else {
            System.out.println("Slot: " + newgame);
            this.loadCampaignMapCanvas(newgame);
            xcanvas.setActualClass(this.cmap);
        }
    }

    protected void return_toMapCampaignOverview() {
        xcanvas.setActualClass(null);
        if (this.cmap == null) {
            this.cmap = new CLCampaignMap(xcanvas, this, this.display, imageTracker);
        }
        xcanvas.setActualClass(this.cmap);
    }

    public void stopGame(int reason) {
        imageTracker.resetGame();
        CLGameCanvas.gameMode = 2;
        ImLoader.initLoad();
        XCanvas.DONT_PROCESS_BUFFER = 1;
        ImLoader.setLoadListener(canvas);
        CLGameCanvas.initLoading(false);
        ImLoader.LOAD_MODE = 0;
        imageTracker.loadMenu(false);
        ImLoader.LOAD_MODE = 1;
        imageTracker.loadMenu(false);
        ImLoader.LOAD_MODE = (byte)2;
        System.out.println("Beleptem a stopGame-be " + this.gameType);
        if (this.gameType == 3 || this.gameType == 5) {
            if (LogoCanvas.getSoundSetting() == 1) {
                this.logo.playMusic();
            }
            this.logo.initMenu();
            xcanvas.setActualClass(this.logo);
        }
        if (this.gameType == 1) {
            switch (reason) {
                case 1: {
                    System.out.println("Victory!");
                    this.cmap.victory();
                    this.return_toMapCampaignOverview();
                    break;
                }
                case 2: {
                    System.out.println("DEFEAT!");
                    this.cmap.defeat();
                    this.return_toMapCampaignOverview();
                    break;
                }
                default: {
                    System.out.println("QUIT!");
                    if (LogoCanvas.getSoundSetting() == 1) {
                        this.logo.playMusic();
                    }
                    this.logo.initMenu();
                    xcanvas.setActualClass(this.logo);
                }
            }
        }
        if (this.gameType == 2) {
            WarlordsCastles.canvas.getGameObjects().level = reason == 1 ? ++WarlordsCastles.canvas.getGameObjects().level : --WarlordsCastles.canvas.getGameObjects().level;
        }
    }

    public void mainMenu() {
        if (LogoCanvas.getSoundSetting() == 1) {
            this.logo.playMusic();
        }
        this.logo.initMenu();
        xcanvas.setActualClass(this.logo);
    }

    public void exitGame() {
        canvas.setAlive(false);
        this.destroyApp(false);
        this.notifyDestroyed();
    }

    public void commandAction(Command c, Displayable d) {
    }
}

