/*
 * Decompiled with CFR 0.152.
 */
package com.impossible.bluetooth;

import com.impossible.bluetooth.L2CAP_GET_DATA;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.bluetooth.L2CAPConnection;

class L2CAP_util
implements Runnable {
    static final int DT = 10;
    static final int TIME_OUT = 2000;
    int recv;
    int transf;
    L2CAP_GET_DATA listener;
    L2CAPConnection conn;
    boolean transmission_ended;
    int len;
    byte[] packet_data;
    int data_pos;
    ByteArrayOutputStream bout;
    public DataOutputStream dout;
    Thread thread;
    int timeout;
    int closeSchedule;

    public L2CAP_util(L2CAP_GET_DATA listener, L2CAPConnection conn) {
        this.conn = conn;
        try {
            this.recv = conn.getReceiveMTU();
            this.transf = conn.getTransmitMTU();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("Transmit: " + this.transf + "; Receive: " + this.recv);
        this.listener = listener;
        this.transmission_ended = true;
        this.initSend();
        this.timeout = 2000;
        this.closeSchedule = -1;
        this.thread = new Thread(this);
        this.thread.start();
    }

    public void run() {
        while (this.thread != null) {
            long time = System.currentTimeMillis();
            try {
                if (this.conn.ready()) {
                    byte[] buf = new byte[this.recv];
                    this.conn.receive(buf);
                    this.receive(buf);
                    this.timeout = 2000;
                }
                Thread.sleep(10L);
                long dt = System.currentTimeMillis() - time;
                this.timeout = (int)((long)this.timeout - dt);
                if (this.timeout <= 0) {
                    this.timeout = 2000;
                    byte[] data = new byte[2];
                    data[1] = 0;
                    data[0] = 0;
                    this.conn.send(data);
                }
                if (this.closeSchedule == -1) continue;
                this.closeSchedule = (int)((long)this.closeSchedule - dt);
                if (this.closeSchedule > 0) continue;
                this.close();
            }
            catch (IOException ie) {
                System.out.println("Connection is probably closed, halt Util");
                this.close();
            }
            catch (Exception e) {}
        }
        try {
            Thread.sleep(1000L);
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            this.conn.close();
        }
        catch (Exception e) {
            System.out.println("Exception while trying to close the connection: ");
            e.printStackTrace();
        }
    }

    public void scheduleClosing(int time) {
        this.closeSchedule = time;
    }

    void receive(byte[] buf) {
        if (this.transmission_ended) {
            this.transmission_ended = false;
            this.len = (buf[0] << 8) + buf[1];
            if (this.len == 0) {
                this.transmission_ended = true;
            } else {
                System.out.println("------- New packet, ln:" + this.len);
                this.packet_data = new byte[this.len];
                this.data_pos = 0;
                int size = Math.min(this.recv - 2, this.len);
                System.arraycopy(buf, 2, this.packet_data, this.data_pos, size);
                this.len -= size;
                this.data_pos += size;
                if (this.len <= 0) {
                    this.transmission_ended = true;
                    this.listener.getData(new DataInputStream(new ByteArrayInputStream(this.packet_data)));
                }
            }
        } else {
            int size = Math.min(this.recv, this.len);
            System.arraycopy(buf, 0, this.packet_data, this.data_pos, size);
            this.len -= size;
            this.data_pos += size;
            if (this.len <= 0) {
                this.transmission_ended = true;
                this.listener.getData(new DataInputStream(new ByteArrayInputStream(this.packet_data)));
            }
        }
    }

    public void initSend() {
        this.bout = new ByteArrayOutputStream();
        this.dout = new DataOutputStream(this.bout);
    }

    public void senddData() {
        this.timeout = 2000;
        try {
            this.dout.flush();
        }
        catch (Exception e) {
            // empty catch block
        }
        byte[] d = this.bout.toByteArray();
        byte[] data = new byte[d.length + 2];
        data[0] = (byte)(d.length >> 8);
        data[1] = (byte)(d.length & 0xFF);
        System.arraycopy(d, 0, data, 2, d.length);
        d = null;
        this.initSend();
        int ln = data.length;
        int pos = 0;
        int count = 0;
        while (ln > 0) {
            int size = Math.min(ln, this.transf);
            byte[] buf = new byte[size];
            System.arraycopy(data, pos, buf, 0, size);
            pos += size;
            ln -= size;
            try {
                this.conn.send(buf);
            }
            catch (Exception e) {
                System.out.println("Exception while sending data over l2cap");
            }
            ++count;
        }
    }

    public void close() {
        this.thread = null;
    }
}

