/*
 * Decompiled with CFR 0.152.
 */
package com.impossible.util;

import com.impossible.util.ByteStringBuffer;
import com.impossible.util.ImLoader;
import java.io.DataInputStream;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public class BCFont {
    public short char_width;
    public short char_height;
    int comp_width;
    byte[][] data;
    public int[] palette = new int[16];
    public int[] rgb_data;
    boolean fixedWidth;
    short[] charWidths;
    public short overWrite = 0;

    public BCFont(boolean fixedWidth) {
        this.fixedWidth = fixedWidth;
        DataInputStream din = ImLoader.jpack_is;
        try {
            din.readInt();
            if (fixedWidth) {
                this.char_width = din.readShort();
                this.char_height = din.readShort();
                int n = din.readShort();
                this.comp_width = (this.char_width & 1) == 0 ? this.char_width >> 1 : (this.char_width >> 1) + 1;
                this.data = new byte[n][this.char_height * this.comp_width];
                this.rgb_data = new int[this.char_height * (this.comp_width * 2)];
                int i = 0;
                while (i < n) {
                    int j = 0;
                    while (j < this.char_height * this.comp_width) {
                        this.data[i][j] = din.readByte();
                        ++j;
                    }
                    ++i;
                }
            } else {
                this.char_height = din.readShort();
                int n = din.readShort();
                this.data = new byte[n][];
                this.charWidths = new short[n];
                int max_half_width = 0;
                int i = 0;
                while (i < n) {
                    this.charWidths[i] = din.readShort();
                    int half_width = (this.charWidths[i] & 1) + (this.charWidths[i] >> 1);
                    if (half_width > max_half_width) {
                        max_half_width = half_width;
                    }
                    this.data[i] = new byte[this.char_height * half_width];
                    int j = 0;
                    while (j < this.char_height * half_width) {
                        this.data[i][j] = din.readByte();
                        ++j;
                    }
                    ++i;
                }
                this.rgb_data = new int[this.char_height * (max_half_width * 2)];
                this.char_width = (short)(this.charWidths[0] >> 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void drawChar(Graphics g, int x, int y, int idx) {
        int i = 0;
        int j = 0;
        try {
            i = 0;
            j = 0;
            while (i < this.data[idx].length) {
                this.rgb_data[j++] = this.palette[this.data[idx][i] >> 4 & 0xF];
                this.rgb_data[j++] = this.palette[this.data[idx][i] & 0xF];
                ++i;
            }
        }
        catch (Exception e) {
            System.out.println("Exception: " + i + ", " + j + " idx=" + idx);
        }
        if (this.fixedWidth) {
            g.drawRGB(this.rgb_data, 0, this.comp_width << 1, x, y, (int)this.char_width, (int)this.char_height, true);
        } else {
            g.drawRGB(this.rgb_data, 0, this.charWidths[idx] + (this.charWidths[idx] & 1), x, y, (int)this.charWidths[idx], (int)this.char_height, true);
        }
    }

    public void textOut(Graphics g, int x, int y, byte[] s) {
        int i = 0;
        int xx = x;
        while (i < s.length) {
            byte b = s[i];
            if (b >= 0) {
                this.drawChar(g, xx, y, b);
                xx = this.fixedWidth ? (xx += this.char_width + this.overWrite) : (xx += this.charWidths[b] + this.overWrite);
            } else {
                xx += this.char_width;
            }
            ++i;
        }
    }

    public void textOut(Graphics g, int x, int y, ByteStringBuffer s) {
        int i = 0;
        int xx = x;
        while (i < s.length()) {
            byte b = s.byteAt(i);
            if (b >= 0) {
                this.drawChar(g, xx, y, b);
                xx = this.fixedWidth ? (xx += this.char_width + this.overWrite) : (xx += this.charWidths[b] + this.overWrite);
            } else {
                xx += this.char_width;
            }
            ++i;
        }
    }

    public int textWidth(byte[] s) {
        if (!this.fixedWidth) {
            int width = 0;
            int i = 0;
            while (i < s.length) {
                width = s[i] >= 0 ? (width += this.charWidths[s[i]]) : (width += this.char_width);
                width += this.overWrite;
                ++i;
            }
            return width;
        }
        return (this.char_width + this.overWrite) * s.length;
    }

    public int textWidth(ByteStringBuffer s) {
        if (!this.fixedWidth) {
            int width = 0;
            int i = 0;
            while (i < s.length()) {
                width = s.byteAt(i) >= 0 ? (width += this.charWidths[s.byteAt(i)]) : (width += this.char_width);
                width += this.overWrite;
                ++i;
            }
            return width;
        }
        return (this.char_width + this.overWrite) * s.length();
    }

    public void textOutCenter(Graphics g, int x, int y, byte[] s) {
        this.textOut(g, x - (this.textWidth(s) >> 1), y, s);
    }

    public byte[][] splitText(byte[] txt_to_split, int width) {
        byte[][] splitted;
        if (this.textWidth(txt_to_split) <= width) {
            splitted = new byte[][]{txt_to_split};
        } else {
            byte[] word;
            int last_start = 0;
            Vector<byte[]> words = new Vector<byte[]>();
            Vector<byte[]> lines = new Vector<byte[]>();
            int i = 0;
            while (i <= txt_to_split.length) {
                if (i == txt_to_split.length || txt_to_split[i] == -1) {
                    word = new byte[i - last_start];
                    System.arraycopy(txt_to_split, last_start, word, 0, i - last_start);
                    words.addElement(word);
                    last_start = i;
                    while (last_start <= txt_to_split.length && (last_start == txt_to_split.length || txt_to_split[last_start] == -1)) {
                        ++last_start;
                    }
                    i = last_start - 1;
                }
                ++i;
            }
            last_start = 0;
            word = null;
            i = 0;
            int lp = -this.char_width;
            int ln = -1;
            while (i <= words.size()) {
                if (i < words.size()) {
                    word = (byte[])words.elementAt(i);
                    lp += this.textWidth(word) + this.char_width;
                }
                if (lp > width || i == words.size()) {
                    byte[] line = new byte[ln];
                    int j = last_start;
                    int idx = 0;
                    while (j < i) {
                        word = (byte[])words.elementAt(j);
                        System.arraycopy(word, 0, line, idx, word.length);
                        if (idx + word.length < line.length) {
                            line[idx + word.length] = -1;
                        }
                        ++j;
                        idx += word.length + 1;
                    }
                    lines.addElement(line);
                    last_start = i;
                    if (i < words.size()) {
                        word = (byte[])words.elementAt(i);
                        ln = word.length;
                        lp = this.textWidth(word);
                    }
                } else if (i < words.size()) {
                    ln += 1 + word.length;
                }
                ++i;
            }
            splitted = new byte[lines.size()][];
            i = 0;
            while (i < lines.size()) {
                splitted[i] = (byte[])lines.elementAt(i);
                ++i;
            }
        }
        return splitted;
    }
}

