/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.GameCanvas;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.rms.RecordEnumeration;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;

public abstract class CCanvas
extends GameCanvas
implements Runnable {
    private volatile Thread animationThread = null;
    protected CMIDlet parent;
    public int slx;
    public int sly;
    public int clip_x0;
    public int clip_y0;
    public int clip_x1;
    public int clip_y1;
    public int clip_lx;
    public int clip_ly;
    public Graphics graphics;
    public int frame;
    private static final int TIMER_X_BORDER = 21;
    private byte[] resource;
    private Image[] resource_composites;
    private int[] resource_composite_counts;
    private Anim[] resource_anims;
    private int localisation;
    private int res_return_inf;
    public boolean res_anim_linearize;
    private Font[] system_fonts;
    private int[] system_font_colors;
    public boolean vibration_on;
    public boolean sound_on;
    public static Player[] sound;
    private int sound_playing = -1;
    boolean sound_call = false;
    long sound_start_time = 0L;
    private int vibraCount;
    public static final int K_NULL = 0;
    public static final int K_NUM0 = 48;
    public static final int K_NUM1 = 49;
    public static final int K_NUM2 = 50;
    public static final int K_NUM3 = 51;
    public static final int K_NUM4 = 52;
    public static final int K_NUM5 = 53;
    public static final int K_NUM6 = 54;
    public static final int K_NUM7 = 55;
    public static final int K_NUM8 = 56;
    public static final int K_NUM9 = 57;
    public static final int K_STAR = 42;
    public static final int K_POUND = 35;
    public static final int KEY_SOFTKEY1 = -1;
    public static final int KEY_SOFTKEY2 = -4;
    public static final int G_NULL = 0;
    public static final int G_UP = 1;
    public static final int G_DOWN = 2;
    public static final int G_LEFT = 3;
    public static final int G_RIGHT = 4;
    public static final int G_FIRE = 5;
    public static final int G_A = 6;
    public static final int G_B = 7;
    public static final int G_C = 8;
    public static final int G_D = 9;
    public static final int G_VAL = 10;
    public static final int G_BACK = 11;
    public static final int KB_UP = 1;
    public static final int KB_DOWN = 2;
    public static final int KB_LEFT = 4;
    public static final int KB_RIGHT = 8;
    public static final int KB_FIRE = 16;
    public static final int KB_UP_LEFT = 32;
    public static final int KB_DOWN_LEFT = 64;
    public static final int KB_UP_RIGHT = 128;
    public static final int KB_DOWN_RIGHT = 256;
    private int k_press_store;
    private int g_press_store;
    private int kb_state;
    private int kb_state_cur;
    private boolean is_kb_read;
    private int kb_state_read;
    public boolean key_released;
    public int k_press;
    public int k_press_down;
    public int g_press;
    public int g_press_down;
    public static final int BANNER_FONT = -2;
    public int slyc;
    private String banner_str_val;
    private String banner_str_back;
    private boolean banner_disp_on;
    private int banner_clear_color;
    private boolean banner_ingame_hide_on;
    private boolean banner_str_val_on;
    private boolean banner_str_back_on;
    private Command banner_cmd_val;
    private Command banner_cmd_back;
    private String banner_str_val_sv;
    private String banner_str_back_sv;
    private byte[] rms_buffer;
    private int rms_pos;
    private int bitres_len;
    private byte[] bitres_buff;
    private int bitres_t;
    private int bitres_nt;
    private int bitres_pos;
    public final boolean bkgnd_optimize_on;
    public int bkgnd_mlx;
    public int bkgnd_mly;
    public int bkgnd_clx;
    public int bkgnd_cly;
    public int bkgnd_slx;
    public int bkgnd_sly;
    public byte EMPTY_TILE;
    public byte WATER_TILE;
    public Anim bkgnd_tiles;
    private byte[] bkgnd_map;

    public CCanvas(CMIDlet parent) {
        super(false);
        this.bkgnd_optimize_on = true;
        this.setFullScreenMode(true);
        this.parent = parent;
        this.slx = this.getWidth();
        this.sly = this.getHeight();
        this.vibraCount = -1;
        this.clip_x1 = this.slx;
        this.clip_y1 = this.sly;
        this.clip_lx = this.slx;
        this.clip_ly = this.sly;
        this.res_init();
        this.font_init();
        this.font_t_load(-1);
        this.font_t_load(-2);
        this.banner_init();
        this.sound_init();
        this.reset_keys();
    }

    public synchronized void start() {
        this.animationThread = new Thread(this);
        this.animationThread.start();
    }

    public synchronized void stop() {
        this.animationThread = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run() {
        try {
            Thread currentThread = Thread.currentThread();
            while (currentThread == this.animationThread) {
                long startTime = System.currentTimeMillis();
                this.repaint(0, 0, this.slx, this.sly);
                this.serviceRepaints();
                long timeTaken = System.currentTimeMillis() - startTime;
                if (timeTaken < 92L) {
                    CCanvas cCanvas = this;
                    synchronized (cCanvas) {
                        this.wait(92L - timeTaken);
                        continue;
                    }
                }
                currentThread.yield();
            }
        }
        catch (Exception e) {
            System.out.println("Exception in run method " + e);
        }
    }

    public void paint(Graphics g) {
        this.graphics = g;
        this.graphics.setClip(this.clip_x0, this.clip_y0, this.clip_lx, this.clip_ly);
        this.key_paint_start();
        this.main_paint();
        this.banner_paint_end();
        this.key_paint_end();
        ++this.frame;
        this.graphics = null;
        if (this.vibraCount > 0) {
            --this.vibraCount;
        } else if (this.vibraCount == 0) {
            // empty if block
        }
    }

    private final InputStream get_InputStream(String str) {
        return this.getClass().getResourceAsStream(str);
    }

    public void set_clip(int _clip_x0, int _clip_y0, int _clip_lx, int _clip_ly) {
        this.clip_x0 = _clip_x0;
        this.clip_y0 = _clip_y0;
        this.clip_lx = _clip_lx;
        this.clip_ly = _clip_ly;
        this.clip_x1 = _clip_x0 + _clip_lx;
        this.clip_y1 = _clip_y0 + _clip_ly;
        this.graphics.setClip(this.clip_x0, this.clip_y0, this.clip_lx, this.clip_ly);
    }

    public void update_clip() {
        this.graphics.setClip(this.clip_x0, this.clip_y0, this.clip_lx, this.clip_ly);
    }

    protected void main_paint() {
    }

    public void hideNotify() {
    }

    public void showNotify() {
    }

    public void t_set_fullscreen_on(boolean value) {
    }

    private final byte[] get_resource(String name) {
        byte[] buffer = null;
        try {
            InputStream in = this.get_InputStream(name);
            int fileSize = (int)in.skip(Integer.MAX_VALUE);
            in.close();
            in = this.get_InputStream(name);
            buffer = new byte[fileSize];
            for (int t = 0; t < fileSize; t += in.read(buffer, t, fileSize - t)) {
            }
            in.close();
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return buffer;
    }

    private final Image get_image(String name, boolean optimize) {
        Image image = null;
        try {
            image = Image.createImage((String)name);
        }
        catch (IOException e) {
            System.out.println(e);
        }
        return image;
    }

    private final int getb(int pos) {
        return this.resource[pos] & 0xFF;
    }

    private final int getw(int pos) {
        return this.resource[pos] & 0xFF | (this.resource[pos + 1] & 0xFF) << 8;
    }

    private final void res_init() {
        int n_anims;
        this.resource = this.get_resource("/resource.bin");
        int n_composites = 8;
        if (n_composites != 0) {
            this.resource_composites = new Image[n_composites];
            this.resource_composite_counts = new int[n_composites];
        }
        if ((n_anims = 63) != 0) {
            this.resource_anims = new Anim[n_anims];
        }
    }

    public final void res_set_localisation(int _localisation) {
        this.localisation = _localisation;
    }

    public final int res_get_localisation() {
        return this.localisation;
    }

    public final byte[] res_get_raw(int res) {
        if ((res & 0x1000) != 0) {
            res += this.localisation - 4096;
        }
        int ptr0 = this.getw(res * 2);
        int ptr1 = this.getw((res + 1) * 2);
        this.res_return_inf = this.getb(ptr0++);
        int len = ptr1 - ptr0;
        if ((this.res_return_inf & 2) != 0) {
            return null;
        }
        if ((this.res_return_inf & 1) == 0) {
            byte[] data = new byte[len];
            for (int i = 0; i < len; ++i) {
                data[i] = this.resource[ptr0 + i];
            }
            return data;
        }
        return this.get_resource("/r" + (res >> 9 & 7) + (res >> 6 & 7) + (res >> 3 & 7) + (res >> 0 & 7) + ".bin");
    }

    public final String res_get_string(int res) {
        byte[] data;
        int t_index = -1;
        if (res >= 8192) {
            t_index = (res >> 13) - 1;
            res &= 0x1FFF;
        }
        if ((data = this.res_get_raw(res)) == null) {
            return null;
        }
        if (t_index >= 0) {
            int pos0 = data[t_index * 2 + 0] & 0xFF | (data[t_index * 2 + 1] & 0xFF) << 8;
            int pos1 = data[t_index * 2 + 2] & 0xFF | (data[t_index * 2 + 3] & 0xFF) << 8;
            byte[] subdata = new byte[pos1 - pos0];
            for (int pos = pos0; pos < pos1; ++pos) {
                subdata[pos - pos0] = data[pos];
            }
            data = subdata;
        }
        String str = null;
        if ((this.res_return_inf & 4) == 0 && (this.res_return_inf & 8) == 0) {
            str = new String(data);
        }
        data = null;
        str = str.replace('\u0092', '\'');
        return str;
    }

    public final char[] res_get_char_array(int res) {
        String s = this.res_get_string(res);
        if (s == null) {
            return null;
        }
        return s.toCharArray();
    }

    public final Anim res_get_anim(int res) {
        if ((res & 0x1000) != 0) {
            res += this.localisation - 4096;
        }
        if (this.resource_anims[res] == null) {
            boolean is_comb;
            int a;
            int ptr0 = this.getw(res * 2);
            int ptr1 = this.getw((res + 1) * 2);
            if ((a = this.getb(ptr0++)) >> 7 != 0) {
                int new_res = this.getw(ptr0);
                if (new_res == 65535) {
                    return null;
                }
                return this.res_get_anim(new_res);
            }
            Anim anim = null;
            int n_anim = this.getb(ptr0++);
            int n_anim_y = this.getb(ptr0++);
            boolean transp_on = (a >> 0 & 1) == 0;
            boolean optimize = (a >> 1 & 1) == 0;
            int anim_type = a >> 2 & 3;
            int anim_mask_type = a >> 4 & 3;
            boolean bl = is_comb = (a >> 6 & 1) != 0;
            if (!is_comb) {
                Image img = this.get_image("/r" + (res >> 9 & 7) + (res >> 6 & 7) + (res >> 3 & 7) + (res >> 0 & 7) + ".png", optimize);
                anim = new Anim(this, img.getWidth(), img.getHeight(), n_anim, n_anim_y, anim_type, anim_mask_type, img, 0, 0, optimize, res, -1, transp_on);
            } else {
                int comb = this.getb(ptr0++);
                int px = this.getw(ptr0);
                int py = this.getw(ptr0 += 2);
                int lx = this.getw(ptr0 += 2);
                int ly = this.getw(ptr0 += 2);
                ptr0 += 2;
                boolean store_composite = true;
                Image composite = this.resource_composites[comb];
                if (composite == null) {
                    composite = this.get_image("/c" + (comb >> 9 & 7) + (comb >> 6 & 7) + (comb >> 3 & 7) + (comb >> 0 & 7) + ".png", optimize);
                }
                anim = new Anim(this, lx, ly, n_anim, n_anim_y, anim_type, anim_mask_type, composite, px, py, optimize, res, comb, transp_on);
                if (anim.pindex != -1) {
                    this.resource_composites[comb] = composite;
                    int n = comb;
                    this.resource_composite_counts[n] = this.resource_composite_counts[n] + 1;
                }
            }
            this.resource_anims[res] = anim;
        }
        return this.resource_anims[res];
    }

    public final Anim res_free_anim(int res) {
        if (this.resource_anims[res] != null) {
            int pindex = this.resource_anims[res].pindex;
            if (pindex != -1) {
                int n = pindex;
                this.resource_composite_counts[n] = this.resource_composite_counts[n] - 1;
                if (this.resource_composite_counts[n] == 0) {
                    this.resource_composites[pindex] = null;
                }
            }
            this.resource_anims[res] = null;
        }
        return null;
    }

    public final Anim res_free_anim(Anim anim) {
        if (anim != null) {
            this.res_free_anim(anim.res_index);
        }
        return null;
    }

    public final void res_free_all_anims() {
        int i;
        for (i = 0; i < this.resource_anims.length; ++i) {
            this.res_free_anim(i);
        }
        for (i = 0; i < this.resource_composites.length; ++i) {
            this.resource_composites[i] = null;
        }
    }

    public final void font_init() {
        this.system_fonts = new Font[2];
        this.system_font_colors = new int[2];
    }

    public final void font_t_load(int index) {
        if (index < 0 && this.system_fonts[-index - 1] == null) {
            Game.get_system_font(index);
            this.system_fonts[-index - 1] = Game.return_get_system_font_font;
            this.system_font_colors[-index - 1] = Game.return_get_system_font_color;
        }
    }

    public final void font_t_unload(int index) {
        if (index < 0) {
            this.system_fonts[-index - 1] = null;
            this.system_font_colors[-index - 1] = 0;
        }
    }

    public final int font_get_width(int index, String str) {
        return index < 0 ? this.system_fonts[-index - 1].stringWidth(str) : 0;
    }

    public final int font_get_width(int index, char[] chars) {
        return index < 0 ? this.system_fonts[-index - 1].charsWidth(chars, 0, chars.length) : 0;
    }

    public final int font_get_height(int index) {
        return index < 0 ? this.system_fonts[-index - 1].getHeight() : 0;
    }

    public final void draw_string(String str, int x, int y, int align, int index) {
        char[] chars = str.toCharArray();
        this.draw_string(chars, x, y, align, index);
    }

    public final void draw_bordered_text(String text, int x, int y, int index, int back_colour, int border_colour, boolean restrictX) {
        int w;
        int x_padding = 2;
        int font_height = this.font_get_height(index);
        int font_width = 0;
        int y_padding = 2;
        int text_start_x = 0;
        int text_start_y = 0;
        int num_lines = 0;
        for (int w2 = 0; w2 < text.length(); ++w2) {
            if (text.charAt(w2) != '\n') continue;
            ++num_lines;
        }
        StringBuffer[] new_text = new StringBuffer[++num_lines];
        num_lines = 0;
        new_text[num_lines] = new StringBuffer("");
        for (w = 0; w < text.length(); ++w) {
            if (text.charAt(w) == '\n') {
                if (++num_lines >= new_text.length) break;
                new_text[num_lines] = new StringBuffer("");
                continue;
            }
            new_text[num_lines].append(text.charAt(w));
        }
        num_lines = 0;
        for (w = 0; w < new_text.length; ++w) {
            if (this.font_get_width(index, new_text[w].toString()) < this.font_get_width(index, new_text[num_lines].toString())) continue;
            num_lines = w;
        }
        font_width = this.font_get_width(index, new_text[num_lines].toString());
        num_lines = new_text.length;
        text_start_x = x - (font_width >> 1);
        if (text_start_x < 21 && restrictX) {
            text_start_x = 21;
        }
        text_start_y = y - font_height * new_text.length;
        this.update_clip();
        this.graphics.setColor(back_colour);
        this.graphics.fillRect(text_start_x - x_padding, text_start_y - y_padding, font_width + (x_padding << 1), font_height * new_text.length + (y_padding << 1));
        this.graphics.setColor(border_colour);
        this.graphics.drawRect(text_start_x - x_padding, text_start_y - y_padding, font_width + (x_padding << 1), font_height * new_text.length + (y_padding << 1));
        text_start_y = y - (font_height * new_text.length >> 1);
        int y_offset = 0;
        for (int w3 = 0; w3 < new_text.length; ++w3) {
            y_offset = (font_height << 8) * ((w3 << 8) - (num_lines << 8 >> 1)) >> 16;
            this.draw_string_centred(new_text[w3].toString(), index, false, text_start_x + (font_width >> 1) - (this.font_get_width(index, new_text[w3].toString()) >> 1) + (x_padding >> 1), false, text_start_y + y_offset + y_padding);
        }
    }

    public final void draw_string(char[] chars, int x, int y, int align, int index) {
        if (index < 0) {
            this.update_clip();
            this.graphics.setColor(this.system_font_colors[-index - 1]);
            this.graphics.setFont(this.system_fonts[-index - 1]);
            this.graphics.drawChars(chars, 0, chars.length, x, y, align);
        }
    }

    public final void draw_string_wrap(String str, int x, int y, int align, int index) {
        int h = this.font_get_height(index);
        char[] chars = null;
        int startPos = 0;
        int endPos = 0;
        for (endPos = startPos; endPos < str.length(); ++endPos) {
            if (str.charAt(endPos) != '\n') continue;
            chars = new char[endPos - startPos];
            str.getChars(startPos, endPos, chars, 0);
            this.draw_string(chars, x, y, align, index);
            startPos = ++endPos;
            chars = null;
            y += h;
        }
        if (startPos != endPos) {
            chars = new char[endPos - startPos];
            str.getChars(startPos, endPos, chars, 0);
            this.draw_string(chars, x, y, align, index);
            chars = null;
        }
    }

    public final void debug_halt() {
        while (true) {
            // Infinite loop
        }
    }

    private final void sound_init() {
        this.sound_on = true;
        sound = new Player[5];
        for (int i = 0; i < 5; ++i) {
            byte[] data = this.res_get_raw(88 + i);
            try {
                ByteArrayInputStream is = new ByteArrayInputStream(data);
                CCanvas.sound[i] = Manager.createPlayer((InputStream)is, (String)"audio/midi");
                is.close();
                continue;
            }
            catch (MediaException pe) {
                System.out.println("sound error - MediaException");
                continue;
            }
            catch (IOException ioe) {
                System.out.println("sound error - IOException");
            }
        }
    }

    public boolean check_sound_playing(int index) {
        return this.sound_on && sound != null && sound[index -= 88] != null && index >= 0 && index < 5 && sound[index].getState() == 400;
    }

    public void stop_all_sounds() {
        for (int s = 0; s < sound.length; ++s) {
            this.sound_stop(s + 88);
        }
    }

    public void deallocate() {
        for (int s = 0; s < sound.length; ++s) {
            try {
                sound[s].stop();
                sound[s].deallocate();
                continue;
            }
            catch (MediaException e) {
                e.printStackTrace();
            }
        }
    }

    private void startSound(int index) {
        index -= 88;
        try {
            sound[index].start();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public final void hdl_sound(int index) {
        if (this.sound_on) {
            try {
                if (sound != null && index >= 88 && index < 93) {
                    this.startSound(index);
                }
            }
            catch (Exception e) {
                this.sound_on = false;
            }
        }
    }

    public final void sound_stop(int index) {
        if (this.sound_on && (index -= 88) >= 0 && index < 5 && sound[index] != null) {
            try {
                sound[index].stop();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private final void key_paint_start() {
        this.k_press = this.k_press_store;
        this.k_press_store = 0;
        this.g_press = this.g_press_store;
        this.g_press_store = 0;
        this.is_kb_read = false;
    }

    private final void key_paint_end() {
        this.get_kb_state();
    }

    private final void key_simulate_g_press(int _g_press) {
        if (this.g_press_store == 0) {
            this.g_press_store = _g_press;
        }
    }

    protected final void keyPressed(int key) {
        this.key_released = false;
        this.k_press_store = key;
        this.k_press_down = key;
        boolean f = true;
        switch (key) {
            case 49: {
                this.kb_state_cur |= 0x20;
                break;
            }
            case 50: {
                this.kb_state_cur |= 1;
                this.g_press_store = 1;
                break;
            }
            case 51: {
                this.kb_state_cur |= 0x80;
                break;
            }
            case 52: {
                this.kb_state_cur |= 4;
                this.g_press_store = 3;
                break;
            }
            case 53: {
                this.kb_state_cur |= 0x10;
                this.g_press_store = 5;
                break;
            }
            case 54: {
                this.kb_state_cur |= 8;
                this.g_press_store = 4;
                break;
            }
            case 55: {
                this.kb_state_cur |= 0x40;
                break;
            }
            case 56: {
                this.kb_state_cur |= 2;
                this.g_press_store = 2;
                break;
            }
            case 57: {
                this.kb_state_cur |= 0x100;
                break;
            }
            case 48: {
                this.kb_state_cur |= 0x80;
                break;
            }
            case -1: {
                if (!this.banner_str_val_on) break;
                this.g_press_store = 10;
                this.banner_str_val_on = false;
                break;
            }
            case -4: {
                if (!this.banner_str_back_on) break;
                this.g_press_store = 11;
                this.banner_str_back_on = false;
                break;
            }
            default: {
                f = false;
            }
        }
        if (!f) {
            switch (this.getGameAction(key)) {
                case 1: {
                    this.g_press_store = 1;
                    this.kb_state_cur |= 1;
                    break;
                }
                case 6: {
                    this.g_press_store = 2;
                    this.kb_state_cur |= 2;
                    break;
                }
                case 2: {
                    this.g_press_store = 3;
                    this.kb_state_cur |= 4;
                    break;
                }
                case 5: {
                    this.g_press_store = 4;
                    this.kb_state_cur |= 8;
                    break;
                }
                case 8: {
                    this.g_press_store = 5;
                    this.kb_state_cur |= 0x10;
                    break;
                }
                case 9: {
                    this.g_press_store = 6;
                    break;
                }
                case 10: {
                    this.g_press_store = 7;
                    break;
                }
                case 11: {
                    this.g_press_store = 8;
                    break;
                }
                case 12: {
                    this.g_press_store = 9;
                }
            }
        }
        this.kb_state |= this.kb_state_cur;
        this.g_press_down = this.g_press_store;
    }

    protected final void keyReleased(int key) {
        this.key_released = true;
        this.k_press_down = 0;
        this.g_press_down = 0;
        boolean f = true;
        switch (key) {
            case 49: {
                this.kb_state_cur &= 0xFFFFFFDF;
                break;
            }
            case 50: {
                this.kb_state_cur &= 0xFFFFFFFE;
                break;
            }
            case 48: {
                this.kb_state_cur &= 0xFFFFFF7F;
                break;
            }
            case 52: {
                this.kb_state_cur &= 0xFFFFFFFB;
                break;
            }
            case 53: {
                this.kb_state_cur &= 0xFFFFFFEF;
                break;
            }
            case 54: {
                this.kb_state_cur &= 0xFFFFFFF7;
                break;
            }
            case 55: {
                this.kb_state_cur &= 0xFFFFFFBF;
                break;
            }
            case 56: {
                this.kb_state_cur &= 0xFFFFFFFD;
                break;
            }
            case 57: {
                this.kb_state_cur &= 0xFFFFFEFF;
                break;
            }
            default: {
                f = false;
            }
        }
        if (!f) {
            switch (this.getGameAction(key)) {
                case 1: {
                    this.kb_state_cur &= 0xFFFFFFFE;
                    break;
                }
                case 6: {
                    this.kb_state_cur &= 0xFFFFFFFD;
                    break;
                }
                case 2: {
                    this.kb_state_cur &= 0xFFFFFFFB;
                    break;
                }
                case 5: {
                    this.kb_state_cur &= 0xFFFFFFF7;
                    break;
                }
                case 8: {
                    this.kb_state_cur &= 0xFFFFFFEF;
                }
            }
        }
    }

    protected void pointerReleased(int x, int y) {
    }

    public final void reset_keys() {
        this.k_press = 0;
        this.k_press_down = 0;
        this.kb_state = 0;
        this.k_press_store = 0;
        this.kb_state_cur = 0;
        this.is_kb_read = false;
        this.kb_state_read = 0;
        this.key_released = true;
    }

    public final int get_kb_state() {
        if (!this.is_kb_read) {
            this.kb_state_read = this.kb_state;
            this.kb_state = this.kb_state_cur;
            this.is_kb_read = true;
        }
        return this.kb_state_read;
    }

    private final void banner_init() {
        this.banner_get_slyc();
    }

    private final void banner_get_slyc() {
        this.slyc = this.sly - this.font_get_height(-2);
    }

    public final int get_slyc_cur() {
        return this.banner_disp_on && !this.banner_ingame_hide_on ? this.slyc : this.sly;
    }

    public final void banner_set(String str_val, String str_back, boolean disp_on, int clear_color, boolean ingame_hide_on) {
        this.banner_str_val = str_val;
        this.banner_str_back = str_back;
        this.banner_disp_on = disp_on;
        this.banner_clear_color = clear_color;
        this.banner_ingame_hide_on = ingame_hide_on;
    }

    private final void banner_paint_end() {
        this.banner_str_val_on = this.banner_str_val != null;
        boolean bl = this.banner_str_back_on = this.banner_str_back != null;
        if (this.banner_disp_on && !this.banner_ingame_hide_on) {
            int sv_clip_x0 = this.clip_x0;
            int sv_clip_y0 = this.clip_y0;
            int sv_clip_lx = this.clip_lx;
            int sv_clip_ly = this.clip_ly;
            this.set_clip(0, 0, this.slx, this.sly);
            if (this.banner_clear_color != -1) {
                this.graphics.setColor(this.banner_clear_color);
                this.graphics.fillRect(0, this.slyc, this.slx, this.sly - this.slyc);
            }
            int padding_x = 1;
            int ypos = this.sly - this.font_get_height(-2) + 1;
            if (this.banner_str_val != null) {
                this.draw_string(this.banner_str_val, 0 + padding_x, ypos, 20, -2);
            }
            if (this.banner_str_back != null) {
                this.draw_string(this.banner_str_back, this.slx - this.font_get_width(-2, this.banner_str_back) - padding_x, ypos, 20, -2);
            }
            this.set_clip(sv_clip_x0, sv_clip_y0, sv_clip_lx, sv_clip_ly);
        }
    }

    public final void rms_set_byte(int v) {
        this.rms_buffer[this.rms_pos++] = (byte)v;
    }

    public final void rms_set_short(int v) {
        this.rms_set_byte(v & 0xFF);
        this.rms_set_byte(v >> 8);
    }

    public final void rms_set_int(int v) {
        this.rms_set_short(v & 0xFFFF);
        this.rms_set_short(v >> 16);
    }

    public final void rms_set_bool(boolean v) {
        this.rms_set_byte(v ? 1 : 0);
    }

    public final int rms_get_byte() {
        int v;
        return (v = this.rms_buffer[this.rms_pos++]) >= 0 ? v : v + 256;
    }

    public final int rms_get_short() {
        return this.rms_get_byte() | this.rms_get_byte() << 8;
    }

    public final int rms_get_int() {
        return this.rms_get_short() | this.rms_get_short() << 16;
    }

    public final boolean rms_get_bool() {
        return this.rms_get_byte() == 1;
    }

    private final int get_rec_id(RecordStore recordStore) {
        RecordEnumeration recordEnumeration = null;
        try {
            recordEnumeration = recordStore.enumerateRecords(null, null, false);
            return recordEnumeration.nextRecordId();
        }
        catch (RecordStoreException e) {
            recordEnumeration.destroy();
            return -1;
        }
    }

    public final boolean rms_t_load_buffer_start(String fname) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fname, (boolean)false);
            int rec_id = this.get_rec_id(recordStore);
            this.rms_buffer = recordStore.getRecord(rec_id);
            recordStore.closeRecordStore();
            this.rms_pos = 0;
            return true;
        }
        catch (RecordStoreException e) {
            return false;
        }
    }

    public final void rms_load_buffer_end() {
        this.rms_buffer = null;
        this.rms_pos = 0;
    }

    public final void rms_save_buffer_start() {
        this.rms_buffer = new byte[128];
        this.rms_pos = 0;
    }

    public final void rms_save_buffer_end(String fname) {
        try {
            RecordStore recordStore = RecordStore.openRecordStore((String)fname, (boolean)true);
            if (recordStore.getNumRecords() == 0) {
                recordStore.addRecord(this.rms_buffer, 0, this.rms_pos);
            } else {
                int rec_id = this.get_rec_id(recordStore);
                recordStore.setRecord(rec_id, this.rms_buffer, 0, this.rms_pos);
            }
            recordStore.closeRecordStore();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.rms_buffer = null;
        this.rms_pos = 0;
    }

    public final void draw_string_centred(String _in_str, int font_index, boolean _center_x, int _x, boolean _center_y, int _y) {
        int a;
        if (_center_x) {
            a = this.font_get_width(font_index, _in_str);
            _x = _x == 0 ? this.clip_x0 + (this.clip_x1 - this.clip_x0 - a) / 2 : (_x -= a / 2);
        }
        if (_center_y) {
            a = this.font_get_height(font_index);
            _y = _y == 0 ? this.clip_y0 + (this.clip_y1 - this.clip_y0 - a) / 2 : (_y -= a / 2);
        }
        char[] chars = _in_str.toCharArray();
        this.draw_string(chars, _x, _y, 20, font_index);
    }

    public final void draw_image_centred(Anim _src_img, int _frame, int _frame_y, boolean _center_x, int _x, boolean _center_y, int _y) {
        if (_center_x) {
            _x = _x == 0 ? this.clip_x0 + (this.clip_x1 - this.clip_x0 - _src_img.lx) / 2 : (_x -= _src_img.lx / 2);
        }
        if (_center_y) {
            _y = _y == 0 ? this.clip_y0 + (this.clip_y1 - this.clip_y0 - _src_img.ly) / 2 : (_y -= _src_img.ly / 2);
        }
        _src_img.disp(_x, _y, _frame, _frame_y);
    }

    public final int font_get_width(int font_index, String[] text) {
        int u = 0;
        for (int i = 0; i < text.length; ++i) {
            int ui = this.font_get_width(font_index, text[i]) / 2;
            if (ui <= u) continue;
            u = ui;
        }
        return u;
    }

    public final int font_get_height(int font_index, String[] text) {
        return this.font_get_height(font_index) * text.length;
    }

    public final void draw_text_centred(String[] text, int font_index, boolean _center_x, int _x, boolean _center_y, int _y) {
        if (_center_y) {
            if (_y == 0) {
                _y = this.sly / 2;
            }
            _y -= this.font_get_height(font_index, text) / 2;
        }
        for (int i = 0; i < text.length; ++i) {
            this.draw_string_centred(text[i], font_index, _center_x, _x, false, _y);
            _y += this.font_get_height(font_index);
        }
    }

    public final String[] res_get_text(StringBuffer all_text, String[] items) {
        int total_lines = 0;
        int cur_item = 0;
        for (int x = 0; x < all_text.length(); ++x) {
            if (all_text.charAt(x) != '\n') continue;
            ++total_lines;
        }
        String[] total_items = new String[++total_lines];
        StringBuffer cur_line = new StringBuffer();
        total_lines = 0;
        for (int x = 0; x < all_text.length(); ++x) {
            if (items != null && all_text.charAt(x) == '%') {
                if (cur_item >= items.length) continue;
                cur_line.append(items[cur_item]);
                ++cur_item;
                continue;
            }
            if (all_text.charAt(x) == '\n') {
                total_items[total_lines] = cur_line.toString();
                cur_line = new StringBuffer();
                ++total_lines;
                continue;
            }
            cur_line.append(all_text.charAt(x));
        }
        total_items[total_lines] = cur_line.toString();
        return total_items;
    }

    public final String[] res_get_text(int res, String[] _strings) {
        byte[] data = this.res_get_string(res).getBytes();
        int n_lines = 0;
        for (int i = 0; i < data.length; ++i) {
            if (data[i] != 10) continue;
            ++n_lines;
        }
        String[] lines = new String[++n_lines];
        StringBuffer s = new StringBuffer();
        int j = 0;
        int index_strings = 0;
        for (int i = 0; i < data.length + 1; ++i) {
            int c;
            int n = c = i < data.length ? data[i] : 10;
            if (c < 0) {
                c += 256;
            }
            if (c >= 32 && c <= 256) {
                if (c == 37) {
                    s.append(_strings[index_strings++]);
                } else {
                    s.append((char)c);
                }
            }
            if (c != 10) continue;
            lines[j] = new String(s);
            s.setLength(0);
            ++j;
        }
        return lines;
    }

    public void bitres_init(int res) {
        this.bitres_t = 0;
        this.bitres_nt = 0;
        this.bitres_buff = this.res_get_raw(res);
        this.bitres_pos = 0;
        this.bitres_len = this.bitres_buff.length;
    }

    public void bitres_close() {
        this.bitres_buff = null;
    }

    public int bitres_read_bit() {
        if (this.bitres_nt == 0) {
            this.bitres_t = this.bitres_buff[this.bitres_pos];
            ++this.bitres_pos;
            this.bitres_nt = 8;
        }
        int b = this.bitres_t & 1;
        this.bitres_t >>= 1;
        --this.bitres_nt;
        return b;
    }

    public int bitres_read_u(int nb) {
        int s = 0;
        for (int i = 0; i < nb; ++i) {
            s |= this.bitres_read_bit() << i;
        }
        return s;
    }

    public int bitres_read_s(int nb) {
        int s = 0;
        for (int i = 0; i < nb; ++i) {
            s |= this.bitres_read_bit() << i;
        }
        if (s >> nb - 1 == 1) {
            s |= -1 << nb;
        }
        return s;
    }

    public void disp_tile(int x, int y, int tile) {
        this.update_clip();
        this.set_clip(x, y, this.bkgnd_tiles.lx, this.bkgnd_tiles.ly);
        this.graphics.drawImage(this.bkgnd_tiles.frames, x, y - (tile << 4), 0);
        this.set_clip(0, 0, this.slx, this.sly);
    }

    public byte getMapTile(int tile) {
        return this.bkgnd_map[tile];
    }

    public byte getMapTile(int x, int y) {
        if (x < 0 || x >= this.bkgnd_mlx || y >= this.bkgnd_mly) {
            return this.WATER_TILE;
        }
        if (y < 0) {
            return this.EMPTY_TILE;
        }
        return this.bkgnd_map[y * this.bkgnd_mlx + x];
    }

    public void setMapTile(int x, int y, byte tile) {
        this.bkgnd_map[y * this.bkgnd_mlx + x] = tile;
    }

    public void flood_level(byte tile) {
        int row = -1;
        for (int r = this.bkgnd_mly - 1; r >= 0; --r) {
            if (this.getMapTile(0, r) == tile) continue;
            row = r;
            break;
        }
        if (row >= 0) {
            for (int c = 0; c < this.bkgnd_mlx; ++c) {
                this.setMapTile(c, row, tile);
            }
        }
    }

    public byte[] bkgnd_init(int res_map, int res_tiles) {
        byte[] level_data = null;
        this.bkgnd_tiles = this.res_get_anim(res_tiles);
        this.bitres_init(res_map);
        level_data = this.res_get_raw(res_map);
        this.bkgnd_slx = level_data[1] * 16;
        this.bkgnd_sly = level_data[2] * 16;
        this.bkgnd_clx = this.bkgnd_tiles.lx;
        this.bkgnd_cly = this.bkgnd_tiles.ly;
        this.bkgnd_mlx = this.bkgnd_slx / this.bkgnd_clx;
        this.bkgnd_mly = this.bkgnd_sly / this.bkgnd_cly;
        this.bkgnd_map = new byte[level_data[1] * level_data[2]];
        for (int x = 0; x < this.bkgnd_map.length; ++x) {
            this.bkgnd_map[x] = level_data[x + 44];
        }
        return level_data;
    }

    public void bkgnd_close() {
        this.bkgnd_tiles = this.res_free_anim(this.bkgnd_tiles.res_index);
        this.bkgnd_map = null;
    }

    public void bkgnd_disp(int pfx, int pfy, byte max_tile) {
        int bkgnd_slx = this.slx;
        int bkgnd_sly = this.sly;
        int i0 = pfx;
        int j0 = pfy;
        int i1 = pfx + bkgnd_slx - 1;
        int j1 = pfy + bkgnd_sly - 1;
        if (this.bkgnd_clx == 16) {
            i0 >>= 4;
            i1 >>= 4;
        } else {
            i0 /= this.bkgnd_clx;
            i1 /= this.bkgnd_clx;
        }
        if (this.bkgnd_cly == 16) {
            j0 >>= 4;
            j1 >>= 4;
        } else {
            j0 /= this.bkgnd_cly;
            j1 /= this.bkgnd_cly;
        }
        if (i0 < 0) {
            i0 = 0;
        }
        if (j0 < 0) {
            j0 = 0;
        }
        if (i1 >= this.bkgnd_mlx) {
            i1 = this.bkgnd_mlx - 1;
        }
        if (j1 >= this.bkgnd_mly) {
            j1 = this.bkgnd_mly - 1;
        }
        int y = j0 * this.bkgnd_cly - pfy;
        if (this.bkgnd_tiles.n_frames_ex == 1) {
            boolean f = true;
            int sv_clip_x0 = this.clip_x0;
            int sv_clip_y0 = this.clip_y0;
            int sv_clip_lx = this.clip_lx;
            int sv_clip_ly = this.clip_ly;
            Image bkgnd_image = this.bkgnd_tiles.frames;
            this.set_clip(0, 0, bkgnd_slx, y + this.bkgnd_cly);
            int k = 0;
            int x = 0;
            byte u = 0;
            int h = 0;
            for (int j = j0; j <= j1; ++j) {
                k = j * this.bkgnd_mlx + i0;
                x = i0 * this.bkgnd_clx - pfx;
                int i = i0;
                while (i <= i1) {
                    u = this.bkgnd_map[k];
                    if (u >= 0 && u <= max_tile) {
                        this.graphics.drawImage(bkgnd_image, x, y - (u << 4), 0);
                    }
                    ++i;
                    ++k;
                    x += this.bkgnd_clx;
                }
                h = (y += this.bkgnd_cly) + this.bkgnd_cly;
                if (h < bkgnd_sly) {
                    this.set_clip(0, y, bkgnd_slx, this.bkgnd_cly);
                    continue;
                }
                this.set_clip(0, y, bkgnd_slx, bkgnd_sly - y);
            }
            this.set_clip(sv_clip_x0, sv_clip_y0, sv_clip_lx, sv_clip_ly);
        } else {
            int shift = 0;
            int mask = 0;
            if (this.bkgnd_tiles.n_rows == 2) {
                shift = 1;
                mask = 1;
            } else if (this.bkgnd_tiles.n_rows == 4) {
                shift = 2;
                mask = 3;
            } else if (this.bkgnd_tiles.n_rows == 8) {
                shift = 3;
                mask = 7;
            }
            int j = j0;
            while (j <= j1) {
                int k = j * this.bkgnd_mlx + i0;
                int x = i0 * this.bkgnd_clx - pfx;
                int i = i0;
                while (i <= i1) {
                    byte u = this.bkgnd_map[k];
                    this.bkgnd_tiles.disp(x, y, u >> shift, u & mask);
                    ++i;
                    ++k;
                    x += this.bkgnd_clx;
                }
                ++j;
                y += this.bkgnd_cly;
            }
        }
    }
}

