/*
 * Decompiled with CFR 0.152.
 */
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.InputStream;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

class FGFileSystem {
    public static final boolean VERBOSE = false;
    public static final String RMS_FILENAME = "fgfs";
    public static final int FAT_ID = 1;
    public static final boolean AUDIT_FILES = false;
    public static final int MAX_PAK_READERS = 5;
    public static final int DEFAULT_MINIMUM_FAT_SIZE = 200;
    private FGFileData[] m_files;
    private FGResLoader m_audit;
    int[] m_pakReaderIDs = new int[5];
    FGPakReader[] m_pakReaders = new FGPakReader[5];
    int m_numPakReaders;
    int m_minimumFatSize = 200;
    private boolean m_bOutputFAT = true;

    public void setMinimumFatSize(int n) {
        this.m_minimumFatSize = n;
    }

    public void init() {
        this.m_numPakReaders = 0;
        String[] stringArray = RecordStore.listRecordStores();
        boolean bl = false;
        if (stringArray != null) {
            for (int i = 0; i < stringArray.length; ++i) {
                if (!stringArray[i].equals(RMS_FILENAME)) continue;
                bl = true;
            }
        }
        if (!bl) {
            this.m_files = new FGFileData[0];
            this.writeFAT();
        } else {
            this.readFAT();
        }
    }

    public void disableFATOutput() {
        this.m_bOutputFAT = false;
    }

    public void enableFATOutput() {
        this.m_bOutputFAT = true;
        this.writeFAT();
    }

    public void addPakReader(FGPakReader fGPakReader, int n) {
        if (this.m_numPakReaders >= 5) {
            return;
        }
        this.m_pakReaderIDs[this.m_numPakReaders] = n;
        this.m_pakReaders[this.m_numPakReaders] = fGPakReader;
        ++this.m_numPakReaders;
    }

    public void removePakReader(int n) {
        int n2;
        int n3 = -1;
        for (n2 = 0; n2 < this.m_numPakReaders; ++n2) {
            if (this.m_pakReaderIDs[n2] != n) continue;
            n3 = n2;
            break;
        }
        if (n3 == -1) {
            return;
        }
        for (n2 = n3; n2 < this.m_numPakReaders - 1; ++n2) {
            this.m_pakReaderIDs[n2] = this.m_pakReaderIDs[n2 + 1];
            this.m_pakReaders[n2] = this.m_pakReaders[n2 + 1];
        }
        --this.m_numPakReaders;
        this.m_pakReaders[this.m_numPakReaders] = null;
    }

    public void outputAuditData() {
    }

    public FGData getFile(String string, FGData fGData) {
        FGData fGData2 = this.getFile(string);
        if (fGData2 == null) {
            return null;
        }
        if (fGData2.m_dataLength > fGData.m_allocated) {
            return null;
        }
        System.arraycopy(fGData2.m_data, 0, fGData.m_data, 0, fGData2.m_dataLength);
        fGData.m_dataLength = fGData2.m_dataLength;
        return fGData;
    }

    public FGData getFile(String string) {
        Object object;
        int n;
        for (n = 0; n < this.m_numPakReaders; ++n) {
            object = this.m_pakReaders[n].getFile(string);
            if (object == null) continue;
            return object;
        }
        try {
            n = this.getFileID(string);
            if (n == -1) {
                object = "/" + string;
                InputStream inputStream = this.getClass().getResourceAsStream((String)object);
                if (inputStream == null) {
                    return null;
                }
                DataInputStream dataInputStream = new DataInputStream(inputStream);
                int n2 = dataInputStream.available();
                if (n2 <= 0) {
                    int n3;
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                    while ((n3 = dataInputStream.read()) != -1) {
                        byteArrayOutputStream.write(n3);
                    }
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    FGData fGData = new FGData();
                    fGData.adopt(byArray, byArray.length);
                    return fGData;
                }
                FGData fGData = new FGData();
                fGData.init(n2);
                dataInputStream.read(fGData.m_data, 0, n2);
                fGData.m_dataLength = n2;
                return fGData;
            }
            object = this.readFromRMS(n);
            if (object == null) {
                return null;
            }
            FGData fGData = new FGData();
            fGData.adopt((byte[])object, ((Object)object).length);
            return fGData;
        }
        catch (Exception exception) {
            return null;
        }
    }

    public boolean putFile(String string, FGData fGData) {
        return this.putFile(string, fGData, 0, fGData.m_dataLength);
    }

    public boolean putFile(String string, FGData fGData, int n, int n2) {
        int n3 = this.getFileIndex(string);
        if (n3 == -1) {
            FGFileData fGFileData = new FGFileData();
            fGFileData.m_fileName = new FGString(string);
            fGFileData.m_fileLength = fGData.m_dataLength;
            fGFileData.m_resID = this.writeToRMS(fGData.m_data, n, n2, -1);
            if (fGFileData.m_resID == -1) {
                System.out.println("New file did not write");
                return false;
            }
            this.addToFiles(fGFileData);
        } else {
            this.m_files[n3].m_fileLength = fGData.m_dataLength;
            int n4 = this.writeToRMS(fGData.m_data, n, n2, this.m_files[n3].m_resID);
            if (n4 == -1) {
                System.out.println("Replace file did not write");
                return false;
            }
        }
        this.writeFAT();
        return true;
    }

    public void deleteAllFiles() {
        try {
            RecordStore.deleteRecordStore((String)RMS_FILENAME);
        }
        catch (RecordStoreNotFoundException recordStoreNotFoundException) {
            recordStoreNotFoundException.printStackTrace();
        }
        catch (RecordStoreException recordStoreException) {
            // empty catch block
        }
        this.m_files = new FGFileData[0];
        this.writeFAT();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteFile(String string) {
        int n = this.getFileID(string);
        if (n == -1) {
            return;
        }
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_FILENAME, (boolean)false);
            recordStore.deleteRecord(n);
        }
        catch (Exception exception) {
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
        this.removeFromFiles(n);
        this.writeFAT();
    }

    public int getFileLength(String string) {
        int n = this.getFileIndex(string);
        if (n == -1) {
            return -1;
        }
        return this.m_files[n].m_fileLength;
    }

    public boolean fileExists(String string) {
        int n = this.getFileIndex(string);
        if (n != -1) {
            return true;
        }
        for (int i = 0; i < this.m_numPakReaders; ++i) {
            int n2 = this.m_pakReaders[i].getFileLength(string);
            if (n2 == -1) continue;
            return true;
        }
        return false;
    }

    public int getNumVolatileFiles() {
        return this.m_files.length;
    }

    public FGString getFilename(int n) {
        return this.m_files[n].m_fileName;
    }

    private int getFileID(String string) {
        int n = -1;
        for (int i = 0; i < this.m_files.length; ++i) {
            if (!this.m_files[i].m_fileName.equals(string)) continue;
            return this.m_files[i].m_resID;
        }
        return n;
    }

    private int getFileIndex(String string) {
        for (int i = 0; i < this.m_files.length; ++i) {
            if (!this.m_files[i].m_fileName.equals(string)) continue;
            return i;
        }
        return -1;
    }

    public void writeFAT() {
        if (!this.m_bOutputFAT) {
            return;
        }
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
            dataOutputStream.writeInt(this.m_files.length);
            for (int i = 0; i < this.m_files.length; ++i) {
                this.m_files[i].writeToStream(dataOutputStream);
            }
            byte[] byArray = byteArrayOutputStream.toByteArray();
            if (byArray.length < this.m_minimumFatSize) {
                byte[] byArray2 = new byte[this.m_minimumFatSize];
                System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
                this.writeToRMS(byArray2, 0, byArray2.length, 1);
            } else {
                this.writeToRMS(byArray, 0, byArray.length, 1);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void readFAT() {
        try {
            byte[] byArray = this.readFromRMS(1);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
            DataInputStream dataInputStream = new DataInputStream(byteArrayInputStream);
            int n = dataInputStream.readInt();
            this.m_files = new FGFileData[n];
            for (int i = 0; i < this.m_files.length; ++i) {
                this.m_files[i] = new FGFileData();
                this.m_files[i].readFromStream(dataInputStream);
            }
        }
        catch (Exception exception) {
            this.m_files = null;
            try {
                RecordStore.deleteRecordStore((String)RMS_FILENAME);
            }
            catch (Exception exception2) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readFromRMS(int n) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_FILENAME, (boolean)false);
            if (recordStore.getNumRecords() > 0) {
                byte[] byArray;
                byte[] byArray2 = byArray = recordStore.getRecord(n);
                return byArray2;
            }
            byte[] byArray = null;
            return byArray;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int writeToRMS(byte[] byArray, int n, int n2, int n3) {
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_FILENAME, (boolean)true);
            if (this.recordIDExists(recordStore, n3)) {
                recordStore.setRecord(n3, byArray, n, n2);
            } else {
                n3 = recordStore.addRecord(byArray, n, n2);
            }
            int n4 = n3;
            return n4;
        }
        catch (Exception exception) {
            int n5 = -1;
            return n5;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean recordIDExists(int n) {
        if (n < 1) {
            return false;
        }
        RecordStore recordStore = null;
        try {
            recordStore = RecordStore.openRecordStore((String)RMS_FILENAME, (boolean)true);
            if (this.recordIDExists(recordStore, n)) {
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        catch (Exception exception) {
            boolean bl = false;
            return bl;
        }
        finally {
            if (recordStore != null) {
                try {
                    recordStore.closeRecordStore();
                }
                catch (Exception exception) {}
            }
        }
    }

    public boolean recordIDExists(RecordStore recordStore, int n) {
        try {
            recordStore.getRecordSize(n);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public void addToFiles(FGFileData fGFileData) {
        FGFileData[] fGFileDataArray = new FGFileData[this.m_files.length + 1];
        for (int i = 0; i < this.m_files.length; ++i) {
            fGFileDataArray[i] = this.m_files[i];
        }
        fGFileDataArray[this.m_files.length] = fGFileData;
        this.m_files = fGFileDataArray;
    }

    public void removeFromFiles(int n) {
        FGFileData[] fGFileDataArray = new FGFileData[this.m_files.length - 1];
        int n2 = 0;
        for (int i = 0; i < this.m_files.length; ++i) {
            if (this.m_files[i].m_resID == n) continue;
            fGFileDataArray[n2] = this.m_files[i];
            ++n2;
        }
        this.m_files = fGFileDataArray;
    }

    class FGFileData {
        FGString m_fileName;
        int m_resID;
        int m_fileLength;

        FGFileData() {
        }

        void writeToStream(DataOutputStream dataOutputStream) {
            try {
                dataOutputStream.writeUTF(this.m_fileName.getNativeString());
                dataOutputStream.writeInt(this.m_resID);
                dataOutputStream.writeInt(this.m_fileLength);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        void readFromStream(DataInputStream dataInputStream) {
            try {
                this.m_fileName = new FGString(dataInputStream.readUTF());
                this.m_resID = dataInputStream.readInt();
                this.m_fileLength = dataInputStream.readInt();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

