/*
 * Decompiled with CFR 0.152.
 */
class CVArtillery {
    public static final int MODE_FLIGHT = 0;
    public static final int MODE_EXPLODE = 1;
    public static final int TIME_EXPLODE = 500;
    public static final int TIME_SMOKE_SPAWN = 100;
    public static final int NUM_SMOKE_ANIMS = 5;
    int m_mode;
    CVGameMode m_game;
    public boolean m_bActive;
    FGVector m_pos = new FGVector();
    FGVector m_velPPS = new FGVector();
    FGVector w_workingVector = new FGVector();
    FGTimer m_explodeTimer = new FGTimer();
    int m_side;
    FGAnimation m_shotAnim = new FGAnimation();
    FGAnimation[] m_smokeAnims = new FGAnimation[5];
    int[] m_smokeX = new int[5];
    int[] m_smokeY = new int[5];
    boolean[] m_bSmokeActive = new boolean[5];
    FGTimer m_smokeSpawnTimer = new FGTimer();
    boolean m_bPaused;

    public CVArtillery() {
        for (int i = 0; i < 5; ++i) {
            this.m_smokeAnims[i] = new FGAnimation();
        }
    }

    public void init(CVGameMode cVGameMode, int n) {
        this.m_game = cVGameMode;
        this.m_side = n;
    }

    public void clearArt() {
        this.m_shotAnim.clearArt();
        for (int i = 0; i < 5; ++i) {
            this.m_smokeAnims[i].clearArt();
        }
    }

    public void getNeededImages(FGLayout fGLayout, FGResLoader fGResLoader) {
        this.m_shotAnim.init(100);
        this.m_game.m_armies[this.m_side].fillAnimFromEraGraphics(this.m_shotAnim, "shot_");
        for (int i = 0; i < 5; ++i) {
            CVGameMode cVGameMode = this.m_game;
            if (cVGameMode.m_engine.isSmall()) {
                this.m_smokeAnims[i].init(200);
            } else {
                this.m_smokeAnims[i].init(100);
            }
            this.m_smokeAnims[i].addFrameSet(fGResLoader, "smoke", ".png", this.m_game.NUM_SMOKE_FRAMES, false, false);
        }
    }

    public void fire(int n) {
        int n2 = FGFixed.toInt(this.m_game.m_armies[this.m_side].m_artilleryStart.m_fixX);
        int n3 = n2 + n;
        if (this.m_side == 1) {
            n3 = n2 - n;
        }
        int n4 = FGFixed.toInt(this.m_game.m_armies[this.m_side].m_artilleryStart.m_fixY);
        int n5 = this.m_game.getTerrainY(n3);
        int n6 = n5 - n4;
        int n7 = FGFixed.toFixed(n -= n6);
        int n8 = FGFixed.toFixed(this.m_game.m_engine.m_artilleryGravity);
        int n9 = FGFixed.multiply(n7, n8);
        if ((n9 = FGFixed.divide(n9, FGFixed.toFixed(2))) < 0) {
            n9 = -n9;
        }
        n9 = FGFixed.sqrt(n9);
        this.fireXY(n9, -n9);
    }

    public void fireAP(int n, int n2) {
        int n3 = n2;
        this.w_workingVector.setRTheta(FGFixed.toFixed(n3), FGFixed.toFixedFourkays(-n));
        this.fireXY(this.w_workingVector.m_fixX, this.w_workingVector.m_fixY);
    }

    private void fireXY(int n, int n2) {
        this.m_pos.set(this.m_game.m_armies[this.m_side].m_artilleryStart);
        this.m_velPPS.setXY(n, n2);
        if (this.m_side == 1) {
            this.m_velPPS.m_fixX = -this.m_velPPS.m_fixX;
        }
        this.m_bActive = true;
        this.m_mode = 0;
        this.m_smokeSpawnTimer.start(0);
        for (int i = 0; i < 5; ++i) {
            this.m_bSmokeActive[i] = false;
        }
    }

    public void tick() {
        int n;
        if (!this.m_bActive) {
            return;
        }
        for (n = 0; n < 5; ++n) {
            if (!this.m_bSmokeActive[n] || !this.m_smokeAnims[n].finishedPlaying()) continue;
            this.m_bSmokeActive[n] = false;
        }
        if (this.m_mode == 1) {
            if (this.m_explodeTimer.isOver()) {
                this.m_bActive = false;
            }
            return;
        }
        if (this.m_smokeSpawnTimer.isOver()) {
            for (n = 0; n < 5; ++n) {
                if (this.m_bSmokeActive[n]) continue;
                this.m_bSmokeActive[n] = true;
                this.m_smokeX[n] = FGFixed.toInt(this.m_pos.m_fixX);
                this.m_smokeY[n] = FGFixed.toInt(this.m_pos.m_fixY);
                this.m_smokeAnims[n].playOnce();
                this.m_smokeSpawnTimer.start(100);
                break;
            }
        }
        n = this.m_game.m_engine.getTickTime();
        boolean bl = true;
        int n2 = 0;
        int n3 = 0;
        while (bl) {
            int n4;
            int n5;
            int n6;
            int n7;
            if (n > 20) {
                n2 = 20;
                n3 = FGFixed.toFixed(n2);
                n -= 20;
            } else {
                bl = false;
                n3 = FGFixed.toFixed(n);
            }
            FGGeometry.applyPPSVel(this.m_pos, this.m_velPPS, n3, this.w_workingVector);
            this.m_pos.set(this.w_workingVector);
            int n8 = FGFixed.toFixed(this.m_game.m_engine.m_artilleryGravity);
            this.m_velPPS.m_fixY = FGGeometry.applyPPSVel(this.m_velPPS.m_fixY, n8, n3);
            int n9 = FGFixed.toInt(this.m_pos.m_fixX);
            int n10 = FGFixed.toInt(this.m_pos.m_fixY);
            if (n9 < 0 || n9 > this.m_game.m_map.getWidth()) {
                this.m_bActive = false;
                return;
            }
            int n11 = this.m_game.getTerrainY(n9);
            if (n10 < n11) continue;
            this.m_pos.m_fixY = FGFixed.toFixed(n11);
            int n12 = this.m_game.getArtilleryImpactWidth(this.m_side);
            int n13 = FGFixed.toInt(this.m_pos.m_fixX);
            this.m_game.playSound(n13 - n12 / 2, n13 + n12 / 2, 4);
            int n14 = this.m_game.getOtherSide(this.m_side);
            for (n7 = 0; n7 < 16; ++n7) {
                CVUnit cVUnit = this.m_game.m_armies[n14].m_units[n7];
                if (!cVUnit.isValid()) continue;
                n6 = cVUnit.m_fixX;
                n5 = FGFixed.toFixed(cVUnit.getVisualWidth() / 2);
                n6 = n14 == 0 ? (n6 -= n5) : (n6 += n5);
                n4 = n6 - this.m_pos.m_fixX;
                if (n4 < 0) {
                    n4 = -n4;
                }
                if (n4 >= FGFixed.toFixed(n12 / 2)) continue;
                cVUnit.takeHit(this.m_game.m_engine.m_artilleryWallDamage, -1);
            }
            n7 = 0;
            int n15 = this.m_game.m_armies[n14].m_unitsStart - FGFixed.toInt(this.m_pos.m_fixX);
            n6 = this.m_game.m_armies[n14].m_castleGFX.getWidth() / 2;
            if (n15 < 0) {
                if (-n15 < n6 / 2 + n12 / 2) {
                    n7 = 1;
                }
            } else if (n15 < n6 / 2 + n12 / 2) {
                n7 = 1;
            }
            if (n7 != 0) {
                this.m_game.castleHit(n14);
            }
            this.m_explodeTimer.start(500);
            this.m_mode = 1;
            if (this.m_game.hasTech(this.m_side, 9)) {
                n5 = FGFixed.toInt(this.m_pos.m_fixX) - n12 / 2;
                n4 = n12;
                this.m_game.m_armies[this.m_side].startBurn(n5, n4);
            }
            bl = false;
        }
    }

    public void drawSelf(FGGraphics fGGraphics, int n, int n2) {
        int n3;
        int n4;
        FGImage fGImage;
        int n5;
        int n6;
        int n7;
        if (!this.m_bActive) {
            return;
        }
        int n8 = FGFixed.toInt(this.m_pos.m_fixX);
        int n9 = FGFixed.toInt(this.m_pos.m_fixY);
        n8 += n;
        n9 += n2;
        boolean bl = false;
        if (this.m_game.m_era == 0) {
            bl = true;
        }
        CVGameMode cVGameMode = this.m_game;
        if (cVGameMode.m_engine.isSmall()) {
            bl = false;
        }
        if (!bl) {
            for (n7 = 0; n7 < 5; ++n7) {
                if (!this.m_bSmokeActive[n7]) continue;
                n6 = this.m_smokeX[n7] + n;
                n5 = this.m_smokeY[n7] + n2;
                fGImage = this.m_smokeAnims[n7].getCurrentFrame();
                n4 = n6 - fGImage.getWidth() / 2;
                n3 = n5 - fGImage.getHeight() / 2;
                fGImage.drawSelf(fGGraphics, n4, n3);
            }
        }
        if (this.m_mode == 0) {
            FGImage fGImage2 = null;
            CVGameMode cVGameMode2 = this.m_game;
            if (!cVGameMode2.m_engine.isSmall() && this.m_game.m_era == 3) {
                n6 = this.m_velPPS.m_fixX;
                n5 = this.m_velPPS.m_fixY;
                if (this.m_side == 1) {
                    n6 = -n6;
                }
                int n10 = FGFixed.atan2(n6, n5);
                n4 = FGFixed.toInt(n10);
                n4 += 1024;
                n4 %= 4096;
                n3 = (n4 -= 128) / 256;
                if (n3 < 0) {
                    n3 = 0;
                }
                if (n3 > 6) {
                    n3 = 6;
                }
                fGImage2 = this.m_shotAnim.getFrame(n3);
            } else {
                fGImage2 = this.m_shotAnim.getCurrentFrame();
            }
            n8 -= fGImage2.getWidth() / 2;
            n9 -= fGImage2.getHeight() / 2;
            if (this.m_side == 0) {
                fGImage2.drawSelf(fGGraphics, n8, n9);
            } else {
                fGImage2.drawSelfFlippedH(fGGraphics, n8, n9);
            }
        } else if (this.m_mode == 1) {
            FGImage fGImage3;
            FGImage fGImage4;
            n7 = this.m_game.getArtilleryImpactWidth(this.m_side);
            n6 = FGFixed.toInt(this.m_pos.m_fixX);
            FGAnimation fGAnimation = this.m_game.m_explosion;
            if (bl) {
                fGAnimation = this.m_smokeAnims[0];
            }
            CVGameMode cVGameMode3 = this.m_game;
            if (cVGameMode3.m_engine.isSmall()) {
                fGImage4 = fGImage = fGAnimation.getFrame(fGAnimation.m_numFrames - 1);
                fGImage3 = fGAnimation.getFrame(0);
            } else {
                fGImage = fGAnimation.getFrame(fGAnimation.m_numFrames - 1);
                fGImage4 = fGAnimation.getFrame(fGAnimation.m_numFrames - 2);
                fGImage3 = fGAnimation.getFrame(0);
            }
            int n11 = n6 - (n7 -= fGImage4.getWidth()) / 2;
            int n12 = fGImage.getWidth();
            int n13 = n7 / n12 + 1;
            CVGameMode cVGameMode4 = this.m_game;
            if (cVGameMode4.m_engine.isSmall()) {
                n13 += 3;
            }
            int n14 = n7 / (n13 - 1);
            for (int i = 0; i <= n7; i += n14) {
                int n15 = this.m_game.m_engine.rand() % fGAnimation.m_numFrames;
                if (!bl && this.m_explodeTimer.remainingTime() < 166) {
                    n15 = this.m_game.m_engine.rand() % (fGAnimation.m_numFrames / 2) + fGAnimation.m_numFrames / 2;
                }
                if (this.m_bPaused) {
                    n15 = i / n14 % 2;
                }
                if (i == 0 || i > n7) {
                    int n16 = fGAnimation.m_numFrames - 2;
                    n15 = n16 + this.m_game.m_engine.rand() % 2;
                }
                FGImage fGImage5 = fGAnimation.getFrame(n15);
                int n17 = i + n11;
                int n18 = this.m_game.getTerrainY(n17);
                int n19 = n2 + n18 - fGImage5.getHeight() / 2;
                int n20 = n + n17 - fGImage5.getWidth() / 2;
                fGImage5.drawSelf(fGGraphics, n20, n19);
            }
        }
    }

    public void pause() {
        this.m_bPaused = true;
        this.m_explodeTimer.pause();
        this.m_shotAnim.pause();
        for (int i = 0; i < 5; ++i) {
            this.m_smokeAnims[i].pause();
        }
    }

    public void resume() {
        this.m_bPaused = false;
        this.m_explodeTimer.resume();
        this.m_shotAnim.resume();
        for (int i = 0; i < 5; ++i) {
            this.m_smokeAnims[i].resume();
        }
    }
}

