/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class FieldrunnersCanvas
extends LanscapeCanvas
implements Runnable {
    public long mElapsedTime = 0L;
    public long mFrameTime = 0L;
    public long mNumFrames = 0L;
    public double mAVGFrameTime = 0.0;
    public long mMillisAtCurrentFrame = 0L;
    public long mMillisAtLastFrame = -1L;
    public Thread mThread = null;
    private Graphics graphics = null;
    FieldrunnersScreen mCurrentScreen = null;
    LogoScreen mLogoViewer = null;
    MapScreen mMapScreen = null;
    Fieldrunners mApp = null;
    public Point mTapPoint = null;
    public boolean mRestart = false;

    protected FieldrunnersCanvas(boolean bl, boolean bl2, Fieldrunners fieldrunners) {
        super(bl, bl2);
        String string;
        int n;
        this.mApp = fieldrunners;
        this.mTapPoint = new Point(0, 0);
        String string2 = this.mApp.getAppProperty("MW-Cleanup-Threshold");
        if (string2 != null && (Can.CLEANUP_THRESHOLD = Long.parseLong(string2)) <= 0L) {
            Can.CLEANUP_THRESHOLD = -1L;
        }
        Can.setMidletVersionNumber(this.mApp.getAppProperty("MIDlet-Version"));
        String string3 = this.mApp.getAppProperty("MW-Help-Text-Width");
        if (null != string3 && (n = Integer.parseInt(string3)) > 0) {
            Can.HELP_TEXT_WIDTH = n;
        }
        if (null != (string = this.mApp.getAppProperty("MW-Show-Heap"))) {
            Can.DEBUG_SHOW_HEAP_IN_GAME = string.compareTo("true") == 0;
        }
        Can.SOUNDPLAYER = new SoundPlayer();
    }

    public Graphics GetCanvasGraphics() {
        if (this.graphics == null) {
            this.graphics = this.getGraphics();
            this.graphics.setColor(0, 0, 0);
            this.graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        }
        return this.graphics;
    }

    protected void hideNotify() {
        try {
            if (this.mMapScreen != null && this.mMapScreen.mMap != null) {
                this.mMapScreen.mMap.saveGameState();
                this.mMapScreen.mMap.mGameHudForm.setStatusString("PAUSED", 0.0f, true);
                this.mMapScreen.mMap.mGameHudForm.mPlaybackButton.mIsToggled = true;
                this.mMapScreen.mMap.pauseGame();
                this.mMapScreen.mMap.suspendGameState();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        try {
            Can.SOUNDPLAYER.stop();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void startApp() {
        Can.SOUNDPLAYER.mNeedSoundRestart = true;
        Can.SOUNDPLAYER.mNeedSoundRestartCount = 30;
    }

    protected void showNotify() {
        if (this.mMapScreen == null) {
            this.setFullScreenMode(true);
            this.mLogoViewer = new LogoScreen();
            this.mLogoViewer.AddLogo("/hom_splash.png", 1);
            this.mLogoViewer.AddLogo("/hom_splash.png", 3);
            this.mLogoViewer.AddLogo("/FieldrunnersSplash.png", 3);
            this.mLogoViewer.AddLogo("/SplashMW.png", 1);
            this.mLogoViewer.AddLogo("/UserInterface/title_screen_wide.png", 1);
            this.mCurrentScreen = this.mLogoViewer;
            this.mThread = new Thread(this);
            this.mThread.start();
        } else {
            Can.SOUNDPLAYER.mNeedSoundRestart = true;
            Can.SOUNDPLAYER.mNeedSoundRestartCount = 30;
            this.mThread.notifyAll();
            this.mMapScreen.mMap.unpauseGame();
            this.mMapScreen.mMap.updateStatusTextWithCurrentRound();
        }
    }

    protected void sizeChanged(int n, int n2) {
        this.graphics = null;
        super.sizeChanged(n, n2);
    }

    protected void pointerPressedLandscape(int n, int n2) {
        this.mTapPoint.x = n;
        this.mTapPoint.y = n2;
        Key.process(this.mElapsedTime);
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.pointerPressed(n, n2);
        }
    }

    protected void pointerDraggedLandscape(int n, int n2) {
        this.mTapPoint.x = n;
        this.mTapPoint.y = n2;
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.pointerDragged(n, n2);
        }
    }

    protected void pointerReleasedLandscape(int n, int n2) {
        this.mTapPoint.x = n;
        this.mTapPoint.y = n2;
        Key.process(this.mElapsedTime);
        if (this.mCurrentScreen != null) {
            this.mCurrentScreen.pointerReleased(n, n2);
        }
    }

    public void run() {
        try {
            long l = 0L;
            while (this.mThread == Thread.currentThread()) {
                this.mMillisAtCurrentFrame = System.currentTimeMillis();
                if (this.mMillisAtLastFrame != -1L) {
                    this.mFrameTime = this.mMillisAtCurrentFrame - this.mMillisAtLastFrame;
                    this.mElapsedTime += this.mFrameTime;
                    this.mAVGFrameTime = (this.mAVGFrameTime * (double)this.mNumFrames + (double)this.mFrameTime) / (double)(this.mNumFrames + 1L);
                    ++this.mNumFrames;
                }
                Graphics graphics = this.GetCanvasGraphics();
                if (this.mRestart) {
                    this.mLogoViewer = null;
                    this.mMapScreen = null;
                    System.gc();
                    this.mMapScreen = new MapScreen(this, this.mApp);
                    this.mCurrentScreen = this.mMapScreen;
                    this.mRestart = false;
                }
                if (this.mLogoViewer != null) {
                    if (!this.mLogoViewer.Finished()) {
                        this.mLogoViewer.Draw(graphics, this.mFrameTime);
                    } else {
                        this.mLogoViewer = null;
                        System.gc();
                        this.mMapScreen = new MapScreen(this, this.mApp);
                        this.mCurrentScreen = this.mMapScreen;
                        this.startThemeMusic();
                    }
                }
                if (this.mMapScreen != null) {
                    if (!this.mMapScreen.Finished()) {
                        this.mMapScreen.Draw(graphics, this.mFrameTime);
                    } else {
                        this.mMapScreen = null;
                        this.mTapPoint = null;
                        System.gc();
                    }
                }
                this.flushGraphics();
                this.mMillisAtLastFrame = this.mMillisAtCurrentFrame;
            }
        }
        catch (Throwable throwable) {
            Fieldrunners.error("FieldrunnersCanvas.run", throwable.toString());
            throwable.printStackTrace();
        }
    }

    public void startThemeMusic() {
    }

    public void stopThemeMusic() {
    }

    public void restart() {
        this.mRestart = true;
    }
}

