/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class LanscapeCanvas
extends Canvas {
    private Image landscape = null;
    private int[] rowData = null;
    private int[] rotatedData = null;
    private boolean mHardwareSupport = false;

    protected LanscapeCanvas(boolean bl, boolean bl2) {
        this.setMHardwareSupport(bl2);
        if (!this.isMHardwareSupport()) {
            this.landscape = Image.createImage((int)super.getHeight(), (int)super.getWidth());
            this.rowData = new int[this.landscape.getWidth()];
            this.rotatedData = new int[this.landscape.getWidth() * this.landscape.getHeight()];
        } else {
            this.landscape = Image.createImage((int)super.getWidth(), (int)super.getHeight());
        }
        this.setFullScreenMode(true);
    }

    protected void sizeChanged(int n, int n2) {
        if (!this.isMHardwareSupport()) {
            this.landscape = Image.createImage((int)n2, (int)n);
            this.rowData = new int[this.landscape.getWidth()];
            this.rotatedData = new int[this.landscape.getWidth() * this.landscape.getHeight()];
        } else {
            this.landscape = Image.createImage((int)n, (int)n2);
        }
        super.sizeChanged(n, n2);
    }

    public int getWidth() {
        return this.isMHardwareSupport() ? super.getWidth() : super.getHeight();
    }

    public int getHeight() {
        return this.isMHardwareSupport() ? super.getHeight() : super.getWidth();
    }

    public Graphics getGraphics() {
        return this.landscape.getGraphics();
    }

    public void flushGraphics(int n, int n2, int n3, int n4) {
        this.repaint(n, n2, n3, n4);
        this.serviceRepaints();
    }

    public void flushGraphics() {
        this.repaint();
        this.serviceRepaints();
    }

    public void paint(Graphics graphics) {
        if (this.landscape != null) {
            graphics.drawImage(this.landscape, 0, 0, 20);
        }
    }

    public Image RotatedImage() {
        int n = this.landscape.getWidth();
        int n2 = this.landscape.getHeight();
        int n3 = 0;
        for (int i = 0; i < n2; ++i) {
            this.landscape.getRGB(this.rowData, 0, n, 0, i, n, 1);
            for (int j = 0; j < n; ++j) {
                n3 = n2 - i - 1 + j * n2;
                this.rotatedData[n3] = this.rowData[j];
            }
        }
        return Image.createRGBImage((int[])this.rotatedData, (int)n2, (int)n, (boolean)true);
    }

    public void setMHardwareSupport(boolean bl) {
        this.mHardwareSupport = bl;
    }

    public boolean isMHardwareSupport() {
        return this.mHardwareSupport;
    }

    protected int translateKey(int n) {
        switch (n) {
            case 48: {
                return 1;
            }
            case 49: {
                return 2;
            }
            case 50: {
                return 4;
            }
            case 51: {
                return 8;
            }
            case 52: {
                return 16;
            }
            case 53: {
                return 32;
            }
            case 54: {
                return 64;
            }
            case 55: {
                return 128;
            }
            case 56: {
                return 256;
            }
            case 57: {
                return 512;
            }
            case 35: {
                return 2048;
            }
            case 42: {
                return 1024;
            }
            case -6: {
                return 0x200000;
            }
            case -7: {
                return 0x400000;
            }
            case -8: {
                return 32768;
            }
        }
        int n2 = this.getGameAction(n);
        switch (n2) {
            case 2: {
                return 262144;
            }
            case 5: {
                return 524288;
            }
            case 1: {
                return 65536;
            }
            case 6: {
                return 131072;
            }
            case 8: {
                return 0x100000;
            }
        }
        return 0;
    }

    protected void keyPressed(int n) {
        Key.eventKeyPressed(this.translateKey(n));
        this.pointerPressedLandscape(0, 0);
    }

    protected synchronized void keyReleased(int n) {
        Key.eventKeyReleased(this.translateKey(n));
        this.pointerReleasedLandscape(0, 0);
    }

    protected void pointerPressed(int n, int n2) {
        if (!this.isMHardwareSupport()) {
            int n3 = n2;
            int n4 = super.getWidth() - n;
            this.pointerPressedLandscape(n3, n4);
        } else {
            this.pointerPressedLandscape(n, n2);
        }
    }

    protected void pointerPressedLandscape(int n, int n2) {
    }

    protected void pointerDragged(int n, int n2) {
        if (!this.mHardwareSupport) {
            int n3 = n2;
            int n4 = super.getWidth() - n;
            this.pointerDraggedLandscape(n3, n4);
        } else {
            this.pointerDraggedLandscape(n, n2);
        }
    }

    protected void pointerDraggedLandscape(int n, int n2) {
    }

    protected void pointerReleased(int n, int n2) {
        if (!this.mHardwareSupport) {
            int n3 = n2;
            int n4 = super.getWidth() - n;
            this.pointerReleasedLandscape(n3, n4);
        } else {
            this.pointerReleasedLandscape(n, n2);
        }
    }

    protected void pointerReleasedLandscape(int n, int n2) {
    }
}

