/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MapSelectionForm
extends Form {
    int mDifficultyLevel;
    int mGameplayMode;
    Color mDisabledColor;
    Color mWhiteColor;
    Color mActiveColor;
    String mMapName;
    Button mEasyButton;
    Button mMediumButton;
    Button mHardButton;
    Button mStartButton;
    Button mClassicMode;
    Button mEndlessMode;
    Button mExtendedMode;
    Button mMap01;
    Button mMap02;
    Button mMap03;
    Overlay[] mMapThumbnails = new Overlay[3];
    Overlay mPadlockIcon;
    int mSelectedMapIndex = 0;
    int mSelectPhase = 0;
    int mSelectButtonPos = 0;
    String mSelectButtonName = "";
    boolean mFirstTimeInMapSelection = true;
    boolean mFirstTimeInDifficulty = true;
    boolean mDoneRender = true;
    boolean mIsMapPlayable = false;
    boolean mIsEndlessModeUnlocked = false;
    boolean mIsExtendedModeUnlocked = false;
    String mSelectTitle;
    int mTitlex = 45;
    int mTitley = 20;
    public int kSelectMapId = 0;
    public int kSelectDifficultyId = 1;
    public int kSelectGameModeId = 2;
    public int kSelectPos1 = 0;
    public int kSelectPos2 = 1;
    public int kSelectPos3 = 2;

    public MapSelectionForm() {
        this.mDisabledColor = new Color();
        this.mWhiteColor = new Color();
        this.mActiveColor = new Color();
        this.mMapName = Map.getOfficialMapNameForIndex(this.mSelectedMapIndex);
    }

    public void initFromFile(String string, MapScreen mapScreen, UserInterface userInterface, String string2) {
        try {
            super.initFromFile(string, mapScreen, userInterface, string2);
            for (int i = 0; i < 3; ++i) {
                this.mMapThumbnails[i] = null;
            }
            this.mPadlockIcon = null;
            if (this.mDisabledColor != null) {
                this.mDisabledColor.setR(128);
                this.mDisabledColor.setG(128);
                this.mDisabledColor.setB(128);
                this.mDisabledColor.setA(255);
            }
            if (this.mWhiteColor != null) {
                this.mWhiteColor.setR(255);
                this.mWhiteColor.setG(255);
                this.mWhiteColor.setB(255);
                this.mWhiteColor.setA(255);
            }
            if (this.mActiveColor != null) {
                this.mActiveColor.setR(255);
                this.mActiveColor.setG(255);
                this.mActiveColor.setB(26);
                this.mActiveColor.setA(255);
            }
            this.mSelectTitle = "CHOOSE MAP";
            this.mTitlex = 45;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public boolean isCombinationPlayableWithMapIndex(int n, int n2) {
        String string = Map.getOfficialMapNameForIndex(n);
        this.mIsMapPlayable = false;
        this.mIsMapPlayable = Settings.IsMapUnlocked(string);
        this.mIsEndlessModeUnlocked = false;
        this.mIsEndlessModeUnlocked = Settings.IsGameplayModeUnlocked(1, string);
        this.mIsExtendedModeUnlocked = false;
        this.mIsExtendedModeUnlocked = this.mIsEndlessModeUnlocked;
        boolean bl = false;
        if ((this.mSelectedMapIndex == 0 || this.mIsMapPlayable) && (n2 == 0 || n2 == 1 && this.mIsEndlessModeUnlocked || n2 == 2 && this.mIsExtendedModeUnlocked)) {
            bl = true;
        }
        return bl;
    }

    public void onFormOpen() {
        try {
            boolean bl;
            Object object;
            int n;
            this.mDifficultyLevel = Settings.GetDifficultyLevel();
            for (n = 0; n < this.mButtonList.size(); ++n) {
                object = (Button)this.mButtonList.elementAt(n);
                if (((Button)object).mName.compareTo("Easy") == 0) {
                    this.mEasyButton = object;
                    this.mEasyButton.mYOffset = -0.01f;
                    this.mEasyButton.mIsToggled = this.mDifficultyLevel == 0;
                    this.mEasyButton.mLabelText.mRed = 0;
                    this.mEasyButton.mLabelText.mGreen = 128;
                    this.mEasyButton.mLabelText.mBlue = 0;
                    continue;
                }
                if (((Button)object).mName.compareTo("Medium") == 0) {
                    this.mMediumButton = object;
                    this.mMediumButton.mYOffset = -0.01f;
                    this.mMediumButton.mIsToggled = this.mDifficultyLevel == 1;
                    this.mMediumButton.mLabelText.mRed = 255;
                    this.mMediumButton.mLabelText.mGreen = 255;
                    this.mMediumButton.mLabelText.mBlue = 26;
                    continue;
                }
                if (((Button)object).mName.compareTo("Hard") == 0) {
                    this.mHardButton = object;
                    this.mHardButton.mYOffset = -0.01f;
                    this.mHardButton.mIsToggled = this.mDifficultyLevel == 2;
                    this.mHardButton.mLabelText.mRed = 255;
                    this.mHardButton.mLabelText.mGreen = 0;
                    this.mHardButton.mLabelText.mBlue = 0;
                    continue;
                }
                if (((Button)object).mName.compareTo("Map01") == 0) {
                    this.mMap01 = object;
                    this.mMap01.mIsToggled = true;
                    this.mMap01.mLabelText.mRed = 255;
                    this.mMap01.mLabelText.mGreen = 255;
                    this.mMap01.mLabelText.mBlue = 26;
                    this.mMap01.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("Map02") == 0) {
                    this.mMap02 = object;
                    this.mMap02.mIsToggled = false;
                    this.mMap02.mLabelText.mRed = 128;
                    this.mMap02.mLabelText.mGreen = 128;
                    this.mMap02.mLabelText.mBlue = 128;
                    this.mMap02.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("Map03") == 0) {
                    this.mMap03 = object;
                    this.mMap03.mIsToggled = false;
                    this.mMap03.mLabelText.mRed = 128;
                    this.mMap03.mLabelText.mGreen = 128;
                    this.mMap03.mLabelText.mBlue = 128;
                    this.mMap03.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("ClassicMode") == 0) {
                    this.mClassicMode = object;
                    this.mClassicMode.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("ExtendedMode") == 0) {
                    this.mExtendedMode = object;
                    this.mExtendedMode.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("EndlessMode") == 0) {
                    this.mEndlessMode = object;
                    this.mEndlessMode.mYOffset = -0.01f;
                    continue;
                }
                if (((Button)object).mName.compareTo("Start") != 0) continue;
                this.mStartButton = object;
            }
            for (n = 0; n < this.mOverlayList.size(); ++n) {
                object = (Overlay)this.mOverlayList.elementAt(n);
                if (((Overlay)object).mName.compareTo("MapThumbnail01") == 0) {
                    this.mMapThumbnails[0] = object;
                    continue;
                }
                if (((Overlay)object).mName.compareTo("MapThumbnail02") == 0) {
                    this.mMapThumbnails[1] = object;
                    continue;
                }
                if (((Overlay)object).mName.compareTo("MapThumbnail03") == 0) {
                    this.mMapThumbnails[2] = object;
                    continue;
                }
                if (((Overlay)object).mName.compareTo("Padlock") != 0) continue;
                this.mPadlockIcon = object;
            }
            this.mSelectedMapIndex = 0;
            this.mGameplayMode = n = 0;
            switch (n) {
                case 0: {
                    this.mGameplayMode = 0;
                    break;
                }
                case 1: {
                    this.mGameplayMode = 1;
                    break;
                }
                case 2: {
                    this.mGameplayMode = 2;
                    break;
                }
            }
            if (this.mClassicMode != null) {
                boolean bl2 = this.mClassicMode.mIsToggled = n == 0;
            }
            if (this.mEndlessMode != null) {
                boolean bl3 = this.mEndlessMode.mIsToggled = n == 1;
            }
            if (this.mExtendedMode != null) {
                this.mExtendedMode.mIsToggled = n == 2;
            }
            this.refreshDisplayForMapWithIndex(this.mSelectedMapIndex);
            boolean bl4 = Settings.IsGameplayModeUnlocked(1, "grasslands");
            if (!bl4) {
                if (this.mEndlessMode != null) {
                    this.mEndlessMode.mLabelText.mRed = 124;
                    this.mEndlessMode.mLabelText.mGreen = 121;
                    this.mEndlessMode.mLabelText.mBlue = 118;
                }
            } else if (this.mEndlessMode != null) {
                this.mEndlessMode.mLabelText.mRed = 255;
                this.mEndlessMode.mLabelText.mGreen = 255;
                this.mEndlessMode.mLabelText.mBlue = 26;
            }
            if (!(bl = bl4)) {
                if (this.mExtendedMode != null) {
                    this.mExtendedMode.mLabelText.mRed = 124;
                    this.mExtendedMode.mLabelText.mGreen = 121;
                    this.mExtendedMode.mLabelText.mBlue = 118;
                }
            } else if (this.mExtendedMode != null) {
                this.mExtendedMode.mLabelText.mRed = 255;
                this.mExtendedMode.mLabelText.mGreen = 255;
                this.mExtendedMode.mLabelText.mBlue = 26;
            }
            if (this.mClassicMode != null) {
                this.mClassicMode.mLabelText.mRed = 255;
                this.mClassicMode.mLabelText.mGreen = 255;
                this.mClassicMode.mLabelText.mBlue = 0;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onButtonPressClassicMode(Button button, Point point) {
        this.mGameplayMode = 0;
        this.updateGameplayModeSelection();
    }

    public void onButtonPressEndlessMode(Button button, Point point) {
        this.mGameplayMode = 1;
        this.updateGameplayModeSelection();
    }

    public void onButtonPressExtendedMode(Button button, Point point) {
        this.mGameplayMode = 2;
        this.updateGameplayModeSelection();
    }

    public void onButtonPressEasy(Button button, Point point) {
        this.mDifficultyLevel = 0;
        this.updateDifficultyModeSelection();
    }

    public void onButtonPressMedium(Button button, Point point) {
        this.mDifficultyLevel = 1;
        this.updateDifficultyModeSelection();
    }

    public void onButtonPressHard(Button button, Point point) {
        this.mDifficultyLevel = 2;
        this.updateDifficultyModeSelection();
    }

    public void onButtonPressMap01(Button button, Point point) {
        this.mSelectedMapIndex = 0;
        this.updateMapSelection();
    }

    public void onButtonPressMap02(Button button, Point point) {
        this.mSelectedMapIndex = 1;
        this.updateMapSelection();
    }

    public void onButtonPressMap03(Button button, Point point) {
        this.mSelectedMapIndex = 2;
        this.updateMapSelection();
    }

    public void onButtonReleaseStart(Button button, Point point) {
        Object object;
        Fieldrunners.mCanvas.stopThemeMusic();
        if (this.mView.mMap != null) {
            this.mView.mMap = null;
            System.gc();
        }
        this.mView.mMap = new Map(this.mView, Fieldrunners.mCanvas.mApp);
        this.mView.mMap.mRestoringGameState = false;
        this.mView.mMap.mDifficultyLevel = this.mDifficultyLevel;
        this.mView.mMap.mGameplayMode = this.mGameplayMode;
        this.mView.mMap.mName = this.mMapName;
        this.mView.mMap.mFilename = this.mMapName;
        if (this.mGameplayMode != 0) {
            this.mView.mMap.mFilename = object = this.mMapName + "_extended";
        }
        try {
            object = (LoadingForm)this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kLoadingFormNameID);
            ((LoadingForm)object).onFormOpen();
            if (this.mView.mMap.mGameHudForm != null) {
                this.mView.mMap.mGameHudForm.mFirstTouch = true;
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void onButtonReleaseX(Button button, Point point) {
        try {
            Form form = this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kNewOrResumeGameFormNameID);
            if (form != null) {
                form.onFormOpen();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void refreshDisplayForMapWithIndex(int n) {
        boolean bl;
        String string = Map.getOfficialMapNameForIndex(n);
        boolean bl2 = Settings.IsGameplayModeUnlocked(1, string);
        if (!bl2) {
            if (this.mEndlessMode != null && this.mEndlessMode.mLabelText != null) {
                this.mEndlessMode.mLabelText.mRed = 124;
                this.mEndlessMode.mLabelText.mGreen = 121;
                this.mEndlessMode.mLabelText.mBlue = 118;
            }
        } else if (this.mEndlessMode != null && this.mEndlessMode.mLabelText != null) {
            this.mEndlessMode.mLabelText.mRed = 255;
            this.mEndlessMode.mLabelText.mGreen = 255;
            this.mEndlessMode.mLabelText.mBlue = 26;
        }
        if (!(bl = bl2)) {
            if (this.mExtendedMode != null && this.mExtendedMode.mLabelText != null) {
                this.mExtendedMode.mLabelText.mRed = 124;
                this.mExtendedMode.mLabelText.mGreen = 121;
                this.mExtendedMode.mLabelText.mBlue = 118;
            }
        } else if (this.mExtendedMode != null && this.mExtendedMode.mLabelText != null) {
            this.mExtendedMode.mLabelText.mRed = 255;
            this.mExtendedMode.mLabelText.mGreen = 255;
            this.mExtendedMode.mLabelText.mBlue = 26;
        }
        boolean bl3 = true;
        if (n == 0) {
            if (this.mMapThumbnails[0] != null) {
                this.mMapThumbnails[0].mColor = this.mWhiteColor;
            }
            if (this.mPadlockIcon != null) {
                this.mPadlockIcon.mIsHidden = true;
            }
        } else if (n > 0) {
            bl3 = Settings.IsMapUnlocked(string);
            if (!bl3) {
                this.mMapThumbnails[n].mColor = this.mDisabledColor;
                this.mPadlockIcon.mIsHidden = false;
            } else {
                if (this.mMapThumbnails[n] != null) {
                    this.mMapThumbnails[n].mColor = this.mWhiteColor;
                }
                if (this.mPadlockIcon != null) {
                    this.mPadlockIcon.mIsHidden = true;
                }
            }
        }
    }

    public void updateDifficultyModeSelection() {
        Settings.UpdateDifficultyLevel(this.mDifficultyLevel);
    }

    public void updateGameplayModeSelection() {
        boolean bl;
        this.mClassicMode.mLabelColor.setR(255);
        this.mClassicMode.mLabelColor.setB(255);
        this.mClassicMode.mLabelColor.setG(0);
        Settings.SetGameplayMode(this.mGameplayMode);
        boolean bl2 = this.isCombinationPlayableWithMapIndex(0, this.mGameplayMode);
        String string = Map.getOfficialMapNameForIndex(0);
        boolean bl3 = bl = Settings.IsGameplayModeUnlocked(1, string);
        if (this.mGameplayMode == 0 ? bl2 : this.mGameplayMode == 1 && bl || this.mGameplayMode != 2 || bl3) {
            // empty if block
        }
    }

    public void handleButtonPressAction(Button button, Point point) {
        if (button != null) {
            String string = button.mPressSelector;
            if (string.compareTo("onButtonPressEasy:withTouches:withEvent:") == 0) {
                this.onButtonPressEasy(button, point);
            } else if (string.compareTo("onButtonPressMedium:withTouches:withEvent:") == 0) {
                this.onButtonPressMedium(button, point);
            } else if (string.compareTo("onButtonPressHard:withTouches:withEvent:") == 0) {
                this.onButtonPressHard(button, point);
            } else if (string.compareTo("onButtonPressMap01:withTouches:withEvent:") == 0) {
                this.onButtonPressMap01(button, point);
            } else if (string.compareTo("onButtonPressMap02:withTouches:withEvent:") == 0) {
                this.onButtonPressMap02(button, point);
            } else if (string.compareTo("onButtonPressMap03:withTouches:withEvent:") == 0) {
                this.onButtonPressMap03(button, point);
            } else if (string.compareTo("onButtonPressClassicMode:withTouches:withEvent:") == 0) {
                this.onButtonPressClassicMode(button, point);
            } else if (string.compareTo("onButtonPressExtendedMode:withTouches:withEvent:") == 0) {
                this.onButtonPressExtendedMode(button, point);
            } else if (string.compareTo("onButtonPressEndlessMode:withTouches:withEvent:") == 0) {
                this.onButtonPressEndlessMode(button, point);
            }
        }
    }

    public void handleButtonReleaseAction(Button button, Point point) {
        if (button != null) {
            String string = button.mReleaseSelector;
            if (string.compareTo("onButtonReleaseStart:withTouches:withEvent:") == 0) {
                this.onButtonReleaseStart(button, point);
            } else if (string.compareTo("onButtonReleaseX:withTouches:withEvent:") == 0) {
                this.onButtonReleaseX(button, point);
            }
        }
    }

    public void touchStart(Point point) {
        block68: {
            try {
                CGPoint cGPoint = new CGPoint(point.x, point.y);
                this.mPressedButton = null;
                cGPoint.x /= (float)this.mView.width();
                cGPoint.y /= (float)this.mView.height();
                this.mActiveButton = null;
                if (Key.mPressed == 0x400000 || Key.mPressed == 0x100000) {
                    if (this.mSelectPhase == this.kSelectGameModeId && this.isCombinationPlayableWithMapIndex(this.mSelectedMapIndex, this.mGameplayMode)) {
                        for (int i = 0; i < this.mButtonList.size(); ++i) {
                            Button button = (Button)this.mButtonList.elementAt(i);
                            if (!button.mName.equals("Start")) continue;
                            this.updateMapSelection();
                            if (!button.mIsHidden) {
                                this.mPressedButton = button;
                                this.mActiveButton = button;
                                if (button.mPressSelector != null) {
                                    this.handleButtonPressAction(button, point);
                                    if (button.mIsToggleable) {
                                        button.mIsToggled = !button.mIsToggled;
                                    }
                                }
                                button.mState = tButtonState.kButtonState_Pressed;
                            }
                            break block68;
                        }
                        break block68;
                    }
                    if (this.mSelectPhase == this.kSelectDifficultyId) {
                        this.mSelectButtonName = "ClassicMode";
                        this.onButtonPressClassicMode(null, null);
                        this.mSelectPhase = this.kSelectGameModeId;
                        this.mSelectTitle = "GAME MODE";
                        this.mTitlex = 45;
                    } else if (this.mSelectPhase == this.kSelectMapId) {
                        if (this.mMapName.compareTo("grasslands") == 0) {
                            this.mIsMapPlayable = true;
                        } else {
                            this.mIsMapPlayable = false;
                            this.mIsMapPlayable = Settings.IsMapUnlocked(this.mMapName);
                        }
                        if (this.mIsMapPlayable) {
                            this.mSelectPhase = this.kSelectDifficultyId;
                            this.mSelectTitle = "DIFFICULTY";
                            this.mTitlex = 45;
                            try {
                                this.mTextureImage = null;
                                this.mTextureImage = this.mView.mBackground;
                            }
                            catch (Exception exception) {
                                exception.printStackTrace();
                            }
                        }
                    }
                    break block68;
                }
                if (Key.mPressed == 0x200000) {
                    if (this.mSelectPhase == this.kSelectGameModeId) {
                        this.mSelectPhase = this.kSelectDifficultyId;
                        this.mSelectTitle = "DIFFICULTY";
                        this.mTitlex = 45;
                        break block68;
                    }
                    if (this.mSelectPhase == this.kSelectDifficultyId) {
                        this.mSelectPhase = this.kSelectMapId;
                        this.mSelectTitle = "CHOOSE MAP";
                        this.mTitlex = 45;
                        try {
                            this.mTextureImage = null;
                            this.mTextureImage = Image.createImage((String)"/UserInterface/menu_map_bkgd.png");
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                        break block68;
                    }
                    for (int i = 0; i < this.mButtonList.size(); ++i) {
                        Button button = (Button)this.mButtonList.elementAt(i);
                        if (!button.mName.equals("X")) continue;
                        if (!button.mIsHidden && !button.mIsDisabled) {
                            this.mPressedButton = button;
                            this.mActiveButton = button;
                            if (button.mPressSelector != null) {
                                this.handleButtonPressAction(button, point);
                                if (button.mIsToggleable) {
                                    button.mIsToggled = !button.mIsToggled;
                                }
                            }
                            button.mState = tButtonState.kButtonState_Pressed;
                        }
                        break block68;
                    }
                    break block68;
                }
                if (Key.mPressed == 131072) {
                    this.mSelectButtonName = "";
                    if (this.mSelectButtonPos == this.kSelectPos1) {
                        this.mSelectButtonPos = this.kSelectPos2;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "ExtendedMode";
                            this.mClassicMode.mIsToggled = false;
                            this.mEndlessMode.mIsToggled = false;
                            this.mExtendedMode.mIsToggled = true;
                            this.onButtonPressExtendedMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Medium";
                            this.mEasyButton.mIsToggled = false;
                            this.mMediumButton.mIsToggled = true;
                            this.mHardButton.mIsToggled = false;
                            this.onButtonPressMedium(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map02";
                            this.mMap02.mIsToggled = true;
                            this.mMap01.mIsToggled = false;
                            this.mMap03.mIsToggled = false;
                            this.onButtonPressMap02(this.mActiveButton, point);
                        }
                    } else if (this.mSelectButtonPos == this.kSelectPos2) {
                        this.mSelectButtonPos = this.kSelectPos3;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "EndlessMode";
                            this.mClassicMode.mIsToggled = false;
                            this.mEndlessMode.mIsToggled = true;
                            this.mExtendedMode.mIsToggled = false;
                            this.onButtonPressEndlessMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Hard";
                            this.mHardButton.mIsToggled = true;
                            this.mMediumButton.mIsToggled = false;
                            this.mEasyButton.mIsToggled = false;
                            this.onButtonPressHard(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map03";
                            this.mMap02.mIsToggled = false;
                            this.mMap01.mIsToggled = false;
                            this.mMap03.mIsToggled = true;
                            this.onButtonPressMap03(this.mActiveButton, point);
                        }
                    } else if (this.mSelectButtonPos == this.kSelectPos3) {
                        this.mSelectButtonPos = this.kSelectPos1;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "ClassicMode";
                            this.mClassicMode.mIsToggled = true;
                            this.mEndlessMode.mIsToggled = false;
                            this.mExtendedMode.mIsToggled = false;
                            this.onButtonPressClassicMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Easy";
                            this.mEasyButton.mIsToggled = true;
                            this.mMediumButton.mIsToggled = false;
                            this.mHardButton.mIsToggled = false;
                            this.onButtonPressEasy(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map01";
                            this.mMap02.mIsToggled = false;
                            this.mMap01.mIsToggled = true;
                            this.mMap03.mIsToggled = false;
                            this.onButtonPressMap01(this.mActiveButton, point);
                        }
                    }
                } else if (Key.mPressed == 65536) {
                    if (this.mSelectButtonPos == this.kSelectPos1) {
                        this.mSelectButtonPos = this.kSelectPos3;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "EndlessMode";
                            this.mClassicMode.mIsToggled = false;
                            this.mEndlessMode.mIsToggled = true;
                            this.mExtendedMode.mIsToggled = false;
                            this.onButtonPressEndlessMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Hard";
                            this.mEasyButton.mIsToggled = false;
                            this.mMediumButton.mIsToggled = false;
                            this.mHardButton.mIsToggled = true;
                            this.onButtonPressHard(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map03";
                            this.mMap02.mIsToggled = false;
                            this.mMap01.mIsToggled = false;
                            this.mMap03.mIsToggled = true;
                            this.onButtonPressMap03(this.mActiveButton, point);
                        }
                    } else if (this.mSelectButtonPos == this.kSelectPos2) {
                        this.mSelectButtonPos = this.kSelectPos1;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "ClassicMode";
                            this.mClassicMode.mIsToggled = true;
                            this.mEndlessMode.mIsToggled = false;
                            this.mExtendedMode.mIsToggled = false;
                            this.onButtonPressClassicMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Easy";
                            this.mEasyButton.mIsToggled = true;
                            this.mMediumButton.mIsToggled = false;
                            this.mHardButton.mIsToggled = false;
                            this.onButtonPressEasy(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map01";
                            this.mMap02.mIsToggled = false;
                            this.mMap01.mIsToggled = true;
                            this.mMap03.mIsToggled = false;
                            this.onButtonPressMap01(this.mActiveButton, point);
                        }
                    } else if (this.mSelectButtonPos == this.kSelectPos3) {
                        this.mSelectButtonPos = this.kSelectPos2;
                        if (this.mSelectPhase == this.kSelectGameModeId) {
                            this.mSelectButtonName = "ExtendedMode";
                            this.mClassicMode.mIsToggled = false;
                            this.mEndlessMode.mIsToggled = false;
                            this.mExtendedMode.mIsToggled = true;
                            this.onButtonPressExtendedMode(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
                            this.mSelectButtonName = "Medium";
                            this.mEasyButton.mIsToggled = false;
                            this.mMediumButton.mIsToggled = true;
                            this.mHardButton.mIsToggled = false;
                            this.onButtonPressMedium(this.mActiveButton, point);
                        } else if (this.mSelectPhase == this.kSelectMapId) {
                            this.mSelectButtonName = "Map02";
                            this.mMap02.mIsToggled = true;
                            this.mMap01.mIsToggled = false;
                            this.mMap03.mIsToggled = false;
                            this.onButtonPressMap02(this.mActiveButton, point);
                        }
                    }
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }
    }

    public void touchEnd(Point point) {
        try {
            if (Key.mReleased == 0x200000 && this.mSelectPhase == this.kSelectMapId) {
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    if (!button.mName.equals("X") || button.mIsHidden || button.mIsDisabled || !(button.mTrackTimer >= 0.999f)) continue;
                    if (button.mReleaseSelector != null && button == this.mPressedButton) {
                        this.handleButtonReleaseAction(this.mActiveButton, point);
                        button.mState = tButtonState.kButtonState_Enabled;
                        if (!button.mIsToggleable) break;
                        button.mIsToggled = !button.mIsToggled;
                        break;
                    }
                    button.mState = tButtonState.kButtonState_Enabled;
                }
            } else if ((Key.mReleased == 0x400000 || Key.mReleased == 0x100000) && this.mSelectPhase == this.kSelectGameModeId && this.isCombinationPlayableWithMapIndex(this.mSelectedMapIndex, this.mGameplayMode)) {
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    if (!button.mName.equals("Start") || button.mIsHidden || button.mIsDisabled) continue;
                    if (button.mReleaseSelector != null && button == this.mPressedButton) {
                        this.handleButtonReleaseAction(this.mActiveButton, point);
                        button.mState = tButtonState.kButtonState_Enabled;
                        if (!button.mIsToggleable) break;
                        button.mIsToggled = !button.mIsToggled;
                        break;
                    }
                    button.mState = tButtonState.kButtonState_Enabled;
                }
            }
            this.mActiveButton = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void renderButtonsWithElapsedTime(Graphics graphics, float f) {
        if (this.mSelectPhase == this.kSelectGameModeId) {
            if (this.mClassicMode != null) {
                this.mClassicMode.renderWithElapsedTime(graphics, f);
            }
            if (this.mEndlessMode != null) {
                if (Settings.IsGameplayModeUnlocked(1, this.mMapName)) {
                    this.mEndlessMode.mLabelText.mRed = 255;
                    this.mEndlessMode.mLabelText.mGreen = 255;
                    this.mEndlessMode.mLabelText.mBlue = 26;
                }
                this.mEndlessMode.renderWithElapsedTime(graphics, f);
            }
            if (this.mExtendedMode != null) {
                if (Settings.IsGameplayModeUnlocked(2, this.mMapName)) {
                    this.mExtendedMode.mLabelText.mRed = 255;
                    this.mExtendedMode.mLabelText.mGreen = 255;
                    this.mExtendedMode.mLabelText.mBlue = 26;
                }
                this.mExtendedMode.renderWithElapsedTime(graphics, f);
            }
        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
            if (this.mEasyButton != null) {
                this.mEasyButton.renderWithElapsedTime(graphics, f);
            }
            if (this.mMediumButton != null) {
                this.mMediumButton.renderWithElapsedTime(graphics, f);
            }
            if (this.mHardButton != null) {
                this.mHardButton.renderWithElapsedTime(graphics, f);
            }
        } else if (this.mSelectPhase == this.kSelectMapId) {
            if (this.mMap01 != null) {
                this.mMap01.renderWithElapsedTime(graphics, f);
            }
            if (this.mMap02 != null) {
                if (Settings.IsMapUnlocked("crossroads")) {
                    this.mMap02.mLabelText.mRed = 255;
                    this.mMap02.mLabelText.mGreen = 255;
                    this.mMap02.mLabelText.mBlue = 26;
                }
                this.mMap02.renderWithElapsedTime(graphics, f);
            }
            if (this.mMap03 != null) {
                if (Settings.IsMapUnlocked("drylands")) {
                    this.mMap03.mLabelText.mRed = 255;
                    this.mMap03.mLabelText.mGreen = 255;
                    this.mMap03.mLabelText.mBlue = 26;
                }
                this.mMap03.renderWithElapsedTime(graphics, f);
            }
        }
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        if (this.mFormType != tFormType.kFormType_Overlay && this.mTextureImage != null) {
            graphics.setColor(0, 0, 0);
            graphics.setGrayScale(255);
            graphics.drawImage(this.mTextureImage, 0, 0, 0);
        }
        this.renderButtonsWithElapsedTime(graphics, f);
        if (this.mSelectPhase == this.kSelectMapId) {
            int n;
            Overlay overlay;
            if (this.mOverlayList.size() > 0 && (overlay = (Overlay)this.mOverlayList.elementAt(this.mSelectedMapIndex)) != null && !overlay.mIsHidden && overlay.mTextureImage != null) {
                n = (int)((float)Fieldrunners.mCanvas.getWidth() * overlay.mCenterX);
                int n2 = (int)((float)Fieldrunners.mCanvas.getHeight() * overlay.mCenterY);
                graphics.drawImage(overlay.mTextureImage, n, n2, 3);
            }
            if (this.mPadlockIcon != null && !this.mPadlockIcon.mIsHidden) {
                int n3 = (int)((float)Fieldrunners.mCanvas.getWidth() * this.mPadlockIcon.mCenterX);
                n = (int)((float)Fieldrunners.mCanvas.getHeight() * this.mPadlockIcon.mCenterY);
                graphics.drawImage(this.mPadlockIcon.mTextureImage, n3, n, 3);
            }
        }
        graphics.drawImage(this.mView.mSoftLeft, this.mView.mAtL.x, this.mView.mAtL.y, 3);
        if (this.isCombinationPlayableWithMapIndex(this.mSelectedMapIndex, this.mGameplayMode)) {
            graphics.drawImage(this.mView.mSoftRight, this.mView.mAtR.x, this.mView.mAtR.y, 3);
        }
        Map.mArtFont.DrawString(graphics, this.mSelectTitle, this.mTitlex, this.mTitley);
        this.mDoneRender = true;
    }

    public void updateMapSelection() {
        this.mMapName = Map.getOfficialMapNameForIndex(this.mSelectedMapIndex);
        this.refreshDisplayForMapWithIndex(this.mSelectedMapIndex);
        boolean bl = this.isCombinationPlayableWithMapIndex(this.mSelectedMapIndex, this.mGameplayMode);
        if (this.mStartButton != null) {
            this.mStartButton.mIsDisabled = !bl;
        }
    }

    public void updateWithElapsedTime(float f) {
        if (this.mSelectPhase == this.kSelectGameModeId) {
            if (this.mClassicMode != null) {
                this.mClassicMode.updateWithElapsedTime(f);
            }
            if (this.mEndlessMode != null) {
                this.mEndlessMode.updateWithElapsedTime(f);
            }
            if (this.mExtendedMode != null) {
                this.mExtendedMode.updateWithElapsedTime(f);
            }
        } else if (this.mSelectPhase == this.kSelectDifficultyId) {
            if (this.mFirstTimeInDifficulty) {
                this.mFirstTimeInDifficulty = false;
                this.mEasyButton.mIsToggled = this.mDifficultyLevel == 0;
                this.mMediumButton.mIsToggled = this.mDifficultyLevel == 1;
                this.mHardButton.mIsToggled = this.mDifficultyLevel == 2;
            }
            this.mEasyButton.updateWithElapsedTime(f);
            this.mMediumButton.updateWithElapsedTime(f);
            this.mHardButton.updateWithElapsedTime(f);
        } else if (this.mSelectPhase == this.kSelectMapId) {
            if (this.mMap01 != null) {
                this.mMap01.updateWithElapsedTime(f);
            }
            if (this.mMap02 != null) {
                this.mMap02.updateWithElapsedTime(f);
            }
            if (this.mMap03 != null) {
                this.mMap03.updateWithElapsedTime(f);
            }
        }
    }
}

