/*
 * Decompiled with CFR 0.152.
 */
import java.util.Vector;

public class PathFinder {
    PriorityQueue mOpenList;
    PathFinderNode[] mClosedList;
    PathFinderNode[] mPathFinderNodeArray;
    int mNumClosedNodes;
    int mTilesAcross;
    int mTilesDown;

    public void initWithTilesAcross(int n, int n2) {
        this.mTilesAcross = n;
        this.mTilesDown = n2;
        this.mPathFinderNodeArray = new PathFinderNode[this.mTilesAcross * this.mTilesDown];
        for (int i = 0; i < this.mTilesDown; ++i) {
            int n3 = 0;
            while (n3 < this.mTilesAcross) {
                PathFinderNode pathFinderNode;
                int n4 = this.getUniqueIDforTilePos(n3, i);
                this.mPathFinderNodeArray[n4] = pathFinderNode = new PathFinderNode();
                pathFinderNode.mTilePosX = n3++;
                pathFinderNode.mTilePosY = i;
                pathFinderNode.mUniqueID = n4;
                pathFinderNode.mConnectionNode = null;
                pathFinderNode.mGoalCost = 0;
                pathFinderNode.mFitnessCost = 0.0f;
                pathFinderNode.mCategory = 2;
            }
        }
        this.mOpenList = new PriorityQueue(this.mTilesAcross * this.mTilesDown);
        this.mClosedList = new PathFinderNode[this.mTilesAcross * this.mTilesDown];
        this.mNumClosedNodes = 0;
    }

    public Point findClosestGoalTileGridIndexFromTilePos(int n, int n2, Map map, Vector vector) {
        Point point = new Point();
        int n3 = Integer.MAX_VALUE;
        for (int i = 0; i < vector.size(); ++i) {
            Integer n4 = (Integer)vector.elementAt(i);
            int n5 = n4;
            Point point2 = map.getTilePosFromTileGridIndex(n5);
            int n6 = Math.abs(point2.x - n) + Math.abs(point2.y - n2);
            if (n6 >= n3) continue;
            n3 = n6;
            point.x = point2.x;
            point.y = point2.y;
        }
        return point;
    }

    public boolean findPathFromTilePos(int n, int n2, Entity[] entityArray, Vector vector, Map map, boolean bl, Vector vector2) {
        Object object;
        int n3;
        boolean bl2 = false;
        int n4 = this.getUniqueIDforTilePos(n, n2);
        Point point = this.findClosestGoalTileGridIndexFromTilePos(n, n2, map, vector2);
        PathFinderNode pathFinderNode = this.mPathFinderNodeArray[n4];
        pathFinderNode.mCategory = 0;
        int n5 = (point.x - n) * (point.x - n) + (point.y - n2) * (point.y - n2);
        this.mOpenList.insert(pathFinderNode);
        this.mNumClosedNodes = 0;
        while (this.mOpenList.size() > 0) {
            int n6;
            pathFinderNode = this.mOpenList.remove();
            for (n3 = 0; n3 < vector2.size(); ++n3) {
                object = (Integer)vector2.elementAt(n3);
                n6 = (Integer)object;
                if (pathFinderNode.mUniqueID != n6) continue;
                bl2 = true;
                break;
            }
            if (bl2) break;
            block8: for (int i = 0; i < 4; ++i) {
                int n7;
                n6 = pathFinderNode.mTilePosX;
                int n8 = pathFinderNode.mTilePosY;
                switch (i) {
                    case 0: {
                        if (n6 + 1 == this.mTilesAcross) continue block8;
                        n7 = this.getUniqueIDforTilePos(n6 + 1, n8);
                        break;
                    }
                    case 1: {
                        if (n6 == 0) continue block8;
                        n7 = this.getUniqueIDforTilePos(n6 - 1, n8);
                        break;
                    }
                    case 2: {
                        if (n8 == 0) continue block8;
                        n7 = this.getUniqueIDforTilePos(n6, n8 - 1);
                        break;
                    }
                    case 3: {
                        if (n8 + 1 == this.mTilesDown) continue block8;
                        n7 = this.getUniqueIDforTilePos(n6, n8 + 1);
                        break;
                    }
                    default: {
                        n7 = -1;
                    }
                }
                if (!bl && (n7 < 0 || n7 >= this.mTilesAcross * this.mTilesDown || entityArray[n7] != null)) continue;
                PathFinderNode pathFinderNode2 = this.mPathFinderNodeArray[n7];
                int n9 = pathFinderNode.mGoalCost + 1;
                if (pathFinderNode2.mCategory == 1 ? pathFinderNode2.mGoalCost <= n9 : pathFinderNode2.mCategory == 0 && pathFinderNode2.mGoalCost <= n9) continue;
                point = this.findClosestGoalTileGridIndexFromTilePos(pathFinderNode2.mTilePosX, pathFinderNode2.mTilePosY, map, vector2);
                int n10 = (point.x - pathFinderNode2.mTilePosX) * (point.x - pathFinderNode2.mTilePosX) + (point.y - pathFinderNode2.mTilePosY) * (point.y - pathFinderNode2.mTilePosY);
                pathFinderNode2.mConnectionNode = pathFinderNode;
                pathFinderNode2.mGoalCost = n9;
                int n11 = n9 + n10;
                if (pathFinderNode2.mCategory != 0) {
                    pathFinderNode2.mFitnessCost = n11;
                    pathFinderNode2.mCategory = 0;
                    this.mOpenList.insert(pathFinderNode2);
                    continue;
                }
                if (pathFinderNode2.mFitnessCost == (float)n11) continue;
                pathFinderNode2.mFitnessCost = n11;
            }
            pathFinderNode.mCategory = 1;
            this.mClosedList[this.mNumClosedNodes] = pathFinderNode;
            ++this.mNumClosedNodes;
        }
        this.mOpenList.removeAll();
        if (bl2) {
            while (true) {
                Point point2 = new Point();
                point2.x = pathFinderNode.mTilePosX;
                point2.y = pathFinderNode.mTilePosY;
                vector.addElement(point2);
                point2 = null;
                if (pathFinderNode.mUniqueID != n4 && pathFinderNode.mConnectionNode != null) {
                    pathFinderNode = pathFinderNode.mConnectionNode;
                    continue;
                }
                break;
            }
        } else {
            for (n3 = 0; n3 < this.mNumClosedNodes; ++n3) {
                object = new Point();
                ((Point)object).x = this.mClosedList[n3].mTilePosX;
                ((Point)object).y = this.mClosedList[n3].mTilePosY;
                vector.addElement(object);
                object = null;
            }
        }
        this.resetNodeArray();
        return bl2;
    }

    public int getUniqueIDforPathFinderNode(PathFinderNode pathFinderNode) {
        return this.mTilesAcross * pathFinderNode.mTilePosY + pathFinderNode.mTilePosX;
    }

    public int getUniqueIDforTilePos(int n, int n2) {
        return this.mTilesAcross * n2 + n;
    }

    public void resetNodeArray() {
        for (int i = 0; i < this.mTilesDown; ++i) {
            for (int j = 0; j < this.mTilesAcross; ++j) {
                int n = this.getUniqueIDforTilePos(j, i);
                PathFinderNode pathFinderNode = this.mPathFinderNodeArray[n];
                pathFinderNode.mConnectionNode = null;
                pathFinderNode.mGoalCost = 0;
                pathFinderNode.mFitnessCost = 0.0f;
                pathFinderNode.mCategory = 2;
            }
        }
    }

    private class PriorityQueue {
        private int maxSize;
        private PathFinderNode[] queArray;
        private int nItems;

        public PriorityQueue(int n) {
            this.maxSize = n;
            this.queArray = new PathFinderNode[this.maxSize];
            this.nItems = 0;
        }

        public void insert(PathFinderNode pathFinderNode) {
            if (this.nItems == 0) {
                this.queArray[this.nItems++] = pathFinderNode;
            } else {
                for (int i = this.nItems - 1; i >= 0 && pathFinderNode.compareTo(this.queArray[i]) > 0; --i) {
                    this.queArray[i + 1] = this.queArray[i];
                }
                this.queArray[i + 1] = pathFinderNode;
                ++this.nItems;
            }
        }

        public PathFinderNode remove() {
            return this.queArray[--this.nItems];
        }

        public int size() {
            return this.nItems;
        }

        public void removeAll() {
            this.nItems = 0;
        }
    }

    public class PathFinderNode
    implements QuickSorter.Comparable {
        int mCategory;
        PathFinderNode mConnectionNode;
        float mFitnessCost;
        int mTilePosX;
        int mTilePosY;
        int mUniqueID;
        int mGoalCost;

        public int compareTo(Object object) {
            PathFinderNode pathFinderNode = (PathFinderNode)object;
            return this.mFitnessCost < pathFinderNode.mFitnessCost ? -1 : 1;
        }
    }
}

