/*
 * Decompiled with CFR 0.152.
 */
import javax.microedition.lcdui.Graphics;

public class InGameOptionsForm
extends Form {
    tGameState mSavedGameState;
    String mTitle = "OPTIONS";
    int mTitlex = 65;
    int mSelectButtonPos = 0;
    public int kSelectHelpId = 0;
    public int kSelectAboutId = 1;
    public int kSelectSoundId = 2;

    public void handleButtonReleaseAction(Button button, Point point) {
        if (button != null) {
            String string = button.mReleaseSelector;
            if (string.compareTo("onButtonReleaseX:withTouches:withEvent:") == 0) {
                this.onButtonReleaseX(button, point);
            } else if (string.compareTo("onButtonPressHelp:withTouches:withEvent:") == 0) {
                this.onButtonReleaseHelp(button, point);
            } else if (string.compareTo("onButtonPressSound:withTouches:withEvent:") == 0) {
                this.onButtonReleaseSound(button, point);
            } else if (string.compareTo("onButtonPressAbout:withTouches:withEvent:") == 0) {
                this.onButtonReleaseAbout(button, point);
            }
        }
    }

    public void onButtonReleaseHelp(Button button, Point point) {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kHelpForm01NameID);
    }

    private void setSoundButtonText() {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName.compareTo("Sound") != 0) continue;
            button.mLabelText.mString = SoundPlayer.gSoundEnabled ? "Set Sound Off" : "Set Sound On";
        }
    }

    public void onButtonReleaseSound(Button button, Point point) {
        if (SoundPlayer.gSoundEnabled) {
            Can.SOUNDPLAYER.stop();
            SoundPlayer.gSoundEnabled = false;
            Settings.SetSoundSetting(2);
        } else {
            Settings.SetSoundSetting(1);
            SoundPlayer.gSoundEnabled = true;
            Can.SOUNDPLAYER.playLoop(SoundPlayer.SOUND_TITLE_THEME);
        }
    }

    public void onButtonReleaseAbout(Button button, Point point) {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kCreditsFormNameID);
    }

    public void onButtonReleaseX(Button button, Point point) {
        this.mUserInterface.switchToBackgroundFormWithName(UserInterface.kTitleScreenFormNameID);
    }

    public void onFormOpen() {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName.compareTo("Help") == 0) {
                button.mIsToggled = false;
                button.mLabelText.mRed = 255;
                button.mLabelText.mGreen = 255;
                button.mLabelText.mBlue = 26;
                button.mYOffset = -0.01f;
                continue;
            }
            if (button.mName.compareTo("About") == 0) {
                button.mIsToggled = false;
                button.mLabelText.mRed = 255;
                button.mLabelText.mGreen = 255;
                button.mLabelText.mBlue = 26;
                button.mYOffset = -0.01f;
                continue;
            }
            if (button.mName.compareTo("Sound") != 0) continue;
            button.mIsToggled = false;
            button.mLabelText.mRed = 255;
            button.mLabelText.mGreen = 255;
            button.mLabelText.mBlue = 26;
            button.mYOffset = -0.01f;
        }
    }

    private void fixButtons() {
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName.compareTo("Help") == 0) {
                button.mYOffset = -0.01f;
                continue;
            }
            if (button.mName.compareTo("About") == 0) {
                button.mYOffset = -0.01f;
                continue;
            }
            if (button.mName.compareTo("Sound") != 0) continue;
            button.mYOffset = -0.01f;
        }
    }

    public void renderWithElapsedTime(Graphics graphics, float f) {
        this.setSoundButtonText();
        this.fixButtons();
        super.renderWithElapsedTime(graphics, f);
        if (this.mView.mSoftLeft != null) {
            graphics.drawImage(this.mView.mSoftLeft, this.mView.mAtL.x, this.mView.mAtL.y, 3);
        }
        if (this.mView.mSoftRight != null) {
            graphics.drawImage(this.mView.mSoftRight, this.mView.mAtR.x, this.mView.mAtR.y, 3);
        }
        Map.mArtFont.DrawString(graphics, this.mTitle, this.mTitlex, 20);
    }

    public void touchStart(Point point) {
        try {
            CGPoint cGPoint = new CGPoint(point.x, point.y);
            this.mPressedButton = null;
            cGPoint.x /= (float)this.mView.width();
            cGPoint.y /= (float)this.mView.height();
            this.mActiveButton = null;
            if (Key.mPressed == 0x200000) {
                this.onButtonReleaseX(this.mActiveButton, point);
            } else if (Key.mPressed == 131072) {
                String string = "";
                if (this.mSelectButtonPos == this.kSelectHelpId) {
                    string = "Help";
                    this.mSelectButtonPos = this.kSelectAboutId;
                } else if (this.mSelectButtonPos == this.kSelectAboutId) {
                    string = "About";
                    this.mSelectButtonPos = this.kSelectSoundId;
                } else if (this.mSelectButtonPos == this.kSelectSoundId) {
                    string = "Sound On";
                    this.mSelectButtonPos = this.kSelectHelpId;
                }
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    button.mIsToggled = button.mName.compareTo(string) == 0;
                }
            } else if (Key.mPressed == 65536) {
                String string = "";
                if (this.mSelectButtonPos == this.kSelectHelpId) {
                    string = "Help";
                    this.mSelectButtonPos = this.kSelectSoundId;
                } else if (this.mSelectButtonPos == this.kSelectAboutId) {
                    string = "About";
                    this.mSelectButtonPos = this.kSelectHelpId;
                } else if (this.mSelectButtonPos == this.kSelectSoundId) {
                    string = "Sound On";
                    this.mSelectButtonPos = this.kSelectAboutId;
                }
                for (int i = 0; i < this.mButtonList.size(); ++i) {
                    Button button = (Button)this.mButtonList.elementAt(i);
                    button.mIsToggled = button.mName.compareTo(string) == 0;
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void touchEnd(Point point) {
        try {
            if (Key.mReleased == 0x400000 || Key.mReleased == 0x100000) {
                if (this.mSelectButtonPos == this.kSelectHelpId) {
                    this.onButtonReleaseHelp(this.mActiveButton, point);
                } else if (this.mSelectButtonPos == this.kSelectAboutId) {
                    this.onButtonReleaseAbout(this.mActiveButton, point);
                } else if (this.mSelectButtonPos == this.kSelectSoundId) {
                    this.onButtonReleaseSound(this.mActiveButton, point);
                }
            }
            this.mActiveButton = null;
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void updateWithElapsedTime(float f) {
        super.updateWithElapsedTime(f);
        for (int i = 0; i < this.mButtonList.size(); ++i) {
            Button button = (Button)this.mButtonList.elementAt(i);
            if (button.mName.compareTo("Help") == 0) {
                button.mIsToggled = this.mSelectButtonPos == this.kSelectHelpId;
                button.mLabelText.mRed = 255;
                button.mLabelText.mGreen = 255;
                button.mLabelText.mBlue = 26;
                continue;
            }
            if (button.mName.compareTo("About") == 0) {
                button.mIsToggled = this.mSelectButtonPos == this.kSelectAboutId;
                button.mLabelText.mRed = 255;
                button.mLabelText.mGreen = 255;
                button.mLabelText.mBlue = 26;
                continue;
            }
            if (button.mName.compareTo("Sound") != 0) continue;
            button.mIsToggled = this.mSelectButtonPos == this.kSelectSoundId;
            button.mLabelText.mRed = 255;
            button.mLabelText.mGreen = 255;
            button.mLabelText.mBlue = 26;
        }
    }
}

