/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;
import javax.microedition.media.control.VolumeControl;

public class SoundPlayer
implements PlayerListener {
    public static boolean gSoundEnabled = false;
    public static String soundExt;
    private static String soundType;
    private static String soundPath;
    private Player[] mPlayer;
    private static Player mCurrPlayer;
    private static Player mLastPlayer;
    private static Form mDeathPlayer;
    public static int mCurrPlayerID;
    private static int mLastPlayerID;
    private int mCurrentVolume = 75;
    public boolean mNeedSoundRestart = false;
    public int mNeedSoundRestartCount = 0;
    private boolean paused;
    private Object pauseLock = new Object();
    public static int SOUND_TITLE_THEME;
    public static int SOUND_GRASSLANDS;
    public static int SOUND_CROSSROADS;
    public static int SOUND_DRYLANDS;
    public static int NUMBER_OF_SOUNDS;

    public SoundPlayer() {
        this.mPlayer = this.loadSounds();
    }

    private Player[] loadSounds() {
        Player[] playerArray = new Player[NUMBER_OF_SOUNDS];
        try {
            playerArray[SoundPlayer.SOUND_TITLE_THEME] = this.preLoad("/Music/fieldrunners_theme.mid", "audio/mid");
            playerArray[SoundPlayer.SOUND_GRASSLANDS] = this.preLoad("/Music/grasslands.mid", "audio/mid");
            playerArray[SoundPlayer.SOUND_CROSSROADS] = this.preLoad("/Music/crossroads.mid", "audio/mid");
            playerArray[SoundPlayer.SOUND_DRYLANDS] = this.preLoad("/Music/drylands.mid", "audio/mid");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return playerArray;
    }

    private Player preLoad(String string, String string2) {
        Player player = null;
        try {
            InputStream inputStream = this.getClass().getResourceAsStream(string);
            if (inputStream == null) {
                return null;
            }
            player = Manager.createPlayer((InputStream)inputStream, (String)string2);
            player.realize();
            player.addPlayerListener((PlayerListener)this);
            player.prefetch();
        }
        catch (Exception exception) {
            System.out.println("** bad preload **");
        }
        return player;
    }

    public int playLoop(int n) {
        if (!gSoundEnabled) {
            return 0;
        }
        this.stop();
        try {
            this.mPlayer[n].setLoopCount(-1);
            this.mPlayer[n].setMediaTime(0L);
            this.mPlayer[n].start();
            VolumeControl volumeControl = (VolumeControl)this.mPlayer[n].getControl("VolumeControl");
            mCurrPlayer = this.mPlayer[n];
            mLastPlayerID = mCurrPlayerID = n;
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
        return 0;
    }

    public void restartLoop(int n) {
        mLastPlayerID = -1;
        try {
            this.playLoop(n);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void stop() {
        if (mCurrPlayerID != -1) {
            SoundPlayer.stop(mCurrPlayer);
        }
    }

    private static void stop(Player player) {
        if (player != null) {
            try {
                if (player.getState() == 400) {
                    player.stop();
                }
            }
            catch (MediaException mediaException) {
            }
            catch (Exception exception) {
                // empty catch block
            }
            mCurrPlayer = null;
        }
    }

    public void playerUpdate(Player player, String string, Object object) {
    }

    static {
        mCurrPlayer = null;
        mLastPlayer = null;
        mDeathPlayer = null;
        mCurrPlayerID = -1;
        mLastPlayerID = -1;
        SOUND_TITLE_THEME = 0;
        SOUND_GRASSLANDS = 1;
        SOUND_CROSSROADS = 2;
        SOUND_DRYLANDS = 3;
        NUMBER_OF_SOUNDS = SOUND_DRYLANDS + 1;
    }
}

