/*
 * Decompiled with CFR 0.152.
 */
public class Vector2f {
    public static Vector2f sOrientationAxis = null;
    float x;
    float y;

    public static Vector2f orientationAxis() {
        if (sOrientationAxis == null) {
            sOrientationAxis = new Vector2f();
            Vector2f.sOrientationAxis.x = 0.0f;
            Vector2f.sOrientationAxis.y = -1.0f;
        }
        return sOrientationAxis;
    }

    public Vector2f() {
        this.x = 0.0f;
        this.y = 0.0f;
    }

    public Vector2f(float f, float f2) {
        this.x = f;
        this.y = f2;
    }

    public Vector2f(Vector2f vector2f) {
        this.x = vector2f.x;
        this.y = vector2f.y;
    }

    public Vector2f initWithOrientationAxis() {
        Vector2f vector2f = Vector2f.orientationAxis();
        this.x = vector2f.x;
        this.y = vector2f.y;
        return this;
    }

    public void clampTo(float f, float f2) {
        float f3 = this.normalize();
        if (f3 > f2) {
            f3 = f2;
        }
        if (f3 < f) {
            f3 = f;
        }
        this.scaleBy(f3);
    }

    float computeDotProductWithVector(Vector2f vector2f) {
        return this.x * vector2f.x + this.y * vector2f.y;
    }

    float computeLength() {
        return (float)Math.sqrt(MathUtilities.SQUARE(this.x) + MathUtilities.SQUARE(this.y));
    }

    boolean isClockwiseToVector(Vector2f vector2f) {
        float f = this.x * vector2f.y - vector2f.x * this.y;
        return f < -0.001f;
    }

    boolean isCounterClockwiseToVector(Vector2f vector2f) {
        float f = this.x * vector2f.y - vector2f.x * this.y;
        return f > 0.001f;
    }

    boolean isNormalized() {
        return MathUtilities.IS_EQUAL(this.computeLength(), 1.0f);
    }

    float normalize() {
        float f = this.computeLength();
        if (MathUtilities.NOT_ZERO(f)) {
            float f2 = 1.0f / f;
            this.x *= f2;
            this.y *= f2;
        } else {
            this.x = 0.0f;
            this.y = 0.0f;
        }
        return f;
    }

    float computeAngleBetweenVector(Vector2f vector2f) {
        return (float)mMath.acos(this.computeDotProductWithVector(vector2f));
    }

    void scaleBy(float f) {
        this.x *= f;
        this.y *= f;
    }

    void rotateBY(float f) {
        if (MathUtilities.NOT_ZERO(f)) {
            float f2 = (float)Math.sin(f);
            float f3 = (float)Math.cos(f);
            float f4 = this.x;
            this.x = this.x * f3 - this.y * f2;
            this.y = this.y * f3 + f4 * f2;
        }
    }

    void serializeWithBinaryFile(GameState gameState) {
        this.x = gameState.SERIALIZE(this.x);
        this.y = gameState.SERIALIZE(this.y);
    }

    void setToOrientationAxis() {
        Vector2f vector2f = Vector2f.orientationAxis();
        this.x = vector2f.x;
        this.y = vector2f.y;
    }
}

