/*
 * Decompiled with CFR 0.152.
 */
package mw;

import mw.NokiaMain;
import mw.NokiaSketch;
import mw.Visualizer01;
import mw.util.ContactList;
import mw.util.FileIO;

public class ScreenSave
extends NokiaSketch {
    public ContactList contactList;
    String filename;
    String prefix = "NokiaBC-";
    String dummy;
    int imgID = -1;
    int saveCnt;
    boolean error = false;
    String errMsg = "";

    public ScreenSave(NokiaMain _p) {
        super(_p);
    }

    public void reinit() {
        this.img = this.p.imgScr;
        this.gr = this.img.getGraphics();
        this.drawBackgroundGradient();
        this.gr.drawImage(this.p.imgTitle, 26, 23, 20);
        this.fnt = this.p.uiFntSmallLight;
        this.saveCnt = 2;
        this.error = false;
    }

    public void draw() {
        this.px = 36;
        this.py = 86;
        this.p.canvas.bufferg.drawImage(this.img, 0, 0, 20);
        if (this.saveCnt == -1) {
            this.drawString("Saving failed.");
            this.drawString("Please allow the application to read user data.");
        } else if (this.saveCnt == 2) {
            this.drawString("The application is currently saving the image in");
            this.drawString("your Media Gallery.");
            this.getFilename();
        } else if (this.saveCnt == 1) {
            this.drawString("The application is currently saving the image in");
            this.drawString(" your Media Gallery. The filenames are:");
            this.drawString(" ");
            this.fnt = this.p.uiFntSmallDark;
            this.drawString(String.valueOf(this.prefix) + "Msg-" + this.filename);
            this.drawString(String.valueOf(this.prefix) + "Bg-" + this.filename);
            this.fnt = this.p.uiFntSmallLight;
            this.saveImage();
        } else {
            this.drawString("Two images were saved in your Media Gallery.");
            this.drawString("See ");
            this.py -= this.fnt.fontHeight;
            this.px = 36 + this.fnt.getWidth("See ");
            this.fnt = this.p.uiFntSmallDark;
            this.drawString("Menu > Media > Gallery > Images.");
            this.drawString(" ");
            this.px = 36;
            this.drawString(String.valueOf(this.prefix) + "Msg-" + this.filename);
            this.drawString(String.valueOf(this.prefix) + "Bg-" + this.filename);
            this.fnt = this.p.uiFntSmallLight;
        }
        if (this.error) {
            this.saveCnt = -1;
        }
        if (this.saveCnt > 0) {
            --this.saveCnt;
        }
        this.p.uiFntDark.draw("Saving Image", 220, 44);
        this.p.drawButtons(0);
    }

    public void getFilename() {
        int max = -1;
        if (this.imgID == -1) {
            try {
                FileIO.listDir(String.valueOf(this.prefix) + "*.png");
                this.dummy = "test ";
                if (FileIO.dir.length > 0) {
                    this.dummy = String.valueOf(this.dummy) + FileIO.dir[0];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            max = -1;
            if (FileIO.dir != null) {
                int i = 0;
                while (i < FileIO.dir.length) {
                    String tmp = FileIO.dir[i];
                    int pos = tmp.lastIndexOf(45) + 1;
                    int pos2 = tmp.indexOf(".png");
                    if (pos2 > pos) {
                        int curr;
                        try {
                            tmp = tmp.substring(pos, pos2);
                            curr = Integer.parseInt(tmp);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            curr = -1;
                        }
                        if (max < curr) {
                            max = curr;
                            this.dummy = String.valueOf(FileIO.dir[i]) + " -" + tmp + "-";
                        }
                    }
                    ++i;
                }
            }
            this.imgID = max + 1;
        } else {
            ++this.imgID;
        }
        this.filename = this.imgID < 10 ? "0" + this.imgID + ".png" : String.valueOf(this.imgID) + ".png";
    }

    public void saveImage() {
        Visualizer01 vis = (Visualizer01)this.p.scr[NokiaMain.VISUAL];
        try {
            FileIO.saveImage(String.valueOf(this.prefix) + "Bg-" + this.filename, vis.img);
            vis.drawFlatType();
            FileIO.saveImage(String.valueOf(this.prefix) + "Msg-" + this.filename, vis.img);
            this.log("Image saved successfully.");
        }
        catch (Exception e) {
            this.log("Image save failed..");
            this.error = true;
            this.errMsg = "saveImage() - " + e.toString();
            e.printStackTrace();
            this.log(e.toString());
        }
    }

    public void keyPressed(char key, int keyCode) {
        if (keyCode == -6) {
            this.p.setCurrent(NokiaMain.MENU);
        }
    }
}

