/*
 * Decompiled with CFR 0.152.
 */
package processing.core;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Form;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.TextBox;
import javax.microedition.midlet.MIDlet;
import javax.microedition.midlet.MIDletStateChangeException;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreNotFoundException;
import processing.core.PCanvas;
import processing.core.PClient;
import processing.core.PFont;
import processing.core.PImage;

public abstract class PMIDlet
extends MIDlet
implements Runnable,
CommandListener {
    public static final int CENTER = 0;
    public static final int CENTER_RADIUS = 1;
    public static final int CORNER = 2;
    public static final int CORNERS = 3;
    public static final int POINTS = 0;
    public static final int LINES = 1;
    public static final int LINE_STRIP = 2;
    public static final int LINE_LOOP = 3;
    public static final int TRIANGLES = 4;
    public static final int TRIANGLE_STRIP = 5;
    public static final int QUADS = 6;
    public static final int QUAD_STRIP = 7;
    public static final int POLYGON = 8;
    public static final int UP = 1;
    public static final int DOWN = 6;
    public static final int LEFT = 2;
    public static final int RIGHT = 5;
    public static final int FIRE = 8;
    public static final int GAME_A = 9;
    public static final int GAME_B = 10;
    public static final int GAME_C = 11;
    public static final int GAME_D = 12;
    public static final int SOFTKEY1 = -6;
    public static final int SOFTKEY2 = -7;
    public static final int SEND = -10;
    public static final String SOFTKEY1_NAME = "SOFT1";
    public static final String SOFTKEY2_NAME = "SOFT2";
    public static final String SEND_NAME = "SEND";
    public static final int FACE_SYSTEM = 0;
    public static final int FACE_MONOSPACE = 32;
    public static final int FACE_PROPORTIONAL = 64;
    public static final int STYLE_PLAIN = 0;
    public static final int STYLE_BOLD = 1;
    public static final int STYLE_ITALIC = 2;
    public static final int STYLE_UNDERLINED = 4;
    public static final int SIZE_SMALL = 8;
    public static final int SIZE_MEDIUM = 0;
    public static final int SIZE_LARGE = 16;
    public static final int RGB = 0;
    public static final int HSB = 1;
    protected boolean pointerPressed;
    protected int pointerX;
    protected int pointerY;
    protected char key;
    protected int keyCode;
    public int keyCodeOriginal;
    protected boolean keyPressed;
    public static final int MULTITAP_KEY_SPACE = 0;
    public static final int MULTITAP_KEY_UPPER = 1;
    public static final String MULTITAP_PUNCTUATION = ".,?!'\"-_:;/()@&#$%*+<=>^";
    protected boolean multitap;
    protected String multitapText;
    protected char[] multitapKeySettings;
    protected char[] multitapBuffer;
    protected int multitapBufferIndex;
    protected int multitapBufferLength;
    protected int multitapLastEdit;
    protected int multitapEditDuration;
    protected boolean multitapIsUpperCase;
    protected String multitapPunctuation;
    protected int framerate;
    protected int frameCount;
    public PCanvas canvas;
    public Command cmdExit;
    public Command cmdCustom;
    public Display display = Display.getDisplay((MIDlet)this);
    public int width;
    public int height;
    private Runtime runtime = Runtime.getRuntime();
    private Thread thread;
    private boolean running;
    private boolean redraw;
    private long startTime;
    private long lastFrameTime;
    private int msPerFrame;
    private Calendar calendar;
    private Random random;
    public static final byte EVENT_KEY_PRESSED = 1;
    public static final byte EVENT_KEY_RELEASED = 2;
    public static final byte EVENT_SOFTKEY_PRESSED = 3;
    public static final byte EVENT_LIBRARY = 4;
    public static final byte EVENT_POINTER_PRESSED = 5;
    public static final byte EVENT_POINTER_DRAGGED = 6;
    public static final byte EVENT_POINTER_RELEASED = 7;
    private byte[] events;
    private byte[] eventsClone;
    private int eventsLength;
    private int[] eventValues;
    private int[] eventValuesClone;
    private Object[] eventData;
    private Object[] eventDataClone;
    public static final int FP_PRECISION = 8;
    public static final int ONE = 256;
    public static final int PI = 804;
    public static final int TWO_PI = 1608;
    public static final int HALF_PI = 402;
    public static final int[] sin;
    private static int[] crc_table;

    static {
        int[] nArray = new int[360];
        nArray[1] = 4;
        nArray[2] = 8;
        nArray[3] = 13;
        nArray[4] = 17;
        nArray[5] = 22;
        nArray[6] = 26;
        nArray[7] = 31;
        nArray[8] = 35;
        nArray[9] = 40;
        nArray[10] = 44;
        nArray[11] = 48;
        nArray[12] = 53;
        nArray[13] = 57;
        nArray[14] = 61;
        nArray[15] = 66;
        nArray[16] = 70;
        nArray[17] = 74;
        nArray[18] = 79;
        nArray[19] = 83;
        nArray[20] = 87;
        nArray[21] = 91;
        nArray[22] = 95;
        nArray[23] = 100;
        nArray[24] = 104;
        nArray[25] = 108;
        nArray[26] = 112;
        nArray[27] = 116;
        nArray[28] = 120;
        nArray[29] = 124;
        nArray[30] = 128;
        nArray[31] = 131;
        nArray[32] = 135;
        nArray[33] = 139;
        nArray[34] = 143;
        nArray[35] = 146;
        nArray[36] = 150;
        nArray[37] = 154;
        nArray[38] = 157;
        nArray[39] = 161;
        nArray[40] = 164;
        nArray[41] = 167;
        nArray[42] = 171;
        nArray[43] = 174;
        nArray[44] = 177;
        nArray[45] = 181;
        nArray[46] = 184;
        nArray[47] = 187;
        nArray[48] = 190;
        nArray[49] = 193;
        nArray[50] = 196;
        nArray[51] = 198;
        nArray[52] = 201;
        nArray[53] = 204;
        nArray[54] = 207;
        nArray[55] = 209;
        nArray[56] = 212;
        nArray[57] = 214;
        nArray[58] = 217;
        nArray[59] = 219;
        nArray[60] = 221;
        nArray[61] = 223;
        nArray[62] = 226;
        nArray[63] = 228;
        nArray[64] = 230;
        nArray[65] = 232;
        nArray[66] = 233;
        nArray[67] = 235;
        nArray[68] = 237;
        nArray[69] = 238;
        nArray[70] = 240;
        nArray[71] = 242;
        nArray[72] = 243;
        nArray[73] = 244;
        nArray[74] = 246;
        nArray[75] = 247;
        nArray[76] = 248;
        nArray[77] = 249;
        nArray[78] = 250;
        nArray[79] = 251;
        nArray[80] = 252;
        nArray[81] = 252;
        nArray[82] = 253;
        nArray[83] = 254;
        nArray[84] = 254;
        nArray[85] = 255;
        nArray[86] = 255;
        nArray[87] = 255;
        nArray[88] = 255;
        nArray[89] = 255;
        nArray[90] = 256;
        nArray[91] = 255;
        nArray[92] = 255;
        nArray[93] = 255;
        nArray[94] = 255;
        nArray[95] = 255;
        nArray[96] = 254;
        nArray[97] = 254;
        nArray[98] = 253;
        nArray[99] = 252;
        nArray[100] = 252;
        nArray[101] = 251;
        nArray[102] = 250;
        nArray[103] = 249;
        nArray[104] = 248;
        nArray[105] = 247;
        nArray[106] = 246;
        nArray[107] = 244;
        nArray[108] = 243;
        nArray[109] = 242;
        nArray[110] = 240;
        nArray[111] = 238;
        nArray[112] = 237;
        nArray[113] = 235;
        nArray[114] = 233;
        nArray[115] = 232;
        nArray[116] = 230;
        nArray[117] = 228;
        nArray[118] = 226;
        nArray[119] = 223;
        nArray[120] = 221;
        nArray[121] = 219;
        nArray[122] = 217;
        nArray[123] = 214;
        nArray[124] = 212;
        nArray[125] = 209;
        nArray[126] = 207;
        nArray[127] = 204;
        nArray[128] = 201;
        nArray[129] = 198;
        nArray[130] = 196;
        nArray[131] = 193;
        nArray[132] = 190;
        nArray[133] = 187;
        nArray[134] = 184;
        nArray[135] = 181;
        nArray[136] = 177;
        nArray[137] = 174;
        nArray[138] = 171;
        nArray[139] = 167;
        nArray[140] = 164;
        nArray[141] = 161;
        nArray[142] = 157;
        nArray[143] = 154;
        nArray[144] = 150;
        nArray[145] = 146;
        nArray[146] = 143;
        nArray[147] = 139;
        nArray[148] = 135;
        nArray[149] = 131;
        nArray[150] = 128;
        nArray[151] = 124;
        nArray[152] = 120;
        nArray[153] = 116;
        nArray[154] = 112;
        nArray[155] = 108;
        nArray[156] = 104;
        nArray[157] = 100;
        nArray[158] = 95;
        nArray[159] = 91;
        nArray[160] = 87;
        nArray[161] = 83;
        nArray[162] = 79;
        nArray[163] = 74;
        nArray[164] = 70;
        nArray[165] = 66;
        nArray[166] = 61;
        nArray[167] = 57;
        nArray[168] = 53;
        nArray[169] = 48;
        nArray[170] = 44;
        nArray[171] = 40;
        nArray[172] = 35;
        nArray[173] = 31;
        nArray[174] = 26;
        nArray[175] = 22;
        nArray[176] = 17;
        nArray[177] = 13;
        nArray[178] = 8;
        nArray[179] = 4;
        nArray[181] = -4;
        nArray[182] = -8;
        nArray[183] = -13;
        nArray[184] = -17;
        nArray[185] = -22;
        nArray[186] = -26;
        nArray[187] = -31;
        nArray[188] = -35;
        nArray[189] = -40;
        nArray[190] = -44;
        nArray[191] = -48;
        nArray[192] = -53;
        nArray[193] = -57;
        nArray[194] = -61;
        nArray[195] = -66;
        nArray[196] = -70;
        nArray[197] = -74;
        nArray[198] = -79;
        nArray[199] = -83;
        nArray[200] = -87;
        nArray[201] = -91;
        nArray[202] = -95;
        nArray[203] = -100;
        nArray[204] = -104;
        nArray[205] = -108;
        nArray[206] = -112;
        nArray[207] = -116;
        nArray[208] = -120;
        nArray[209] = -124;
        nArray[210] = -128;
        nArray[211] = -131;
        nArray[212] = -135;
        nArray[213] = -139;
        nArray[214] = -143;
        nArray[215] = -146;
        nArray[216] = -150;
        nArray[217] = -154;
        nArray[218] = -157;
        nArray[219] = -161;
        nArray[220] = -164;
        nArray[221] = -167;
        nArray[222] = -171;
        nArray[223] = -174;
        nArray[224] = -177;
        nArray[225] = -181;
        nArray[226] = -184;
        nArray[227] = -187;
        nArray[228] = -190;
        nArray[229] = -193;
        nArray[230] = -196;
        nArray[231] = -198;
        nArray[232] = -201;
        nArray[233] = -204;
        nArray[234] = -207;
        nArray[235] = -209;
        nArray[236] = -212;
        nArray[237] = -214;
        nArray[238] = -217;
        nArray[239] = -219;
        nArray[240] = -221;
        nArray[241] = -223;
        nArray[242] = -226;
        nArray[243] = -228;
        nArray[244] = -230;
        nArray[245] = -232;
        nArray[246] = -233;
        nArray[247] = -235;
        nArray[248] = -237;
        nArray[249] = -238;
        nArray[250] = -240;
        nArray[251] = -242;
        nArray[252] = -243;
        nArray[253] = -244;
        nArray[254] = -246;
        nArray[255] = -247;
        nArray[256] = -248;
        nArray[257] = -249;
        nArray[258] = -250;
        nArray[259] = -251;
        nArray[260] = -252;
        nArray[261] = -252;
        nArray[262] = -253;
        nArray[263] = -254;
        nArray[264] = -254;
        nArray[265] = -255;
        nArray[266] = -255;
        nArray[267] = -255;
        nArray[268] = -255;
        nArray[269] = -255;
        nArray[270] = -256;
        nArray[271] = -255;
        nArray[272] = -255;
        nArray[273] = -255;
        nArray[274] = -255;
        nArray[275] = -255;
        nArray[276] = -254;
        nArray[277] = -254;
        nArray[278] = -253;
        nArray[279] = -252;
        nArray[280] = -252;
        nArray[281] = -251;
        nArray[282] = -250;
        nArray[283] = -249;
        nArray[284] = -248;
        nArray[285] = -247;
        nArray[286] = -246;
        nArray[287] = -244;
        nArray[288] = -243;
        nArray[289] = -242;
        nArray[290] = -240;
        nArray[291] = -238;
        nArray[292] = -237;
        nArray[293] = -235;
        nArray[294] = -233;
        nArray[295] = -232;
        nArray[296] = -230;
        nArray[297] = -228;
        nArray[298] = -226;
        nArray[299] = -223;
        nArray[300] = -221;
        nArray[301] = -219;
        nArray[302] = -217;
        nArray[303] = -214;
        nArray[304] = -212;
        nArray[305] = -209;
        nArray[306] = -207;
        nArray[307] = -204;
        nArray[308] = -201;
        nArray[309] = -198;
        nArray[310] = -196;
        nArray[311] = -193;
        nArray[312] = -190;
        nArray[313] = -187;
        nArray[314] = -184;
        nArray[315] = -181;
        nArray[316] = -177;
        nArray[317] = -174;
        nArray[318] = -171;
        nArray[319] = -167;
        nArray[320] = -164;
        nArray[321] = -161;
        nArray[322] = -157;
        nArray[323] = -154;
        nArray[324] = -150;
        nArray[325] = -146;
        nArray[326] = -143;
        nArray[327] = -139;
        nArray[328] = -135;
        nArray[329] = -131;
        nArray[330] = -128;
        nArray[331] = -124;
        nArray[332] = -120;
        nArray[333] = -116;
        nArray[334] = -112;
        nArray[335] = -108;
        nArray[336] = -104;
        nArray[337] = -100;
        nArray[338] = -95;
        nArray[339] = -91;
        nArray[340] = -87;
        nArray[341] = -83;
        nArray[342] = -79;
        nArray[343] = -74;
        nArray[344] = -70;
        nArray[345] = -66;
        nArray[346] = -61;
        nArray[347] = -57;
        nArray[348] = -53;
        nArray[349] = -48;
        nArray[350] = -44;
        nArray[351] = -40;
        nArray[352] = -35;
        nArray[353] = -31;
        nArray[354] = -26;
        nArray[355] = -22;
        nArray[356] = -17;
        nArray[357] = -13;
        nArray[358] = -8;
        nArray[359] = -4;
        sin = nArray;
    }

    public final Canvas getCanvas() {
        return this.canvas;
    }

    public final void commandAction(Command c, Displayable d) {
        if (c == this.cmdExit) {
            this.exit();
        } else if (c == this.cmdCustom) {
            this.enqueueEvent((byte)3, 0, this.cmdCustom.getLabel());
        }
    }

    public void softkeyPressed(String softkey) {
    }

    public final void softkey(String softkey) {
        if (this.cmdCustom != null) {
            this.canvas.removeCommand(this.cmdCustom);
        }
        if (softkey != null) {
            this.cmdCustom = new Command(softkey, 1, 2);
            this.canvas.addCommand(this.cmdCustom);
        }
    }

    public final void exit() {
        try {
            this.destroyApp(true);
            this.notifyDestroyed();
        }
        catch (MIDletStateChangeException mIDletStateChangeException) {
            // empty catch block
        }
    }

    protected final void destroyApp(boolean unconditional) throws MIDletStateChangeException {
        this.running = false;
        this.destroy();
    }

    protected final void pauseApp() {
        this.running = false;
    }

    protected final void startApp() throws MIDletStateChangeException {
        if (this.canvas == null) {
            this.cmdExit = new Command("Exit", 7, 1);
            this.canvas = new PCanvas(this);
            this.canvas.addCommand(this.cmdExit);
            this.canvas.setCommandListener(this);
            this.canvas.setFullScreenMode(true);
            this.width = this.canvas.getWidth();
            this.height = this.canvas.getHeight();
            this.startTime = System.currentTimeMillis();
            this.msPerFrame = 1;
            this.multitapBuffer = new char[64];
            this.multitapText = "";
            this.multitapKeySettings = new char[]{'#', '*'};
            this.multitapPunctuation = MULTITAP_PUNCTUATION;
            this.multitapEditDuration = 1000;
            this.events = new byte[8];
            this.eventsClone = new byte[8];
            this.eventValues = new int[8];
            this.eventValuesClone = new int[8];
            this.eventData = new Object[8];
            this.eventDataClone = new Object[8];
            this.running = true;
            this.setup();
            this.lastFrameTime = this.startTime - (long)this.msPerFrame;
        }
        this.redraw = true;
        this.display.setCurrent((Displayable)this.canvas);
        this.thread = new Thread(this);
        this.thread.start();
    }

    public final void run() {
        try {
            do {
                long currentTime = System.currentTimeMillis();
                int elapsed = Math.max(1, (int)(currentTime - this.lastFrameTime));
                this.dequeueEvents();
                if (this.redraw || this.running && elapsed >= this.msPerFrame) {
                    this.canvas.resetMatrix();
                    this.draw();
                    this.runtime.gc();
                    this.canvas.repaint();
                    this.canvas.serviceRepaints();
                    this.lastFrameTime = currentTime;
                    this.framerate = 1000 / elapsed;
                    ++this.frameCount;
                    this.redraw = false;
                }
                Thread.yield();
            } while (this.running || this.eventsLength > 0);
        }
        catch (Exception e) {
            Form form = new Form("Exception");
            form.append(e.getMessage());
            form.setCommandListener((CommandListener)this);
            form.addCommand(this.cmdExit);
            this.display.setCurrent((Displayable)form);
        }
        this.thread = null;
    }

    public void setup() {
    }

    public void destroy() {
    }

    public void draw() {
    }

    public void libraryEvent(Object library, int event, Object data) {
    }

    public final void enqueueLibraryEvent(Object library, int event, Object data) {
        this.enqueueEvent((byte)4, event, new Object[]{library, data});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void enqueueEvent(byte event, int value, Object data) {
        PMIDlet pMIDlet = this;
        synchronized (pMIDlet) {
            ++this.eventsLength;
            if (this.eventsLength > this.events.length) {
                byte[] oldEvents = this.events;
                int[] oldEventValues = this.eventValues;
                Object[] oldEventData = this.eventData;
                this.events = new byte[oldEvents.length * 2];
                this.eventValues = new int[this.events.length];
                this.eventData = new Object[this.events.length];
                System.arraycopy(oldEvents, 0, this.events, 0, this.eventsLength - 1);
                System.arraycopy(oldEventValues, 0, this.eventValues, 0, this.eventsLength - 1);
                System.arraycopy(oldEventData, 0, this.eventData, 0, this.eventsLength - 1);
            }
            this.events[this.eventsLength - 1] = event;
            this.eventValues[this.eventsLength - 1] = value;
            this.eventData[this.eventsLength - 1] = data;
        }
        if (this.thread == null) {
            this.thread = new Thread(this);
            this.thread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void dequeueEvents() {
        int length;
        PMIDlet pMIDlet = this;
        synchronized (pMIDlet) {
            length = this.eventsLength;
            this.eventsLength = 0;
            if (this.eventsClone.length < length) {
                this.eventsClone = new byte[this.events.length];
                this.eventValuesClone = new int[this.events.length];
                this.eventDataClone = new Object[this.events.length];
            }
            System.arraycopy(this.events, 0, this.eventsClone, 0, length);
            System.arraycopy(this.eventValues, 0, this.eventValuesClone, 0, length);
            System.arraycopy(this.eventData, 0, this.eventDataClone, 0, length);
            int i = length - 1;
            while (i >= 0) {
                this.eventData[i] = null;
                --i;
            }
        }
        int i = 0;
        while (i < length) {
            switch (this.eventsClone[i]) {
                case 1: {
                    this.keyPressed(this.eventValuesClone[i]);
                    break;
                }
                case 2: {
                    this.keyReleased(this.eventValuesClone[i]);
                    break;
                }
                case 3: {
                    this.softkeyPressed((String)this.eventDataClone[i]);
                    break;
                }
                case 4: {
                    Object[] objs = (Object[])this.eventDataClone[i];
                    this.libraryEvent(objs[0], this.eventValuesClone[i], objs[1]);
                    Object object = objs[0];
                    synchronized (object) {
                        objs[0].notifyAll();
                        break;
                    }
                }
                case 5: {
                    this.pointerPressed = true;
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerPressed();
                    break;
                }
                case 6: {
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerDragged();
                    break;
                }
                case 7: {
                    this.pointerPressed = false;
                    this.pointerX = this.eventValuesClone[i] >> 16;
                    this.pointerY = this.eventValuesClone[i] & 0xFFFF;
                    this.pointerReleased();
                }
            }
            this.eventDataClone[i] = null;
            ++i;
        }
    }

    private void key(int keyCode) {
        this.keyCodeOriginal = keyCode;
        if (keyCode >= 48 && keyCode <= 57) {
            this.key = (char)(48 + (keyCode - 48));
            this.keyCode = this.key;
        } else {
            switch (keyCode) {
                case 35: {
                    this.key = (char)35;
                    this.keyCode = this.key;
                    break;
                }
                case 42: {
                    this.key = (char)42;
                    this.keyCode = this.key;
                    break;
                }
                default: {
                    String name = this.canvas.getKeyName(keyCode);
                    if (name.equals(SOFTKEY1_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -6;
                        break;
                    }
                    if (name.equals(SOFTKEY2_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -7;
                        break;
                    }
                    if (name.equals(SEND_NAME)) {
                        this.key = (char)65535;
                        this.keyCode = -10;
                        break;
                    }
                    this.key = (char)65535;
                    this.keyCode = this.canvas.getGameAction(keyCode);
                    if (this.keyCode != 0) break;
                    this.keyCode = keyCode;
                }
            }
        }
    }

    private void keyPressed(int keyCode) {
        this.keyPressed = true;
        if (this.multitap) {
            this.multitapKeyPressed(keyCode);
        }
        this.key(keyCode);
        this.keyPressed();
    }

    private void keyReleased(int keyCode) {
        char oldKey = this.key;
        int oldKeyCode = this.keyCode;
        this.key(keyCode);
        if (this.key == oldKey && this.keyCode == oldKeyCode) {
            this.keyPressed = false;
        } else {
            this.key = oldKey;
            this.keyCode = oldKeyCode;
        }
        this.keyReleased();
    }

    public void keyPressed() {
    }

    public void keyReleased() {
    }

    public void pointerPressed() {
    }

    public void pointerDragged() {
    }

    public void pointerReleased() {
    }

    public final void redraw() {
        this.redraw = true;
    }

    public final void loop() {
        this.running = true;
    }

    public final void noLoop() {
        this.running = false;
    }

    public final void size(int width, int height) {
    }

    public final void framerate(int fps) {
        this.msPerFrame = 1000 / fps;
        if (this.msPerFrame <= 0) {
            this.msPerFrame = 1;
        }
    }

    public final String getProperty(String property) {
        return System.getProperty(property);
    }

    public final String textInput() {
        return this.textInput("Text Input", null, 256);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final String textInput(String title, String text, int max) {
        TextInputForm form = new TextInputForm(this, title, text, max, 0);
        PMIDlet pMIDlet = this;
        synchronized (pMIDlet) {
            this.display.setCurrent((Displayable)form);
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.display.setCurrent((Displayable)this.canvas);
        return form.getString();
    }

    public final void multitap() {
        this.multitap = true;
    }

    public final void noMultitap() {
        this.multitap = false;
    }

    public final void multitapClear() {
        this.multitapBufferIndex = 0;
        this.multitapBufferLength = 0;
        this.multitapText = "";
    }

    public final void multitapDeleteChar() {
        if (this.multitapBufferIndex > 0) {
            System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex - 1, this.multitapBufferLength - this.multitapBufferIndex);
            --this.multitapBufferLength;
            --this.multitapBufferIndex;
            this.multitapLastEdit = 0;
        }
        this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
    }

    private char multitapUpperKeyPressed(boolean editing, char newChar) {
        boolean bl = this.multitapIsUpperCase = !this.multitapIsUpperCase;
        if (editing) {
            if (newChar == this.multitapKeySettings[1]) {
                this.multitapDeleteChar();
                this.multitapLastEdit = this.millis();
                newChar = '\u0000';
            } else {
                newChar = this.multitapKeySettings[1];
            }
        } else {
            this.multitapLastEdit = this.millis();
        }
        return newChar;
    }

    protected final void multitapKeyPressed(int keyCode) {
        boolean editing = keyCode == this.keyCode && this.millis() - this.multitapLastEdit <= this.multitapEditDuration;
        char newChar = '\u0000';
        if (editing && Character.isUpperCase(newChar = this.multitapBuffer[this.multitapBufferIndex - 1])) {
            newChar = Character.toLowerCase(newChar);
        }
        char startChar = '\u0000';
        char endChar = '\u0000';
        char otherChar = '\u0000';
        block0 : switch (keyCode) {
            case -8: {
                this.multitapDeleteChar();
                break;
            }
            case 42: {
                if (this.multitapKeySettings[0] == '*') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '*';
                    break;
                }
                if (this.multitapKeySettings[1] == '*') {
                    editing = (newChar = this.multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '*';
                endChar = '*';
                otherChar = '*';
                editing = false;
                break;
            }
            case 35: {
                if (this.multitapKeySettings[0] == '#') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '#';
                    break;
                }
                if (this.multitapKeySettings[1] == '#') {
                    editing = (newChar = this.multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '#';
                endChar = '#';
                otherChar = '#';
                editing = false;
                break;
            }
            case 48: {
                if (this.multitapKeySettings[0] == '0') {
                    startChar = ' ';
                    endChar = ' ';
                    otherChar = '0';
                    break;
                }
                if (this.multitapKeySettings[1] == '0') {
                    editing = (newChar = this.multitapUpperKeyPressed(editing, newChar)) == '\u0000';
                    break;
                }
                startChar = '0';
                endChar = '0';
                otherChar = '0';
                editing = false;
                break;
            }
            case 49: {
                int index = 0;
                if (editing && (index = this.multitapPunctuation.indexOf(newChar) + 1) == this.multitapPunctuation.length()) {
                    index = 0;
                }
                newChar = this.multitapPunctuation.charAt(index);
                break;
            }
            case 50: {
                startChar = 'a';
                endChar = 'c';
                otherChar = '2';
                break;
            }
            case 51: {
                startChar = 'd';
                endChar = 'f';
                otherChar = '3';
                break;
            }
            case 52: {
                startChar = 'g';
                endChar = 'i';
                otherChar = '4';
                break;
            }
            case 53: {
                startChar = 'j';
                endChar = 'l';
                otherChar = '5';
                break;
            }
            case 54: {
                startChar = 'm';
                endChar = 'o';
                otherChar = '6';
                break;
            }
            case 55: {
                startChar = 'p';
                endChar = 's';
                otherChar = '7';
                break;
            }
            case 56: {
                startChar = 't';
                endChar = 'v';
                otherChar = '8';
                break;
            }
            case 57: {
                startChar = 'w';
                endChar = 'z';
                otherChar = '9';
                break;
            }
            default: {
                int action = this.canvas.getGameAction(keyCode);
                switch (action) {
                    case 2: {
                        this.multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.max(0, this.multitapBufferIndex - 1);
                        break block0;
                    }
                    case 5: {
                        this.multitapLastEdit = 0;
                        this.multitapBufferIndex = Math.min(this.multitapBufferLength, this.multitapBufferIndex + 1);
                    }
                }
            }
        }
        if (startChar > '\u0000') {
            newChar = editing ? (char)((char)(newChar + 1)) : startChar;
            if (newChar == otherChar + 1) {
                newChar = startChar;
            } else if (newChar > endChar) {
                newChar = otherChar;
            }
        }
        if (newChar > '\u0000') {
            if (this.multitapIsUpperCase) {
                newChar = Character.toUpperCase(newChar);
            }
            if (editing) {
                if (this.multitapBuffer[this.multitapBufferIndex - 1] != newChar) {
                    this.multitapBuffer[this.multitapBufferIndex - 1] = newChar;
                    this.multitapLastEdit = this.millis();
                }
            } else {
                ++this.multitapBufferLength;
                if (this.multitapBufferLength == this.multitapBuffer.length) {
                    char[] oldBuffer = this.multitapBuffer;
                    this.multitapBuffer = new char[oldBuffer.length * 2];
                    System.arraycopy(oldBuffer, 0, this.multitapBuffer, 0, this.multitapBufferIndex);
                    System.arraycopy(oldBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                } else {
                    System.arraycopy(this.multitapBuffer, this.multitapBufferIndex, this.multitapBuffer, this.multitapBufferIndex + 1, this.multitapBufferLength - this.multitapBufferIndex);
                }
                this.multitapBuffer[this.multitapBufferIndex] = newChar;
                ++this.multitapBufferIndex;
                this.multitapLastEdit = this.millis();
            }
            this.multitapText = new String(this.multitapBuffer, 0, this.multitapBufferLength);
        }
    }

    public final int freeMemory() {
        return (int)this.runtime.freeMemory();
    }

    public final int totalMemory() {
        return (int)this.runtime.totalMemory();
    }

    public final boolean isColor() {
        return this.display.isColor();
    }

    public final int numColors() {
        return this.display.numColors();
    }

    public final void point(int x1, int y1) {
        this.canvas.point(x1, y1);
    }

    public final void line(int x1, int y1, int x2, int y2) {
        this.canvas.line(x1, y1, x2, y2);
    }

    public final void triangle(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.canvas.triangle(x1, y1, x2, y2, x3, y3);
    }

    public final void quad(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.canvas.quad(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public final void rect(int x, int y, int width, int height) {
        this.canvas.rect(x, y, width, height);
    }

    public final void rectMode(int MODE) {
        this.canvas.rectMode(MODE);
    }

    public final void ellipse(int x, int y, int width, int height) {
        this.canvas.ellipse(x, y, width, height);
    }

    public final void ellipseMode(int MODE) {
        this.canvas.ellipseMode(MODE);
    }

    public final void curve(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.canvas.curve(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public final void bezier(int x1, int y1, int x2, int y2, int x3, int y3, int x4, int y4) {
        this.canvas.bezier(x1, y1, x2, y2, x3, y3, x4, y4);
    }

    public final void strokeWeight(int width) {
        this.canvas.strokeWeight(width);
    }

    public final void beginShape(int MODE) {
        this.canvas.beginShape(MODE);
    }

    public final void endShape() {
        this.canvas.endShape();
    }

    public final void vertex(int x, int y) {
        this.canvas.vertex(x, y);
    }

    public final void curveVertex(int x, int y) {
        this.canvas.curveVertex(x, y);
    }

    public final void bezierVertex(int x1, int y1, int x2, int y2, int x3, int y3) {
        this.canvas.bezierVertex(x1, y1, x2, y2, x3, y3);
    }

    public final void translate(int x, int y) {
        this.canvas.translate(x, y);
    }

    public final void pushMatrix() {
        this.canvas.pushMatrix();
    }

    public final void popMatrix() {
        this.canvas.popMatrix();
    }

    public final void resetMatrix() {
        this.canvas.resetMatrix();
    }

    public final void background(int gray) {
        this.canvas.background(gray);
    }

    public final void background(int value1, int value2, int value3) {
        this.canvas.background(value1, value2, value3);
    }

    public void background(PImage img) {
        this.canvas.background(img);
    }

    public final void colorMode(int mode) {
        this.canvas.colorMode(mode);
    }

    public final void colorMode(int mode, int range) {
        this.colorMode(mode, range, range, range);
    }

    public final void colorMode(int mode, int range1, int range2, int range3) {
        this.canvas.colorMode(mode, range1, range2, range3);
    }

    public final void colorMode(int mode, int range1, int range2, int range3, int range4) {
        this.canvas.colorMode(mode, range1, range2, range3, range4);
    }

    public final int color(int gray) {
        return this.canvas.color(gray);
    }

    public final int color(int gray, int alpha) {
        return this.canvas.color(gray, alpha);
    }

    public final int color(int value1, int value2, int value3) {
        return this.canvas.color(value1, value2, value3);
    }

    public final int color(int value1, int value2, int value3, int alpha) {
        return this.canvas.color(value1, value2, value3, alpha);
    }

    public final void stroke(int gray) {
        this.canvas.stroke(gray);
    }

    public final void stroke(int value1, int value2, int value3) {
        this.canvas.stroke(value1, value2, value3);
    }

    public final void noStroke() {
        this.canvas.noStroke();
    }

    public final void fill(int gray) {
        this.canvas.fill(gray);
    }

    public final void fill(int value1, int value2, int value3) {
        this.canvas.fill(value1, value2, value3);
    }

    public final void noFill() {
        this.canvas.noFill();
    }

    public final PImage loadImage(String filename) {
        try {
            if (filename.startsWith("http")) {
                PClient client = new PClient();
                client.GET_URL(filename);
                byte[] data = client.readBytes();
                return new PImage(data);
            }
            System.out.println("/" + filename);
            Image peer = Image.createImage((String)("/" + filename));
            return new PImage(peer);
        }
        catch (Exception e) {
            throw new RuntimeException(String.valueOf(filename) + " " + e.getMessage());
        }
    }

    public final PImage loadImage(byte[] data) {
        return new PImage(data);
    }

    public final void image(PImage img, int x, int y) {
        this.canvas.image(img, x, y);
    }

    public final void image(PImage img, int sx, int sy, int swidth, int sheight, int dx, int dy) {
        this.canvas.image(img, sx, sy, swidth, sheight, dx, dy);
    }

    public final void imageMode(int mode) {
        this.canvas.imageMode(mode);
    }

    public final PFont loadFont(String fontname, int color, int bgcolor) {
        try {
            return new PFont(this.getClass().getResourceAsStream("/" + fontname), color, bgcolor);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final PFont loadFont(String fontname, int color) {
        return this.loadFont(fontname, color, 0xFFFFFF);
    }

    public final PFont loadFont(String fontname) {
        return this.loadFont(fontname, 0);
    }

    public final PFont loadFont() {
        return new PFont(Font.getDefaultFont());
    }

    public final PFont loadFont(int face, int style, int size) {
        return new PFont(Font.getFont((int)face, (int)style, (int)size));
    }

    public final void textFont(PFont font) {
        this.canvas.textFont(font);
    }

    public final void textAlign(int MODE) {
        this.canvas.textAlign(MODE);
    }

    public final void text(String data, int x, int y) {
        this.canvas.text(data, x, y);
    }

    public final int textWidth(String data) {
        return this.canvas.textWidth(data);
    }

    public final int millis() {
        return (int)(System.currentTimeMillis() - this.startTime);
    }

    private void checkCalendar() {
        if (this.calendar == null) {
            this.calendar = Calendar.getInstance();
        }
        this.calendar.setTime(new Date());
    }

    public final int second() {
        this.checkCalendar();
        return this.calendar.get(13);
    }

    public final int minute() {
        this.checkCalendar();
        return this.calendar.get(12);
    }

    public final int hour() {
        this.checkCalendar();
        return this.calendar.get(10);
    }

    public final int day() {
        this.checkCalendar();
        return this.calendar.get(5);
    }

    public final int month() {
        this.checkCalendar();
        return this.calendar.get(2);
    }

    public final int year() {
        this.checkCalendar();
        return this.calendar.get(1);
    }

    public final int abs(int value) {
        return Math.abs(value);
    }

    public final int max(int value1, int value2) {
        return Math.max(value1, value2);
    }

    public final int min(int value1, int value2) {
        return Math.min(value1, value2);
    }

    public final int sq(int value) {
        return value * value;
    }

    public final int pow(int base, int exponent) {
        int value = 1;
        int i = 0;
        while (i < exponent) {
            value *= base;
            ++i;
        }
        return value;
    }

    public final int constrain(int value, int min, int max) {
        return Math.min(Math.max(value, min), max);
    }

    public final int random(int value1) {
        return this.random(0, value1);
    }

    public final int random(int value1, int value2) {
        if (this.random == null) {
            this.random = new Random();
        }
        int min = Math.min(value1, value2);
        int range = Math.abs(value2 - value1) + 1;
        return min + Math.abs(this.random.nextInt() % range);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final byte[] loadBytes(String filename) {
        try {
            RecordStore store = null;
            try {
                String name = filename;
                if (name.length() > 32) {
                    name = name.substring(0, 32);
                }
                store = RecordStore.openRecordStore((String)name, (boolean)false);
                byte[] byArray = store.getRecord(1);
                return byArray;
            }
            catch (RecordStoreNotFoundException name) {
            }
            finally {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        InputStream is = null;
        try {
            is = this.getClass().getResourceAsStream(filename);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            int bytesRead = is.read(buffer);
            while (true) {
                if (bytesRead < 0) {
                    byte[] byArray = baos.toByteArray();
                    return byArray;
                }
                baos.write(buffer, 0, bytesRead);
                bytesRead = is.read(buffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException(e.getMessage());
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final String[] loadStrings(String filename) {
        try {
            RecordStore store = null;
            try {
                String name = filename;
                if (name.length() > 32) {
                    name = name.substring(0, 32);
                }
                store = RecordStore.openRecordStore((String)name, (boolean)false);
                int numRecords = store.getNumRecords();
                String[] strings = new String[numRecords];
                int i = 0;
                while (true) {
                    if (i >= numRecords) {
                        String[] stringArray = strings;
                        return stringArray;
                    }
                    strings[i] = new String(store.getRecord(i + 1));
                    ++i;
                }
            }
            catch (RecordStoreNotFoundException name) {
            }
            finally {
                if (store != null) {
                    store.closeRecordStore();
                }
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
        Vector<String> v = new Vector<String>();
        InputStream is = null;
        try {
            try {
                is = this.getClass().getResourceAsStream(filename);
                InputStreamReader r = new InputStreamReader(is);
                int numStrings = 0;
                StringBuffer buffer = new StringBuffer();
                int input = ((Reader)r).read();
                while (true) {
                    if (input < 0 || input == 10) {
                        String s = buffer.toString().trim();
                        if (s.length() > 0) {
                            ++numStrings;
                            v.addElement(s);
                        }
                        buffer.delete(0, Integer.MAX_VALUE);
                        if (input < 0) {
                            break;
                        }
                    } else {
                        buffer.append((char)input);
                    }
                    input = ((Reader)r).read();
                }
            }
            catch (Exception e) {
                throw new RuntimeException(e.getMessage());
            }
        }
        finally {
            if (is != null) {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        Object[] strings = new String[v.size()];
        v.copyInto(strings);
        return strings;
    }

    public final void saveBytes(String filename, byte[] data) {
        if (filename.length() > 32) {
            throw new RuntimeException("filename must be 32 characters or less");
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)filename);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            RecordStore store = RecordStore.openRecordStore((String)filename, (boolean)true);
            store.addRecord(data, 0, data.length);
            store.closeRecordStore();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void saveStrings(String filename, String[] strings) {
        if (filename.length() > 32) {
            throw new RuntimeException("filename must be 32 characters or less");
        }
        try {
            try {
                RecordStore.deleteRecordStore((String)filename);
            }
            catch (RecordStoreNotFoundException recordStoreNotFoundException) {
                // empty catch block
            }
            RecordStore store = RecordStore.openRecordStore((String)filename, (boolean)true);
            int i = 0;
            int length = strings.length;
            while (i < length) {
                byte[] data = strings[i].getBytes();
                store.addRecord(data, 0, data.length);
                ++i;
            }
            store.closeRecordStore();
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public final void print(boolean data) {
        System.out.print(String.valueOf(data));
    }

    public final void print(byte data) {
        System.out.print(String.valueOf(data));
    }

    public final void print(char data) {
        System.out.print(String.valueOf(data));
    }

    public final void print(int data) {
        System.out.print(String.valueOf(data));
    }

    public final void print(Object data) {
        System.out.print(String.valueOf(data));
    }

    public final void print(String data) {
        System.out.print(data);
    }

    public final void println(boolean data) {
        System.out.println(String.valueOf(data));
    }

    public final void println(byte data) {
        System.out.println(String.valueOf(data));
    }

    public final void println(char data) {
        System.out.println(String.valueOf(data));
    }

    public final void println(int data) {
        System.out.println(String.valueOf(data));
    }

    public final void println(Object data) {
        System.out.println(String.valueOf(data));
    }

    public final void println(String data) {
        System.out.println(data);
    }

    public final String join(String[] anyArray, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = anyArray.length;
        while (i < length) {
            buffer.append(anyArray[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public final String join(int[] anyArray, String separator) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = anyArray.length;
        while (i < length) {
            buffer.append(anyArray[i]);
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public final String join(int[] intArray, String separator, int digits) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = intArray.length;
        while (i < length) {
            buffer.append(this.nf(intArray[i], digits));
            if (i < length - 1) {
                buffer.append(separator);
            }
            ++i;
        }
        return buffer.toString();
    }

    public final String nf(int intValue, int digits) {
        StringBuffer buffer = new StringBuffer();
        int j = Integer.toString(intValue).length();
        while (j < digits) {
            buffer.append("0");
            ++j;
        }
        buffer.append(intValue);
        return buffer.toString();
    }

    public final String nfp(int intValue, int digits) {
        StringBuffer buffer = new StringBuffer();
        if (intValue < 0) {
            buffer.append("-");
        } else {
            buffer.append("+");
        }
        buffer.append(this.nf(intValue, digits));
        return buffer.toString();
    }

    public final String nfs(int intValue, int digits) {
        StringBuffer buffer = new StringBuffer();
        if (intValue < 0) {
            buffer.append("-");
        } else {
            buffer.append(" ");
        }
        buffer.append(this.nf(intValue, digits));
        return buffer.toString();
    }

    public final String[] split(String str) {
        Vector<String> v = new Vector<String>();
        StringBuffer buffer = new StringBuffer();
        boolean whitespace = false;
        int i = 0;
        int length = str.length();
        while (i < length) {
            char c = str.charAt(i);
            switch (c) {
                case '\t': 
                case '\n': 
                case '\f': 
                case '\r': 
                case ' ': {
                    whitespace = true;
                    break;
                }
                default: {
                    if (whitespace) {
                        v.addElement(buffer.toString());
                        buffer.delete(0, buffer.length());
                        whitespace = false;
                    }
                    buffer.append(c);
                }
            }
            ++i;
        }
        if (buffer.length() > 0) {
            v.addElement(buffer.toString());
        }
        Object[] tokens = new String[v.size()];
        v.copyInto(tokens);
        return tokens;
    }

    public final String[] split(String str, String delim) {
        Vector<String> v = new Vector<String>();
        int prevIndex = 0;
        int nextIndex = str.indexOf(delim, prevIndex);
        while (nextIndex >= 0) {
            v.addElement(str.substring(prevIndex, nextIndex));
            prevIndex = nextIndex + 1;
            nextIndex = str.indexOf(delim, prevIndex);
        }
        if (prevIndex < str.length()) {
            v.addElement(str.substring(prevIndex));
        }
        Object[] tokens = new String[v.size()];
        v.copyInto(tokens);
        return tokens;
    }

    public final String trim(String str) {
        return str.trim();
    }

    public final String[] append(String[] array, String element) {
        String[] old = array;
        int length = old.length;
        array = new String[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public final boolean[] append(boolean[] array, boolean element) {
        boolean[] old = array;
        int length = old.length;
        array = new boolean[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public final byte[] append(byte[] array, byte element) {
        byte[] old = array;
        int length = old.length;
        array = new byte[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public final char[] append(char[] array, char element) {
        char[] old = array;
        int length = old.length;
        array = new char[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public final int[] append(int[] array, int element) {
        int[] old = array;
        int length = old.length;
        array = new int[length + 1];
        System.arraycopy(old, 0, array, 0, length);
        array[length] = element;
        return array;
    }

    public final void arraycopy(Object src, int srcPos, Object dest, int destPos, int length) {
        System.arraycopy(src, srcPos, dest, destPos, length);
    }

    public final String[] concat(String[] array1, String[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        String[] array = new String[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public final boolean[] concat(boolean[] array1, boolean[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        boolean[] array = new boolean[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public final byte[] concat(byte[] array1, byte[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        byte[] array = new byte[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public final char[] concat(char[] array1, char[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        char[] array = new char[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public final int[] concat(int[] array1, int[] array2) {
        int length1 = array1.length;
        int length2 = array2.length;
        int[] array = new int[length1 + length2];
        System.arraycopy(array1, 0, array, 0, length1);
        System.arraycopy(array2, 0, array, length1, length2);
        return array;
    }

    public final String[] contract(String[] array, int newSize) {
        int length = array.length;
        if (length > newSize) {
            String[] old = array;
            array = new String[newSize];
            System.arraycopy(old, 0, array, 0, newSize);
        }
        return array;
    }

    public final String[] expand(String[] array) {
        return this.expand(array, array.length * 2);
    }

    public final String[] expand(String[] array, int newSize) {
        int length = array.length;
        if (length < newSize) {
            String[] old = array;
            array = new String[newSize];
            System.arraycopy(old, 0, array, 0, length);
        }
        return array;
    }

    public final String[] reverse(String[] array) {
        int length = array.length;
        String[] reversed = new String[length];
        int i = length - 1;
        while (i >= 0) {
            reversed[i] = array[length - i - 1];
            --i;
        }
        return reversed;
    }

    public final String[] shorten(String[] array) {
        String[] old = array;
        int length = old.length - 1;
        array = new String[length];
        System.arraycopy(old, 0, array, 0, length);
        return array;
    }

    public final String[] slice(String[] array, int offset) {
        return this.slice(array, offset, array.length - offset);
    }

    public final String[] slice(String[] array, int offset, int length) {
        String[] slice = new String[length];
        System.arraycopy(array, offset, slice, 0, length);
        return slice;
    }

    public final String[] splice(String[] array, String value, int index) {
        int length = array.length;
        String[] splice = new String[length + 1];
        System.arraycopy(array, 0, splice, 0, index);
        splice[index] = value;
        System.arraycopy(array, index, splice, index + 1, length - index);
        return splice;
    }

    public final String[] splice(String[] array, String[] array2, int index) {
        int length = array.length;
        int length2 = array2.length;
        String[] splice = new String[length + length2];
        System.arraycopy(array, 0, splice, 0, index);
        System.arraycopy(array2, 0, splice, index, length2);
        System.arraycopy(array, index, splice, index + length2, length - index);
        return splice;
    }

    public static final char toChar(boolean val) {
        return val ? (char)'t' : 'f';
    }

    public static final char toChar(byte val) {
        return (char)(val & 0xFF);
    }

    public static final char toChar(int val) {
        return (char)val;
    }

    public static final char[] toChar(String val) {
        return val.toCharArray();
    }

    public static final char[] toChar(boolean[] val) {
        char[] result = new char[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = val[i] ? 116 : 102;
            --i;
        }
        return result;
    }

    public static final char[] toChar(byte[] val) {
        char[] result = new char[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = (char)(val[i] & 0xFF);
            --i;
        }
        return result;
    }

    public static final char[] toChar(int[] val) {
        char[] result = new char[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = (char)val[i];
            --i;
        }
        return result;
    }

    public static final char[][] toChar(String[] val) {
        char[][] result = new char[val.length][];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = val[i].toCharArray();
            --i;
        }
        return result;
    }

    public static final int toInt(boolean val) {
        return val ? 1 : 0;
    }

    public static final int toInt(byte val) {
        return val & 0xFF;
    }

    public static final int toInt(char val) {
        return val;
    }

    public static final int toInt(String val) {
        int result = 0;
        try {
            result = Integer.parseInt(val);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        return result;
    }

    public static final int[] toInt(boolean[] val) {
        int[] result = new int[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = val[i] ? 116 : 102;
            --i;
        }
        return result;
    }

    public static final int[] toInt(byte[] val) {
        int[] result = new int[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = val[i] & 0xFF;
            --i;
        }
        return result;
    }

    public static final int[] toInt(char[] val) {
        int[] result = new int[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = val[i];
            --i;
        }
        return result;
    }

    public static final int[] toInt(String[] val) {
        int[] result = new int[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            try {
                result[i] = Integer.parseInt(val[i]);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            --i;
        }
        return result;
    }

    public static final String str(boolean val) {
        return String.valueOf(val);
    }

    public static final String str(byte val) {
        return String.valueOf(val);
    }

    public static final String str(char val) {
        return String.valueOf(val);
    }

    public static final String str(int val) {
        return String.valueOf(val);
    }

    public static final String[] str(boolean[] val) {
        String[] result = new String[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = String.valueOf(val[i]);
            --i;
        }
        return result;
    }

    public static final String[] str(byte[] val) {
        String[] result = new String[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = String.valueOf(val[i]);
            --i;
        }
        return result;
    }

    public static final String[] str(char[] val) {
        String[] result = new String[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = String.valueOf(val[i]);
            --i;
        }
        return result;
    }

    public static final String[] str(int[] val) {
        String[] result = new String[val.length];
        int i = val.length - 1;
        while (i >= 0) {
            result[i] = String.valueOf(val[i]);
            --i;
        }
        return result;
    }

    public final int mul(int value1, int value2) {
        return value1 * value2 >> 8;
    }

    public final int div(int dividend, int divisor) {
        return (dividend << 8) / divisor;
    }

    public final int itofp(int value1) {
        return value1 << 8;
    }

    public final int fptoi(int value1) {
        if (value1 < 0) {
            value1 += 255;
        }
        return value1 >> 8;
    }

    public final int sqrt(int value_fp) {
        int prev;
        int prev_fp = value_fp;
        int next_fp = 0;
        while ((prev = prev_fp >> 8) != 0) {
            next_fp = (prev_fp + value_fp / prev) / 2;
            int error_fp = prev_fp > next_fp ? prev_fp - next_fp : next_fp - prev_fp;
            prev_fp = next_fp;
            if (error_fp > 256) continue;
        }
        return next_fp;
    }

    public final int dist(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return this.sqrt(dx * dx + dy * dy << 8);
    }

    public final int dist_fp(int x1, int y1, int x2, int y2) {
        int dx = x2 - x1;
        int dy = y2 - y1;
        return this.sqrt((dx * dx >> 8) + (dy * dy >> 8));
    }

    public final int floor(int value1) {
        return value1 >> 8 << 8;
    }

    public final int ceil(int value1) {
        return value1 + 256 - 1 >> 8 << 8;
    }

    public final int round(int value1) {
        return value1 + 128 >> 8 << 8;
    }

    public final int radians(int angle) {
        return angle * 804 / 46080;
    }

    public final int sin(int rad) {
        int index = rad * 180 / 804 % 360;
        if (index < 0) {
            index += 360;
        }
        return sin[index];
    }

    public final int cos(int rad) {
        int index = (rad * 180 / 804 + 90) % 360;
        if (index < 0) {
            index += 360;
        }
        return sin[index];
    }

    public final int atan(int value1) {
        int result = value1 <= 256 ? this.div(value1, 256 + this.mul(71, this.mul(value1, value1))) : 402 - this.div(value1, this.mul(value1, value1) + 71);
        return result;
    }

    public final int atan2(int y, int x) {
        int result = y == 0 && x == 0 ? 0 : (x > 0 ? this.atan(this.div(y, x)) : (x < 0 ? (y < 0 ? -(804 - this.atan(this.div(-y, -x))) : 804 - this.atan(this.div(y, -x))) : (y < 0 ? -402 : 402)));
        return result;
    }

    private static void make_crc_table() {
        crc_table = new int[256];
        int n = 0;
        while (n < 256) {
            long c = n;
            int k = 0;
            while (k < 8) {
                c = (c & 1L) != 0L ? 0xEDB88320L ^ c >> 1 : (c >>= 1);
                ++k;
            }
            PMIDlet.crc_table[n] = (int)c;
            ++n;
        }
    }

    private static int update_crc(long crc, byte[] buf, int offset, int len) {
        long c = crc;
        if (crc_table == null) {
            PMIDlet.make_crc_table();
        }
        int n = offset;
        int end = offset + len;
        while (n < end) {
            c = (long)crc_table[(int)((c ^ (long)buf[n]) & 0xFFL)] & 0xFFFFFFFFL ^ c >> 8;
            ++n;
        }
        return (int)c;
    }

    public static int crc(byte[] buf, int offset, int len) {
        return ~PMIDlet.update_crc(0xFFFFFFFFL, buf, offset, len);
    }

    private static class TextInputForm
    extends TextBox
    implements CommandListener {
        private PMIDlet midlet;
        private Command cmdOk;
        private Command cmdCancel;
        private boolean cancelled;

        public TextInputForm(PMIDlet midlet, String title, String text, int max, int constraints) {
            super(title, text, max, constraints);
            this.midlet = midlet;
            this.cmdOk = new Command("OK", 4, 1);
            this.cmdCancel = new Command("Cancel", 3, 2);
            this.addCommand(this.cmdOk);
            this.addCommand(this.cmdCancel);
            this.setCommandListener(this);
        }

        public String getString() {
            String result = this.cancelled ? null : super.getString();
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void commandAction(Command c, Displayable d) {
            if (c == this.cmdCancel) {
                this.cancelled = true;
            }
            PMIDlet pMIDlet = this.midlet;
            synchronized (pMIDlet) {
                this.midlet.notifyAll();
            }
        }
    }
}

