/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;

public class CSound {
    private Player[] m_players;
    public static final byte SOUND_PLAYER_STATE_PREFETCHED = 0;
    public static final byte SOUND_PLAYER_STATE_REALIZED = 1;
    public static final byte SOUND_PLAYER_STATE_STARTED = 2;
    public static final byte SOUND_PLAYER_STATE_ERROR = -1;
    public boolean m_bSoundEnabled = false;

    public void initializeSound(byte playerCount) {
        this.destroy();
        this.m_players = new Player[playerCount];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void loadMIDI(String NameFile, byte index) {
        InputStream istream = this.getClass().getResourceAsStream(NameFile);
        try {
            this.m_players[index] = Manager.createPlayer((InputStream)istream, (String)"audio/midi");
            this.m_players[index].realize();
        }
        catch (Exception e) {
            this.m_players[index] = null;
        }
        finally {
            istream = null;
        }
    }

    public boolean prefetch(byte playerIndex) {
        boolean res = false;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null && this.m_players[playerIndex].getState() == 200) {
            try {
                this.m_players[playerIndex].prefetch();
                res = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                res = false;
            }
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean close(byte playerIndex) {
        boolean res = false;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null) {
            try {
                this.m_players[playerIndex].close();
                res = true;
            }
            catch (Exception e) {
                res = false;
            }
            finally {
                this.m_players[playerIndex] = null;
            }
        }
        return res;
    }

    public boolean deallocate(byte playerIndex) {
        boolean res = false;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null && this.m_players[playerIndex].getState() == 300) {
            try {
                this.m_players[playerIndex].deallocate();
                this.m_players[playerIndex].close();
                this.m_players[playerIndex] = null;
                res = true;
            }
            catch (Exception e) {
                res = false;
            }
        }
        return res;
    }

    public boolean play(byte playerIndex) {
        boolean res = false;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null) {
            try {
                this.m_players[playerIndex].setLoopCount(1);
                this.m_players[playerIndex].start();
                res = true;
            }
            catch (Exception e) {
                res = false;
            }
        }
        return res;
    }

    public byte getPlayerState(byte playerIndex) {
        int res = -1;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null) {
            switch (this.m_players[playerIndex].getState()) {
                case 200: {
                    res = 1;
                    break;
                }
                case 300: {
                    res = 0;
                    break;
                }
                case 400: {
                    res = 2;
                    break;
                }
                default: {
                    res = -1;
                }
            }
        }
        return (byte)res;
    }

    public boolean stop(byte playerIndex) {
        boolean res = false;
        if (this.m_players != null && playerIndex > -1 && playerIndex < this.m_players.length && this.m_players[playerIndex] != null && this.m_players[playerIndex].getState() == 400) {
            try {
                this.m_players[playerIndex].stop();
                res = true;
            }
            catch (Exception e) {
                res = false;
            }
        }
        return res;
    }

    public void destroy() {
        if (this.m_players != null) {
            for (int i = 0; i < this.m_players.length; ++i) {
                if (this.m_players[i] == null) continue;
                this.m_players[i].close();
                this.m_players[i] = null;
            }
        }
    }

    public byte getFirstPrefetchedPlayer() {
        byte res = -1;
        if (this.m_players != null) {
            for (int i = 0; i < this.m_players.length; ++i) {
                Player p;
                int state;
                if (this.m_players[i] == null || (state = (p = this.m_players[i]).getState()) == 300 || state == 400) continue;
                res = (byte)i;
                break;
            }
        }
        return res;
    }

    public void ToggleSound(boolean soundActived) {
        if (soundActived == this.m_bSoundEnabled) {
            return;
        }
        boolean bl = this.m_bSoundEnabled = !this.m_bSoundEnabled;
        if (!this.m_bSoundEnabled) {
            for (byte i = 0; i < this.m_players.length; i = (byte)(i + 1)) {
                this.stop(i);
            }
        }
    }

    public boolean isSoundSupported() {
        return true;
    }

    public boolean isSoundEnabled() {
        return this.m_bSoundEnabled;
    }

    public void SetEnabled(boolean Enabled) {
        this.m_bSoundEnabled = Enabled;
    }

    private void debug(byte sound) {
        System.out.println();
        System.out.println();
    }
}

