/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.agave;

import com.tqm.agave.IData;
import com.tqm.agave.IReader;
import com.tqm.agave.ISMSConnection;
import com.tqm.agave.ISound;
import com.tqm.agave.ISystemFactory;

public final class J2MESystemFactory
implements ISystemFactory {
    private static J2MESystemFactory _factory = null;

    private J2MESystemFactory() {
    }

    public static J2MESystemFactory createFactory() {
        if (_factory == null) {
            _factory = new J2MESystemFactory();
        }
        return _factory;
    }

    public final IData createDataManager(String string) {
        return new IData(string, 0);
    }

    public final IReader createIOManager() {
        return new IReader();
    }

    public final ISMSConnection createSmsConnection(int n) throws ClassNotFoundException {
        switch (n) {
            case 1: {
                return J2MESystemFactory.createWMAConnection();
            }
            case 2: {
                return J2MESystemFactory.createSamsungConnection();
            }
        }
        throw new IllegalArgumentException("wrong sms api");
    }

    public final ISound createPlayer$176c5be0(String[] stringArray) throws ClassNotFoundException {
        return J2MESystemFactory.createMobileMediaPlayer(stringArray, 0);
    }

    private static ISMSConnection createWMAConnection() throws ClassNotFoundException {
        Class.forName("javax.wireless.messaging.MessageConnection");
        ISMSConnection iSMSConnection = null;
        Class<?> clazz = Class.forName("com.tqm.agave.net.WMASms");
        try {
            iSMSConnection = (ISMSConnection)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return iSMSConnection;
    }

    private static ISMSConnection createSamsungConnection() throws ClassNotFoundException {
        Class.forName("com.samsung.util.SMS");
        ISMSConnection iSMSConnection = null;
        Class<?> clazz = Class.forName("com.tqm.agave.net.SamsungSms");
        try {
            iSMSConnection = (ISMSConnection)clazz.newInstance();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return iSMSConnection;
    }

    private static ISound createMobileMediaPlayer(String[] stringArray, int n) throws ClassNotFoundException {
        Class.forName("javax.microedition.media.Player");
        ISound iSound = null;
        Class<?> clazz = Class.forName("com.tqm.agave.system.sound.MobileMediaPlayer");
        try {
            iSound = (ISound)clazz.newInstance();
            iSound.init$7ec83a6(stringArray, 0);
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        return iSound;
    }
}

