/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.wrapper;

import com.tqm.wrapper.Operator;
import com.tqm.wrapper.VirtualGood;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

final class Country {
    String name;
    String currency;
    String doubleOptKeyword;
    String doubleOptAnswer;
    public String mcc;
    private Hashtable _operators;
    private Hashtable _virtualGoods;

    Country(String name, String currency, String mcc) {
        this.name = name;
        this.currency = currency;
        if (mcc == null) {
            mcc = "";
        }
        this.mcc = mcc;
        this._operators = new Hashtable();
        this._virtualGoods = new Hashtable();
    }

    final void addOperator(Operator operator) {
        operator.country = this;
        this._operators.put(operator.id, operator);
    }

    final Vector getOperatorNames() {
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this._operators.elements();
        while (enumeration.hasMoreElements()) {
            vector.addElement(enumeration.nextElement().toString());
        }
        return vector;
    }

    final Enumeration getOperators() {
        return this._operators.elements();
    }

    final Operator getOperatorByID(String id) {
        return (Operator)this._operators.get(id);
    }

    final Operator getOperatorByName(String string) {
        Enumeration enumeration = this._operators.elements();
        while (enumeration.hasMoreElements()) {
            Operator operator = (Operator)enumeration.nextElement();
            if (operator.name.equals(string)) {
                return operator;
            }
            operator.equals(operator);
        }
        return null;
    }

    final void addVirtualGood(VirtualGood virtualGood) {
        this._virtualGoods.put(virtualGood.id, virtualGood);
    }

    final Enumeration getVirtualGoods() {
        return this._virtualGoods.elements();
    }

    final VirtualGood getVirtualGoodById(String id) {
        return (VirtualGood)this._virtualGoods.get(id);
    }

    final String toXml() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("<c n=\"").append(this.name).append("\" curr=\"").append(this.currency).append("\" mc=\"").append(this.mcc).append("\">");
        if (this.doubleOptAnswer != null) {
            stringBuffer.append("<da>").append(this.doubleOptAnswer).append("</da>");
        }
        if (this.doubleOptKeyword != null) {
            stringBuffer.append("<do>").append(this.doubleOptKeyword).append("</do>");
        }
        Enumeration enumeration = this._operators.elements();
        while (enumeration.hasMoreElements()) {
            stringBuffer.append(((Operator)enumeration.nextElement()).toXml());
        }
        enumeration = this._virtualGoods.elements();
        while (enumeration.hasMoreElements()) {
            VirtualGood virtualGood = (VirtualGood)enumeration.nextElement();
            stringBuffer.append("<vg ").append("id=\"").append(virtualGood.id).append("\" l=\"").append(virtualGood.paymentLevel);
            if (virtualGood.quantity != null) {
                stringBuffer.append("\" q=\"").append(virtualGood.quantity);
            }
            stringBuffer.append("\"/>");
        }
        stringBuffer.append("</c>");
        return stringBuffer.toString();
    }

    public final String toString() {
        return this.name;
    }
}

