/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.GameLogic;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class FramedPaper {
    private Sprite frameHorizontal;
    private Sprite frameVertical1;
    private Sprite frameVertical2;
    private static int frameHorizontalWide;
    private int x;
    private int y;
    public static int margin;
    public static int menuLineX1;
    public static int menuLineX2;

    public static void initMargin() {
        FramedPaper framedPaper = new FramedPaper();
        framedPaper.loadSprites();
        if (MainLogic.width < 24 * framedPaper.frameHorizontal.getWidth()) {
            int diff = 22 * framedPaper.frameHorizontal.getWidth() - MainLogic.width;
            int minus = diff % framedPaper.frameHorizontal.getWidth() == 0 ? diff / framedPaper.frameHorizontal.getWidth() : diff / framedPaper.frameHorizontal.getWidth() + 1;
            frameHorizontalWide = 22 - minus;
        } else {
            frameHorizontalWide = 22;
        }
        framedPaper.setMenuFramePosition();
        margin = framedPaper.getWidePaperWidth() / 14;
        menuLineX1 = framedPaper.getPaperX() + margin;
        menuLineX2 = framedPaper.getPaperX() + framedPaper.getWidePaperWidth() - margin - 1;
        framedPaper.disposeSprites();
    }

    public final void loadSprites() {
        this.frameVertical1 = GameLogic.loadSprite(117);
        this.frameVertical2 = GameLogic.loadSprite(123);
        this.frameHorizontal = GameLogic.loadSprite(135);
    }

    public final void setFramePosition(int x, int y) {
        this.x = x;
        this.y = y;
    }

    public final void setMenuFramePosition() {
        this.setFramePosition((MainLogic.width - this.getWideFrameWidth()) / 2, (MainLogic.height - MainLogic.icons.getHeight() - this.getMenuFrameHeight()) / 2);
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(135);
        MainLogic.disposeImage(123);
        MainLogic.disposeImage(117);
        this.frameVertical1 = null;
        this.frameVertical2 = null;
        this.frameHorizontal = null;
    }

    public final void drawMenuFramedPaper(Graphics g) {
        this.drawFramedPaper(g, 22, 4);
    }

    public final void drawWideHighFramedPaper(Graphics g) {
        this.drawFramedPaper(g, 22, 3);
    }

    public final void drawWideLowFramedPaper(Graphics g) {
        this.drawFramedPaper(g, 22, 1);
    }

    public final void drawNarrowMediumFramedPaper(Graphics g) {
        this.drawFramedPaper(g, 14, 2);
    }

    private void drawFramedPaper(Graphics graphics, int n, int n2) {
        int n3;
        boolean bl = false;
        if (n == 1) {
            n = 14;
            bl = true;
        }
        int n4 = FramedPaper.getFrameHorizontalWide(n);
        Graphics graphics2 = graphics;
        FramedPaper framedPaper = this;
        graphics2.setColor(-330561);
        graphics2.fillRect(framedPaper.getPaperX(), framedPaper.getVerticalFrameY(), framedPaper.getPaperWidth(n4), framedPaper.getVerticalFrameHeight(n2));
        n4 = bl ? 1 : n;
        graphics2 = graphics;
        framedPaper = this;
        switch (n4) {
            case 14: {
                framedPaper.frameHorizontal.setTransform(0);
                framedPaper.frameHorizontal.setFrame(0);
                framedPaper.frameHorizontal.setPosition(framedPaper.x, framedPaper.y);
                framedPaper.frameHorizontal.paint(graphics2);
                break;
            }
            case 1: 
            case 22: {
                framedPaper.frameHorizontal.setTransform(2);
                framedPaper.frameHorizontal.setFrame(2);
                framedPaper.frameHorizontal.setPosition(framedPaper.x, framedPaper.y);
                framedPaper.frameHorizontal.paint(graphics2);
            }
        }
        n4 = FramedPaper.getFrameHorizontalWide(n);
        graphics2 = graphics;
        framedPaper = this;
        framedPaper.frameHorizontal.setTransform(0);
        framedPaper.frameHorizontal.setFrame(1);
        for (n3 = 0; n3 < n4; ++n3) {
            framedPaper.frameHorizontal.setPosition(framedPaper.getHorizontalFrameX() + n3 * framedPaper.frameHorizontal.getWidth(), framedPaper.y);
            framedPaper.frameHorizontal.paint(graphics2);
        }
        n4 = FramedPaper.getFrameHorizontalWide(n);
        graphics2 = graphics;
        framedPaper = this;
        framedPaper.frameHorizontal.setTransform(0);
        framedPaper.frameHorizontal.setFrame(2);
        framedPaper.frameHorizontal.setPosition(framedPaper.getRightCornerX(n4), framedPaper.y);
        framedPaper.frameHorizontal.paint(graphics2);
        graphics2 = graphics;
        framedPaper = this;
        n3 = framedPaper.x;
        switch (n2) {
            case 4: {
                framedPaper.frameVertical1.setTransform(0);
                framedPaper.frameVertical1.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                framedPaper.frameVertical1.setTransform(0);
                framedPaper.frameVertical1.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY() + framedPaper.frameVertical1.getHeight());
                framedPaper.frameVertical1.paint(graphics2);
                break;
            }
            case 3: {
                framedPaper.frameVertical1.setTransform(0);
                framedPaper.frameVertical1.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                framedPaper.frameVertical2.setTransform(0);
                framedPaper.frameVertical2.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY() + framedPaper.frameVertical1.getHeight());
                framedPaper.frameVertical2.paint(graphics2);
                break;
            }
            case 2: {
                framedPaper.frameVertical1.setTransform(0);
                framedPaper.frameVertical1.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                break;
            }
            case 1: {
                framedPaper.frameVertical2.setTransform(0);
                framedPaper.frameVertical2.setPosition(n3 + framedPaper.frameHorizontal.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical2.paint(graphics2);
            }
        }
        n4 = n;
        graphics2 = graphics;
        framedPaper = this;
        n4 = FramedPaper.getFrameHorizontalWide(n4);
        n3 = framedPaper.getRightCornerX(n4);
        switch (n2) {
            case 4: {
                framedPaper.frameVertical1.setTransform(2);
                framedPaper.frameVertical1.setPosition(n3 - framedPaper.frameVertical1.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                framedPaper.frameVertical1.setTransform(2);
                framedPaper.frameVertical1.setPosition(n3 - framedPaper.frameVertical2.getWidth(), framedPaper.getVerticalFrameY() + framedPaper.frameVertical1.getHeight());
                framedPaper.frameVertical1.paint(graphics2);
                break;
            }
            case 3: {
                framedPaper.frameVertical1.setTransform(2);
                framedPaper.frameVertical1.setPosition(n3 - framedPaper.frameVertical1.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                framedPaper.frameVertical2.setTransform(2);
                framedPaper.frameVertical2.setPosition(n3 - framedPaper.frameVertical2.getWidth(), framedPaper.getVerticalFrameY() + framedPaper.frameVertical1.getHeight());
                framedPaper.frameVertical2.paint(graphics2);
                break;
            }
            case 2: {
                framedPaper.frameVertical1.setTransform(2);
                framedPaper.frameVertical1.setPosition(n3 - framedPaper.frameVertical1.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical1.paint(graphics2);
                break;
            }
            case 1: {
                framedPaper.frameVertical2.setTransform(2);
                framedPaper.frameVertical2.setPosition(n3 - framedPaper.frameVertical2.getWidth(), framedPaper.getVerticalFrameY());
                framedPaper.frameVertical2.paint(graphics2);
            }
        }
        n4 = bl ? 1 : n;
        graphics2 = graphics;
        framedPaper = this;
        switch (n4) {
            case 14: {
                framedPaper.frameHorizontal.setTransform(1);
                framedPaper.frameHorizontal.setFrame(0);
                framedPaper.frameHorizontal.setPosition(framedPaper.x, framedPaper.getLowerCornerY(n2));
                framedPaper.frameHorizontal.paint(graphics2);
                break;
            }
            case 1: 
            case 22: {
                framedPaper.frameHorizontal.setTransform(3);
                framedPaper.frameHorizontal.setFrame(2);
                framedPaper.frameHorizontal.setPosition(framedPaper.x, framedPaper.getLowerCornerY(n2));
                framedPaper.frameHorizontal.paint(graphics2);
            }
        }
        n4 = FramedPaper.getFrameHorizontalWide(n);
        graphics2 = graphics;
        framedPaper = this;
        framedPaper.frameHorizontal.setTransform(1);
        framedPaper.frameHorizontal.setFrame(1);
        for (n3 = 0; n3 < n4; ++n3) {
            framedPaper.frameHorizontal.setPosition(framedPaper.getHorizontalFrameX() + n3 * framedPaper.frameHorizontal.getWidth(), framedPaper.getLowerCornerY(n2));
            framedPaper.frameHorizontal.paint(graphics2);
        }
        n4 = FramedPaper.getFrameHorizontalWide(n);
        graphics2 = graphics;
        framedPaper = this;
        framedPaper.frameHorizontal.setTransform(1);
        framedPaper.frameHorizontal.setFrame(2);
        framedPaper.frameHorizontal.setPosition(framedPaper.getRightCornerX(n4), framedPaper.getLowerCornerY(n2));
        framedPaper.frameHorizontal.paint(graphics2);
    }

    private int getHorizontalFrameX() {
        return this.x + this.frameHorizontal.getWidth();
    }

    private int getVerticalFrameY() {
        return this.y + this.frameHorizontal.getHeight();
    }

    private int getHorizonstalFrameWidth(int frameHorizontalType) {
        return frameHorizontalType * this.frameHorizontal.getWidth();
    }

    private int getPaperWidth(int n) {
        return this.getHorizonstalFrameWidth(n) - 2 * this.frameVertical1.getWidth();
    }

    private int getVerticalFrameHeight(int frameVerticalType) {
        switch (frameVerticalType) {
            case 4: {
                return 2 * this.frameVertical1.getHeight();
            }
            case 3: {
                return this.frameVertical1.getHeight() + this.frameVertical2.getHeight();
            }
            case 2: {
                return this.frameVertical1.getHeight();
            }
            case 1: {
                return this.frameVertical2.getHeight();
            }
        }
        return 0;
    }

    private int getRightCornerX(int frameHorizontalType) {
        return this.getHorizontalFrameX() + this.getHorizonstalFrameWidth(frameHorizontalType);
    }

    private int getLowerCornerY(int frameVerticalType) {
        return this.getVerticalFrameY() + this.getVerticalFrameHeight(frameVerticalType);
    }

    public final int getX() {
        return this.x;
    }

    public final int getY() {
        return this.y;
    }

    public final int getPaperX() {
        return this.getHorizontalFrameX() + this.frameVertical1.getWidth();
    }

    public final int getPaperY() {
        return this.getVerticalFrameY();
    }

    public final int getWideFrameWidth() {
        return 2 * this.frameHorizontal.getWidth() + this.getHorizonstalFrameWidth(FramedPaper.getFrameHorizontalWide(22));
    }

    public final int getNarrowFrameWidth() {
        return 2 * this.frameHorizontal.getWidth() + this.getHorizonstalFrameWidth(14);
    }

    public final int getWidePaperWidth() {
        return this.getPaperWidth(FramedPaper.getFrameHorizontalWide(22));
    }

    public final int getNarrowPaperWidth() {
        return this.getPaperWidth(14);
    }

    public final int getMenuFrameHeight() {
        return 2 * this.frameHorizontal.getHeight() + this.getVerticalFrameHeight(4);
    }

    public final int getHighFrameHeight() {
        return 2 * this.frameHorizontal.getHeight() + this.getVerticalFrameHeight(3);
    }

    public final int getMediumFrameHeight() {
        return 2 * this.frameHorizontal.getHeight() + this.getVerticalFrameHeight(2);
    }

    public final int getLowFrameHeight() {
        return 2 * this.frameHorizontal.getHeight() + this.getVerticalFrameHeight(1);
    }

    public final int getMenuPaperHeight() {
        return this.getVerticalFrameHeight(4);
    }

    public final int getHighPaperHeight() {
        return this.getVerticalFrameHeight(3);
    }

    public final int getMediumPaperHeight() {
        return this.getVerticalFrameHeight(2);
    }

    public final int getLowPaperHeight() {
        return this.getVerticalFrameHeight(1);
    }

    public final int getVerticalPaperMargin() {
        return this.frameHorizontal.getHeight();
    }

    public final int getHorizontalPaperMargin() {
        return this.frameVertical1.getWidth();
    }

    public static void setContainerParams(Container container) {
        container.setAdjustableScrollBarParts$4868d30e();
        container.setScrollBarTrackStrokeStyle$13462e();
        container.setTextColors(-7388160, -7388160);
    }

    private static int getFrameHorizontalWide(int n) {
        if (n == 22) {
            return frameHorizontalWide;
        }
        return n;
    }
}

