/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Defender;
import com.tqm.fantasydefense.game.Enemy;
import com.tqm.fantasydefense.game.EnemyWaves;
import com.tqm.fantasydefense.game.ParticleGroup;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import javax.microedition.lcdui.Graphics;

public final class Castle {
    public int _castleHp;
    public int _castleHpFull;
    public boolean _castleHit;
    public int _castleTileX = 3;
    public int _castleTileY = 7;
    private int _castleDefender = 0;
    private int _defenderIdle = 0;
    private int _defenderFrame = 0;
    private int _range;
    private int _rangeSquared;
    private int _damageGround;
    private int _damageAir;
    private int _damageAdditional;
    private int _x;
    private int _y;
    private int _castleCatapult = -1;
    private int _catapultFrame = 0;
    private int _catapultFrameCounter = 0;
    private int _catapultAttackDelay;
    private int _startCatapultAttackDelay;
    private int _damageCatapult;
    private int _damageCatapultAdditional;
    private static int dx;
    private static int dy;
    private static Enemy enemy;
    private static int _enemyDistanceFromRoadEnd;
    private int _currentAttackDelay;
    private int _startAttackDelay;
    private static int[] DAMAGE_GROUND;
    private static int[] DAMAGE_AIR;
    private static int[] DAMAGE_ADDITIONAL;
    private static int[] SPECIAL_ABILITY;
    private static int drawBiasX;
    private static int drawBiasY;

    public final void init$4868d30e(int n, int n2) {
        this._castleDefender = n;
        this._castleHpFull = 1000;
        if (n2 != 0) {
            this._castleHpFull += n2 * this._castleHpFull / 100;
        }
        this._castleHp = this._castleHpFull;
        this._currentAttackDelay = 0;
        this._startAttackDelay = 24;
        Castle castle = this;
        this._range = 75;
        castle._rangeSquared = castle._range * castle._range;
        this._damageGround = DAMAGE_GROUND[this._castleDefender];
        this._damageAir = DAMAGE_AIR[this._castleDefender];
        this._damageAdditional = DAMAGE_ADDITIONAL[this._castleDefender];
        this._castleCatapult = -1;
        if (SecretItemsManager.getInstance().getCatapults()[0].isActive()) {
            this._castleCatapult = 0;
            this._damageCatapult = 30;
            this._damageCatapultAdditional = 0;
        } else if (SecretItemsManager.getInstance().getCatapults()[1].isActive()) {
            this._castleCatapult = 1;
            this._damageCatapult = 50;
            this._damageCatapultAdditional = 15;
        } else if (SecretItemsManager.getInstance().getCatapults()[2].isActive()) {
            this._castleCatapult = 2;
            this._damageCatapult = 70;
            this._damageCatapultAdditional = 15;
        }
        this._startCatapultAttackDelay = 30;
    }

    private void setDragonBias() {
        switch (this._castleDefender) {
            case 1: {
                drawBiasX = 20;
                drawBiasY = -54;
                break;
            }
            case 2: {
                drawBiasX = 10;
                drawBiasY = -51;
                break;
            }
            case 3: {
                drawBiasX = 3;
                drawBiasY = -29;
            }
        }
        if (GameTemplate._theme == 16) {
            --drawBiasX;
        }
    }

    private void setCatapultBias() {
        switch (this._castleCatapult) {
            case 0: {
                drawBiasX = 122;
                drawBiasY = -57;
                return;
            }
            case 1: {
                drawBiasX = 124;
                drawBiasY = -55;
                return;
            }
            case 2: {
                drawBiasX = 115;
                drawBiasY = -58;
            }
        }
    }

    public final void draw(Graphics graphics) {
        this._x = this._castleTileX * 28 - this._castleTileY * 13 + GameTemplate.castle.getWidth() / 41;
        this._y = this._castleTileY * 26;
        graphics.setColor(GameLogic.GAME_RANGE_COLOR);
        if (this._castleDefender != 0 || this._castleCatapult == 0 || this._castleCatapult == 1 || this._castleCatapult == 2) {
            graphics.drawArc(GameTemplate.castle.getWidth() / 2 + this._castleTileX * 28 - this._castleTileY * 13 + GameTemplate.viewX - this._range, this._castleTileY * 26 + GameTemplate.viewY - this._range * 26 / 28, this._range << 1, (this._range << 1) * 26 / 28, 0, 360);
        }
        if (!GameTemplate._pause) {
            this._defenderFrame = 0;
            if (this._currentAttackDelay > this._startAttackDelay - 1 - 4) {
                this._defenderFrame = 2;
            } else if (this._castleDefender == 1 && this._currentAttackDelay > this._startAttackDelay - 1 - 8) {
                this._defenderFrame = 3;
            }
            if (this._defenderFrame == 0) {
                if (this._defenderIdle <= 0) {
                    this._defenderIdle = 24 + Math.abs(Defender.rand.nextInt() % 8);
                }
                if (this._defenderIdle > 0) {
                    --this._defenderIdle;
                }
                if (this._defenderIdle > 20) {
                    this._defenderFrame = 1;
                }
            }
            this._catapultFrame = 0;
            if (this._castleCatapult == 2) {
                this._catapultFrame = 6;
            }
            if (this._catapultAttackDelay > 0) {
                switch (this._castleCatapult) {
                    case 0: {
                        if (this._catapultFrameCounter >= 7) break;
                        this._catapultFrame = this._catapultFrameCounter++;
                        if (this._catapultAttackDelay % 2 != 0) break;
                        break;
                    }
                    case 1: {
                        if (this._catapultFrameCounter >= 4) break;
                        this._catapultFrame = this._catapultFrameCounter++;
                        if (this._catapultAttackDelay % 2 != 0) break;
                        break;
                    }
                    case 2: {
                        if (this._catapultFrameCounter >= 7) break;
                        this._catapultFrame = this._catapultFrameCounter++;
                        if (this._catapultAttackDelay % 2 != 0) break;
                    }
                }
            }
        }
        Castle castle = this;
        castle._x = castle._castleTileX * 28 - castle._castleTileY * 13 + GameTemplate.castle.getWidth() / 41;
        castle._y = castle._castleTileY * 26;
        if (!(castle._x + GameTemplate.viewX + GameTemplate.castle.getWidth() + 20 >= 0 && castle._y + GameTemplate.viewY + 13 >= 0 && castle._x + GameTemplate.viewX - 28 <= GameLogic.width && castle._y + GameTemplate.viewY - GameTemplate.castle.getHeight() >> 14 <= GameLogic.height)) {
            return;
        }
        GameTemplate.castle.setPosition(this._x + GameTemplate.viewX, this._y + GameTemplate.viewY - GameTemplate.castle.getHeight());
        GameTemplate.castle.setFrame(0);
        GameTemplate.castle.paint(graphics);
        GameTemplate.gate.setPosition(GameTemplate.castle.getX() + GameTemplate.castle.getWidth() * 100 / 246, GameTemplate.castle.getY() + GameTemplate.castle.getHeight() - GameTemplate.gate.getHeight() * 5 / 3);
        if (SecretItemsManager.getInstance().getGates()[0].isActive()) {
            GameTemplate.gate.setFrame(0);
            GameTemplate.gate.paint(graphics);
        } else if (SecretItemsManager.getInstance().getGates()[1].isActive()) {
            GameTemplate.gate.setFrame(1);
            GameTemplate.gate.paint(graphics);
        } else if (SecretItemsManager.getInstance().getGates()[2].isActive()) {
            GameTemplate.gate.setFrame(2);
            GameTemplate.gate.paint(graphics);
        }
        if (GameTemplate._theme == 16) {
            drawBiasX = -1;
            drawBiasY = 6;
        } else {
            drawBiasX = 0;
            drawBiasY = 0;
        }
        GameTemplate.castleFlag.setPosition(this._x + GameTemplate.viewX + drawBiasX + 15, this._y + GameTemplate.viewY - GameTemplate.castle.getHeight() - GameTemplate.castleFlag.getHeight() + drawBiasY + 44);
        GameTemplate.castleFlag.setFrame(GameTemplate.getIter() / 2 % 3);
        GameTemplate.castleFlag.paint(graphics);
        GameTemplate.castleFlag.setPosition(this._x + GameTemplate.viewX + drawBiasX + 60, this._y + GameTemplate.viewY - GameTemplate.castle.getHeight() - GameTemplate.castleFlag.getHeight() + drawBiasY);
        GameTemplate.castleFlag.setFrame((GameTemplate.getIter() / 2 + 1) % 3);
        GameTemplate.castleFlag.paint(graphics);
        GameTemplate.castleFlag.setPosition(this._x + GameTemplate.viewX + drawBiasX + 139, this._y + GameTemplate.viewY - GameTemplate.castle.getHeight() - GameTemplate.castleFlag.getHeight() + drawBiasY + 1);
        GameTemplate.castleFlag.setFrame((GameTemplate.getIter() / 2 + 2) % 3);
        GameTemplate.castleFlag.paint(graphics);
        GameTemplate.castleFlag.setPosition(this._x + GameTemplate.viewX + drawBiasX + 163, this._y + GameTemplate.viewY - GameTemplate.castle.getHeight() - GameTemplate.castleFlag.getHeight() + drawBiasY + 43);
        GameTemplate.castleFlag.setFrame(GameTemplate.getIter() / 2 % 3);
        GameTemplate.castleFlag.paint(graphics);
        this.setDragonBias();
        switch (this._castleDefender) {
            case 1: {
                GameTemplate.wyvern.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.wyvern.getHeight() + drawBiasY);
                GameTemplate.wyvern.setFrame(this._defenderFrame);
                GameTemplate.wyvern.paint(graphics);
                break;
            }
            case 2: {
                GameTemplate.dragon.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.dragon.getHeight() + drawBiasY);
                GameTemplate.dragon.setFrame(this._defenderFrame);
                GameTemplate.dragon.paint(graphics);
                break;
            }
            case 3: {
                GameTemplate.hydra.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.hydra.getHeight() + drawBiasY);
                GameTemplate.hydra.setFrame(this._defenderFrame);
                GameTemplate.hydra.paint(graphics);
            }
        }
        this.setCatapultBias();
        switch (this._castleCatapult) {
            case 0: {
                GameTemplate.catapult.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.catapult.getHeight() + drawBiasY);
                GameTemplate.catapult.setFrame(this._catapultFrame);
                GameTemplate.catapult.paint(graphics);
                return;
            }
            case 1: {
                GameTemplate.ballista.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.ballista.getHeight() + drawBiasY);
                GameTemplate.ballista.setFrame(this._catapultFrame);
                GameTemplate.ballista.paint(graphics);
                return;
            }
            case 2: {
                GameTemplate.cannon.setPosition(this._x + GameTemplate.viewX + drawBiasX, this._y + GameTemplate.viewY - GameTemplate.cannon.getHeight() + drawBiasY);
                GameTemplate.cannon.setFrame(this._catapultFrame);
                GameTemplate.cannon.paint(graphics);
            }
        }
    }

    private boolean inRange(int x, int y) {
        int _y;
        int _x = this._castleTileX * 28 - this._castleTileY * 13 + GameTemplate.castle.getWidth() / 2;
        dx = x - _x;
        return dx * dx + (dy = (y - (_y = this._castleTileY * 26)) * 28 / 26) * dy <= this._rangeSquared;
    }

    public final void think() {
        int n;
        int n2;
        int n3;
        this._castleHit = false;
        Castle castle = this;
        if (castle._catapultAttackDelay > 0) {
            --castle._catapultAttackDelay;
        } else {
            _enemyDistanceFromRoadEnd = 1000000;
            n3 = -1;
            for (n2 = 0; n2 < EnemyWaves.enemies.size(); ++n2) {
                enemy = (Enemy)EnemyWaves.enemies.elementAt(n2);
                if (Castle.enemy._distanceFromEnd >= _enemyDistanceFromRoadEnd || !castle.inRange(Castle.enemy._x, Castle.enemy._y)) continue;
                _enemyDistanceFromRoadEnd = Castle.enemy._distanceFromEnd;
                n3 = n2;
            }
            if (n3 >= 0 && (castle._castleCatapult == 0 || castle._castleCatapult == 1 || castle._castleCatapult == 2)) {
                if (castle._castleCatapult == 1) {
                    if (((Enemy)EnemyWaves.enemies.elementAt(n3)).isAir()) {
                        ((Enemy)EnemyWaves.enemies.elementAt(n3)).receiveTimedHitCatapult(castle._damageCatapult, 14);
                    } else {
                        ((Enemy)EnemyWaves.enemies.elementAt(n3)).receiveTimedHitCatapult(castle._damageCatapult, 14);
                    }
                } else {
                    EnemyWaves.enemies.elementAt(n3);
                    ((Enemy)EnemyWaves.enemies.elementAt(n3)).receiveTimedHitCatapult(castle._damageCatapult, 20);
                }
                if (castle._castleCatapult == 1) {
                    ((Enemy)EnemyWaves.enemies.elementAt(n3)).receiveTimedPoison(castle._damageCatapultAdditional, 14);
                }
                if (castle._castleCatapult == 2) {
                    ((Enemy)EnemyWaves.enemies.elementAt(n3)).receiveTimedFire(castle._damageCatapultAdditional, 20);
                }
                castle._catapultAttackDelay = castle._startCatapultAttackDelay - 1;
                castle._catapultFrameCounter = 0;
                castle.setCatapultBias();
                if (castle._castleCatapult == 0) {
                    ParticleGroup.addParticleWithDelay(castle._x + drawBiasX, castle._y + drawBiasY - GameTemplate.catapult.getHeight(), ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._y + 13, 12, 5, 8, true);
                }
                if (castle._castleCatapult == 1) {
                    ParticleGroup.addParticleWithDelay(castle._x + GameTemplate.ballista.getWidth() / 10 + drawBiasX, castle._y + drawBiasY - (GameTemplate.ballista.getHeight() << 2) / 10, ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._y + 13, 8, 6, 6, false);
                }
                if (castle._castleCatapult == 2) {
                    ParticleGroup.addParticleWithDelay(castle._x + drawBiasX, castle._y + drawBiasY - GameTemplate.cannon.getHeight(), ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n3))._y + 13, 12, 7, 8, true);
                }
            }
        }
        if (this._currentAttackDelay > 0) {
            --this._currentAttackDelay;
            return;
        }
        _enemyDistanceFromRoadEnd = 1000000;
        int n4 = -1;
        for (n = 0; n < EnemyWaves.enemies.size(); ++n) {
            enemy = (Enemy)EnemyWaves.enemies.elementAt(n);
            if (Castle.enemy._distanceFromEnd >= _enemyDistanceFromRoadEnd || !this.inRange(Castle.enemy._x, Castle.enemy._y)) continue;
            _enemyDistanceFromRoadEnd = Castle.enemy._distanceFromEnd;
            n4 = n;
        }
        if (n4 >= 0 && this._castleDefender != 0) {
            if (this._castleDefender == 3) {
                enemy = (Enemy)EnemyWaves.enemies.elementAt(n4);
                int n5 = Castle.enemy._x;
                int n6 = Castle.enemy._y;
                for (n = 0; n < EnemyWaves.enemies.size(); ++n) {
                    enemy = (Enemy)EnemyWaves.enemies.elementAt(n);
                    int n7 = Castle.enemy._y;
                    int n8 = Castle.enemy._x;
                    n2 = n6;
                    n3 = n5;
                    castle = this;
                    dx = n3 - n8;
                    dy = (n2 - n7) * 28 / 26;
                    if (!(dx * dx + dy * dy <= castle._rangeSquared / 4)) continue;
                    enemy.receiveTimedHitDragon(this._damageGround, 8);
                    enemy.receiveTimedPoison(this._damageAdditional, 8);
                }
            } else if (this._castleDefender == 1) {
                if (((Enemy)EnemyWaves.enemies.elementAt(n4)).isAir()) {
                    ((Enemy)EnemyWaves.enemies.elementAt(n4)).receiveTimedHitDragon(this._damageAir, 12);
                } else {
                    ((Enemy)EnemyWaves.enemies.elementAt(n4)).receiveTimedHitDragon(this._damageGround, 12);
                }
            } else if (this._castleDefender == 2) {
                if (((Enemy)EnemyWaves.enemies.elementAt(n4)).isAir()) {
                    ((Enemy)EnemyWaves.enemies.elementAt(n4)).receiveTimedHitDragon(this._damageAir, 8);
                } else {
                    ((Enemy)EnemyWaves.enemies.elementAt(n4)).receiveTimedHitDragon(this._damageGround, 8);
                }
            }
            if (SPECIAL_ABILITY[this._castleDefender] == 1) {
                ((Enemy)EnemyWaves.enemies.elementAt(n4)).receiveTimedFire(this._damageAdditional, 8);
            }
            this._currentAttackDelay = this._startAttackDelay - 1;
            this.setDragonBias();
            if (this._castleDefender == 2) {
                ParticleGroup.addParticleWithDelay(this._x + drawBiasX + GameTemplate.dragon.getWidth() * 7 / 9, this._y + drawBiasY - GameTemplate.dragon.getHeight() / 10, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._y - (((Enemy)EnemyWaves.enemies.elementAt((int)n4))._height >> 1) + 13, 8, 14, 0, false);
            }
            if (this._castleDefender == 1) {
                ParticleGroup.addParticleWithDelay(this._x + drawBiasX + (GameTemplate.wyvern.getWidth() << 1) / 3, this._y + drawBiasY - GameTemplate.wyvern.getHeight() / 10, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._y - (((Enemy)EnemyWaves.enemies.elementAt((int)n4))._height >> 1) + 13, 8, 3, 4, false);
            }
            if (this._castleDefender == 3) {
                ParticleGroup.addParticleWithDelay(this._x + drawBiasX + GameTemplate.hydra.getWidth() * 75 / 100, this._y + drawBiasY - GameTemplate.hydra.getHeight() / 10, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._y - (((Enemy)EnemyWaves.enemies.elementAt((int)n4))._height >> 1) + 13, 8, 4, 0, false);
                ParticleGroup.addParticleWithDelay(this._x + drawBiasX + GameTemplate.hydra.getWidth() * 90 / 100, this._y + drawBiasY - GameTemplate.hydra.getHeight() * 5 / 10, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._y - ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._height * 3 / 4 + 13, 8, 4, 0, false);
                ParticleGroup.addParticleWithDelay(this._x + drawBiasX + (GameTemplate.hydra.getWidth() << 2) / 10, this._y + drawBiasY - GameTemplate.hydra.getHeight() * 30 / 100, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._x + 20, ((Enemy)EnemyWaves.enemies.elementAt((int)n4))._y - (((Enemy)EnemyWaves.enemies.elementAt((int)n4))._height >> 2) + 13, 8, 4, 0, false);
            }
        }
    }

    static {
        DAMAGE_GROUND = new int[]{0, 30, 40, 25};
        DAMAGE_AIR = new int[]{0, 30, 40, 25};
        DAMAGE_ADDITIONAL = new int[]{0, 0, 15, 15};
        SPECIAL_ABILITY = new int[]{0, 0, 1, 2};
        drawBiasX = 0;
        drawBiasY = 0;
    }
}

