/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.game;

import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.game.Defender;
import com.tqm.fantasydefense.game.UnitPipeline;
import java.util.Enumeration;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;

public final class DefenderGroup {
    private static Vector defenders = new Vector();
    private Defender defender;
    public static boolean usedKnight;
    public static boolean usedArcher;
    public static boolean usedSorcerer;
    public static boolean usedPaladin;
    public static boolean usedElf;
    public static boolean usedWarlock;

    public static void clear() {
        defenders.removeAllElements();
        usedKnight = false;
        usedArcher = false;
        usedSorcerer = false;
        usedPaladin = false;
        usedElf = false;
        usedWarlock = false;
    }

    public final boolean addDefender(int tileX, int tileY, int type, boolean useElixir) {
        if (GameTemplate.roads.getRoadTile(tileX, tileY) == -1) {
            this.defender = new Defender(tileX, tileY, type, useElixir);
            if (this.defender.price(1) <= GameTemplate._money) {
                GameTemplate._money -= this.defender.price(1);
                GameTemplate.roads.setRoadTile(tileX, tileY, -2);
                defenders.addElement(this.defender);
                switch (type) {
                    case 20: {
                        usedKnight = true;
                        break;
                    }
                    case 21: {
                        usedArcher = true;
                        break;
                    }
                    case 22: {
                        usedSorcerer = true;
                        break;
                    }
                    case 23: {
                        usedPaladin = true;
                        break;
                    }
                    case 24: {
                        usedElf = true;
                        break;
                    }
                    case 25: {
                        usedWarlock = true;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public final boolean canAffordDefender$3b4dbe76(int n, int n2, int n3) {
        this.defender = new Defender(n, n2, n3, true);
        if (this.defender.price(1) <= GameTemplate._money) {
            this.defender = null;
            return true;
        }
        this.defender = null;
        return false;
    }

    public final Defender getNewDefender$21e4ea39(int n, int n2, int n3) {
        this.defender = new Defender(n, n2, n3, true);
        return this.defender;
    }

    public static boolean fieldIsEmpty(int tileX, int tileY) {
        return GameTemplate.roads.getRoadTile(tileX, tileY) == -1;
    }

    public final boolean removeDefender(int n, int n2) {
        if (GameTemplate.roads.getRoadTile(n, n2) == -2) {
            defenders.elements();
            for (int i = 0; i < defenders.size(); ++i) {
                this.defender = (Defender)defenders.elementAt(i);
                if (this.defender._tileX != n || this.defender._tileY != n2) continue;
                GameTemplate._money += this.defender.sellPrice();
                defenders.removeElementAt(i);
                GameTemplate.roads.setRoadTile(n, n2, -1);
                return true;
            }
        }
        return false;
    }

    public final Defender getDefender(int tileX, int tileY) {
        if (GameTemplate.roads.getRoadTile(tileX, tileY) == -2) {
            Enumeration e = defenders.elements();
            while (e.hasMoreElements()) {
                this.defender = (Defender)e.nextElement();
                if (this.defender._tileX != tileX || this.defender._tileY != tileY) continue;
                return this.defender;
            }
        }
        return null;
    }

    public final int getDefenderRange(int tileX, int tileY) {
        this.defender = this.getDefender(tileX, tileY);
        if (this.defender != null) {
            return this.defender._range;
        }
        return 0;
    }

    public final int getDefenderSpecialRange(int tileX, int tileY) {
        this.defender = this.getDefender(tileX, tileY);
        if (this.defender != null) {
            return this.defender._rangeSpecial;
        }
        return 0;
    }

    public final void think() {
        Enumeration d = defenders.elements();
        while (d.hasMoreElements()) {
            this.defender = (Defender)d.nextElement();
            this.defender.think();
        }
    }

    public final void draw() {
        Enumeration enumeration = defenders.elements();
        while (enumeration.hasMoreElements()) {
            this.defender = (Defender)enumeration.nextElement();
            if (!this.defender.visible()) continue;
            UnitPipeline.addUnit(this.defender);
        }
    }

    public final void drawShadows(Graphics g) {
        Enumeration e = defenders.elements();
        while (e.hasMoreElements()) {
            this.defender = (Defender)e.nextElement();
            if (!this.defender.shadowVisible()) continue;
            this.defender.drawShadow(g);
        }
    }
}

