/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class Achievements {
    private GameLogic gameLogic;
    private FramedPaper framedPaper;
    private AchievementsView achievementsView;
    private String achievementTitle;
    private Container achievementDesc;
    private int line1Y;
    private int verticalSpace;
    private int textMargin;
    private int[] rmsAchvLocks;
    private static Achievements achievements;

    public static Achievements getInstance() {
        return achievements;
    }

    public static Achievements createInstance(GameLogic gameLogic) {
        if (achievements == null) {
            achievements = new Achievements(gameLogic);
        }
        return achievements;
    }

    private Achievements(GameLogic gameLogic) {
        this.gameLogic = gameLogic;
        this.framedPaper = new FramedPaper();
        this.achievementsView = new AchievementsView();
        this.achievementDesc = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.achievementDesc);
        this.verticalSpace = GameLogic.getSystemFont().getHeight() / 6;
        this.textMargin = MainLogic.width / 16;
        this.rmsAchvLocks = new int[29];
    }

    public final void init() {
        Achievements achievements = this;
        achievements.framedPaper.loadSprites();
        achievements.framedPaper.setMenuFramePosition();
        Achievements achievements2 = achievements;
        achievements2.achievementsView.setSize(achievements2.framedPaper.getWidePaperWidth() - achievements2.framedPaper.getWidePaperWidth() * 3 / 11, achievements2.framedPaper.getMenuFrameHeight() * 50 / 133);
        achievements2.achievementsView.setPosition((MainLogic.width - achievements2.achievementsView.getWidth()) / 2, achievements2.framedPaper.getPaperY() + achievements2.framedPaper.getMenuPaperHeight() / 7);
        achievements.achievementsView.loadSprites();
        this.reloadAchievementTitle(this.achievementsView.getCursorIndexPos());
        achievements = this;
        achievements.line1Y = achievements.achievementsView.getY() + achievements.achievementsView.getHeight() + achievements.verticalSpace;
        int n = achievements.line1Y + GameLogic.getSystemFont().getHeight() + 2 * achievements.verticalSpace;
        achievements.achievementDesc.setSize(achievements.achievementsView.getWidth() + 2 * achievements.textMargin - 2 * achievements.verticalSpace, achievements.framedPaper.getPaperY() + achievements.framedPaper.getMenuPaperHeight() - n - 7 * achievements.verticalSpace / 2);
        achievements.achievementDesc.setPosition(achievements.achievementsView.getX() - achievements.textMargin + 1 + achievements.verticalSpace, n + achievements.verticalSpace);
        this.reloadAchievementDesc(this.achievementsView.getCursorIndexPos());
        this.achievementsView.initParams();
    }

    public final void deinit() {
        Achievements achievements = this;
        achievements.framedPaper.disposeSprites();
        achievements.achievementsView.disposeSprites();
    }

    public final void draw(Graphics g) {
        GameLogic.setMenuScrollbarColor();
        this.framedPaper.drawMenuFramedPaper(g);
        this.gameLogic.drawMenuTitle(g, this.gameLogic.getMenuFramedPaperTitleY(this.framedPaper));
        this.achievementsView.draw(g);
        Graphics graphics = g;
        Achievements achievements = this;
        int n = MainLogic.width / 2;
        int n2 = achievements.achievementsView.getX() + 1 - achievements.textMargin;
        graphics.setColor(-3621766);
        graphics.drawLine(n2, achievements.line1Y, n2 + achievements.achievementsView.getWidth() + 2 * achievements.textMargin - 1, achievements.line1Y);
        graphics.setColor(-44032);
        graphics.setFont(GameLogic.getSystemFont());
        graphics.drawString(achievements.achievementTitle, n, achievements.line1Y + achievements.verticalSpace, 17);
        g.setColor(-2173794);
        g.fillRect(this.achievementDesc.getX() - this.verticalSpace, this.achievementDesc.getY() - this.verticalSpace, this.achievementDesc.getWidth() + 2 * this.verticalSpace, this.achievementDesc.getHeight() + 2 * this.verticalSpace);
        this.achievementDesc.draw(g);
        GameLogic.drawBackIcon(g);
    }

    public final void keyPressed(int n) {
        switch (n) {
            case 53: 
            case 89: 
            case 91: {
                return;
            }
            case 90: 
            case 95: {
                GameLogic.changeState(17, 207, 2, false);
                return;
            }
            case 50: 
            case 52: 
            case 54: 
            case 56: 
            case 85: 
            case 86: 
            case 87: 
            case 88: {
                this.achievementsView.keyPressed(n);
            }
        }
    }

    private void reloadAchievementTitle(int n) {
        switch (n) {
            case 0: {
                this.achievementTitle = MainLogic.strings[210];
                return;
            }
            case 1: {
                this.achievementTitle = MainLogic.strings[212];
                return;
            }
            case 2: {
                this.achievementTitle = MainLogic.strings[214];
                return;
            }
            case 3: {
                this.achievementTitle = MainLogic.strings[216];
                return;
            }
            case 4: {
                this.achievementTitle = MainLogic.strings[218];
                return;
            }
            case 5: {
                this.achievementTitle = MainLogic.strings[220];
                return;
            }
            case 6: {
                this.achievementTitle = MainLogic.strings[222];
                return;
            }
            case 7: {
                this.achievementTitle = MainLogic.strings[224];
                return;
            }
            case 8: {
                this.achievementTitle = MainLogic.strings[226];
                return;
            }
            case 9: {
                this.achievementTitle = MainLogic.strings[228];
                return;
            }
            case 10: {
                this.achievementTitle = MainLogic.strings[230];
                return;
            }
            case 11: {
                this.achievementTitle = MainLogic.strings[232];
                return;
            }
            case 12: {
                this.achievementTitle = MainLogic.strings[234];
                return;
            }
            case 13: {
                this.achievementTitle = MainLogic.strings[236];
                return;
            }
            case 14: {
                this.achievementTitle = MainLogic.strings[238];
                return;
            }
            case 15: {
                this.achievementTitle = MainLogic.strings[240];
                return;
            }
            case 16: {
                this.achievementTitle = MainLogic.strings[242];
                return;
            }
            case 17: {
                this.achievementTitle = MainLogic.strings[244];
                return;
            }
            case 18: {
                this.achievementTitle = MainLogic.strings[246];
                return;
            }
            case 19: {
                this.achievementTitle = MainLogic.strings[248];
                return;
            }
            case 20: {
                this.achievementTitle = MainLogic.strings[250];
                return;
            }
            case 21: {
                this.achievementTitle = MainLogic.strings[252];
                return;
            }
            case 22: {
                this.achievementTitle = MainLogic.strings[254];
                return;
            }
            case 23: {
                this.achievementTitle = MainLogic.strings[266];
                return;
            }
            case 24: {
                this.achievementTitle = MainLogic.strings[256];
                return;
            }
            case 25: {
                this.achievementTitle = MainLogic.strings[258];
                return;
            }
            case 26: {
                this.achievementTitle = MainLogic.strings[260];
                return;
            }
            case 27: {
                this.achievementTitle = MainLogic.strings[262];
                return;
            }
            case 28: {
                this.achievementTitle = MainLogic.strings[264];
            }
        }
    }

    private void reloadAchievementDesc(int n) {
        String string = "";
        switch (n) {
            case 0: {
                string = MainLogic.strings[211];
                break;
            }
            case 1: {
                string = MainLogic.strings[213];
                break;
            }
            case 2: {
                string = MainLogic.strings[215];
                break;
            }
            case 3: {
                string = MainLogic.strings[217];
                break;
            }
            case 4: {
                string = MainLogic.strings[219];
                break;
            }
            case 5: {
                string = MainLogic.strings[221];
                break;
            }
            case 6: {
                string = MainLogic.strings[223];
                break;
            }
            case 7: {
                string = MainLogic.strings[225];
                break;
            }
            case 8: {
                string = MainLogic.strings[227];
                break;
            }
            case 9: {
                string = MainLogic.strings[229];
                break;
            }
            case 10: {
                string = MainLogic.strings[231];
                break;
            }
            case 11: {
                string = MainLogic.strings[233];
                break;
            }
            case 12: {
                string = MainLogic.strings[235];
                break;
            }
            case 13: {
                string = MainLogic.strings[237];
                break;
            }
            case 14: {
                string = MainLogic.strings[239];
                break;
            }
            case 15: {
                string = MainLogic.strings[241];
                break;
            }
            case 16: {
                string = MainLogic.strings[243];
                break;
            }
            case 17: {
                string = MainLogic.strings[245];
                break;
            }
            case 18: {
                string = MainLogic.strings[247];
                break;
            }
            case 19: {
                string = MainLogic.strings[249];
                break;
            }
            case 20: {
                string = MainLogic.strings[251];
                break;
            }
            case 21: {
                string = MainLogic.strings[253];
                break;
            }
            case 22: {
                string = MainLogic.strings[255];
                break;
            }
            case 23: {
                string = MainLogic.strings[267];
                break;
            }
            case 24: {
                string = MainLogic.strings[257];
                break;
            }
            case 25: {
                string = MainLogic.strings[259];
                break;
            }
            case 26: {
                string = MainLogic.strings[261];
                break;
            }
            case 27: {
                string = MainLogic.strings[263];
                break;
            }
            case 28: {
                string = MainLogic.strings[265];
            }
        }
        this.achievementDesc.setText$40907f8c(string, GameLogic.getSystemFont(), null, 17);
        this.achievementDesc.setVAnchor(16);
        this.achievementDesc.setPosition(this.achievementDesc.getX(), this.achievementDesc.getY());
        GameLogic.changeContainerTextColor(this.achievementDesc);
    }

    public static String getDefaultAchvLocksToRMS() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < 29; ++i) {
            stringBuffer.append(2);
        }
        return stringBuffer.toString();
    }

    public final void loadAchvLocksFromRMS() {
        String string = this.gameLogic.getGData().loadAsString(48);
        for (int i = 0; i < string.length(); ++i) {
            this.rmsAchvLocks[i] = Integer.parseInt(String.valueOf(string.charAt(i)));
        }
    }

    public final void unlockAchievement(int n) {
        this.saveAchvLocksToRMS(n, 1);
    }

    public final boolean isUnlockedAchievement(int n) {
        return this.rmsAchvLocks[n] != 2;
    }

    private void saveAchvLocksToRMS(int n, int n2) {
        this.rmsAchvLocks[n] = n2;
        StringBuffer stringBuffer = new StringBuffer();
        for (n2 = 0; n2 < this.rmsAchvLocks.length; ++n2) {
            stringBuffer.append(this.rmsAchvLocks[n2]);
        }
        this.gameLogic.getGData().save(stringBuffer.toString(), 48);
    }

    public final void resetAchievementsParams() {
        for (int i = 0; i < this.rmsAchvLocks.length; ++i) {
            this.rmsAchvLocks[i] = 2;
        }
        this.gameLogic.getGData().save(Achievements.getDefaultAchvLocksToRMS(), 48);
    }

    static /* synthetic */ boolean access$100(Achievements achievements, int n) {
        return achievements.rmsAchvLocks[n] == 1;
    }

    private final class AchievementsView {
        private int x;
        private int y;
        private int width;
        private int height;
        private int hSpace;
        private int vSpace;
        private int translateY = 0;
        private int cursorIndexPos = 0;
        private Sprite cursorSprite;
        private Sprite achArrows;
        private Sprite achScrollUp;
        private Sprite achScrollMiddle;
        private Sprite achScrollDown;
        private Sprite achievementIconsSprite;
        private Sprite achievementCupSprite;
        private Sprite achievementIconSprite;
        private int achievementsHeight;
        private int scrollLineHeight;
        private int scrollHeight;

        public final void loadSprites() {
            this.cursorSprite = GameLogic.loadSprite(121);
            this.cursorSprite.setTransform(2);
            this.achArrows = GameLogic.loadSprite(129);
            this.achScrollUp = GameLogic.loadSprite(139);
            this.achScrollMiddle = GameLogic.loadSprite(138);
            this.achScrollDown = GameLogic.loadSprite(140);
            this.achievementIconsSprite = GameLogic.loadSprite(219);
            this.achievementIconSprite = GameLogic.loadSprite(218);
            this.achievementCupSprite = GameLogic.loadSprite(133);
        }

        public final void initParams() {
            int n = 3 * this.achievementIconsSprite.getWidth();
            int n2 = 2 * this.achievementIconsSprite.getHeight();
            this.hSpace = (this.width - n) / 2;
            this.vSpace = this.height - n2;
            this.achievementsHeight = this.getAchievementY(28) + this.achievementIconsSprite.getHeight();
            this.scrollLineHeight = this.height - 2 * this.achArrows.getHeight();
            n = this.achievementsHeight / this.height + (this.achievementsHeight % this.height == 0 ? 0 : 1);
            this.scrollHeight = this.scrollLineHeight / n;
            n = this.getUpAndDownScrollHeight();
            if ((n = (this.scrollHeight - n) % this.achScrollMiddle.getHeight()) > 0) {
                this.scrollHeight = this.scrollHeight - n + this.achScrollMiddle.getHeight();
            }
        }

        private int getUpAndDownScrollHeight() {
            return this.achScrollUp.getHeight() + this.achScrollDown.getHeight();
        }

        public final void disposeSprites() {
            MainLogic.disposeImage(121);
            MainLogic.disposeImage(129);
            MainLogic.disposeImage(139);
            MainLogic.disposeImage(138);
            MainLogic.disposeImage(140);
            MainLogic.disposeImage(219);
            MainLogic.disposeImage(218);
            MainLogic.disposeImage(133);
            this.cursorSprite = null;
            this.achArrows = null;
            this.achScrollUp = null;
            this.achScrollMiddle = null;
            this.achScrollDown = null;
            this.achievementIconsSprite = null;
            this.achievementIconSprite = null;
            this.achievementCupSprite = null;
        }

        public final void draw(Graphics graphics) {
            int n = graphics.getClipX();
            int n2 = graphics.getClipY();
            int n3 = graphics.getClipWidth();
            int n4 = graphics.getClipHeight();
            Graphics graphics2 = graphics;
            AchievementsView achievementsView = this;
            graphics2.setColor(-7388160);
            graphics2.drawLine(achievementsView.getScrollbarLineX(), achievementsView.y + achievementsView.achArrows.getHeight(), achievementsView.getScrollbarLineX(), achievementsView.getBottomSideY() - achievementsView.achArrows.getHeight());
            achievementsView.achArrows.setFrame(0);
            achievementsView.achArrows.setPosition(achievementsView.getRigthSideX(), achievementsView.y);
            achievementsView.achArrows.paint(graphics2);
            achievementsView.achArrows.setFrame(1);
            achievementsView.achArrows.setPosition(achievementsView.getRigthSideX(), achievementsView.getBottomSideY() - achievementsView.achArrows.getHeight() + 1);
            achievementsView.achArrows.paint(graphics2);
            AchievementsView achievementsView2 = achievementsView;
            int n5 = achievementsView2.y + achievementsView2.achArrows.getHeight();
            if (achievementsView2.cursorIndexPos == 28 || achievementsView2.isAchievementVisible(28)) {
                n5 = achievementsView2.achArrows.getY() - achievementsView2.scrollHeight;
            } else if (achievementsView2.translateY < 0) {
                int n6 = achievementsView2.scrollLineHeight * (-achievementsView2.translateY + achievementsView2.height / 2) / achievementsView2.achievementsHeight;
                n5 += n6 - achievementsView2.scrollHeight / 2;
            }
            achievementsView.achScrollUp.setPosition(achievementsView.getRigthSideX() + achievementsView.getCenterXForScroll(achievementsView.achScrollUp), n5);
            achievementsView.achScrollUp.paint(graphics2);
            int n7 = achievementsView.getUpAndDownScrollHeight();
            n5 = 0;
            while (n7 < achievementsView.scrollHeight) {
                achievementsView.achScrollMiddle.setPosition(achievementsView.getRigthSideX() + achievementsView.getCenterXForScroll(achievementsView.achScrollMiddle), achievementsView.achScrollUp.getY() + achievementsView.achScrollUp.getHeight() + n5 * achievementsView.achScrollMiddle.getHeight());
                achievementsView.achScrollMiddle.paint(graphics2);
                n7 += achievementsView.achScrollMiddle.getHeight();
                ++n5;
            }
            achievementsView.achScrollDown.setPosition(achievementsView.getRigthSideX() + achievementsView.getCenterXForScroll(achievementsView.achScrollDown), achievementsView.achScrollUp.getY() + n7 - achievementsView.achScrollDown.getHeight());
            achievementsView.achScrollDown.paint(graphics2);
            graphics.setClip(this.x, this.y, GameLogic.width, this.height);
            graphics.translate(graphics.getTranslateX(), this.translateY);
            for (n7 = 0; n7 < 29; ++n7) {
                if (Achievements.this.rmsAchvLocks[n7] == 2) {
                    this.achievementIconsSprite.setFrame(0);
                    n5 = n7;
                    graphics2 = graphics;
                    achievementsView = this;
                    achievementsView.drawAchievement(graphics2, achievementsView.achievementIconsSprite, n5);
                    continue;
                }
                if (Achievements.this.rmsAchvLocks[n7] == 1) {
                    this.drawAchievement(graphics, this.achievementIconSprite, n7);
                    Sprite sprite = this.achievementIconSprite;
                    graphics2 = graphics;
                    achievementsView = this;
                    achievementsView.achievementCupSprite.setPosition(sprite.getX() + sprite.getWidth() - achievementsView.achievementCupSprite.getWidth(), sprite.getY() + sprite.getHeight() - achievementsView.achievementCupSprite.getHeight());
                    achievementsView.achievementCupSprite.paint(graphics2);
                    continue;
                }
                if (Achievements.this.rmsAchvLocks[n7] != 0) continue;
                this.drawAchievement(graphics, this.achievementIconSprite, n7);
            }
            graphics2 = graphics;
            achievementsView = this;
            achievementsView.cursorSprite.setPosition(achievementsView.getAchievementXFromTheFirst(achievementsView.cursorIndexPos) + achievementsView.achievementIconsSprite.getWidth() - achievementsView.cursorSprite.getWidth() / 4, achievementsView.getAchievementYFromTheFirst(achievementsView.cursorIndexPos) + achievementsView.achievementIconsSprite.getHeight() / 2 - achievementsView.cursorSprite.getHeight() / 2);
            achievementsView.cursorSprite.paint(graphics2);
            graphics.translate(graphics.getTranslateX(), -this.translateY);
            graphics.setClip(n, n2, n3, n4);
        }

        private void drawAchievement(Graphics g, Sprite sprite, int index) {
            sprite.setPosition(this.getAchievementXFromTheFirst(index), this.getAchievementYFromTheFirst(index));
            sprite.paint(g);
        }

        private int getCenterXForScroll(Sprite scrollPart) {
            return (this.achArrows.getWidth() - scrollPart.getWidth()) / 2;
        }

        private int getScrollbarLineX() {
            return this.getRigthSideX() + this.achArrows.getWidth() / 2;
        }

        private int getAchievementXFromTheFirst(int index2) {
            int n = index2;
            AchievementsView index2 = this;
            return this.x + (n % 3 * index2.achievementIconsSprite.getWidth() + n % 3 * index2.hSpace);
        }

        private int getAchievementY(int index) {
            return index / 3 * this.achievementIconsSprite.getHeight() + index / 3 * this.vSpace;
        }

        private int getAchievementYFromTheFirst(int index) {
            return this.y + this.getAchievementY(index);
        }

        public final void keyPressed(int n) {
            if (Achievements.access$100(Achievements.this, this.cursorIndexPos)) {
                Achievements.this.saveAchvLocksToRMS(this.cursorIndexPos, 0);
            }
            switch (n) {
                case 50: 
                case 85: {
                    if (this.isTranslateYValid()) {
                        if (this.cursorIndexPos - 3 + 1 <= 0) break;
                        this.cursorIndexPos -= 3;
                        this.updateTranslateForUp();
                        break;
                    }
                    this.updateInvalidTranslateForUp();
                    break;
                }
                case 56: 
                case 87: {
                    if (this.isTranslateYValid()) {
                        if (this.cursorIndexPos + 3 < 29) {
                            this.cursorIndexPos += 3;
                            this.updateTranslateForDown();
                            break;
                        }
                        if (this.cursorIndexPos + 1 >= 29 || 29 - this.cursorIndexPos < 3) break;
                        this.cursorIndexPos = 28;
                        this.updateTranslateForDown();
                        break;
                    }
                    this.updateInvalidTranslateForDown();
                    break;
                }
                case 52: 
                case 88: {
                    if (this.isTranslateYValid()) {
                        if (this.cursorIndexPos <= 0) break;
                        --this.cursorIndexPos;
                        this.updateTranslateForUp();
                        break;
                    }
                    this.updateInvalidTranslateForUp();
                    break;
                }
                case 54: 
                case 86: {
                    if (this.isTranslateYValid()) {
                        if (this.cursorIndexPos + 1 >= 29) break;
                        ++this.cursorIndexPos;
                        this.updateTranslateForDown();
                        break;
                    }
                    this.updateInvalidTranslateForDown();
                }
            }
            Achievements.this.reloadAchievementTitle(((Achievements)Achievements.this).achievementsView.cursorIndexPos);
            Achievements.this.reloadAchievementDesc(((Achievements)Achievements.this).achievementsView.cursorIndexPos);
        }

        private boolean isTranslateYValid() {
            return this.isSelectedAchievementVisible() && this.translateY % this.getAchievementFrameWithVSpaceHeight() == 0;
        }

        private void updateInvalidTranslateForUp() {
            int h = this.getAchievementFrameWithVSpaceHeight();
            this.translateY = -(this.cursorIndexPos / 3) * h;
            if (this.cursorIndexPos / 3 == 9) {
                this.translateY += h;
            }
        }

        private void updateInvalidTranslateForDown() {
            int h = this.getAchievementFrameWithVSpaceHeight();
            this.translateY = -(this.cursorIndexPos / 3) * h + h;
            if (this.cursorIndexPos / 3 == 0) {
                this.translateY -= h;
            }
        }

        private void updateTranslateForUp() {
            if (!this.isSelectedAchievementVisible()) {
                this.translateY += this.getAchievementFrameWithVSpaceHeight();
            }
        }

        private void updateTranslateForDown() {
            if (!this.isSelectedAchievementVisible()) {
                this.translateY -= this.getAchievementFrameWithVSpaceHeight();
            }
        }

        private boolean isSelectedAchievementVisible() {
            return this.isAchievementVisible(this.cursorIndexPos);
        }

        private boolean isAchievementVisible(int n) {
            return (n = this.translateY + this.getAchievementY(n)) >= 0 && n <= this.height;
        }

        private int getAchievementFrameWithVSpaceHeight() {
            return this.achievementIconsSprite.getHeight() + this.vSpace;
        }

        public final void setPosition(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public final void setSize(int width, int height) {
            this.width = width;
            this.height = height;
        }

        private int getRigthSideX() {
            return this.x + this.width;
        }

        private int getBottomSideY() {
            return this.y + this.height;
        }

        public final int getX() {
            return this.x;
        }

        public final int getY() {
            return this.y;
        }

        public final int getWidth() {
            return this.width;
        }

        public final int getHeight() {
            return this.height;
        }

        public final int getCursorIndexPos() {
            return this.cursorIndexPos;
        }
    }
}

