/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.menu;

import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Container;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.GameTemplate;
import com.tqm.fantasydefense.GraphicNumbers;
import com.tqm.fantasydefense.shop.secret.SecretElixir;
import com.tqm.fantasydefense.shop.secret.SecretGems;
import com.tqm.fantasydefense.shop.secret.SecretItemsManager;
import java.util.Calendar;
import java.util.Date;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class DailyReward {
    private static int LOTTERY_ICONS_SPACE;
    private GameLogic gameLogic;
    private long lastPlayDateInMillisRMS;
    private int lastPlayDayNumberRMS;
    private int[] rewardDay1;
    private int[] rewardDay2;
    private int[] rewardDay3;
    private int[] rewardDay4;
    private int[] rewardDay5;
    private int[] rewardDay6;
    private int[][] lotteryRewardDayInitial;
    private int[][] lotteryRewardDayFinal;
    private Random random;
    private boolean rewardGranted;
    private int grantedRewardType;
    private int grantedRewardValue;
    private SecretItemsManager itemsManager;
    private SecretElixir[] secretElixirs;
    private Sprite grantedRewardSprite;
    private boolean startLottery;
    private int grantedLotteryRewardIndex;
    private Sprite[] lotteryRewardSprites;
    private int lotteryRewardBoundaryLeftX;
    private int lotteryRewardBoundaryRightX;
    private int lotteryRewardBoundaryY;
    private int lotteryRewardBoundaryWidth;
    private int lotteryRewardBoundaryHeight;
    private int lotteryRewardOutOfBoundaryIndex;
    private int lotteryRewardFrameLeftX;
    private int lotteryRewardFrameWidth;
    private int currT;
    private int prevS;
    private int totalS;
    private int totalT;
    private int currStage;
    private int currLotteryStageAnimFrame;
    private Container desc;
    private FramedPaper lotteryFramedPaper;
    private Sprite lotteryBoardSprite;
    private Sprite lotteryFrontBoardSprite;
    private Sprite lotteryWallSprite;
    private Sprite lotterySpinShelfSprite;
    private Sprite lotterySpinPointerSprite;
    private Sprite lotteryShutterStage2Sprite;
    private Sprite lotterySpinLightSprite;
    private Sprite lotteryQuestionMarkSprite;
    private Sprite rewardWindowSprite;
    private Sprite rewardBackgroundSprite;
    private Sprite rewardLeftSprite;
    private Sprite rewardRightSprite;
    private Sprite rewardShutterSprite;
    private Sprite rewardSashSprite;
    private Sprite rewardHillSprite;
    private Sprite shutterSprite;
    private Sprite zabkiSprite;
    private Sprite graphicNumberSprite;
    private GraphicNumbers graphicNumber;
    private int questionMarkSpriteY;
    private int questionMarkSpriteYShift;
    private int lotteryStage1ZabkiHSpace;
    private int lotteryStage1ZabkiX;
    private int lotteryStage2ZabkiHSpace;
    private int lotteryStageRestZabkiHSpace;
    private int rewardShutterX;
    private int rewardShutterY;
    private int rewardStage1ZabkiHSpace;
    private int rewardStage1ZabkiX;
    private int rewardStage2ZabkiHSpace;
    private int shutterSpriteY;
    private int zabkiSpriteY;
    private int titleY;
    private int titleVSpace;

    public DailyReward(GameLogic gameLogic) {
        this.gameLogic = gameLogic;
        this.random = new Random();
        this.lotteryFramedPaper = new FramedPaper();
        this.itemsManager = SecretItemsManager.getInstance();
        this.secretElixirs = this.itemsManager.getElixirs();
        gameLogic = this;
        this.rewardDay1 = new int[]{1, 20};
        ((DailyReward)gameLogic).rewardDay2 = new int[]{3, 40};
        ((DailyReward)gameLogic).rewardDay3 = new int[]{1, 40};
        ((DailyReward)gameLogic).rewardDay4 = new int[]{3, 60};
        ((DailyReward)gameLogic).rewardDay5 = new int[]{1, 60};
        ((DailyReward)gameLogic).rewardDay6 = new int[]{4, 60};
        ((DailyReward)gameLogic).lotteryRewardDayInitial = new int[][]{{2, 75}, {1, 75}, {4, 0, 75}, {4, 6, 75}, {4, 2, 75}, {4, 4, 75}};
        ((DailyReward)gameLogic).lotteryRewardDayFinal = new int[((DailyReward)gameLogic).lotteryRewardDayInitial.length][];
        this.lotteryRewardSprites = new Sprite[this.lotteryRewardDayInitial.length];
        this.desc = new Container(MainLogic.width, MainLogic.height, 129);
        FramedPaper.setContainerParams(this.desc);
        this.graphicNumber = new GraphicNumbers();
        gameLogic = this.graphicNumber;
        GameLogic.disposeImage(223);
        ((GraphicNumbers)gameLogic).numbersSprite = null;
    }

    public static String getDefaultDateToRMS() {
        return Long.toString(System.currentTimeMillis() - 172800000L);
    }

    public final void loadDateFromRMS() {
        this.lastPlayDateInMillisRMS = Long.parseLong(this.gameLogic.getGData().loadAsString(46));
    }

    public final void loadDayNumberFromRMS() {
        this.lastPlayDayNumberRMS = this.gameLogic.getGData().loadAsInt(47);
    }

    public final void init() {
        int n;
        Object object;
        DailyReward dailyReward;
        DailyReward dailyReward2 = this;
        dailyReward2.gameLogic.getGData().save(Long.toString(dailyReward2.lastPlayDateInMillisRMS), 46);
        dailyReward2 = this;
        dailyReward2.gameLogic.getGData().save(dailyReward2.lastPlayDayNumberRMS, 47);
        dailyReward2 = this;
        this.rewardGranted = false;
        if (dailyReward2.lastPlayDayNumberRMS != 7) {
            dailyReward2.currStage = 1;
        }
        switch (dailyReward2.lastPlayDayNumberRMS) {
            case 1: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay1);
                break;
            }
            case 2: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay2);
                break;
            }
            case 3: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay3);
                break;
            }
            case 4: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay4);
                break;
            }
            case 5: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay5);
                break;
            }
            case 6: {
                dailyReward2.initRewardParams(dailyReward2.rewardDay6);
                break;
            }
            case 7: {
                int n2;
                dailyReward2.currStage = 1;
                dailyReward2.currLotteryStageAnimFrame = 1;
                dailyReward = dailyReward2;
                int[][] nArrayArray = new int[dailyReward.lotteryRewardDayInitial.length][];
                for (n2 = 0; n2 < nArrayArray.length; ++n2) {
                    nArrayArray[n2] = new int[dailyReward.lotteryRewardDayInitial[n2].length];
                    System.arraycopy(dailyReward.lotteryRewardDayInitial[n2], 0, nArrayArray[n2], 0, dailyReward.lotteryRewardDayInitial[n2].length);
                }
                for (n2 = 0; n2 < nArrayArray.length; ++n2) {
                    if (nArrayArray[n2][0] != 4 || !dailyReward.secretElixirs[nArrayArray[n2][1]].isActive()) continue;
                    nArrayArray[n2][0] = 1;
                    nArrayArray[n2][1] = nArrayArray[n2][2];
                }
                object = new Vector<int[]>(dailyReward.lotteryRewardDayInitial.length);
                for (n = 0; n < nArrayArray.length; ++n) {
                    ((Vector)object).addElement(nArrayArray[n]);
                }
                for (n = 0; n < dailyReward.lotteryRewardDayFinal.length; ++n) {
                    int n3 = Math.abs(dailyReward.random.nextInt()) % ((Vector)object).size();
                    dailyReward.lotteryRewardDayFinal[n] = (int[])((Vector)object).elementAt(n3);
                    ((Vector)object).removeElementAt(n3);
                }
                dailyReward.startLottery = false;
            }
        }
        dailyReward2 = this;
        switch (dailyReward2.lastPlayDayNumberRMS) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                dailyReward = dailyReward2;
                dailyReward2.rewardWindowSprite = GameLogic.loadSprite(19);
                dailyReward.rewardBackgroundSprite = GameLogic.loadSprite(1);
                dailyReward.rewardLeftSprite = GameLogic.loadSprite(8);
                dailyReward.rewardRightSprite = GameLogic.loadSprite(7);
                dailyReward.rewardShutterSprite = GameLogic.loadSprite(88);
                dailyReward.rewardSashSprite = GameLogic.loadSprite(12);
                dailyReward.rewardHillSprite = GameLogic.loadSprite(33);
                dailyReward.grantedRewardSprite = DailyReward.loadSpriteByRewardType(dailyReward.grantedRewardType, dailyReward.grantedRewardValue);
                break;
            }
            case 7: {
                dailyReward2.loadLotterySprites();
            }
        }
        dailyReward = dailyReward2;
        dailyReward2.shutterSprite = GameLogic.loadSprite(102);
        dailyReward.zabkiSprite = GameLogic.loadSprite(136);
        dailyReward.graphicNumber.numbersSprite = dailyReward.graphicNumberSprite = GameLogic.loadSprite(224);
        dailyReward = dailyReward2 = this;
        dailyReward2.titleVSpace = -dailyReward2.gameLogic.getFontWrapper().getHeight() / 4;
        switch (dailyReward2.lastPlayDayNumberRMS) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: {
                dailyReward2.setRewardSpritesPositions();
                dailyReward2.updateDescText(MainLogic.replaceKeyString(MainLogic.strings[313], "[x]", Integer.toString(7 - dailyReward2.lastPlayDayNumberRMS)) + " " + MainLogic.strings[312]);
                break;
            }
            case 6: {
                dailyReward2.setRewardSpritesPositions();
                dailyReward2.updateDescText(MainLogic.strings[314] + " " + MainLogic.strings[312]);
                break;
            }
            case 7: {
                LOTTERY_ICONS_SPACE = dailyReward2.lotterySpinLightSprite.getWidth();
                dailyReward2.setLotterySpritesPositions();
                dailyReward2.updateDescText(MainLogic.strings[315]);
            }
        }
        if (this.lastPlayDayNumberRMS == 7) {
            dailyReward2 = this;
            object = dailyReward2;
            dailyReward2.grantedLotteryRewardIndex = Math.abs(dailyReward2.random.nextInt()) % ((DailyReward)object).lotteryRewardDayFinal.length;
            ((DailyReward)object).grantedRewardType = ((DailyReward)object).lotteryRewardDayFinal[((DailyReward)object).grantedLotteryRewardIndex][0];
            ((DailyReward)object).grantedRewardValue = ((DailyReward)object).lotteryRewardDayFinal[((DailyReward)object).grantedLotteryRewardIndex][1];
            dailyReward = ((DailyReward)object).lotteryRewardSprites[((DailyReward)object).grantedLotteryRewardIndex];
            dailyReward2.currT = 0;
            dailyReward2.prevS = 0;
            dailyReward2.totalT = 100;
            dailyReward2.totalS = DailyReward.getCurrS(dailyReward2.totalT);
            n = dailyReward.getX() + dailyReward.getWidth() / 2;
            object = dailyReward2;
            int n4 = ((DailyReward)object).lotteryRewardFrameLeftX + ((DailyReward)object).lotteryRewardFrameWidth / 2;
            int n5 = n > n4 ? ((DailyReward)object).lotteryRewardBoundaryWidth - (n - n4) : n4 - n;
            object = dailyReward2;
            n4 = n5 - ((DailyReward)object).totalS % ((DailyReward)object).lotteryRewardBoundaryWidth;
            if (n4 < 0) {
                n4 += dailyReward2.lotteryRewardBoundaryWidth;
            }
            dailyReward2.updateLotteryItemsPositions(n4);
        }
    }

    private void initRewardParams(int[] nArray) {
        this.grantedRewardType = nArray[0];
        if (this.grantedRewardType == 3) {
            this.initElixirReward(this.itemsManager.getInactiveSmallElixirsIds(), nArray);
            return;
        }
        if (this.grantedRewardType == 4) {
            this.initElixirReward(this.itemsManager.getInactiveBigElixirsIds(), nArray);
            return;
        }
        this.grantedRewardValue = nArray[1];
    }

    private void initElixirReward(int[] nArray, int[] nArray2) {
        if (nArray.length == 0) {
            this.grantedRewardType = 1;
            this.grantedRewardValue = nArray2[1];
            return;
        }
        this.grantedRewardValue = nArray[Math.abs(this.random.nextInt()) % nArray.length];
    }

    private static Sprite loadSpriteByRewardType(int n, int n2) {
        switch (n) {
            case 1: {
                Sprite sprite = GameLogic.loadSprite(222);
                sprite.setFrame(2);
                return sprite;
            }
            case 2: {
                Sprite sprite = GameLogic.loadSprite(132);
                sprite.setFrame(0);
                return sprite;
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        Sprite sprite = GameLogic.loadSprite(83);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 3: {
                        Sprite sprite = GameLogic.loadSprite(78);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 5: {
                        Sprite sprite = GameLogic.loadSprite(85);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 7: {
                        Sprite sprite = GameLogic.loadSprite(86);
                        sprite.setFrame(0);
                        return sprite;
                    }
                }
                break;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        Sprite sprite = GameLogic.loadSprite(55);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 2: {
                        Sprite sprite = GameLogic.loadSprite(49);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 4: {
                        Sprite sprite = GameLogic.loadSprite(48);
                        sprite.setFrame(0);
                        return sprite;
                    }
                    case 6: {
                        Sprite sprite = GameLogic.loadSprite(61);
                        sprite.setFrame(0);
                        return sprite;
                    }
                }
            }
        }
        return null;
    }

    private void loadLotterySprites() {
        this.lotteryFramedPaper.loadSprites();
        this.lotteryBoardSprite = GameLogic.loadSprite(20);
        this.lotteryFrontBoardSprite = GameLogic.loadSprite(110);
        this.lotteryWallSprite = GameLogic.loadSprite(35);
        this.lotterySpinShelfSprite = GameLogic.loadSprite(9);
        this.lotterySpinPointerSprite = GameLogic.loadSprite(91);
        this.lotteryShutterStage2Sprite = GameLogic.loadSprite(45);
        this.lotterySpinLightSprite = GameLogic.loadSprite(90);
        this.lotteryQuestionMarkSprite = GameLogic.loadSprite(109);
        for (int i = 0; i < this.lotteryRewardDayFinal.length; ++i) {
            this.lotteryRewardSprites[i] = DailyReward.loadSpriteByRewardType(this.lotteryRewardDayFinal[i][0], this.lotteryRewardDayFinal[i][1]);
        }
    }

    private void setRewardSpritesPositions() {
        this.rewardBackgroundSprite.setPosition((MainLogic.width - this.rewardBackgroundSprite.getWidth()) / 2, (MainLogic.height - this.rewardBackgroundSprite.getHeight()) / 2);
        GameLogic.setSashSpritePosition(this.rewardSashSprite);
        this.rewardWindowSprite.setPosition((MainLogic.width - this.rewardWindowSprite.getWidth()) / 2, MainLogic.height * 9 / 40);
        GameLogic.setHillSpritePosition(this.rewardHillSprite);
        this.rewardLeftSprite.setPosition(0, MainLogic.height - this.rewardLeftSprite.getHeight());
        this.rewardRightSprite.setPosition(MainLogic.width - this.rewardRightSprite.getWidth(), MainLogic.height - this.rewardRightSprite.getHeight());
        this.grantedRewardSprite.setPosition(this.rewardWindowSprite.getX() + (this.rewardWindowSprite.getWidth() - this.grantedRewardSprite.getWidth()) / 2, this.rewardWindowSprite.getY() + this.rewardWindowSprite.getHeight() * 19 / 22 - this.grantedRewardSprite.getHeight());
        this.titleY = this.rewardWindowSprite.getY() + this.rewardWindowSprite.getHeight() + MainLogic.height / 26;
        this.desc.setSize(MainLogic.width * 17 / 24, MainLogic.height * 3 / 16);
        this.desc.setPosition((MainLogic.width - this.desc.getWidth()) / 2, this.titleY + this.gameLogic.getFontWrapper().getHeight() + this.titleVSpace);
        this.rewardShutterX = this.rewardWindowSprite.getX() + (this.rewardWindowSprite.getWidth() - 6 * this.shutterSprite.getWidth()) / 2;
        this.rewardShutterY = this.rewardWindowSprite.getY() + this.rewardWindowSprite.getHeight() / 8;
        this.rewardStage1ZabkiHSpace = this.getZabkiSpace(6 * this.shutterSprite.getWidth(), 6, 6);
        this.rewardStage1ZabkiX = this.rewardWindowSprite.getX() + this.rewardWindowSprite.getWidth() / 2 - this.rewardStage1ZabkiHSpace / 2 - this.zabkiSprite.getWidth();
        this.zabkiSpriteY = this.getZabkiSpriteY(this.rewardShutterY);
        this.rewardStage2ZabkiHSpace = this.getZabkiSpace(this.rewardShutterSprite.getWidth(), 3, 4);
    }

    private int getZabkiSpace(int width, int zabkiAmount, int spacesAmount) {
        return (width - zabkiAmount * this.zabkiSprite.getWidth()) / spacesAmount;
    }

    private int getZabkiSpriteY(int shutterY) {
        return shutterY - this.zabkiSprite.getHeight() + (this.zabkiSprite.getHeight() << 1) / 13;
    }

    private void setLotterySpritesPositions() {
        int n;
        this.lotteryRewardBoundaryWidth = 0;
        for (int i = 0; i < this.lotteryRewardSprites.length; ++i) {
            this.lotteryRewardBoundaryWidth += this.lotteryRewardSprites[i].getWidth() + LOTTERY_ICONS_SPACE;
        }
        this.lotteryRewardBoundaryLeftX = (MainLogic.width - this.lotteryRewardBoundaryWidth) / 2;
        this.lotteryRewardOutOfBoundaryIndex = -1;
        this.shutterSpriteY = this.lotterySpinShelfSprite.getHeight() * 83 / 163;
        DailyReward dailyReward = this;
        int n2 = 0;
        for (n = 0; n < dailyReward.lotteryRewardSprites.length; ++n) {
            if (n2 >= dailyReward.lotteryRewardSprites[n].getHeight()) continue;
            n2 = dailyReward.lotteryRewardSprites[n].getHeight();
        }
        if (n2 < dailyReward.lotteryQuestionMarkSprite.getHeight()) {
            n2 = DailyReward.loadSpriteByRewardType(4, 4).getHeight();
            DailyReward.disposeSpriteByRewardType(4, 4);
        }
        this.lotteryRewardBoundaryHeight = n2;
        this.lotteryRewardBoundaryY = this.shutterSpriteY + (this.shutterSprite.getHeight() - this.lotteryRewardBoundaryHeight) / 2;
        int n3 = this.lotteryRewardBoundaryLeftX;
        for (n2 = 0; n2 < this.lotteryRewardSprites.length; ++n2) {
            n = this.lotteryRewardBoundaryY + this.lotteryRewardBoundaryHeight - this.lotteryRewardSprites[n2].getHeight();
            if (this.lotteryRewardDayFinal[n2][0] == 2) {
                n -= this.lotteryRewardSprites[n2].getHeight() * 3 / 14;
            }
            this.lotteryRewardSprites[n2].setPosition(n3, n);
            n3 += this.lotteryRewardSprites[n2].getWidth() + LOTTERY_ICONS_SPACE;
        }
        this.lotteryRewardBoundaryRightX = n3 - 1;
        this.lotteryRewardFrameWidth = MainLogic.width / 2;
        this.lotteryRewardFrameLeftX = (MainLogic.width - this.lotteryRewardFrameWidth) / 2;
        n2 = this.lotterySpinPointerSprite.getHeight() * 11 / 24;
        this.lotterySpinPointerSprite.setPosition((MainLogic.width - this.lotterySpinPointerSprite.getWidth()) / 2, this.lotterySpinShelfSprite.getHeight() - n2);
        this.lotteryFramedPaper.setFramePosition((MainLogic.width - this.lotteryFramedPaper.getWideFrameWidth()) / 2, this.lotterySpinShelfSprite.getHeight());
        this.lotteryBoardSprite.setPosition(0, this.lotteryFramedPaper.getY() + this.lotteryFramedPaper.getLowFrameHeight());
        this.questionMarkSpriteY = this.lotteryRewardBoundaryY + (this.lotteryRewardBoundaryHeight - this.lotteryQuestionMarkSprite.getHeight()) / 2;
        this.questionMarkSpriteYShift = this.lotteryQuestionMarkSprite.getHeight() / 19;
        this.lotteryQuestionMarkSprite.setPosition((MainLogic.width - this.lotteryQuestionMarkSprite.getWidth()) / 2, this.questionMarkSpriteY);
        this.zabkiSpriteY = this.getZabkiSpriteY(this.shutterSpriteY);
        n = (this.lotterySpinShelfSprite.getHeight() << 3) / 119;
        n3 = this.lotterySpinShelfSprite.getHeight() * 50 / 119 - n;
        this.titleY = n + (n3 - ((this.gameLogic.getFontWrapper().getHeight() << 1) + this.titleVSpace)) / 2;
        this.desc.setSize(this.lotteryFramedPaper.getWidePaperWidth() - 2 * this.lotteryFramedPaper.getHorizontalPaperMargin(), this.lotteryFramedPaper.getLowPaperHeight() - 2 * this.lotteryFramedPaper.getVerticalPaperMargin());
        this.desc.setPosition(this.lotteryFramedPaper.getPaperX() + this.lotteryFramedPaper.getHorizontalPaperMargin(), this.lotteryFramedPaper.getPaperY() + this.lotteryFramedPaper.getVerticalPaperMargin());
        this.lotteryStage1ZabkiHSpace = this.getZabkiSpace(MainLogic.width, 15, 16);
        this.lotteryStage1ZabkiX = (MainLogic.width - this.zabkiSprite.getWidth()) / 2;
        this.lotteryStage2ZabkiHSpace = this.getZabkiSpace(5 * this.shutterSprite.getWidth(), 5, 4);
        this.lotteryStageRestZabkiHSpace = this.getZabkiSpace(3 * this.shutterSprite.getWidth(), 5, 4);
    }

    public final void deinit() {
        DailyReward dailyReward = this;
        switch (dailyReward.lastPlayDayNumberRMS) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                MainLogic.disposeImage(19);
                MainLogic.disposeImage(1);
                MainLogic.disposeImage(8);
                MainLogic.disposeImage(7);
                MainLogic.disposeImage(88);
                MainLogic.disposeImage(12);
                MainLogic.disposeImage(102);
                MainLogic.disposeImage(136);
                MainLogic.disposeImage(33);
                MainLogic.disposeImage(224);
                dailyReward.rewardWindowSprite = null;
                dailyReward.rewardBackgroundSprite = null;
                dailyReward.rewardLeftSprite = null;
                dailyReward.rewardRightSprite = null;
                dailyReward.rewardShutterSprite = null;
                dailyReward.rewardSashSprite = null;
                dailyReward.shutterSprite = null;
                dailyReward.zabkiSprite = null;
                dailyReward.rewardHillSprite = null;
                dailyReward.graphicNumberSprite = null;
                dailyReward.graphicNumber.numbersSprite = null;
                DailyReward.disposeSpriteByRewardType(dailyReward.grantedRewardType, dailyReward.grantedRewardValue);
                dailyReward.grantedRewardSprite = null;
                return;
            }
            case 7: {
                dailyReward.lotteryFramedPaper.disposeSprites();
                MainLogic.disposeImage(20);
                MainLogic.disposeImage(110);
                MainLogic.disposeImage(35);
                MainLogic.disposeImage(9);
                MainLogic.disposeImage(91);
                MainLogic.disposeImage(102);
                MainLogic.disposeImage(136);
                MainLogic.disposeImage(90);
                MainLogic.disposeImage(45);
                MainLogic.disposeImage(109);
                MainLogic.disposeImage(224);
                dailyReward.lotteryBoardSprite = null;
                dailyReward.lotteryFrontBoardSprite = null;
                dailyReward.lotteryWallSprite = null;
                dailyReward.lotterySpinShelfSprite = null;
                dailyReward.lotterySpinPointerSprite = null;
                dailyReward.shutterSprite = null;
                dailyReward.lotteryShutterStage2Sprite = null;
                dailyReward.zabkiSprite = null;
                dailyReward.lotterySpinLightSprite = null;
                dailyReward.lotteryQuestionMarkSprite = null;
                dailyReward.graphicNumberSprite = null;
                dailyReward.graphicNumber.numbersSprite = null;
                for (int i = 0; i < dailyReward.lotteryRewardDayFinal.length; ++i) {
                    DailyReward.disposeSpriteByRewardType(dailyReward.lotteryRewardDayFinal[i][0], dailyReward.lotteryRewardDayFinal[i][1]);
                    dailyReward.lotteryRewardSprites[i] = null;
                }
                break;
            }
        }
    }

    private static void disposeSpriteByRewardType(int n, int n2) {
        switch (n) {
            case 1: {
                MainLogic.disposeImage(222);
            }
            case 2: {
                MainLogic.disposeImage(132);
            }
            case 3: {
                switch (n2) {
                    case 1: {
                        MainLogic.disposeImage(83);
                    }
                    case 3: {
                        MainLogic.disposeImage(78);
                    }
                    case 5: {
                        MainLogic.disposeImage(85);
                    }
                    case 7: {
                        MainLogic.disposeImage(86);
                    }
                }
                return;
            }
            case 4: {
                switch (n2) {
                    case 0: {
                        MainLogic.disposeImage(55);
                    }
                    case 2: {
                        MainLogic.disposeImage(49);
                    }
                    case 4: {
                        MainLogic.disposeImage(48);
                    }
                    case 6: {
                        MainLogic.disposeImage(61);
                    }
                }
            }
        }
    }

    private void updateDescText(String string) {
        this.desc.setText$40907f8c(string, GameLogic.getSystemFont(), null, 3);
    }

    public final void setReward(int day) {
        this.lastPlayDateInMillisRMS = System.currentTimeMillis() - 86400000L;
        this.lastPlayDayNumberRMS = day;
    }

    public final boolean isDailyReward() {
        Calendar c = Calendar.getInstance();
        long currDateInMillis = System.currentTimeMillis();
        Date currDateMinusOneDayDate = new Date(currDateInMillis - 86400000L);
        Date lastPlayDate = new Date(this.lastPlayDateInMillisRMS);
        c.setTime(currDateMinusOneDayDate);
        int cDay = c.get(5);
        int cMonth = c.get(2);
        int cYear = c.get(1);
        c.setTime(lastPlayDate);
        int lDay = c.get(5);
        int lMonth = c.get(2);
        int lYear = c.get(1);
        if (cDay == lDay && cMonth == lMonth && cYear == lYear) {
            this.lastPlayDateInMillisRMS = currDateInMillis;
            this.lastPlayDayNumberRMS = this.lastPlayDayNumberRMS % 7 + 1;
            return true;
        }
        Date currDate22 = new Date(currDateInMillis);
        c.setTime(currDate22);
        int currDate22 = c.get(5);
        cMonth = c.get(2);
        cYear = c.get(1);
        if (currDate22 == lDay && cMonth == lMonth && cYear == lYear) {
            return false;
        }
        this.lastPlayDateInMillisRMS = currDateInMillis;
        this.lastPlayDayNumberRMS = 1;
        return true;
    }

    public final void keyPressed(int n) {
        switch (n) {
            case 53: 
            case 89: 
            case 91: {
                if (this.lastPlayDayNumberRMS == 7) {
                    switch (this.currStage) {
                        case 1: {
                            ++this.currStage;
                            this.updateDescText(MainLogic.strings[316]);
                            return;
                        }
                        case 3: {
                            ++this.currStage;
                            this.startLottery = true;
                            this.updateDescText(MainLogic.strings[319]);
                            return;
                        }
                        case 4: {
                            this.markReward();
                        }
                    }
                    return;
                }
                switch (this.currStage) {
                    case 1: {
                        ++this.currStage;
                        this.rewardGranted = true;
                        switch (this.grantedRewardType) {
                            case 4: {
                                this.updateDescText(MainLogic.strings[311]);
                                return;
                            }
                            case 1: {
                                this.updateDescText(MainLogic.replaceKeyString(MainLogic.strings[309], "[X]", Integer.toString(this.grantedRewardValue)));
                                return;
                            }
                            case 3: {
                                this.updateDescText(MainLogic.strings[310]);
                            }
                        }
                        return;
                    }
                    case 2: {
                        this.markReward();
                    }
                }
                return;
            }
            case 50: 
            case 56: 
            case 85: 
            case 87: {
                this.desc.keyPressed(n);
            }
        }
    }

    private void markReward() {
        if (this.rewardGranted) {
            DailyReward dailyReward = this;
            if (dailyReward.grantedRewardType == 3 || dailyReward.grantedRewardType == 4) {
                dailyReward.secretElixirs[dailyReward.grantedRewardValue].grantElixirAsReward();
                dailyReward.rewardGranted = false;
            } else if (dailyReward.grantedRewardType == 2) {
                SecretGems.grantGemsAsReward(dailyReward.grantedRewardValue);
                dailyReward.rewardGranted = false;
            }
            GameLogic.changeState(17, 204, 1, false);
        }
    }

    public final void draw(Graphics object) {
        switch (this.lastPlayDayNumberRMS) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                Graphics graphics = object;
                object = this;
                block4 : switch (((DailyReward)object).currStage) {
                    case 1: {
                        int n;
                        Graphics graphics2 = graphics;
                        Object object2 = object;
                        GameLogic.drawDoubleGradient(graphics2, -11143954, -793179, -5057986, MainLogic.height);
                        ((DailyReward)object2).rewardWindowSprite.paint(graphics2);
                        int n2 = ((DailyReward)object2).rewardShutterX;
                        for (n = 0; n < 6; ++n) {
                            ((DailyReward)object2).shutterSprite.setTransform(0);
                            ((DailyReward)object2).shutterSprite.setPosition(n2, ((DailyReward)object2).rewardShutterY);
                            ((DailyReward)object2).shutterSprite.paint(graphics2);
                            n2 += ((DailyReward)object2).shutterSprite.getWidth();
                        }
                        for (n = 0; n < 3; ++n) {
                            ((DailyReward)object2).zabkiSprite.setFrame(0);
                            ((DailyReward)object2).zabkiSprite.setTransform(0);
                            ((DailyReward)object2).zabkiSprite.setPosition(((DailyReward)object2).rewardStage1ZabkiX - n * ((DailyReward)object2).zabkiSprite.getWidth() - n * ((DailyReward)object2).rewardStage1ZabkiHSpace, ((DailyReward)object2).zabkiSpriteY);
                            ((DailyReward)object2).zabkiSprite.paint(graphics2);
                            ((DailyReward)object2).zabkiSprite.setFrame(0);
                            ((DailyReward)object2).zabkiSprite.setTransform(2);
                            ((DailyReward)object2).zabkiSprite.setPosition(((DailyReward)object2).rewardStage1ZabkiX + (n + 1) * ((DailyReward)object2).zabkiSprite.getWidth() + (n + 1) * ((DailyReward)object2).rewardStage1ZabkiHSpace, ((DailyReward)object2).zabkiSpriteY);
                            ((DailyReward)object2).zabkiSprite.paint(graphics2);
                        }
                        break;
                    }
                    case 2: {
                        int n;
                        Graphics graphics3 = graphics;
                        Object object3 = object;
                        ((DailyReward)object3).rewardBackgroundSprite.paint(graphics3);
                        ((DailyReward)object3).rewardWindowSprite.paint(graphics3);
                        ((DailyReward)object3).rewardShutterSprite.setTransform(0);
                        ((DailyReward)object3).rewardShutterSprite.setPosition(((DailyReward)object3).rewardShutterX, ((DailyReward)object3).rewardShutterY);
                        ((DailyReward)object3).rewardShutterSprite.paint(graphics3);
                        int n3 = ((DailyReward)object3).rewardShutterSprite.getX() + ((DailyReward)object3).rewardStage2ZabkiHSpace;
                        for (n = 0; n < 3; ++n) {
                            ((DailyReward)object3).zabkiSprite.setFrame(0);
                            ((DailyReward)object3).zabkiSprite.setTransform(0);
                            ((DailyReward)object3).zabkiSprite.setPosition(n3 + n * ((DailyReward)object3).zabkiSprite.getWidth() + n * ((DailyReward)object3).rewardStage2ZabkiHSpace, ((DailyReward)object3).zabkiSpriteY);
                            ((DailyReward)object3).zabkiSprite.paint(graphics3);
                        }
                        ((DailyReward)object3).rewardShutterSprite.setTransform(2);
                        ((DailyReward)object3).rewardShutterSprite.setPosition(((DailyReward)object3).rewardWindowSprite.getX() + ((DailyReward)object3).rewardWindowSprite.getWidth() - (((DailyReward)object3).rewardShutterX - ((DailyReward)object3).rewardWindowSprite.getX()) - ((DailyReward)object3).rewardShutterSprite.getWidth(), ((DailyReward)object3).rewardShutterY);
                        ((DailyReward)object3).rewardShutterSprite.paint(graphics3);
                        n3 = ((DailyReward)object3).rewardShutterSprite.getX() + ((DailyReward)object3).rewardShutterSprite.getWidth() - ((DailyReward)object3).zabkiSprite.getWidth() - ((DailyReward)object3).rewardStage2ZabkiHSpace;
                        for (n = 0; n < 3; ++n) {
                            ((DailyReward)object3).zabkiSprite.setFrame(0);
                            ((DailyReward)object3).zabkiSprite.setTransform(2);
                            ((DailyReward)object3).zabkiSprite.setPosition(n3 - n * ((DailyReward)object3).zabkiSprite.getWidth() - n * ((DailyReward)object3).rewardStage2ZabkiHSpace, ((DailyReward)object3).zabkiSpriteY);
                            ((DailyReward)object3).zabkiSprite.paint(graphics3);
                        }
                        Sprite sprite = ((DailyReward)object3).grantedRewardSprite;
                        switch (((DailyReward)object3).grantedRewardType) {
                            case 1: {
                                super.drawRewardWithValue(graphics3, sprite, ((DailyReward)object3).grantedRewardValue);
                                break block4;
                            }
                            case 2: {
                                super.drawRewardWithValue(graphics3, sprite, ((DailyReward)object3).grantedRewardValue);
                                break block4;
                            }
                            case 3: 
                            case 4: {
                                sprite.paint(graphics3);
                            }
                        }
                    }
                }
                ((DailyReward)object).rewardHillSprite.paint(graphics);
                ((DailyReward)object).rewardLeftSprite.paint(graphics);
                ((DailyReward)object).rewardRightSprite.paint(graphics);
                ((DailyReward)object).rewardSashSprite.paint(graphics);
                ((DailyReward)object).gameLogic.drawMenuTitle(graphics, MainLogic.strings[317], ((DailyReward)object).rewardSashSprite.getY(), ((DailyReward)object).rewardSashSprite.getHeight());
                ((DailyReward)object).gameLogic.getFontWrapper().drawString(graphics, MainLogic.strings[320] + " " + ((DailyReward)object).lastPlayDayNumberRMS, MainLogic.width / 2, ((DailyReward)object).titleY, 17);
                GameLogic.setMenuScrollbarColor();
                ((DailyReward)object).desc.setPosition(((DailyReward)object).desc.getX(), ((DailyReward)object).desc.getY());
                ((DailyReward)object).desc.draw(graphics);
                return;
            }
            case 7: {
                this.drawLottery((Graphics)object);
            }
        }
    }

    private void drawRewardWithValue(Graphics graphics, Sprite sprite, int n) {
        int n2;
        sprite.paint(graphics);
        int n3 = sprite.getX() + sprite.getWidth() / 2;
        DailyReward dailyReward = this;
        switch (dailyReward.lastPlayDayNumberRMS) {
            case 7: {
                n2 = dailyReward.lotterySpinShelfSprite.getY() + dailyReward.lotterySpinShelfSprite.getHeight() * 104 / 163;
                break;
            }
            default: {
                n2 = dailyReward.rewardWindowSprite.getY() + dailyReward.rewardWindowSprite.getHeight() * 34 / 88;
            }
        }
        int n4 = n2;
        this.graphicNumber.drawNumber(graphics, "+" + n, n3, n4, 17);
    }

    private void drawLottery(Graphics graphics) {
        this.lotterySpinShelfSprite.setTransform(2);
        this.lotterySpinShelfSprite.setPosition((MainLogic.width - (this.lotterySpinShelfSprite.getWidth() << 1)) / 2, 0);
        this.lotterySpinShelfSprite.paint(graphics);
        this.lotterySpinShelfSprite.setTransform(0);
        this.lotterySpinShelfSprite.setPosition(MainLogic.width / 2, 0);
        this.lotterySpinShelfSprite.paint(graphics);
        Graphics graphics2 = graphics;
        DailyReward dailyReward = this;
        dailyReward.gameLogic.getFontWrapper().drawString(graphics2, MainLogic.strings[320] + " " + dailyReward.lastPlayDayNumberRMS, MainLogic.width / 2, dailyReward.titleY, 17);
        dailyReward.gameLogic.getFontWrapper().drawString(graphics2, MainLogic.strings[318], MainLogic.width / 2, dailyReward.titleY + dailyReward.gameLogic.getFontWrapper().getHeight() + dailyReward.titleVSpace, 17);
        int n = this.lotterySpinShelfSprite.getHeight();
        while (n - this.lotteryWallSprite.getHeight() < this.lotteryBoardSprite.getY()) {
            this.lotteryWallSprite.setPosition(0, n);
            this.lotteryWallSprite.paint(graphics);
            n += this.lotteryWallSprite.getHeight();
        }
        this.lotteryFramedPaper.drawWideLowFramedPaper(graphics);
        this.lotterySpinPointerSprite.paint(graphics);
        this.lotteryBoardSprite.paint(graphics);
        for (n = 0; n < MainLogic.width; n += this.lotteryFrontBoardSprite.getWidth()) {
            this.lotteryFrontBoardSprite.setPosition(n, this.lotteryBoardSprite.getY() + this.lotteryBoardSprite.getHeight());
            this.lotteryFrontBoardSprite.paint(graphics);
        }
        switch (this.currStage) {
            case 1: {
                this.drawLotteryShutterStage1(graphics);
                break;
            }
            case 2: {
                this.drawLotteryQuestionMark(graphics);
                this.drawLotteryShutterStage2(graphics);
                break;
            }
            case 3: {
                this.drawLotteryQuestionMark(graphics);
                graphics2 = graphics;
                this.drawLotteryExposedShutters(graphics2);
                break;
            }
            case 4: {
                if (this.rewardGranted) {
                    this.lotterySpinLightSprite.setTransform(2);
                    this.lotterySpinLightSprite.setPosition((MainLogic.width - 2 * this.lotterySpinLightSprite.getWidth()) / 2, this.shutterSpriteY);
                    this.lotterySpinLightSprite.paint(graphics);
                    this.lotterySpinLightSprite.setTransform(0);
                    this.lotterySpinLightSprite.setPosition(MainLogic.width / 2, this.shutterSpriteY);
                    this.lotterySpinLightSprite.paint(graphics);
                }
                this.drawLotteryItems(graphics);
                graphics2 = graphics;
                this.drawLotteryExposedShutters(graphics2);
            }
        }
        GameLogic.setMenuScrollbarColor();
        this.desc.setPosition(this.desc.getX(), this.desc.getY());
        this.desc.draw(graphics);
    }

    private void drawLotteryShutterStage1(Graphics graphics) {
        try {
            int n;
            for (n = 0; n < MainLogic.width; n += this.shutterSprite.getWidth()) {
                this.shutterSprite.setTransform(0);
                this.shutterSprite.setPosition(n, this.shutterSpriteY);
                this.shutterSprite.paint(graphics);
            }
            this.zabkiSprite.setFrame(1);
            this.zabkiSprite.setPosition(this.lotteryStage1ZabkiX, this.zabkiSpriteY);
            this.zabkiSprite.paint(graphics);
            for (n = 0; n < 7; ++n) {
                this.zabkiSprite.setTransform(0);
                this.zabkiSprite.setFrame(0);
                this.zabkiSprite.setPosition(this.lotteryStage1ZabkiX - (n + 1) * this.zabkiSprite.getWidth() - (n + 1) * this.lotteryStage1ZabkiHSpace, this.zabkiSpriteY);
                this.zabkiSprite.paint(graphics);
                this.zabkiSprite.setTransform(2);
                this.zabkiSprite.setFrame(0);
                this.zabkiSprite.setPosition(this.lotteryStage1ZabkiX + (n + 1) * this.zabkiSprite.getWidth() + (n + 1) * this.lotteryStage1ZabkiHSpace, this.zabkiSpriteY);
                this.zabkiSprite.paint(graphics);
            }
            return;
        }
        catch (Exception exception) {
            graphics.setColor(-16777216);
            graphics.drawString(exception.getMessage(), 0, 20, 20);
            return;
        }
    }

    private void drawLotteryQuestionMark(Graphics g) {
        if (MainLogic.counter % 8L < 4L) {
            this.lotteryQuestionMarkSprite.setPosition(this.lotteryQuestionMarkSprite.getX(), this.questionMarkSpriteY);
        } else {
            this.lotteryQuestionMarkSprite.setPosition(this.lotteryQuestionMarkSprite.getX(), this.questionMarkSpriteY - this.questionMarkSpriteYShift);
        }
        this.lotteryQuestionMarkSprite.paint(g);
    }

    private void drawLotteryShutterStage2(Graphics g) {
        int i;
        for (i = 0; i < 3; ++i) {
            this.shutterSprite.setTransform(0);
            this.shutterSprite.setPosition(i * this.shutterSprite.getWidth(), this.shutterSpriteY);
            this.shutterSprite.paint(g);
            this.shutterSprite.setTransform(2);
            this.shutterSprite.setPosition(MainLogic.width - (i + 1) * this.shutterSprite.getWidth(), this.shutterSpriteY);
            this.shutterSprite.paint(g);
        }
        this.lotteryShutterStage2Sprite.setTransform(0);
        this.lotteryShutterStage2Sprite.setPosition(3 * this.shutterSprite.getWidth(), this.shutterSpriteY);
        this.lotteryShutterStage2Sprite.paint(g);
        this.lotteryShutterStage2Sprite.setTransform(2);
        this.lotteryShutterStage2Sprite.setPosition(MainLogic.width - 3 * this.shutterSprite.getWidth() - this.lotteryShutterStage2Sprite.getWidth(), this.shutterSpriteY);
        this.lotteryShutterStage2Sprite.paint(g);
        for (i = 0; i < 5; ++i) {
            this.zabkiSprite.setTransform(0);
            this.zabkiSprite.setFrame(0);
            this.zabkiSprite.setPosition(i * this.zabkiSprite.getWidth() + i * this.lotteryStage2ZabkiHSpace, this.zabkiSpriteY);
            this.zabkiSprite.paint(g);
            this.zabkiSprite.setTransform(2);
            this.zabkiSprite.setFrame(0);
            this.zabkiSprite.setPosition(MainLogic.width - (i + 1) * this.zabkiSprite.getWidth() - i * this.lotteryStage2ZabkiHSpace, this.zabkiSpriteY);
            this.zabkiSprite.paint(g);
        }
        if (this.currLotteryStageAnimFrame % 8 == 0) {
            ++this.currStage;
            this.updateDescText(MainLogic.strings[316]);
        }
        ++this.currLotteryStageAnimFrame;
    }

    private void drawLotteryExposedShutters(Graphics g) {
        int i;
        for (i = 0; i < 3; ++i) {
            this.shutterSprite.setTransform(0);
            this.shutterSprite.setPosition(i * this.shutterSprite.getWidth(), this.shutterSpriteY);
            this.shutterSprite.paint(g);
            this.shutterSprite.setTransform(2);
            this.shutterSprite.setPosition(MainLogic.width - (i + 1) * this.shutterSprite.getWidth(), this.shutterSpriteY);
            this.shutterSprite.paint(g);
        }
        for (i = 0; i < 5; ++i) {
            this.zabkiSprite.setTransform(0);
            this.zabkiSprite.setFrame(0);
            this.zabkiSprite.setPosition(i * this.zabkiSprite.getWidth() + i * this.lotteryStageRestZabkiHSpace, this.zabkiSpriteY);
            this.zabkiSprite.paint(g);
            this.zabkiSprite.setTransform(2);
            this.zabkiSprite.setFrame(0);
            this.zabkiSprite.setPosition(MainLogic.width - (i + 1) * this.zabkiSprite.getWidth() - i * this.lotteryStageRestZabkiHSpace, this.zabkiSpriteY);
            this.zabkiSprite.paint(g);
        }
    }

    private void drawLotteryItems(Graphics graphics) {
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(0, this.lotteryRewardBoundaryY, MainLogic.width, this.lotteryRewardBoundaryHeight);
        for (int i = 0; i < this.lotteryRewardDayFinal.length; ++i) {
            if (this.lotteryRewardDayFinal[i][0] == 1) {
                this.drawRewardWithValue(graphics, this.lotteryRewardSprites[i], this.lotteryRewardDayFinal[i][1]);
                continue;
            }
            if (this.lotteryRewardDayFinal[i][0] == 2) {
                this.drawRewardWithValue(graphics, this.lotteryRewardSprites[i], this.lotteryRewardDayFinal[i][1]);
                continue;
            }
            this.lotteryRewardSprites[i].paint(graphics);
        }
        if (this.lotteryRewardOutOfBoundaryIndex != -1) {
            Sprite sprite = this.lotteryRewardSprites[this.lotteryRewardOutOfBoundaryIndex];
            int n5 = sprite.getX();
            int n6 = sprite.getY();
            Sprite sprite2 = sprite;
            DailyReward dailyReward = this;
            int n7 = DailyReward.getSpriteRightX(sprite2) - dailyReward.lotteryRewardBoundaryRightX;
            sprite.setPosition(this.lotteryRewardBoundaryLeftX - sprite.getWidth() + n7, n6);
            sprite.paint(graphics);
            sprite.setPosition(n5, n6);
        }
        graphics.setClip(n, n2, n3, n4);
    }

    private static int getSpriteRightX(Sprite lotterySprite) {
        return lotterySprite.getX() + lotterySprite.getWidth() - 1;
    }

    public final void grantReward() {
        if (this.rewardGranted) {
            switch (this.grantedRewardType) {
                case 1: {
                    GameTemplate.grantMoneyAsReward(this.grantedRewardValue);
                }
            }
            this.rewardGranted = false;
        }
    }

    public final void resetDailyRewardParams() {
        String string = DailyReward.getDefaultDateToRMS();
        this.lastPlayDateInMillisRMS = Long.parseLong(string);
        this.lastPlayDayNumberRMS = 1;
        this.gameLogic.getGData().save(string, 46);
        this.gameLogic.getGData().save(this.lastPlayDayNumberRMS, 47);
    }

    public final void updatePhysics() {
        if (!this.rewardGranted && this.startLottery) {
            DailyReward dailyReward = this;
            int n = DailyReward.getCurrS(dailyReward.currT);
            int n2 = n - dailyReward.prevS;
            dailyReward.prevS = n;
            ++dailyReward.currT;
            this.updateLotteryItemsPositions(n2);
        }
    }

    private void updateLotteryItemsPositions(int n) {
        this.lotteryRewardOutOfBoundaryIndex = -1;
        if (this.currT > this.totalT) {
            this.rewardGranted = true;
            switch (this.grantedRewardType) {
                case 4: {
                    this.updateDescText(MainLogic.strings[355]);
                    return;
                }
                case 1: {
                    this.updateDescText(MainLogic.replaceKeyString(MainLogic.strings[354], "[x]", Integer.toString(this.grantedRewardValue)));
                    return;
                }
                case 2: {
                    this.updateDescText(MainLogic.replaceKeyString(MainLogic.strings[353], "[x]", Integer.toString(this.grantedRewardValue)));
                }
            }
            return;
        }
        for (int i = 0; i < this.lotteryRewardSprites.length; ++i) {
            int n2 = this.lotteryRewardSprites[i].getX() + n;
            if (n2 > this.lotteryRewardBoundaryRightX) {
                n2 = this.lotteryRewardBoundaryLeftX + (n2 - this.lotteryRewardBoundaryRightX - 1);
            }
            this.lotteryRewardSprites[i].setPosition(n2, this.lotteryRewardSprites[i].getY());
            if (this.lotteryRewardOutOfBoundaryIndex != -1 || DailyReward.getSpriteRightX(this.lotteryRewardSprites[i]) <= this.lotteryRewardBoundaryRightX) continue;
            this.lotteryRewardOutOfBoundaryIndex = i;
        }
    }

    private static int getCurrS(int n) {
        return (n * 298 - 3 * (n * n) / 2) / 10;
    }
}

