/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.menu;

import com.tqm.agave.IData;
import com.tqm.agave.MainLogic;
import com.tqm.agave.menu.Cell;
import com.tqm.agave.menu.Container;
import com.tqm.agave.menu.Row;
import com.tqm.agave.menu.TextLabel;
import com.tqm.fantasydefense.FramedPaper;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.menu.Nick;
import java.util.Random;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class Highscores {
    private GameLogic gameLogic;
    private Container content;
    private int currHighscore;
    private static final String[] initialCampaignNicks;
    private static final int[] initialCampaignWorld1Points;
    private static final int[] initialCampaignWorld2Points;
    private static final int[] initialCampaignWorld3Points;
    private static final String[] initialSurvivalNicks;
    private static final int[] initialSurvivalPoints;
    private String[] campaignTotalNicks;
    private int[] campaignTotalPoints;
    private String[] campaignWorld1Nicks;
    private int[] campaignWorld1Points;
    private String[] campaignWorld2Nicks;
    private int[] campaignWorld2Points;
    private String[] campaignWorld3Nicks;
    private int[] campaignWorld3Points;
    private int[] campaignWorldsPositions;
    private int[] campaignLevelsPoints;
    private String[] survivalNicks;
    private int[] survivalPoints;
    private FramedPaper framedPaper;
    private Sprite arrowSprite;
    private Sprite starSprite;
    private String subtitleString;
    private int line1Y;
    private int line2Y;
    private int subtitleX;
    private int subtitleY;
    private int arrowLeftX;
    private int arrowRightX;
    private int currResult;
    private Nick nick;

    private static void initInitialHighscoresNicks(String[] nicks) {
        nicks[0] = "King Arthur";
        nicks[1] = "Joan of Arc";
        nicks[2] = "Sir Wallace";
        nicks[3] = "Don Quixote";
        nicks[4] = "Sir Lancelot";
        nicks[5] = "Sir Galahad";
        nicks[6] = "Merlin";
        nicks[7] = "Roland";
        nicks[8] = "Zawisza Czarny";
        nicks[9] = "Robin Hood";
    }

    public Highscores(GameLogic gameLogic) {
        this.gameLogic = gameLogic;
        this.content = new Container(MainLogic.width, MainLogic.height, 129);
        this.content.setRowSpace(0);
        FramedPaper.setContainerParams(this.content);
        this.survivalNicks = new String[10];
        this.survivalPoints = new int[10];
        this.campaignTotalNicks = new String[10];
        this.campaignTotalPoints = new int[10];
        this.campaignWorld1Nicks = new String[10];
        this.campaignWorld1Points = new int[10];
        this.campaignWorld2Nicks = new String[10];
        this.campaignWorld2Points = new int[10];
        this.campaignWorld3Nicks = new String[10];
        this.campaignWorld3Points = new int[10];
        this.campaignWorldsPositions = new int[4];
        this.campaignLevelsPoints = new int[21];
        this.framedPaper = new FramedPaper();
        this.currHighscore = 0;
    }

    public final void loadSprites() {
        this.framedPaper.loadSprites();
        this.arrowSprite = GameLogic.loadSprite(137);
        this.starSprite = GameLogic.loadSprite(239);
    }

    public final void setSpritesPositions() {
        this.framedPaper.setMenuFramePosition();
        this.subtitleX = MainLogic.width / 2;
        this.subtitleY = this.gameLogic.getMenuFramedPaperTitleY(this.framedPaper) + this.gameLogic.getFontWrapper().getHeight();
        this.line1Y = this.subtitleY + GameLogic.getSystemFont().getHeight() + this.arrowSprite.getHeight() / 2;
        this.line2Y = this.framedPaper.getPaperY() + this.framedPaper.getMenuPaperHeight() - this.arrowSprite.getHeight() * 3 / 2 - 1;
        this.content.setSize(FramedPaper.menuLineX2 - FramedPaper.menuLineX1 + 1, this.line2Y - this.line1Y - 2 * this.arrowSprite.getHeight());
        this.content.setPosition(FramedPaper.menuLineX1, this.line1Y + this.arrowSprite.getHeight());
        this.content.setScrollBarSpace(FramedPaper.margin / 2);
    }

    public final void disposeSprites() {
        this.framedPaper.disposeSprites();
        MainLogic.disposeImage(137);
        MainLogic.disposeImage(239);
        this.arrowSprite = null;
        this.starSprite = null;
    }

    public final void draw(Graphics graphics) {
        this.framedPaper.drawMenuFramedPaper(graphics);
        this.gameLogic.drawMenuTitle(graphics, this.gameLogic.getMenuFramedPaperTitleY(this.framedPaper));
        graphics.setColor(-7388160);
        graphics.setFont(GameLogic.getSystemFont());
        graphics.drawString(this.subtitleString, this.subtitleX, this.subtitleY, 17);
        this.arrowSprite.setTransform(2);
        this.arrowSprite.setPosition(this.arrowLeftX, this.arrowSprite.getY());
        this.arrowSprite.paint(graphics);
        this.arrowSprite.setTransform(0);
        this.arrowSprite.setPosition(this.arrowRightX, this.arrowSprite.getY());
        this.arrowSprite.paint(graphics);
        this.content.setPosition(this.content.getX(), this.content.getY());
        Row[] rowArray = this.content.getRows();
        int n = graphics.getClipX();
        int n2 = graphics.getClipY();
        int n3 = graphics.getClipWidth();
        int n4 = graphics.getClipHeight();
        graphics.setClip(0, this.content.getY(), MainLogic.width, this.content.getHeight());
        for (int i = 0; i < rowArray.length; ++i) {
            if (i % 2 == 0) {
                graphics.setColor(-2173794);
                graphics.fillRect(rowArray[i].getX(), rowArray[i].getY() + this.content.getTransY(), rowArray[i].getWidth(), rowArray[i].getHeight());
            }
            if (i != this.currResult) continue;
            int n5 = rowArray[i].getX() - this.starSprite.getWidth();
            int n6 = rowArray[i].getY() + (rowArray[i].getHeight() - this.starSprite.getHeight()) / 2;
            this.starSprite.setFrame(2);
            this.starSprite.setPosition(n5, n6 + this.content.getTransY());
            this.starSprite.paint(graphics);
        }
        graphics.setClip(n, n2, n3, n4);
        GameLogic.setMenuScrollbarColor();
        this.content.setPosition(this.content.getX(), this.content.getY());
        this.content.draw(graphics);
        graphics.setColor(-3621766);
        graphics.drawLine(FramedPaper.menuLineX1, this.line1Y, FramedPaper.menuLineX2, this.line1Y);
        graphics.drawLine(FramedPaper.menuLineX1, this.line2Y, FramedPaper.menuLineX2, this.line2Y);
    }

    public final void keyPressed(int n) {
        switch (n) {
            case 50: 
            case 56: 
            case 85: 
            case 87: {
                this.content.keyPressed(n);
                return;
            }
            case 52: 
            case 88: {
                Highscores highscores = this;
                --highscores.currHighscore;
                if (highscores.currHighscore < 0) {
                    highscores.currHighscore = 4;
                }
                highscores.updateContent(GameLogic.getSystemFont());
                return;
            }
            case 54: 
            case 86: {
                Highscores highscores = this;
                ++highscores.currHighscore;
                if (highscores.currHighscore > 4) {
                    highscores.currHighscore = 0;
                }
                highscores.updateContent(GameLogic.getSystemFont());
            }
        }
    }

    private void updateContent(String[] stringArray, int[] nArray, Font font) {
        Row[] rowArray = new Row[stringArray.length];
        for (int i = 0; i < rowArray.length; ++i) {
            TextLabel textLabel = new TextLabel(Integer.toString(i + 1) + ". " + (stringArray[i].equals("") ? "Player" : stringArray[i]), 1, font, null, 60);
            textLabel.setAnchor(4);
            TextLabel textLabel2 = new TextLabel(Integer.toString(nArray[i]), 1, font, null, 40);
            textLabel2.setAnchor(8);
            rowArray[i] = new Row(this.content.getWidth(), new Cell[]{textLabel, textLabel2});
        }
        this.content.setRows(rowArray, 3);
        this.content.setTextColors(-7388160, -7388160);
        if (this.currHighscore != 4) {
            this.currResult = this.campaignWorldsPositions[this.currHighscore];
            Highscores.changeCellColor(this.content.getRowAt(this.campaignWorldsPositions[this.currHighscore]).getCells());
            GameLogic.scrollContentToCurrResult(this.currResult, this.content);
            return;
        }
        String string = this.gameLogic.getNickName();
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(string)) continue;
            this.currResult = i;
            Highscores.changeCellColor(this.content.getRowAt(this.currResult).getCells());
            GameLogic.scrollContentToCurrResult(this.currResult, this.content);
            return;
        }
    }

    private static void changeCellColor(Cell[] cells) {
        for (int i = 0; i < cells.length; ++i) {
            ((TextLabel)cells[i]).setColor(-44032, 1);
            ((TextLabel)cells[i]).setColor(-44032, 2);
        }
    }

    public static void saveDefaultToRMS(IData iData) {
        iData.save(Highscores.getHighscoresString(initialSurvivalNicks, initialSurvivalPoints), 9);
        int[] nArray = new int[initialCampaignWorld1Points.length];
        for (int i = 0; i < initialCampaignWorld1Points.length; ++i) {
            nArray[i] = initialCampaignWorld1Points[i] + initialCampaignWorld2Points[i] + initialCampaignWorld3Points[i];
        }
        iData.save(Highscores.getHighscoresString(initialCampaignNicks, nArray), 10);
        iData.save(Highscores.getHighscoresString(initialCampaignNicks, initialCampaignWorld1Points), 11);
        iData.save(Highscores.getHighscoresString(initialCampaignNicks, initialCampaignWorld2Points), 12);
        iData.save(Highscores.getHighscoresString(initialCampaignNicks, initialCampaignWorld3Points), 13);
        iData.save(Highscores.getSemicolonSeparatedString(4, 9), 14);
        iData.save(Highscores.getSemicolonSeparatedString(21, 0), 15);
    }

    private static String getHighscoresString(String[] stringArray, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(":").append(nArray[i]).append(";");
        }
        return stringBuffer.toString();
    }

    private static String getSemicolonSeparatedString(int n, int n2) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            stringBuffer.append(n2).append(";");
        }
        return stringBuffer.toString();
    }

    public final void updateContent(Font rowFont) {
        switch (this.currHighscore) {
            case 0: {
                Font font = rowFont;
                rowFont = this;
                ((Highscores)rowFont).updateContent(((Highscores)rowFont).campaignTotalNicks, ((Highscores)rowFont).campaignTotalPoints, font);
                this.updateSubtitle(247);
                break;
            }
            case 1: {
                Font font = rowFont;
                rowFont = this;
                ((Highscores)rowFont).updateContent(((Highscores)rowFont).campaignWorld1Nicks, ((Highscores)rowFont).campaignWorld1Points, font);
                this.updateSubtitle(248);
                break;
            }
            case 2: {
                Font font = rowFont;
                rowFont = this;
                ((Highscores)rowFont).updateContent(((Highscores)rowFont).campaignWorld2Nicks, ((Highscores)rowFont).campaignWorld2Points, font);
                this.updateSubtitle(249);
                break;
            }
            case 3: {
                Font font = rowFont;
                rowFont = this;
                ((Highscores)rowFont).updateContent(((Highscores)rowFont).campaignWorld3Nicks, ((Highscores)rowFont).campaignWorld3Points, font);
                this.updateSubtitle(250);
                break;
            }
            case 4: {
                Font font = rowFont;
                rowFont = this;
                this.currResult = -1;
                super.updateContent(((Highscores)rowFont).survivalNicks, ((Highscores)rowFont).survivalPoints, font);
                this.updateSubtitle(40);
            }
        }
        rowFont = this;
        int n = GameLogic.getSystemFont().stringWidth(((Highscores)rowFont).subtitleString);
        ((Highscores)rowFont).arrowLeftX = (MainLogic.width - n) / 2 - 2 * ((Highscores)rowFont).arrowSprite.getWidth();
        ((Highscores)rowFont).arrowRightX = (MainLogic.width - n) / 2 + n + ((Highscores)rowFont).arrowSprite.getWidth();
        ((Highscores)rowFont).arrowSprite.setPosition(0, ((Highscores)rowFont).subtitleY + (GameLogic.getSystemFont().getHeight() - ((Highscores)rowFont).arrowSprite.getHeight()) / 2);
    }

    private void updateSubtitle(int menuId) {
        this.subtitleString = this.gameLogic.getNameMenu(menuId);
    }

    public final void loadHighscoresFromRMS() {
        Highscores highscores = this;
        highscores.loadHighscoresFromRMS(9, highscores.survivalNicks, highscores.survivalPoints);
        highscores = this;
        highscores.loadHighscoresFromRMS(10, highscores.campaignTotalNicks, highscores.campaignTotalPoints);
        highscores = this;
        highscores.loadHighscoresFromRMS(11, highscores.campaignWorld1Nicks, highscores.campaignWorld1Points);
        highscores = this;
        highscores.loadHighscoresFromRMS(12, highscores.campaignWorld2Nicks, highscores.campaignWorld2Points);
        highscores = this;
        highscores.loadHighscoresFromRMS(13, highscores.campaignWorld3Nicks, highscores.campaignWorld3Points);
        highscores = this;
        highscores.loadSemicolonSeparatedDataFromRMS(14, highscores.campaignWorldsPositions);
        highscores = this;
        highscores.loadSemicolonSeparatedDataFromRMS(15, highscores.campaignLevelsPoints);
    }

    private void loadHighscoresFromRMS(int n, String[] stringArray, int[] nArray) {
        String string = this.gameLogic.getGData().loadAsString(n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) == ':') {
                stringArray[n3] = string.substring(n2, i);
                n2 = i + 1;
                continue;
            }
            if (string.charAt(i) != ';') continue;
            nArray[n3] = Integer.parseInt(string.substring(n2, i));
            ++n3;
            n2 = i + 1;
        }
    }

    private void loadSemicolonSeparatedDataFromRMS(int n, int[] nArray) {
        String string = this.gameLogic.getGData().loadAsString(n);
        int n2 = 0;
        int n3 = 0;
        for (int i = 0; i < string.length(); ++i) {
            if (string.charAt(i) != ';') continue;
            nArray[n3] = Integer.parseInt(string.substring(n2, i));
            ++n3;
            n2 = i + 1;
        }
    }

    private void saveCampaignTotalToRMS() {
        this.saveHighscoresToRMS(10, this.campaignTotalNicks, this.campaignTotalPoints);
    }

    private void saveCampaignWorld1ToRMS() {
        this.saveHighscoresToRMS(11, this.campaignWorld1Nicks, this.campaignWorld1Points);
    }

    private void saveCampaignWorld2ToRMS() {
        this.saveHighscoresToRMS(12, this.campaignWorld2Nicks, this.campaignWorld2Points);
    }

    private void saveCampaignWorld3ToRMS() {
        this.saveHighscoresToRMS(13, this.campaignWorld3Nicks, this.campaignWorld3Points);
    }

    private void saveHighscoresToRMS(int n, String[] stringArray, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < stringArray.length; ++i) {
            stringBuffer.append(stringArray[i]).append(":").append(nArray[i]).append(";");
        }
        this.gameLogic.getGData().save(stringBuffer.toString(), n);
    }

    private void saveCampaignWorldsPositionsToRMS() {
        this.saveSemicolonSeparatedStringToRMS(14, this.campaignWorldsPositions);
    }

    private void saveCampaignLevelsPointsToRMS() {
        this.saveSemicolonSeparatedStringToRMS(15, this.campaignLevelsPoints);
    }

    private void saveSemicolonSeparatedStringToRMS(int n, int[] nArray) {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < nArray.length; ++i) {
            stringBuffer.append(nArray[i]).append(";");
        }
        this.gameLogic.getGData().save(stringBuffer.toString(), n);
    }

    public final void resetNickOnHighscores() {
        String nickString;
        this.campaignTotalNicks[this.campaignWorldsPositions[0]] = nickString = this.nick.getNickString();
        this.campaignWorld1Nicks[this.campaignWorldsPositions[1]] = nickString;
        this.campaignWorld2Nicks[this.campaignWorldsPositions[2]] = nickString;
        this.campaignWorld3Nicks[this.campaignWorldsPositions[3]] = nickString;
        this.saveCampaignTotalToRMS();
        this.saveCampaignWorld1ToRMS();
        this.saveCampaignWorld2ToRMS();
        this.saveCampaignWorld3ToRMS();
    }

    public final void saveSurvivalPointsToRMS(int n) {
        int n2 = n;
        Highscores highscores = this;
        String string = highscores.nick.getNickString();
        int n3 = n2;
        for (int i = 0; i < highscores.survivalNicks.length; ++i) {
            if (highscores.survivalPoints[i] >= n2) continue;
            String string2 = highscores.survivalNicks[i];
            int n4 = highscores.survivalPoints[i];
            highscores.survivalNicks[i] = string;
            highscores.survivalPoints[i] = n3;
            string = string2;
            n3 = n4;
        }
        highscores = this;
        highscores.saveHighscoresToRMS(9, highscores.survivalNicks, highscores.survivalPoints);
    }

    public final void saveCampaignPointsToRMS(int n, int n2) {
        if (this.campaignLevelsPoints[n] < n2) {
            int n3 = n / 7 + 1;
            switch (n3) {
                case 1: {
                    this.updateCampaignHighscoresPositions(this.campaignWorld1Nicks, this.campaignWorld1Points, n3, n, n2);
                    this.saveCampaignWorld1ToRMS();
                    return;
                }
                case 2: {
                    this.updateCampaignHighscoresPositions(this.campaignWorld2Nicks, this.campaignWorld2Points, n3, n, n2);
                    this.saveCampaignWorld2ToRMS();
                    return;
                }
                case 3: {
                    this.updateCampaignHighscoresPositions(this.campaignWorld3Nicks, this.campaignWorld3Points, n3, n, n2);
                    this.saveCampaignWorld3ToRMS();
                }
            }
        }
    }

    private void updateCampaignHighscoresPositions(String[] nicks, int[] points, int worldNumber, int levelIndex, int newResult) {
        this.updateCampaignHighscores(nicks, points, worldNumber, levelIndex, newResult);
        this.updateCampaignHighscores(this.campaignTotalNicks, this.campaignTotalPoints, 0, levelIndex, newResult);
        this.campaignLevelsPoints[levelIndex] = newResult;
        this.saveCampaignTotalToRMS();
        this.saveCampaignLevelsPointsToRMS();
        this.saveCampaignWorldsPositionsToRMS();
    }

    private void updateCampaignHighscores(String[] stringArray, int[] nArray, int n, int n2, int n3) {
        n2 = this.campaignLevelsPoints[n2];
        int n4 = this.campaignWorldsPositions[n];
        nArray[n4] = nArray[n4] - n2 + n3;
        for (n3 = n2 = n4; n3 > 0; --n3) {
            if (nArray[n3] <= nArray[n3 - 1]) continue;
            String string = stringArray[n3 - 1];
            n4 = nArray[n3 - 1];
            stringArray[n3 - 1] = stringArray[n3];
            nArray[n3 - 1] = nArray[n3];
            stringArray[n3] = string;
            nArray[n3] = n4;
            n2 = n3 - 1;
        }
        this.campaignWorldsPositions[n] = n2;
    }

    public final int getCampaignPoints(int levelIndex) {
        return this.campaignLevelsPoints[levelIndex];
    }

    public final int getSurvivalPoints() {
        for (int i = 0; i < this.survivalNicks.length; ++i) {
            if (!this.survivalNicks[i].equals(this.nick.getNickString())) continue;
            return this.survivalPoints[i];
        }
        return 0;
    }

    public final void setNick(Nick nick) {
        this.nick = nick;
    }

    public final void resetHighscoresParams() {
        int n;
        Highscores highscores = this;
        String string = highscores.nick.getNickString();
        for (n = 0; n < highscores.campaignLevelsPoints.length; ++n) {
            highscores.campaignLevelsPoints[n] = 0;
        }
        for (n = 0; n < highscores.campaignWorldsPositions.length; ++n) {
            highscores.campaignWorldsPositions[n] = 9;
        }
        highscores.campaignTotalNicks[highscores.campaignWorldsPositions[0]] = string;
        highscores.campaignWorld1Nicks[highscores.campaignWorldsPositions[1]] = string;
        highscores.campaignWorld2Nicks[highscores.campaignWorldsPositions[2]] = string;
        highscores.campaignWorld3Nicks[highscores.campaignWorldsPositions[3]] = string;
        highscores.campaignTotalPoints[highscores.campaignWorldsPositions[0]] = 0;
        highscores.campaignWorld1Points[highscores.campaignWorldsPositions[1]] = 0;
        highscores.campaignWorld2Points[highscores.campaignWorldsPositions[2]] = 0;
        highscores.campaignWorld3Points[highscores.campaignWorldsPositions[3]] = 0;
        highscores.saveCampaignLevelsPointsToRMS();
        highscores.saveCampaignWorldsPositionsToRMS();
        highscores.saveCampaignTotalToRMS();
        highscores.saveCampaignWorld1ToRMS();
        highscores.saveCampaignWorld2ToRMS();
        highscores.saveCampaignWorld3ToRMS();
    }

    static {
        new Random();
        initialSurvivalNicks = new String[10];
        initialSurvivalPoints = new int[10];
        Highscores.initInitialHighscoresNicks(initialSurvivalNicks);
        int[] nArray = initialSurvivalPoints;
        initialSurvivalPoints[0] = 15000;
        nArray[1] = 14000;
        nArray[2] = 12500;
        nArray[3] = 11000;
        nArray[4] = 9500;
        nArray[5] = 8000;
        nArray[6] = 6500;
        nArray[7] = 5000;
        nArray[8] = 3500;
        nArray[9] = 2000;
        initialCampaignNicks = new String[10];
        initialCampaignWorld1Points = new int[10];
        initialCampaignWorld2Points = new int[10];
        initialCampaignWorld3Points = new int[10];
        Highscores.initInitialHighscoresNicks(initialCampaignNicks);
        nArray = initialCampaignWorld1Points;
        initialCampaignWorld1Points[0] = 27000;
        nArray[1] = 23500;
        nArray[2] = 20000;
        nArray[3] = 17500;
        nArray[4] = 15000;
        nArray[5] = 12500;
        nArray[6] = 10000;
        nArray[7] = 7500;
        nArray[8] = 5000;
        nArray[9] = 2500;
        nArray = initialCampaignWorld2Points;
        initialCampaignWorld2Points[0] = 36000;
        nArray[1] = 34000;
        nArray[2] = 32000;
        nArray[3] = 28000;
        nArray[4] = 24000;
        nArray[5] = 20000;
        nArray[6] = 16000;
        nArray[7] = 12000;
        nArray[8] = 8000;
        nArray[9] = 4000;
        nArray = initialCampaignWorld3Points;
        initialCampaignWorld3Points[0] = 43000;
        nArray[1] = 38000;
        nArray[2] = 33500;
        nArray[3] = 29000;
        nArray[4] = 24500;
        nArray[5] = 20000;
        nArray[6] = 16000;
        nArray[7] = 12000;
        nArray[8] = 8000;
        nArray[9] = 4000;
    }
}

