/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop;

import com.tqm.agave.MainLogic;
import com.tqm.fantasydefense.GameLogic;
import com.tqm.fantasydefense.shop.AbstractShop;
import com.tqm.fantasydefense.shop.secret.SecretCastleDefender;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.Sprite;

public final class ShopCastleGates
extends AbstractShop {
    private Sprite iconsSprite;
    private Sprite iconsSelectionSprite;
    private Sprite castleIconSprite;
    private int[] iconsX;
    private int iconsY;
    private SecretCastleDefender[] gates;
    private boolean questionMode;
    private int clipX;
    private int clipY;
    private int clipWidth;
    private int clipHeight;

    public ShopCastleGates(SecretCastleDefender[] gates) {
        this.gates = gates;
        this.questionMode = false;
    }

    protected final void loadSprites() {
        this.castleIconSprite = GameLogic.loadSprite(125);
        this.iconsSprite = GameLogic.loadSprite(189);
        this.iconsSelectionSprite = GameLogic.loadSprite(81);
    }

    protected final void setSpritesPositions() {
        int n;
        int n2 = this.iconsSprite.getWidth() / 8;
        int n3 = this.iconsSprite.getWidth() * this.iconsSprite.getFrameSequenceLength() + (this.iconsSprite.getFrameSequenceLength() - 1) * n2;
        n3 = (MainLogic.width - n3) / 2;
        this.iconsY = ShopCastleGates.getRackSprite().getY() + ShopCastleGates.getRackSprite().getHeight() / 2 - this.iconsSprite.getHeight();
        this.iconsX = new int[3];
        for (n = 0; n < this.iconsX.length; ++n) {
            this.iconsX[n] = n3 + n * (this.iconsSprite.getWidth() + n2);
        }
        n = ShopCastleGates.getItemDesc().getX() + ShopCastleGates.getItemDesc().getWidth() - this.castleIconSprite.getWidth() - GameLogic.getSystemFont().stringWidth(" +00%");
        this.castleIconSprite.setPosition(n, ShopCastleGates.getTitleStressY() - this.castleIconSprite.getHeight() - 2);
    }

    protected final void initOthersShopData() {
        ShopCastleGates.setFramedPaperDefaultPosition();
        this.setSelectionDesc();
    }

    public final void disposeSprites() {
        MainLogic.disposeImage(189);
        MainLogic.disposeImage(81);
        MainLogic.disposeImage(125);
        this.iconsSprite = null;
        this.iconsSelectionSprite = null;
        this.castleIconSprite = null;
    }

    protected final void drawShopItems(Graphics graphics) {
        Graphics graphics2 = graphics;
        ShopCastleGates shopCastleGates = this;
        shopCastleGates.iconsSelectionSprite.setPosition(shopCastleGates.iconsX[shopCastleGates.getCurrRackItem()] - (shopCastleGates.iconsSelectionSprite.getWidth() - shopCastleGates.iconsSprite.getWidth()) / 2, shopCastleGates.iconsY - (shopCastleGates.iconsSelectionSprite.getHeight() - shopCastleGates.iconsSprite.getHeight()) / 2);
        shopCastleGates.iconsSelectionSprite.paint(graphics2);
        graphics2 = graphics;
        shopCastleGates = this;
        int n = 0;
        while (n < 3) {
            int n2 = n++;
            Graphics graphics3 = graphics2;
            ShopCastleGates shopCastleGates2 = shopCastleGates;
            shopCastleGates2.iconsSprite.setFrame(n2);
            shopCastleGates2.iconsSprite.setPosition(shopCastleGates2.iconsX[n2], shopCastleGates2.iconsY);
            shopCastleGates2.iconsSprite.paint(graphics3);
        }
        graphics2 = graphics;
        shopCastleGates = this;
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[0], shopCastleGates.iconsY);
        ShopCastleGates.drawUnlockState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[0]);
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[1], shopCastleGates.iconsY);
        ShopCastleGates.drawUnlockState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[1]);
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[2], shopCastleGates.iconsY);
        ShopCastleGates.drawUnlockState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[2]);
        graphics2 = graphics;
        shopCastleGates = this;
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[0], shopCastleGates.iconsY);
        ShopCastleGates.drawActiveState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[0]);
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[1], shopCastleGates.iconsY);
        ShopCastleGates.drawActiveState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[1]);
        shopCastleGates.iconsSprite.setPosition(shopCastleGates.iconsX[2], shopCastleGates.iconsY);
        ShopCastleGates.drawActiveState(graphics2, shopCastleGates.iconsSprite, shopCastleGates.gates[2]);
    }

    protected final void drawShopItemDesc(Graphics graphics) {
        if (this.questionMode) {
            ShopCastleGates.drawItemDesc(graphics);
            return;
        }
        ShopCastleGates.drawShopItemDescWithPrice(graphics, this.gates[this.getCurrRackItem()]);
        this.clipX = graphics.getClipX();
        this.clipY = graphics.getClipY();
        this.clipWidth = graphics.getClipWidth();
        this.clipHeight = graphics.getClipHeight();
        if (ShopCastleGates.getItemDesc().getTransY() < 0) {
            graphics.setClip(this.castleIconSprite.getX(), ShopCastleGates.getItemDesc().getY(), ShopCastleGates.getItemDesc().getX() + ShopCastleGates.getItemDesc().getWidth() - this.castleIconSprite.getX(), ShopCastleGates.getTitleStressY() - ShopCastleGates.getFramedPaper().getPaperY());
        }
        this.castleIconSprite.setPosition(this.castleIconSprite.getX(), ShopCastleGates.getTitleStressY() - this.castleIconSprite.getHeight() - 2 + ShopCastleGates.getItemDesc().getTransY());
        this.castleIconSprite.paint(graphics);
        graphics.setFont(GameLogic.getSystemFont());
        graphics.setColor(-16777216);
        graphics.drawString(" +" + this.gates[this.getCurrRackItem()].getPower() + "%", ShopCastleGates.getItemDesc().getX() + ShopCastleGates.getItemDesc().getWidth(), ShopCastleGates.getTitleStressY() + ShopCastleGates.getItemDesc().getTransY(), 40);
        graphics.setClip(this.clipX, this.clipY, this.clipWidth, this.clipHeight);
    }

    protected final void onEnterKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setSelectionDesc();
            return;
        }
        if (this.getCurrRackItem() == 0 || this.gates[this.getCurrRackItem() - 1].isUnlocked()) {
            this.onEnterForBuyKeyPressed(this.gates[this.getCurrRackItem()]);
            return;
        }
        this.questionMode = true;
        ShopCastleGates.setDescTextWithTitle(MainLogic.strings[302], MainLogic.strings[198]);
    }

    protected final void onBackKeyPressed() {
        if (this.questionMode) {
            this.questionMode = false;
            this.setSelectionDesc();
            return;
        }
        this.onBackForBuyKeyPressed$255f299(243);
    }

    protected final void onOthersKeyPressed(int key) {
        if (!this.questionMode) {
            this.onLeftAndRightKeyPressed(key, 3);
        }
    }

    protected final void setSelectionDesc() {
        switch (this.getCurrRackItem()) {
            case 0: {
                ShopCastleGates.setDescTextWithTitle(MainLogic.strings[189], MainLogic.strings[186]);
                break;
            }
            case 1: {
                ShopCastleGates.setDescTextWithTitle(MainLogic.strings[190], MainLogic.strings[187]);
                break;
            }
            case 2: {
                ShopCastleGates.setDescTextWithTitle(MainLogic.strings[191], MainLogic.strings[188]);
            }
        }
        ShopCastleGates.setPriceCrystalPosition(this.gates[this.getCurrRackItem()].getPrice());
    }
}

