/*
 * Decompiled with CFR 0.152.
 */
package com.tqm.fantasydefense.shop.secret;

import com.tqm.fantasydefense.shop.secret.AbstractSecretItem;
import com.tqm.wrapper.WrapperController;

public final class SecretCastleDefender
extends AbstractSecretItem {
    private SecretCastleDefender[] exclusiveCastleDefenders;
    private int defenderType;
    private int defender;
    private int power;
    private int specialSkill;

    public SecretCastleDefender(int price, int defenderType, int defender, int power, int specialSkill, int statsItemId) {
        super(price, statsItemId);
        this.defenderType = defenderType;
        this.defender = defender;
        this.power = power;
        this.specialSkill = specialSkill;
    }

    public final void setExclusiveCastleDefenders(SecretCastleDefender[] exclusiveCastleDefenders) {
        this.exclusiveCastleDefenders = exclusiveCastleDefenders;
    }

    protected final int getRMSId() {
        switch (this.defenderType) {
            case 0: {
                switch (this.defender) {
                    case 0: {
                        return 19;
                    }
                    case 1: {
                        return 20;
                    }
                    case 2: {
                        return 21;
                    }
                }
                return -1;
            }
            case 2: {
                switch (this.defender) {
                    case 0: {
                        return 22;
                    }
                    case 1: {
                        return 23;
                    }
                    case 2: {
                        return 24;
                    }
                }
                return -1;
            }
            case 1: {
                switch (this.defender) {
                    case 0: {
                        return 25;
                    }
                    case 1: {
                        return 26;
                    }
                    case 2: {
                        return 27;
                    }
                }
                return -1;
            }
        }
        return -1;
    }

    public final int getPower() {
        return this.power;
    }

    public final int getSpecialSkill() {
        return this.specialSkill;
    }

    public final boolean buy(int n) {
        if (this.isUnlocked()) {
            if (this.isActive()) {
                SecretCastleDefender secretCastleDefender = this;
                secretCastleDefender.setActive(false);
                secretCastleDefender.saveUnlockWithActivateToRMS();
            } else {
                this.unlockAndActivateToRMS();
                this.deactivateOtherDefenders();
            }
            return true;
        }
        if (this.isEnoughGems()) {
            this.reduceGems();
            this.buyWithUnlockAndActivate(n);
            this.deactivateOtherDefenders();
            return true;
        }
        WrapperController.logNotEnoughTokens();
        return false;
    }

    public final void unlockDefender() {
        this.unlockAndActivateToRMS();
        this.deactivateOtherDefenders();
    }

    public final void lockDefender() {
        this.setActive(false);
        this.setUnlocked(false);
        this.saveDefaultToRMS();
    }

    private void deactivateOtherDefenders() {
        for (int i = 0; i < this.exclusiveCastleDefenders.length; ++i) {
            this.exclusiveCastleDefenders[i].setActive(false);
            this.exclusiveCastleDefenders[i].saveUnlockWithActivateToRMS();
        }
    }

    public final void uninstallItem() {
        if (this.isUnlocked() && this.isActive()) {
            this.setActive(false);
            this.saveUnlockWithActivateToRMS();
        }
    }
}

